/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.console;

import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleConfig;
import io.quarkus.deployment.dev.BrowserOpenerBuildItem;
import io.quarkus.deployment.dev.console.ConsoleHelper;
import io.quarkus.deployment.dev.testing.TestConfig;
import io.quarkus.deployment.dev.testing.TestConsoleHandler;
import io.quarkus.deployment.dev.testing.TestListenerBuildItem;
import io.quarkus.deployment.dev.testing.TestSetupBuildItem;
import io.quarkus.deployment.dev.testing.TestSupport;
import io.quarkus.runtime.console.ConsoleRuntimeConfig;
import java.util.Optional;
import org.eclipse.microprofile.config.ConfigProvider;

public class ConsoleProcessor {
    private static boolean consoleInstalled = false;

    @BuildStep(onlyIf={IsDevelopment.class})
    @Produce(value=TestSetupBuildItem.class)
    void setupConsole(TestConfig config, BuildProducer<TestListenerBuildItem> testListenerBuildItemBuildProducer, LaunchModeBuildItem launchModeBuildItem, Capabilities capabilities, ConsoleConfig consoleConfig, Optional<BrowserOpenerBuildItem> browserOpener) {
        if (!TestSupport.instance().isPresent() || config.continuousTesting == TestConfig.Mode.DISABLED || config.flatClassPath) {
            return;
        }
        if (consoleInstalled) {
            return;
        }
        consoleInstalled = true;
        if (config.console.orElse(consoleConfig.enabled).booleanValue()) {
            ConsoleRuntimeConfig consoleRuntimeConfig = new ConsoleRuntimeConfig();
            consoleRuntimeConfig.color = ConfigProvider.getConfig().getOptionalValue("quarkus.console.color", Boolean.class);
            io.quarkus.runtime.logging.ConsoleConfig loggingConsoleConfig = new io.quarkus.runtime.logging.ConsoleConfig();
            loggingConsoleConfig.color = ConfigProvider.getConfig().getOptionalValue("quarkus.log.console.color", Boolean.class);
            ConsoleHelper.installConsole(config, consoleConfig, consoleRuntimeConfig, loggingConsoleConfig);
            TestConsoleHandler consoleHandler = new TestConsoleHandler(launchModeBuildItem.getDevModeType().get(), browserOpener.map(BrowserOpenerBuildItem::getBrowserOpener).orElse(null), capabilities.isPresent("io.quarkus.vertx.http"));
            consoleHandler.install();
            testListenerBuildItemBuildProducer.produce(new TestListenerBuildItem(consoleHandler));
        }
    }
}

