/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.console;

import io.quarkus.dev.console.InputHandler;
import io.quarkus.dev.console.QuarkusConsole;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.Connection;
import org.aesh.terminal.tty.Size;
import org.aesh.terminal.utils.ANSI;

public class AeshConsole
extends QuarkusConsole {
    private final Connection connection;
    private final boolean inputSupport;
    private Size size;
    private Attributes attributes;
    private String[] messages = new String[0];
    private int totalStatusLines = 0;
    private int lastWriteCursorX;
    private String lastColorCode;
    private volatile boolean doingReadline;
    private int bottomBlankSpace = 0;
    private final LinkedBlockingDeque<String> writeQueue = new LinkedBlockingDeque();
    private final Lock connectionLock = new ReentrantLock();
    private static final ThreadLocal<Boolean> IN_WRITE = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    static final Pattern ESCAPE = Pattern.compile("\u001b\\[(\\d\\d?)[\\d;]*m");

    public AeshConsole(final Connection connection, boolean inputSupport) {
        this.inputSupport = inputSupport;
        INSTANCE = this;
        this.connection = connection;
        connection.openNonBlocking();
        this.setup(connection);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                connection.close();
            }
        }, "Console Shutdown Hoot"));
    }

    private void updatePromptOnChange(StringBuilder buffer, int newLines) {
        if (newLines > this.totalStatusLines) {
            StringBuilder nb = new StringBuilder();
            for (int i = 0; i < newLines - this.totalStatusLines; ++i) {
                if (this.bottomBlankSpace > 0) {
                    --this.bottomBlankSpace;
                    continue;
                }
                nb.append("\n");
            }
            this.writeQueue.add(nb.toString());
            this.deadlockSafeWrite();
        } else if (newLines < this.totalStatusLines) {
            this.bottomBlankSpace += this.totalStatusLines - newLines;
        }
        this.totalStatusLines = newLines;
        this.printStatusAndPrompt(buffer);
        this.writeQueue.add(buffer.toString());
    }

    public AeshInputHolder createHolder(InputHandler inputHandler) {
        return new AeshInputHolder(inputHandler);
    }

    private AeshConsole setPromptMessage(String promptMessage) {
        if (!this.inputSupport) {
            return this;
        }
        this.setMessage(0, promptMessage);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AeshConsole setMessage(int position, String message) {
        AeshConsole aeshConsole = this;
        synchronized (aeshConsole) {
            if (this.messages.length <= position) {
                String[] old = this.messages;
                this.messages = new String[position + 1];
                System.arraycopy(old, 0, this.messages, 0, old.length);
            }
            this.messages[position] = message;
            int newLines = this.countTotalStatusLines();
            StringBuilder buffer = new StringBuilder();
            this.clearStatusMessages(buffer);
            this.updatePromptOnChange(buffer, newLines);
        }
        this.deadlockSafeWrite();
        return this;
    }

    private int countTotalStatusLines() {
        int total = 0;
        for (String i : this.messages) {
            if (i == null) continue;
            ++total;
            total += this.countLines(i);
        }
        return total == 0 ? total : total + 1;
    }

    private void end(Connection conn) {
        conn.setAttributes(this.attributes);
        StringBuilder sb = new StringBuilder();
        sb.append(ANSI.MAIN_BUFFER);
        sb.append("\u001b[?25h");
        sb.append("\u001b[0m");
        this.writeQueue.add(sb.toString());
        this.deadlockSafeWrite();
    }

    private void deadlockSafeWrite() {
        block3: while (!this.writeQueue.isEmpty()) {
            if (!this.connectionLock.tryLock()) continue;
            IN_WRITE.set(true);
            try {
                while (true) {
                    if (this.writeQueue.isEmpty()) continue block3;
                    String s = this.writeQueue.poll();
                    this.connection.write(s);
                }
            }
            finally {
                IN_WRITE.set(false);
                this.connectionLock.unlock();
                continue;
            }
            break;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setup(Connection conn) {
        AeshConsole aeshConsole = this;
        synchronized (aeshConsole) {
            this.size = conn.size();
            if (this.inputSupport) {
                conn.setSignalHandler(event -> {
                    switch (event) {
                        case INT: {
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    System.exit(0);
                                }
                            }).start();
                        }
                    }
                });
                conn.setStdinHandler(keys -> {
                    QuarkusConsole.InputHolder handler = (QuarkusConsole.InputHolder)this.inputHandlers.peek();
                    if (handler != null) {
                        handler.handler.handleInput(keys);
                    }
                    if (this.doingReadline) {
                        for (int k : keys) {
                            if (k != 10) continue;
                            this.doingReadline = false;
                            this.connection.enterRawMode();
                        }
                    }
                });
            }
            conn.setCloseHandler(close -> this.end(conn));
            conn.setSizeHandler(size -> this.setup(conn));
            this.attributes = this.inputSupport ? conn.enterRawMode() : conn.getAttributes();
            StringBuilder sb = new StringBuilder();
            this.printStatusAndPrompt(sb);
            this.writeQueue.add(sb.toString());
        }
        this.deadlockSafeWrite();
    }

    private void printStatusAndPrompt(StringBuilder buffer) {
        if (this.totalStatusLines == 0) {
            return;
        }
        if (this.totalStatusLines < this.size.getHeight()) {
            this.clearStatusMessages(buffer);
            this.gotoLine(buffer, this.size.getHeight() - this.totalStatusLines);
        } else {
            this.bottomBlankSpace = 0;
        }
        buffer.append("\n--\n");
        block0: for (int i = this.messages.length - 1; i >= 0; --i) {
            String msg = this.messages[i];
            if (msg == null) continue;
            buffer.append(msg);
            if (i <= 0) continue;
            for (int j = 0; j < i; ++j) {
                if (this.messages[j] == null) continue;
                buffer.append("\n");
                continue block0;
            }
        }
    }

    private void clearStatusMessages(StringBuilder buffer) {
        this.gotoLine(buffer, this.size.getHeight() - this.totalStatusLines + 1);
        buffer.append("\u001b[J");
    }

    private StringBuilder gotoLine(StringBuilder builder, int line) {
        return builder.append("\u001b[").append(line).append(";").append(0).append("H");
    }

    int countLines(String s) {
        return this.countLines(s, 0);
    }

    int countLines(String s, int cursorPos) {
        if (s == null) {
            return 0;
        }
        s = this.stripAnsiCodes(s);
        int lines = 0;
        int curLength = cursorPos;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\n') {
                ++lines;
                curLength = 0;
                continue;
            }
            if (curLength++ != this.size.getWidth()) continue;
            ++lines;
            curLength = 0;
        }
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String s) {
        if (IN_WRITE.get().booleanValue()) {
            return;
        }
        if (this.lastColorCode != null) {
            s = this.lastColorCode + (String)s;
        }
        Matcher m = ESCAPE.matcher((CharSequence)s);
        while (m.find()) {
            int val = Integer.parseInt(m.group(1));
            if (val != 0 && (val < 30 || val > 39) && (val < 90 || val > 97)) continue;
            this.lastColorCode = m.group(0);
        }
        StringBuilder buffer = new StringBuilder();
        AeshConsole aeshConsole = this;
        synchronized (aeshConsole) {
            if (this.outputFilter != null && !this.outputFilter.test(s)) {
                return;
            }
            if (this.totalStatusLines == 0) {
                this.bottomBlankSpace = 0;
                this.writeQueue.add((String)s);
            } else {
                this.clearStatusMessages(buffer);
                int cursorPos = this.lastWriteCursorX;
                String stripped = this.stripAnsiCodes((String)s);
                int lines = this.countLines((String)s, cursorPos);
                int trailing = 0;
                int index = stripped.lastIndexOf("\n");
                trailing = index == -1 ? stripped.length() : stripped.length() - index - 1;
                int newCursorPos = lines == 0 ? trailing + cursorPos : trailing;
                int usedBlankSpace = 0;
                this.gotoLine(buffer, this.size.getHeight());
                if (cursorPos > 1 && lines == 0) {
                    this.gotoLine(buffer, this.size.getHeight() - this.bottomBlankSpace);
                    buffer.append((String)s);
                    this.lastWriteCursorX = newCursorPos;
                    this.writeQueue.add(buffer.toString());
                } else {
                    if (lines == 0) {
                        ++lines;
                    }
                    int originalBlank = this.bottomBlankSpace;
                    if (this.bottomBlankSpace > 0) {
                        usedBlankSpace = Math.min(this.bottomBlankSpace, lines);
                        this.bottomBlankSpace -= usedBlankSpace;
                    }
                    int appendLines = Math.max(Math.min(cursorPos > 1 ? lines - 1 : lines, this.totalStatusLines), 1);
                    appendLines -= usedBlankSpace;
                    this.clearStatusMessages(buffer);
                    buffer.append("\u001b[").append(this.size.getHeight() - this.totalStatusLines - originalBlank).append(";").append(this.lastWriteCursorX).append("H");
                    buffer.append((String)s);
                    buffer.append("\u001b[").append(this.size.getHeight()).append(";").append(0).append("H");
                    for (int i = 0; i < appendLines; ++i) {
                        buffer.append("\n");
                    }
                    this.lastWriteCursorX = newCursorPos;
                    this.printStatusAndPrompt(buffer);
                    this.writeQueue.add(buffer.toString());
                }
            }
        }
        this.deadlockSafeWrite();
    }

    public void write(byte[] buf, int off, int len) {
        this.write(new String(buf, off, len, this.connection.outputEncoding()));
    }

    class AeshInputHolder
    extends QuarkusConsole.InputHolder {
        protected AeshInputHolder(InputHandler handler) {
            super(handler);
        }

        protected void setPromptMessage(String prompt) {
            if (!AeshConsole.this.inputSupport) {
                return;
            }
            AeshConsole.this.setMessage(0, prompt);
        }

        protected void setResultsMessage(String results) {
            AeshConsole.this.setMessage(1, results);
        }

        protected void setCompileErrorMessage(String results) {
            AeshConsole.this.setMessage(3, results);
        }

        protected void setStatusMessage(String status) {
            AeshConsole.this.setMessage(2, status);
        }

        public void doReadLine() {
            if (!AeshConsole.this.inputSupport) {
                return;
            }
            this.setPrompt("");
            AeshConsole.this.connection.setAttributes(AeshConsole.this.attributes);
            AeshConsole.this.doingReadline = true;
        }
    }
}

