/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.testing;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.deployment.QuarkusClassWriter;
import io.quarkus.deployment.dev.ClassScanResult;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.testing.CurrentTestApplication;
import io.quarkus.deployment.dev.testing.HtmlAnsiOutputStream;
import io.quarkus.deployment.dev.testing.TestClassResult;
import io.quarkus.deployment.dev.testing.TestClassUsages;
import io.quarkus.deployment.dev.testing.TestResult;
import io.quarkus.deployment.dev.testing.TestRunListener;
import io.quarkus.deployment.dev.testing.TestRunResults;
import io.quarkus.deployment.dev.testing.TestState;
import io.quarkus.deployment.dev.testing.TestSupport;
import io.quarkus.deployment.dev.testing.TestTracingProcessor;
import io.quarkus.deployment.dev.testing.TestType;
import io.quarkus.deployment.util.IoUtil;
import io.quarkus.dev.console.QuarkusConsole;
import io.quarkus.dev.testing.TracingHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.platform.commons.annotation.Testable;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherConfig;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.opentest4j.TestAbortedException;

public class JunitTestRunner {
    private static final Logger log = Logger.getLogger(JunitTestRunner.class);
    public static final DotName QUARKUS_TEST = DotName.createSimple((String)"io.quarkus.test.junit.QuarkusTest");
    public static final DotName QUARKUS_INTEGRATION_TEST = DotName.createSimple((String)"io.quarkus.test.junit.QuarkusIntegrationTest");
    public static final DotName NATIVE_IMAGE_TEST = DotName.createSimple((String)"io.quarkus.test.junit.NativeImageTest");
    public static final DotName TEST_PROFILE = DotName.createSimple((String)"io.quarkus.test.junit.TestProfile");
    public static final DotName TEST = DotName.createSimple((String)Test.class.getName());
    public static final DotName REPEATED_TEST = DotName.createSimple((String)RepeatedTest.class.getName());
    public static final DotName PARAMETERIZED_TEST = DotName.createSimple((String)ParameterizedTest.class.getName());
    public static final DotName TEST_FACTORY = DotName.createSimple((String)TestFactory.class.getName());
    public static final DotName TEST_TEMPLATE = DotName.createSimple((String)TestTemplate.class.getName());
    public static final DotName TESTABLE = DotName.createSimple((String)Testable.class.getName());
    private final long runId;
    private final DevModeContext devModeContext;
    private final CuratedApplication testApplication;
    private final ClassScanResult classScanResult;
    private final TestClassUsages testClassUsages;
    private final TestState testState;
    private final List<TestRunListener> listeners;
    List<PostDiscoveryFilter> additionalFilters;
    private final Set<String> includeTags;
    private final Set<String> excludeTags;
    private final Pattern include;
    private final Pattern exclude;
    private final boolean failingTestsOnly;
    private final TestType testType;
    private volatile boolean testsRunning = false;
    private volatile boolean aborted;
    private volatile boolean paused;

    public JunitTestRunner(Builder builder) {
        this.runId = builder.runId;
        this.devModeContext = builder.devModeContext;
        this.testApplication = builder.testApplication;
        this.classScanResult = builder.classScanResult;
        this.testClassUsages = builder.testClassUsages;
        this.listeners = builder.listeners;
        this.additionalFilters = builder.additionalFilters;
        this.testState = builder.testState;
        this.includeTags = new HashSet<String>(builder.includeTags);
        this.excludeTags = new HashSet<String>(builder.excludeTags);
        this.include = builder.include;
        this.exclude = builder.exclude;
        this.failingTestsOnly = builder.failingTestsOnly;
        this.testType = builder.testType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runTests() {
        long start = System.currentTimeMillis();
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try (QuarkusClassLoader tcl = this.testApplication.createDeploymentClassLoader();){
            Thread.currentThread().setContextClassLoader((ClassLoader)tcl);
            Consumer currentTestAppConsumer = (Consumer)tcl.loadClass(CurrentTestApplication.class.getName()).newInstance();
            currentTestAppConsumer.accept(this.testApplication);
            final HashSet<UniqueId> allDiscoveredIds = new HashSet<UniqueId>();
            final HashSet<UniqueId> dynamicIds = new HashSet<UniqueId>();
            try (DiscoveryResult quarkusTestClasses = this.discoverTestClasses(this.devModeContext);){
                LauncherDiscoveryRequest request;
                TestPlan testPlan;
                Launcher launcher = LauncherFactory.create((LauncherConfig)LauncherConfig.builder().build());
                LauncherDiscoveryRequestBuilder launchBuilder = new LauncherDiscoveryRequestBuilder().selectors(quarkusTestClasses.testClasses.stream().map(DiscoverySelectors::selectClass).collect(Collectors.toList()));
                launchBuilder.filters(new Filter[]{new PostDiscoveryFilter(){

                    public FilterResult apply(TestDescriptor testDescriptor) {
                        allDiscoveredIds.add(testDescriptor.getUniqueId());
                        return FilterResult.included(null);
                    }
                }});
                if (this.classScanResult != null) {
                    launchBuilder.filters(new Filter[]{this.testClassUsages.getTestsToRun(this.classScanResult.getChangedClassNames(), this.testState)});
                }
                if (!this.includeTags.isEmpty()) {
                    launchBuilder.filters(new Filter[]{new TagFilter(false, this.includeTags)});
                } else if (!this.excludeTags.isEmpty()) {
                    launchBuilder.filters(new Filter[]{new TagFilter(true, this.excludeTags)});
                }
                if (this.include != null) {
                    launchBuilder.filters(new Filter[]{new RegexFilter(false, this.include)});
                } else if (this.exclude != null) {
                    launchBuilder.filters(new Filter[]{new RegexFilter(true, this.exclude)});
                }
                if (!this.additionalFilters.isEmpty()) {
                    launchBuilder.filters((Filter[])this.additionalFilters.toArray(new PostDiscoveryFilter[0]));
                }
                if (this.failingTestsOnly) {
                    launchBuilder.filters(new Filter[]{new CurrentlyFailingFilter()});
                }
                if ((testPlan = launcher.discover(request = launchBuilder.build())).containsTests()) {
                    long toRun = testPlan.countTestIdentifiers(TestIdentifier::isTest);
                    for (TestRunListener listener : this.listeners) {
                        listener.runStarted(toRun);
                    }
                    log.debug((Object)("Starting test run with " + testPlan.countTestIdentifiers(s -> true) + " tests"));
                    final TestLogCapturingHandler logHandler = new TestLogCapturingHandler();
                    QuarkusConsole.INSTANCE.setOutputFilter((Predicate)logHandler);
                    final LinkedBlockingDeque touchedClasses = new LinkedBlockingDeque();
                    final HashMap startTimes = new HashMap();
                    final AtomicReference startupClasses = new AtomicReference();
                    TracingHandler.setTracingHandler((TracingHandler.TraceListener)new TracingHandler.TraceListener(){

                        public void touched(String className) {
                            Set set = (Set)touchedClasses.peek();
                            if (set != null) {
                                set.add(className);
                            }
                        }

                        public void quarkusStarting() {
                            startupClasses.set((Set)touchedClasses.peek());
                        }
                    });
                    final HashMap<String, Map<UniqueId, TestResult>> resultsByClass = new HashMap<String, Map<UniqueId, TestResult>>();
                    launcher.execute(testPlan, new TestExecutionListener[]{new TestExecutionListener(){

                        public void executionStarted(TestIdentifier testIdentifier) {
                            if (JunitTestRunner.this.aborted) {
                                return;
                            }
                            startTimes.put(testIdentifier, System.currentTimeMillis());
                            String className = "";
                            Class clazz = null;
                            if (testIdentifier.getSource().isPresent()) {
                                if (testIdentifier.getSource().get() instanceof MethodSource) {
                                    clazz = ((MethodSource)testIdentifier.getSource().get()).getJavaClass();
                                } else if (testIdentifier.getSource().get() instanceof ClassSource) {
                                    clazz = ((ClassSource)testIdentifier.getSource().get()).getJavaClass();
                                }
                            }
                            if (clazz != null) {
                                className = clazz.getName();
                                Thread.currentThread().setContextClassLoader(clazz.getClassLoader());
                            }
                            for (TestRunListener listener : JunitTestRunner.this.listeners) {
                                listener.testStarted(testIdentifier, className);
                            }
                            JunitTestRunner.this.waitTillResumed();
                            touchedClasses.push(Collections.synchronizedSet(new HashSet()));
                        }

                        public void executionSkipped(TestIdentifier testIdentifier, String reason) {
                            JunitTestRunner.this.waitTillResumed();
                            if (JunitTestRunner.this.aborted) {
                                return;
                            }
                            Class testClass = null;
                            Object displayName = testIdentifier.getDisplayName();
                            TestSource testSource = testIdentifier.getSource().orElse(null);
                            touchedClasses.pop();
                            UniqueId id = UniqueId.parse((String)testIdentifier.getUniqueId());
                            if (testSource instanceof ClassSource) {
                                testClass = ((ClassSource)testSource).getJavaClass();
                            } else if (testSource instanceof MethodSource) {
                                testClass = ((MethodSource)testSource).getJavaClass();
                                displayName = testClass.getSimpleName() + "#" + (String)displayName;
                            }
                            if (testClass != null) {
                                Map results = resultsByClass.computeIfAbsent(testClass.getName(), s -> new HashMap());
                                TestResult result = new TestResult((String)displayName, testClass.getName(), id, TestExecutionResult.aborted(null), logHandler.captureOutput(), testIdentifier.isTest(), JunitTestRunner.this.runId, 0L);
                                results.put(id, result);
                                if (result.isTest()) {
                                    for (TestRunListener listener : JunitTestRunner.this.listeners) {
                                        listener.testComplete(result);
                                    }
                                }
                            }
                            touchedClasses.push(Collections.synchronizedSet(new HashSet()));
                        }

                        public void dynamicTestRegistered(TestIdentifier testIdentifier) {
                            dynamicIds.add(UniqueId.parse((String)testIdentifier.getUniqueId()));
                        }

                        public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
                            if (JunitTestRunner.this.aborted) {
                                return;
                            }
                            Class testClass = null;
                            Object displayName = testIdentifier.getDisplayName();
                            TestSource testSource = testIdentifier.getSource().orElse(null);
                            Set touched = (Set)touchedClasses.pop();
                            UniqueId id = UniqueId.parse((String)testIdentifier.getUniqueId());
                            if (testSource instanceof ClassSource) {
                                testClass = ((ClassSource)testSource).getJavaClass();
                                if (testExecutionResult.getStatus() != TestExecutionResult.Status.ABORTED) {
                                    for (Set i : touchedClasses) {
                                        touched.addAll(i);
                                    }
                                    if (startupClasses.get() != null) {
                                        touched.addAll((Collection)startupClasses.get());
                                    }
                                    JunitTestRunner.this.testClassUsages.updateTestData(testClass.getName(), touched);
                                }
                            } else if (testSource instanceof MethodSource) {
                                testClass = ((MethodSource)testSource).getJavaClass();
                                displayName = testClass.getSimpleName() + "#" + (String)displayName;
                                if (testExecutionResult.getStatus() != TestExecutionResult.Status.ABORTED) {
                                    for (Set i : touchedClasses) {
                                        touched.addAll(i);
                                    }
                                    if (startupClasses.get() != null) {
                                        touched.addAll((Collection)startupClasses.get());
                                    }
                                    JunitTestRunner.this.testClassUsages.updateTestData(testClass.getName(), id, touched);
                                }
                            }
                            if (testClass != null) {
                                Map results = resultsByClass.computeIfAbsent(testClass.getName(), s -> new HashMap());
                                TestResult result = new TestResult((String)displayName, testClass.getName(), id, testExecutionResult, logHandler.captureOutput(), testIdentifier.isTest(), JunitTestRunner.this.runId, System.currentTimeMillis() - (Long)startTimes.get(testIdentifier));
                                results.put(id, result);
                                if (result.isTest()) {
                                    for (TestRunListener listener : JunitTestRunner.this.listeners) {
                                        listener.testComplete(result);
                                    }
                                }
                            }
                            if (testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED) {
                                Throwable throwable = (Throwable)testExecutionResult.getThrowable().get();
                                if (testClass != null) {
                                    for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
                                        StackTraceElement[] newst;
                                        StackTraceElement elem;
                                        int i;
                                        StackTraceElement[] st = cause.getStackTrace();
                                        for (i = st.length - 1; i >= 0; --i) {
                                            elem = st[i];
                                            if (!elem.getClassName().equals(testClass.getName())) continue;
                                            newst = new StackTraceElement[i + 1];
                                            System.arraycopy(st, 0, newst, 0, i + 1);
                                            st = newst;
                                            break;
                                        }
                                        for (i = st.length - 1; i >= 0; --i) {
                                            elem = st[i];
                                            if (!elem.getClassName().startsWith("io.restassured")) continue;
                                            newst = new StackTraceElement[st.length - i];
                                            System.arraycopy(st, i, newst, 0, st.length - i);
                                            st = newst;
                                            break;
                                        }
                                        cause.setStackTrace(st);
                                    }
                                }
                            }
                        }

                        public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
                        }
                    }});
                    if (this.aborted) {
                        return;
                    }
                    this.testState.updateResults(resultsByClass);
                    this.testState.pruneDeletedTests(allDiscoveredIds, dynamicIds);
                    if (this.classScanResult != null) {
                        this.testState.classesRemoved(this.classScanResult.getDeletedClassNames());
                    }
                } else {
                    this.testState.pruneDeletedTests(allDiscoveredIds, dynamicIds);
                    Iterator<TestRunListener> iterator = this.listeners.iterator();
                    while (iterator.hasNext()) {
                        TestRunListener i = iterator.next();
                        i.noTests(new TestRunResults(this.runId, this.classScanResult, this.classScanResult == null, start, System.currentTimeMillis(), this.toResultsMap(this.testState.getCurrentResults())));
                    }
                    return;
                }
                QuarkusConsole.INSTANCE.setOutputFilter(null);
                Iterator<TestRunListener> iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    TestRunListener listener = iterator.next();
                    listener.runComplete(new TestRunResults(this.runId, this.classScanResult, this.classScanResult == null, start, System.currentTimeMillis(), this.toResultsMap(this.testState.getCurrentResults())));
                }
                return;
            }
            finally {
                currentTestAppConsumer.accept(null);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            TracingHandler.setTracingHandler(null);
            QuarkusConsole.INSTANCE.setOutputFilter(null);
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public synchronized void abort() {
        for (TestRunListener listener : this.listeners) {
            try {
                listener.runAborted();
            }
            catch (Throwable t) {
                log.error((Object)"Failed to invoke test listener", t);
            }
        }
        this.aborted = true;
        this.notifyAll();
    }

    public synchronized void pause() {
        this.paused = true;
    }

    public synchronized void resume() {
        this.paused = false;
        this.notifyAll();
    }

    private Map<String, TestClassResult> toResultsMap(Map<String, Map<UniqueId, TestResult>> resultsByClass) {
        HashMap<String, TestClassResult> resultMap = new HashMap<String, TestClassResult>();
        HashSet<String> classes = new HashSet<String>(resultsByClass.keySet());
        for (String clazz : classes) {
            ArrayList<TestResult> passing = new ArrayList<TestResult>();
            ArrayList<TestResult> failing = new ArrayList<TestResult>();
            ArrayList<TestResult> skipped = new ArrayList<TestResult>();
            long time = 0L;
            for (TestResult i : Optional.ofNullable(resultsByClass.get(clazz)).orElse(Collections.emptyMap()).values()) {
                if (i.getTestExecutionResult().getStatus() == TestExecutionResult.Status.FAILED) {
                    failing.add(i);
                } else if (i.getTestExecutionResult().getStatus() == TestExecutionResult.Status.ABORTED) {
                    skipped.add(i);
                } else {
                    passing.add(i);
                }
                if (!i.getUniqueId().getLastSegment().getType().equals("class")) continue;
                time = i.time;
            }
            resultMap.put(clazz, new TestClassResult(clazz, passing, failing, skipped, time));
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTillResumed() {
        JunitTestRunner junitTestRunner = this;
        synchronized (junitTestRunner) {
            while (this.paused && !this.aborted) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.aborted) {
                throw new TestAbortedException("Tests are disabled");
            }
        }
    }

    private DiscoveryResult discoverTestClasses(DevModeContext devModeContext) {
        Indexer indexer = new Indexer();
        try (Stream<Path> files = Files.walk(Paths.get(devModeContext.getApplicationRoot().getTest().get().getClassesPath(), new String[0]), new FileVisitOption[0]);){
            files.filter(s -> s.getFileName().toString().endsWith(".class")).forEach(s -> {
                try (InputStream in = Files.newInputStream(s, new OpenOption[0]);){
                    indexer.index(in);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        final Index index = indexer.complete();
        HashSet<String> integrationTestClasses = new HashSet<String>();
        for (DotName dotName : Arrays.asList(QUARKUS_INTEGRATION_TEST, NATIVE_IMAGE_TEST)) {
            for (AnnotationInstance i : index.getAnnotations(dotName)) {
                DotName dotName2 = i.target().asClass().name();
                integrationTestClasses.add(dotName2.toString());
                for (ClassInfo clazz : index.getAllKnownSubclasses(dotName2)) {
                    integrationTestClasses.add(clazz.name().toString());
                }
            }
        }
        HashSet<String> quarkusTestClasses = new HashSet<String>();
        for (AnnotationInstance i : index.getAnnotations(QUARKUS_TEST)) {
            DotName name = i.target().asClass().name();
            quarkusTestClasses.add(name.toString());
            for (ClassInfo clazz : index.getAllKnownSubclasses(name)) {
                if (integrationTestClasses.contains(clazz.name().toString())) continue;
                quarkusTestClasses.add(clazz.name().toString());
            }
        }
        Set<DotName> set = JunitTestRunner.collectTestAnnotations(index);
        HashSet<DotName> allTestClasses = new HashSet<DotName>();
        for (DotName dotName : set) {
            for (AnnotationInstance instance : index.getAnnotations(dotName)) {
                if (instance.target().kind() != AnnotationTarget.Kind.METHOD) continue;
                allTestClasses.add(instance.target().asMethod().declaringClass().name());
            }
        }
        HashSet<Object> unitTestClasses = new HashSet<Object>();
        for (DotName testClass : allTestClasses) {
            ClassInfo clazz;
            String name = testClass.toString();
            if (integrationTestClasses.contains(name) || quarkusTestClasses.contains(name) || Modifier.isAbstract((clazz = index.getClassByName(testClass)).flags())) continue;
            unitTestClasses.add(name);
        }
        ArrayList arrayList = new ArrayList();
        ArrayList utClasses = new ArrayList();
        for (String i : quarkusTestClasses) {
            try {
                arrayList.add(Thread.currentThread().getContextClassLoader().loadClass(i));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        arrayList.sort(Comparator.comparing(new Function<Class<?>, String>(){

            @Override
            public String apply(Class<?> aClass) {
                ClassInfo def = index.getClassByName(DotName.createSimple((String)aClass.getName()));
                AnnotationInstance testProfile = def.classAnnotation(TEST_PROFILE);
                if (testProfile == null) {
                    return "$$" + aClass.getName();
                }
                return testProfile.value().asClass().name().toString() + "$$" + aClass.getName();
            }
        }));
        QuarkusClassLoader cl = null;
        if (!unitTestClasses.isEmpty()) {
            QuarkusClassLoader deploymentClassLoader = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
            HashSet classesToTransform = new HashSet(deploymentClassLoader.getLocalClassNames());
            HashMap<CallSite, byte[]> transformedClasses = new HashMap<CallSite, byte[]>();
            for (String string : classesToTransform) {
                try {
                    byte[] classData = IoUtil.readBytes(deploymentClassLoader.getResourceAsStream(string.replace('.', '/') + ".class"));
                    ClassReader cr = new ClassReader(classData);
                    QuarkusClassWriter writer = new QuarkusClassWriter(cr, 3);
                    cr.accept((ClassVisitor)new TestTracingProcessor.TracingClassVisitor((ClassVisitor)writer, string), 0);
                    transformedClasses.put((CallSite)((Object)(string.replace('.', '/') + ".class")), writer.toByteArray());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            cl = this.testApplication.createRuntimeClassLoader((ClassLoader)this.testApplication.getAugmentClassLoader(), Collections.emptyMap(), transformedClasses);
            for (String string : unitTestClasses) {
                try {
                    utClasses.add(cl.loadClass(string));
                }
                catch (ClassNotFoundException exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
        if (this.testType == TestType.ALL) {
            ArrayList ret = new ArrayList(utClasses.size() + arrayList.size());
            ret.addAll(utClasses);
            ret.addAll(arrayList);
            return new DiscoveryResult(cl, ret);
        }
        if (this.testType == TestType.UNIT) {
            return new DiscoveryResult(cl, utClasses);
        }
        return new DiscoveryResult(cl, arrayList);
    }

    private static Set<DotName> collectTestAnnotations(Index index) {
        HashSet<DotName> ret = new HashSet<DotName>();
        ret.add(TEST);
        ret.add(REPEATED_TEST);
        ret.add(PARAMETERIZED_TEST);
        ret.add(TEST_FACTORY);
        ret.add(TEST_TEMPLATE);
        ret.add(TESTABLE);
        HashSet<DotName> metaAnnotations = new HashSet<DotName>(ret);
        metaAnnotations.add(TESTABLE);
        for (DotName an : metaAnnotations) {
            for (AnnotationInstance instance : index.getAnnotations(an)) {
                if (instance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
                ret.add(instance.target().asClass().name());
            }
        }
        return ret;
    }

    public TestState getResults() {
        return this.testState;
    }

    public boolean isRunning() {
        return this.testsRunning;
    }

    static class DiscoveryResult
    implements AutoCloseable {
        final QuarkusClassLoader classLoader;
        final List<Class<?>> testClasses;

        DiscoveryResult(QuarkusClassLoader classLoader, List<Class<?>> testClasses) {
            this.classLoader = classLoader;
            this.testClasses = testClasses;
        }

        @Override
        public void close() throws Exception {
            if (this.classLoader != null) {
                this.classLoader.close();
            }
        }
    }

    private class CurrentlyFailingFilter
    implements PostDiscoveryFilter {
        private CurrentlyFailingFilter() {
        }

        public FilterResult apply(TestDescriptor testDescriptor) {
            if (testDescriptor.getSource().isPresent() && testDescriptor.getSource().get() instanceof MethodSource) {
                MethodSource methodSource = (MethodSource)testDescriptor.getSource().get();
                String name = methodSource.getJavaClass().getName();
                Map<UniqueId, TestResult> results = JunitTestRunner.this.testState.getCurrentResults().get(name);
                if (results == null) {
                    return FilterResult.included((String)"new test");
                }
                TestResult testResult = results.get(testDescriptor.getUniqueId());
                if (testResult == null) {
                    return FilterResult.included((String)"new test");
                }
                return FilterResult.includedIf((testResult.getTestExecutionResult().getStatus() == TestExecutionResult.Status.FAILED ? 1 : 0) != 0);
            }
            return FilterResult.included((String)"not a method");
        }
    }

    private static class RegexFilter
    implements PostDiscoveryFilter {
        final boolean exclude;
        final Pattern pattern;

        private RegexFilter(boolean exclude, Pattern pattern) {
            this.exclude = exclude;
            this.pattern = pattern;
        }

        public FilterResult apply(TestDescriptor testDescriptor) {
            if (testDescriptor.getSource().isPresent() && testDescriptor.getSource().get() instanceof MethodSource) {
                MethodSource methodSource = (MethodSource)testDescriptor.getSource().get();
                String name = methodSource.getJavaClass().getName();
                if (this.pattern.matcher(name).matches()) {
                    return FilterResult.includedIf((!this.exclude ? 1 : 0) != 0);
                }
                return FilterResult.includedIf((boolean)this.exclude);
            }
            return FilterResult.included((String)"not a method");
        }
    }

    private static class TagFilter
    implements PostDiscoveryFilter {
        final boolean exclude;
        final Set<String> tags;

        private TagFilter(boolean exclude, Set<String> tags) {
            this.exclude = exclude;
            this.tags = tags;
        }

        public FilterResult apply(TestDescriptor testDescriptor) {
            if (testDescriptor.getSource().isPresent() && testDescriptor.getSource().get() instanceof MethodSource) {
                MethodSource methodSource = (MethodSource)testDescriptor.getSource().get();
                Method m = methodSource.getJavaMethod();
                FilterResult res = this.filterTags(m);
                if (res != null) {
                    return res;
                }
                res = this.filterTags(methodSource.getJavaClass());
                if (res != null) {
                    return res;
                }
                return FilterResult.includedIf((boolean)this.exclude);
            }
            return FilterResult.included((String)"not a method");
        }

        public FilterResult filterTags(AnnotatedElement clz) {
            Tag tag = clz.getAnnotation(Tag.class);
            Tags tagsAnn = clz.getAnnotation(Tags.class);
            List<Tag> all = null;
            if (tag != null) {
                all = Collections.singletonList(tag);
            } else if (tagsAnn != null) {
                all = Arrays.asList(tagsAnn.value());
            } else {
                return null;
            }
            for (Tag i : all) {
                if (!this.tags.contains(i.value())) continue;
                return FilterResult.includedIf((!this.exclude ? 1 : 0) != 0);
            }
            return FilterResult.includedIf((boolean)this.exclude);
        }
    }

    static class Builder {
        private TestType testType = TestType.ALL;
        private TestState testState;
        private long runId = -1L;
        private DevModeContext devModeContext;
        private CuratedApplication testApplication;
        private ClassScanResult classScanResult;
        private TestClassUsages testClassUsages;
        private final List<TestRunListener> listeners = new ArrayList<TestRunListener>();
        private final List<PostDiscoveryFilter> additionalFilters = new ArrayList<PostDiscoveryFilter>();
        private List<String> includeTags = Collections.emptyList();
        private List<String> excludeTags = Collections.emptyList();
        private Pattern include;
        private Pattern exclude;
        private boolean failingTestsOnly;

        Builder() {
        }

        public Builder setRunId(long runId) {
            this.runId = runId;
            return this;
        }

        public Builder setTestType(TestType testType) {
            this.testType = testType;
            return this;
        }

        public Builder setDevModeContext(DevModeContext devModeContext) {
            this.devModeContext = devModeContext;
            return this;
        }

        public Builder setTestApplication(CuratedApplication testApplication) {
            this.testApplication = testApplication;
            return this;
        }

        public Builder setClassScanResult(ClassScanResult classScanResult) {
            this.classScanResult = classScanResult;
            return this;
        }

        public Builder setIncludeTags(List<String> includeTags) {
            this.includeTags = includeTags;
            return this;
        }

        public Builder setExcludeTags(List<String> excludeTags) {
            this.excludeTags = excludeTags;
            return this;
        }

        public Builder setTestClassUsages(TestClassUsages testClassUsages) {
            this.testClassUsages = testClassUsages;
            return this;
        }

        public Builder addListener(TestRunListener listener) {
            this.listeners.add(listener);
            return this;
        }

        public Builder addAdditionalFilter(PostDiscoveryFilter filter) {
            this.additionalFilters.add(filter);
            return this;
        }

        public Builder setTestState(TestState testState) {
            this.testState = testState;
            return this;
        }

        public Builder setInclude(Pattern include) {
            this.include = include;
            return this;
        }

        public Builder setExclude(Pattern exclude) {
            this.exclude = exclude;
            return this;
        }

        public JunitTestRunner build() {
            Objects.requireNonNull(this.devModeContext, "devModeContext");
            Objects.requireNonNull(this.testClassUsages, "testClassUsages");
            Objects.requireNonNull(this.testApplication, "testApplication");
            Objects.requireNonNull(this.testState, "testState");
            return new JunitTestRunner(this);
        }

        public Builder setFailingTestsOnly(boolean failingTestsOnly) {
            this.failingTestsOnly = failingTestsOnly;
            return this;
        }
    }

    private class TestLogCapturingHandler
    implements Predicate<String> {
        private final List<String> logOutput = new ArrayList<String>();

        public List<String> captureOutput() {
            ArrayList<String> ret = new ArrayList<String>(this.logOutput);
            this.logOutput.clear();
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean test(String logRecord) {
            Thread thread = Thread.currentThread();
            ClassLoader cl = thread.getContextClassLoader();
            while (cl.getParent() != null) {
                if (cl == JunitTestRunner.this.testApplication.getAugmentClassLoader() || cl == JunitTestRunner.this.testApplication.getBaseRuntimeClassLoader()) {
                    List<String> list = this.logOutput;
                    synchronized (list) {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        HtmlAnsiOutputStream outputStream = new HtmlAnsiOutputStream(out){};
                        try {
                            outputStream.write(logRecord.getBytes(StandardCharsets.UTF_8));
                            this.logOutput.add(new String(out.toByteArray(), StandardCharsets.UTF_8));
                        }
                        catch (IOException e) {
                            log.error((Object)"Failed to capture log record", (Throwable)e);
                            this.logOutput.add(logRecord);
                        }
                    }
                    return TestSupport.instance().get().isDisplayTestOutput();
                }
                cl = cl.getParent();
            }
            return true;
        }
    }
}

