/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.testing;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.deployment.dev.ClassScanResult;
import io.quarkus.deployment.dev.RuntimeUpdatesProcessor;
import io.quarkus.deployment.dev.console.AeshConsole;
import io.quarkus.deployment.dev.testing.MessageFormat;
import io.quarkus.deployment.dev.testing.TestClassResult;
import io.quarkus.deployment.dev.testing.TestController;
import io.quarkus.deployment.dev.testing.TestListener;
import io.quarkus.deployment.dev.testing.TestResult;
import io.quarkus.deployment.dev.testing.TestRunListener;
import io.quarkus.deployment.dev.testing.TestRunResults;
import io.quarkus.deployment.dev.testing.TestSupport;
import io.quarkus.dev.console.InputHandler;
import io.quarkus.dev.console.QuarkusConsole;
import io.quarkus.dev.spi.DevModeType;
import java.io.IOException;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.LogManager;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestIdentifier;

public class TestConsoleHandler
implements TestListener {
    private static final org.jboss.logging.Logger log = org.jboss.logging.Logger.getLogger((String)"io.quarkus.test");
    public static final String PAUSED_PROMPT = "Tests paused, press [\u001b[34mr\u001b[39m] to resume, [\u001b[34mw\u001b[39m] to open the browser,\u001b[39m [\u001b[34mh\u001b[39m] for more options>\u001b[39m";
    public static final String PAUSED_PROMPT_NO_HTTP = "Tests paused, press [\u001b[34mr\u001b[39m] to resume, [\u001b[34ms\u001b[39m] to restart with changes, [\u001b[34mh\u001b[39m] for more options>\u001b[39m";
    public static final String FIRST_RUN_PROMPT = "\u001b[34mRunning tests for the first time\u001b[39m";
    public static final String RUNNING_PROMPT = "Press [\u001b[34mr\u001b[39m] to re-run, [\u001b[34mv\u001b[39m] to view full results, [\u001b[34mp\u001b[39m] to pause, [\u001b[34mh\u001b[39m] for more options>";
    public static final String RUNNING_PROMPT_NO_HTTP = "Press [\u001b[34mr\u001b[39m] to re-run, [\u001b[34mv\u001b[39m] to view full results, [\u001b[34mp\u001b[39m] to pause, [\u001b[34ms\u001b[39m] to restart with changes, [\u001b[34mh\u001b[39m] for more options>";
    final DevModeType devModeType;
    boolean firstRun = true;
    boolean disabled = true;
    boolean currentlyFailing = false;
    volatile InputHandler.ConsoleStatus promptHandler;
    volatile TestController testController;
    private String lastResults;
    final Consumer<String> browserOpener;
    private List<Runnable> restoreLogLevelsTasks;
    private Level currentLevel;
    private final boolean hasHttp;
    private final InputHandler inputHandler = new InputHandler(){

        public void handleInput(int[] keys) {
            for (int k : keys) {
                if (k == 13) {
                    TestConsoleHandler.this.printBlankLine();
                    continue;
                }
                if (k == 104) {
                    TestConsoleHandler.this.printUsage();
                    continue;
                }
                if (k == 119 && TestConsoleHandler.this.devModeType != DevModeType.TEST_ONLY) {
                    TestConsoleHandler.this.browserOpener.accept("/");
                    continue;
                }
                if (k == 100 && TestConsoleHandler.this.devModeType != DevModeType.TEST_ONLY) {
                    TestConsoleHandler.this.browserOpener.accept("/q/dev");
                    continue;
                }
                if (k == 108 && TestConsoleHandler.this.devModeType != DevModeType.TEST_ONLY) {
                    RuntimeUpdatesProcessor.INSTANCE.toggleLiveReloadEnabled();
                    continue;
                }
                if (k == 106) {
                    Logger logger;
                    String name;
                    Iterator<String> names;
                    Logger rootLogger = LogManager.getLogManager().getLogger("");
                    if (TestConsoleHandler.this.currentLevel == null) {
                        TestConsoleHandler.this.restoreLogLevelsTasks = new ArrayList<Runnable>();
                        names = LogManager.getLogManager().getLoggerNames().asIterator();
                        while (names.hasNext()) {
                            name = names.next();
                            logger = LogManager.getLogManager().getLogger(name);
                            final java.util.logging.Level level = logger.getLevel();
                            TestConsoleHandler.this.restoreLogLevelsTasks.add(new Runnable(){

                                @Override
                                public void run() {
                                    logger.setLevel(level);
                                }
                            });
                            logger.setLevel((java.util.logging.Level)Level.DEBUG);
                        }
                        TestConsoleHandler.this.currentLevel = Level.DEBUG;
                        System.out.println("Set log level to DEBUG");
                        continue;
                    }
                    if (TestConsoleHandler.this.currentLevel == Level.DEBUG) {
                        names = LogManager.getLogManager().getLoggerNames().asIterator();
                        while (names.hasNext()) {
                            name = names.next();
                            logger = LogManager.getLogManager().getLogger(name);
                            logger.setLevel((java.util.logging.Level)Level.TRACE);
                        }
                        System.out.println("Set log level to TRACE");
                        TestConsoleHandler.this.currentLevel = Level.TRACE;
                        continue;
                    }
                    for (Runnable i : TestConsoleHandler.this.restoreLogLevelsTasks) {
                        i.run();
                    }
                    TestConsoleHandler.this.restoreLogLevelsTasks = null;
                    TestConsoleHandler.this.currentLevel = null;
                    System.out.println("Restored log levels to configured values");
                    continue;
                }
                if (k == 115 && TestConsoleHandler.this.devModeType != DevModeType.TEST_ONLY) {
                    try {
                        RuntimeUpdatesProcessor.INSTANCE.doScan(true, true);
                    }
                    catch (IOException e) {
                        log.error((Object)"Live reload scan failed", (Throwable)e);
                    }
                    continue;
                }
                if (k == 113) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            System.exit(0);
                        }
                    }, "Quarkus exit thread").run();
                    continue;
                }
                if (k == 111 && TestConsoleHandler.this.devModeType != DevModeType.TEST_ONLY) {
                    TestConsoleHandler.this.testController.toggleTestOutput();
                    continue;
                }
                if (TestConsoleHandler.this.disabled) {
                    if (k != 114) continue;
                    TestConsoleHandler.this.promptHandler.setStatus("\u001b[34mStarting tests\u001b[39m");
                    TestSupport.instance().get().start();
                    continue;
                }
                if (k == 114) {
                    TestConsoleHandler.this.testController.runAllTests();
                    continue;
                }
                if (k == 102) {
                    TestConsoleHandler.this.testController.runFailedTests();
                    continue;
                }
                if (k == 118) {
                    TestConsoleHandler.this.testController.printFullResults();
                    continue;
                }
                if (k == 112) {
                    TestSupport.instance().get().stop();
                    continue;
                }
                if (k != 98) continue;
                TestConsoleHandler.this.testController.toggleBrokenOnlyMode();
            }
        }

        public void promptHandler(InputHandler.ConsoleStatus promptHandler) {
            TestConsoleHandler.this.promptHandler = promptHandler;
        }
    };

    public TestConsoleHandler(DevModeType devModeType, Consumer<String> browserOpener, boolean hasHttp) {
        this.devModeType = devModeType;
        this.browserOpener = browserOpener;
        this.hasHttp = hasHttp;
    }

    public void install() {
        QuarkusConsole.INSTANCE.pushInputHandler(this.inputHandler);
        QuarkusClassLoader classLoader = (QuarkusClassLoader)this.getClass().getClassLoader();
        classLoader.addCloseTask(new Runnable(){

            @Override
            public void run() {
                QuarkusConsole.INSTANCE.popInputHandler();
            }
        });
    }

    @Override
    public void listenerRegistered(TestController testController) {
        this.testController = testController;
        this.promptHandler.setPrompt(this.hasHttp ? PAUSED_PROMPT : PAUSED_PROMPT_NO_HTTP);
    }

    private void printBlankLine() {
        System.out.println("");
    }

    public void printUsage() {
        System.out.println("\u001b[39m\nThe following commands are available:");
        if (this.disabled) {
            System.out.println(MessageFormat.helpOption("r", "Resume testing"));
        } else {
            System.out.println(MessageFormat.helpOption("r", "Re-run all tests"));
            System.out.println(MessageFormat.helpOption("f", "Re-run failed tests"));
            System.out.println(MessageFormat.helpOption("b", "Toggle 'broken only' mode, where only failing tests are run", this.testController.isBrokenOnlyMode()));
            System.out.println(MessageFormat.helpOption("v", "Print failures from the last test run"));
            System.out.println(MessageFormat.helpOption("p", "Pause tests"));
        }
        if (this.devModeType != DevModeType.TEST_ONLY) {
            System.out.println(MessageFormat.helpOption("o", "Toggle test output", this.testController.isDisplayTestOutput()));
            System.out.println(MessageFormat.helpOption("i", "Toggle instrumentation based reload", this.testController.isInstrumentationEnabled()));
            System.out.println(MessageFormat.helpOption("l", "Toggle live reload", this.testController.isLiveReloadEnabled()));
            System.out.println(MessageFormat.helpOption("s", "Force restart"));
            if (this.hasHttp) {
                System.out.println(MessageFormat.helpOption("w", "Open the application in a browser"));
                System.out.println(MessageFormat.helpOption("d", "Open the Dev UI in a browser"));
            }
        }
        System.out.println(MessageFormat.helpOption("j", "Toggle log levels", this.currentLevel == null ? this.toLevel(((LogManager)LogManager.getLogManager()).getLogger("").getLevel()).toString() : this.currentLevel.toString(), this.currentLevel == null ? "\u001b[34m" : "\u001b[91m"));
        System.out.println(MessageFormat.helpOption("h", "Display this help"));
        System.out.println(MessageFormat.helpOption("q", "Quit"));
    }

    private Level toLevel(java.util.logging.Level level) {
        if (level.intValue() >= Level.FATAL.intValue()) {
            return Level.FATAL;
        }
        if (level.intValue() >= Level.ERROR.intValue()) {
            return Level.ERROR;
        }
        if (level.intValue() >= Level.WARN.intValue()) {
            return Level.WARN;
        }
        if (level.intValue() >= Level.INFO.intValue()) {
            return Level.INFO;
        }
        if (level.intValue() >= Level.DEBUG.intValue()) {
            return Level.DEBUG;
        }
        return Level.TRACE;
    }

    @Override
    public void testsEnabled() {
        this.disabled = false;
        if (this.firstRun) {
            this.promptHandler.setStatus(null);
            this.promptHandler.setResults(FIRST_RUN_PROMPT);
        } else {
            this.promptHandler.setResults(this.lastResults);
            this.promptHandler.setStatus(null);
        }
        this.promptHandler.setPrompt(this.hasHttp ? RUNNING_PROMPT : RUNNING_PROMPT_NO_HTTP);
    }

    @Override
    public void testsDisabled() {
        this.disabled = true;
        this.promptHandler.setPrompt(this.hasHttp ? PAUSED_PROMPT : PAUSED_PROMPT_NO_HTTP);
        this.promptHandler.setStatus(null);
        this.promptHandler.setResults(null);
    }

    @Override
    public void testCompileFailed(String message) {
        this.promptHandler.setCompileError(message);
    }

    @Override
    public void testCompileSucceeded() {
        this.promptHandler.setCompileError(null);
    }

    @Override
    public void testRunStarted(Consumer<TestRunListener> listenerConsumer) {
        final AtomicLong totalNoTests = new AtomicLong();
        final AtomicLong skipped = new AtomicLong();
        final AtomicLong methodCount = new AtomicLong();
        final AtomicLong failureCount = new AtomicLong();
        listenerConsumer.accept(new TestRunListener(){

            @Override
            public void runStarted(long toRun) {
                totalNoTests.set(toRun);
                TestConsoleHandler.this.promptHandler.setStatus("Starting test run, " + toRun + " tests to run.");
            }

            @Override
            public void testComplete(TestResult result) {
                if (result.getTestExecutionResult().getStatus() == TestExecutionResult.Status.FAILED) {
                    failureCount.incrementAndGet();
                } else if (result.getTestExecutionResult().getStatus() == TestExecutionResult.Status.ABORTED) {
                    skipped.incrementAndGet();
                }
                methodCount.incrementAndGet();
            }

            @Override
            public void runComplete(TestRunResults results) {
                TestConsoleHandler.this.firstRun = false;
                SimpleDateFormat df = new SimpleDateFormat("kk:mm:ss");
                String end = " Tests completed at " + df.format(new Date());
                if (results.getTrigger() != null) {
                    ClassScanResult trigger = results.getTrigger();
                    LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
                    paths.addAll(trigger.getChangedClasses());
                    paths.addAll(trigger.getAddedClasses());
                    paths.addAll(trigger.getDeletedClasses());
                    end = paths.size() == 1 ? end + " due to changes to " + ((Path)paths.iterator().next()).getFileName() + "." : (paths.size() > 1 ? end + " due to changes to " + ((Path)paths.iterator().next()).getFileName() + " and " + (paths.size() - 1) + " other files." : end + ".");
                } else {
                    end = end + ".";
                }
                if (results.getTotalCount() == 0L) {
                    TestConsoleHandler.this.lastResults = "\u001b[34mNo tests found\u001b[39m";
                } else if (results.getFailedCount() == 0L && results.getPassedCount() == 0L) {
                    TestConsoleHandler.this.lastResults = String.format("\u001b[34mAll %d tests were skipped\u001b[39m", results.getSkippedCount());
                } else if (results.getCurrentFailing().isEmpty()) {
                    if (TestConsoleHandler.this.currentlyFailing) {
                        log.info((Object)"\u001b[32mAll tests are now passing\u001b[39m");
                    }
                    TestConsoleHandler.this.currentlyFailing = false;
                    TestConsoleHandler.this.lastResults = String.format("\u001b[32mAll %d " + TestConsoleHandler.pluralize("test is", "tests are", results.getPassedCount()) + " passing (%d skipped), %d " + TestConsoleHandler.pluralize("test was", "tests were", results.getCurrentTotalCount() - results.getCurrentSkippedCount()) + " run in %dms." + end + "\u001b[39m", results.getPassedCount(), results.getSkippedCount(), results.getCurrentTotalCount() - results.getCurrentSkippedCount(), results.getTotalTime());
                } else {
                    TestConsoleHandler.this.currentlyFailing = true;
                    log.error((Object)MessageFormat.statusHeader("TEST REPORT #" + results.getId()));
                    for (Map.Entry<String, TestClassResult> classEntry : results.getCurrentFailing().entrySet()) {
                        for (TestResult test : classEntry.getValue().getFailing()) {
                            log.error((Object)("\u001b[91mTest " + test.getDisplayName() + " failed \n\u001b[39m"), (Throwable)test.getTestExecutionResult().getThrowable().get());
                        }
                    }
                    log.error((Object)MessageFormat.statusFooter("\u001b[91m" + results.getCurrentFailedCount() + " " + TestConsoleHandler.pluralize("TEST", "TESTS", results.getCurrentFailedCount()) + " FAILED"));
                    TestConsoleHandler.this.lastResults = String.format("\u001b[91m%d " + TestConsoleHandler.pluralize("test", "tests", results.getCurrentFailedCount()) + " failed\u001b[39m (\u001b[32m%d passing\u001b[39m, \u001b[34m%d skipped\u001b[39m), \u001b[91m%d " + TestConsoleHandler.pluralize("test was", "tests were", results.getCurrentTotalCount() - results.getCurrentSkippedCount()) + " run in %dms." + end + "\u001b[39m", results.getCurrentFailedCount(), results.getPassedCount(), results.getSkippedCount(), results.getCurrentTotalCount() - results.getCurrentSkippedCount(), results.getTotalTime());
                }
                if (!TestConsoleHandler.this.disabled) {
                    TestConsoleHandler.this.promptHandler.setPrompt(TestConsoleHandler.this.hasHttp ? TestConsoleHandler.RUNNING_PROMPT : TestConsoleHandler.RUNNING_PROMPT_NO_HTTP);
                    TestConsoleHandler.this.promptHandler.setResults(TestConsoleHandler.this.lastResults);
                    TestConsoleHandler.this.promptHandler.setStatus(null);
                }
            }

            @Override
            public void noTests(TestRunResults results) {
                this.runComplete(results);
            }

            @Override
            public void runAborted() {
                TestConsoleHandler.this.firstRun = false;
            }

            @Override
            public void testStarted(TestIdentifier testIdentifier, String className) {
                String status = "Running " + (methodCount.get() + 1L) + "/" + totalNoTests + (String)(failureCount.get() == 0L ? "." : ". " + failureCount + " " + TestConsoleHandler.pluralize("failure", "failures", failureCount) + " so far.") + " Running: " + className + "#" + testIdentifier.getDisplayName();
                if (TestSupport.instance().get().isDisplayTestOutput() && QuarkusConsole.INSTANCE instanceof AeshConsole) {
                    log.info((Object)status);
                }
                TestConsoleHandler.this.promptHandler.setStatus(status);
            }
        });
    }

    private static String pluralize(String singular, String plural, long number) {
        if (number == 1L) {
            return singular;
        }
        return plural;
    }

    private static String pluralize(String singular, String plural, AtomicLong number) {
        return TestConsoleHandler.pluralize(singular, plural, number.get());
    }
}

