/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem.nativeimage;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ReflectiveClassBuildItem
extends MultiBuildItem {
    private final List<String> className;
    private final boolean methods;
    private final boolean fields;
    private final boolean constructors;
    private final boolean finalFieldsWritable;
    private final boolean weak;
    private final boolean serialization;

    public ReflectiveClassBuildItem(boolean methods, boolean fields, Class<?> ... className) {
        this(true, methods, fields, className);
    }

    public ReflectiveClassBuildItem(boolean constructors, boolean methods, boolean fields, Class<?> ... className) {
        this(constructors, methods, fields, false, false, className);
    }

    private ReflectiveClassBuildItem(boolean constructors, boolean methods, boolean fields, boolean finalFieldsWritable, boolean weak, Class<?> ... className) {
        this(constructors, methods, fields, false, false, false, className);
    }

    private ReflectiveClassBuildItem(boolean constructors, boolean methods, boolean fields, boolean finalFieldsWritable, boolean weak, boolean serialization, Class<?> ... className) {
        ArrayList<String> names = new ArrayList<String>();
        for (Class<?> i : className) {
            if (i == null) {
                throw new NullPointerException();
            }
            names.add(i.getName());
        }
        this.className = names;
        this.methods = methods;
        this.fields = fields;
        this.constructors = constructors;
        this.finalFieldsWritable = finalFieldsWritable;
        this.weak = weak;
        this.serialization = serialization;
    }

    public ReflectiveClassBuildItem(boolean methods, boolean fields, String ... className) {
        this(true, methods, fields, className);
    }

    public ReflectiveClassBuildItem(boolean constructors, boolean methods, boolean fields, String ... className) {
        this(constructors, methods, fields, false, false, className);
    }

    public ReflectiveClassBuildItem(boolean constructors, boolean methods, boolean fields, boolean serialization, String ... className) {
        this(constructors, methods, fields, false, false, serialization, className);
    }

    public static ReflectiveClassBuildItem weakClass(String ... className) {
        return new ReflectiveClassBuildItem(true, true, true, false, true, className);
    }

    public static ReflectiveClassBuildItem serializationClass(String ... className) {
        return new ReflectiveClassBuildItem(false, false, false, false, false, true, className);
    }

    private ReflectiveClassBuildItem(boolean constructors, boolean methods, boolean fields, boolean finalFieldsWritable, boolean weak, String ... className) {
        this(constructors, methods, fields, finalFieldsWritable, weak, false, className);
    }

    private ReflectiveClassBuildItem(boolean constructors, boolean methods, boolean fields, boolean finalFieldsWritable, boolean weak, boolean serialization, String ... className) {
        for (String i : className) {
            if (i != null) continue;
            throw new NullPointerException();
        }
        this.className = Arrays.asList(className);
        this.methods = methods;
        this.fields = fields;
        this.constructors = constructors;
        this.finalFieldsWritable = finalFieldsWritable;
        this.weak = weak;
        this.serialization = serialization;
    }

    public List<String> getClassNames() {
        return this.className;
    }

    public boolean isMethods() {
        return this.methods;
    }

    public boolean isFields() {
        return this.fields;
    }

    public boolean isConstructors() {
        return this.constructors;
    }

    public boolean areFinalFieldsWritable() {
        return this.finalFieldsWritable;
    }

    public boolean isWeak() {
        return this.weak;
    }

    public boolean isSerialization() {
        return this.serialization;
    }

    public static Builder builder(Class<?> ... className) {
        String[] classNameStrings = (String[])Arrays.stream(className).map(aClass -> {
            if (aClass == null) {
                throw new NullPointerException();
            }
            return aClass.getName();
        }).toArray(String[]::new);
        return new Builder().className(classNameStrings);
    }

    public static Builder builder(String ... className) {
        return new Builder().className(className);
    }

    public static class Builder {
        private String[] className;
        private boolean constructors = true;
        private boolean methods;
        private boolean fields;
        private boolean finalFieldsWritable;
        private boolean weak;
        private boolean serialization;

        private Builder() {
        }

        public Builder className(String[] className) {
            this.className = className;
            return this;
        }

        public Builder constructors(boolean constructors) {
            this.constructors = constructors;
            return this;
        }

        public Builder methods(boolean methods) {
            this.methods = methods;
            return this;
        }

        public Builder fields(boolean fields) {
            this.fields = fields;
            return this;
        }

        public Builder finalFieldsWritable(boolean finalFieldsWritable) {
            this.finalFieldsWritable = finalFieldsWritable;
            return this;
        }

        public Builder weak(boolean weak) {
            this.weak = weak;
            return this;
        }

        public Builder serialization(boolean serialize) {
            this.serialization = this.serialization;
            return this;
        }

        public ReflectiveClassBuildItem build() {
            return new ReflectiveClassBuildItem(this.constructors, this.methods, this.fields, this.finalFieldsWritable, this.weak, this.className);
        }
    }
}

