/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import io.quarkus.deployment.dev.CompilationProvider;
import io.quarkus.deployment.dev.CompilerFlags;
import io.quarkus.paths.PathCollection;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class JavaCompilationProvider
implements CompilationProvider {
    private static final Logger log = Logger.getLogger(JavaCompilationProvider.class);
    private static final Set<String> COMPILER_OPTIONS = Set.of("-g", "-parameters");
    private static final Set<String> IGNORE_NAMESPACES = Set.of("org.osgi");
    JavaCompiler compiler;
    StandardJavaFileManager fileManager;
    DiagnosticCollector<JavaFileObject> fileManagerDiagnostics;

    @Override
    public String getProviderKey() {
        return "java";
    }

    @Override
    public Set<String> handledExtensions() {
        return Set.of(".java");
    }

    @Override
    public void compile(Set<File> filesToCompile, CompilationProvider.Context context) {
        JavaCompiler compiler = this.compiler;
        if (compiler == null) {
            compiler = this.compiler = ToolProvider.getSystemJavaCompiler();
        }
        if (compiler == null) {
            throw new RuntimeException("No system java compiler provided");
        }
        try {
            if (this.fileManager == null) {
                this.fileManagerDiagnostics = new DiagnosticCollector();
                this.fileManager = compiler.getStandardFileManager(this.fileManagerDiagnostics, null, context.getSourceEncoding());
            }
            DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector<JavaFileObject>();
            this.fileManager.setLocation(StandardLocation.CLASS_PATH, context.getClasspath());
            this.fileManager.setLocation(StandardLocation.CLASS_OUTPUT, List.of(context.getOutputDirectory()));
            CompilerFlags compilerFlags = new CompilerFlags(COMPILER_OPTIONS, context.getCompilerOptions(this.getProviderKey()), context.getReleaseJavaVersion(), context.getSourceJavaVersion(), context.getTargetJvmVersion());
            Iterable<? extends JavaFileObject> sources = this.fileManager.getJavaFileObjectsFromFiles(filesToCompile);
            JavaCompiler.CompilationTask task = compiler.getTask(null, this.fileManager, diagnostics, compilerFlags.toList(), null, sources);
            if (!task.call().booleanValue()) {
                StringBuilder sb = new StringBuilder("\u001b[91mCompilation Failed:");
                for (Diagnostic<JavaFileObject> i : diagnostics.getDiagnostics()) {
                    sb.append("\n");
                    sb.append(i.toString());
                }
                sb.append("\u001b[0m");
                throw new RuntimeException(sb.toString());
            }
            this.logDiagnostics(diagnostics);
            if (!this.fileManagerDiagnostics.getDiagnostics().isEmpty()) {
                this.logDiagnostics(this.fileManagerDiagnostics);
                this.fileManager.close();
                this.fileManagerDiagnostics = null;
                this.fileManager = null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot close file manager", e);
        }
    }

    @Override
    public Path getSourcePath(Path classFilePath, PathCollection sourcePaths, String classesPath) {
        Path sourceFilePath = null;
        RuntimeUpdatesClassVisitor visitor = new RuntimeUpdatesClassVisitor(sourcePaths, classesPath);
        try (InputStream inputStream = Files.newInputStream(classFilePath, new OpenOption[0]);){
            ClassReader reader = new ClassReader(inputStream);
            reader.accept((ClassVisitor)visitor, 0);
            sourceFilePath = visitor.getSourceFileForClass(classFilePath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sourceFilePath;
    }

    @Override
    public void close() throws IOException {
        if (this.fileManager != null) {
            this.fileManager.close();
            this.fileManager = null;
            this.fileManagerDiagnostics = null;
        }
    }

    private void logDiagnostics(DiagnosticCollector<JavaFileObject> diagnostics) {
        for (Diagnostic<JavaFileObject> diagnostic : diagnostics.getDiagnostics()) {
            Logger.Level level = diagnostic.getKind() == Diagnostic.Kind.ERROR ? Logger.Level.ERROR : Logger.Level.WARN;
            String message = diagnostic.getMessage(null);
            if (level.equals((Object)Logger.Level.WARN) && JavaCompilationProvider.ignoreWarningForNamespace(message)) continue;
            log.logf(level, "%s, line %d in %s", (Object)message, (Object)diagnostic.getLineNumber(), (Object)(diagnostic.getSource() == null ? "[unknown source]" : diagnostic.getSource().getName()));
        }
    }

    private static boolean ignoreWarningForNamespace(String message) {
        for (String ignoreNamespace : IGNORE_NAMESPACES) {
            if (!message.contains(ignoreNamespace)) continue;
            return true;
        }
        return false;
    }

    static class RuntimeUpdatesClassVisitor
    extends ClassVisitor {
        private final PathCollection sourcePaths;
        private final String classesPath;
        private String sourceFile;

        public RuntimeUpdatesClassVisitor(PathCollection sourcePaths, String classesPath) {
            super(589824);
            this.sourcePaths = sourcePaths;
            this.classesPath = classesPath;
        }

        public void visitSource(String source, String debug) {
            this.sourceFile = source;
        }

        public Path getSourceFileForClass(Path classFilePath) {
            for (Path sourcesDir : this.sourcePaths) {
                Path classesDir = Paths.get(this.classesPath, new String[0]);
                StringBuilder sourceRelativeDir = new StringBuilder();
                sourceRelativeDir.append(classesDir.relativize(classFilePath.getParent()));
                sourceRelativeDir.append(File.separator);
                sourceRelativeDir.append(this.sourceFile);
                Path sourceFilePath = sourcesDir.resolve(Path.of(sourceRelativeDir.toString(), new String[0]));
                if (!Files.exists(sourceFilePath, new LinkOption[0])) continue;
                return sourceFilePath;
            }
            return null;
        }
    }
}

