/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.DevModeMain;
import io.quarkus.deployment.dev.IsolatedRemoteDevModeMain;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.runtime.logging.JBossVersion;
import io.quarkus.runtime.util.JavaVersionUtil;
import io.quarkus.utilities.JavaBinFinder;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.maven.shared.utils.cli.CommandLineUtils;

public abstract class QuarkusDevModeLauncher {
    final Pattern validDebug = Pattern.compile("^(true|false|client|[0-9]+)$");
    final Pattern validPort = Pattern.compile("^[0-9]+$");
    private List<String> args = new ArrayList<String>(0);
    private String debug;
    private Boolean debugPortOk;
    private String suspend;
    private String debugHost = "localhost";
    private String debugPort = "5005";
    private File projectDir;
    private File buildDir;
    private File outputDir;
    private Map<String, String> buildSystemProperties = new HashMap<String, String>(0);
    private String applicationName;
    private String applicationVersion;
    private String sourceEncoding;
    private Map<String, Set<String>> compilerOptions = new HashMap<String, Set<String>>(1);
    private List<String> compilerPluginArtifacts;
    private List<String> compilerPluginOptions;
    private String releaseJavaVersion;
    private String sourceJavaVersion;
    private String targetJavaVersion;
    private Set<Path> buildFiles = new HashSet<Path>(0);
    private boolean deleteDevJar = true;
    private String baseName;
    private Consumer<DevModeContext> entryPointCustomizer;
    private String applicationArgs;
    private Set<ArtifactKey> localArtifacts = new HashSet<ArtifactKey>();
    private DevModeContext.ModuleInfo main;
    private List<DevModeContext.ModuleInfo> dependencies = new ArrayList<DevModeContext.ModuleInfo>(0);
    private List<File> classpath = new ArrayList<File>(0);

    protected QuarkusDevModeLauncher() {
    }

    protected void prepare() throws Exception {
        JBossVersion.disableVersionLogging();
        if (!JavaVersionUtil.isGraalvmJdk()) {
            this.args.add("-XX:TieredStopAtLevel=1");
        }
        if (this.suspend != null) {
            switch (this.suspend.toLowerCase(Locale.ENGLISH)) {
                case "n": 
                case "false": {
                    this.suspend = "n";
                    break;
                }
                case "y": 
                case "true": {
                    this.suspend = "y";
                    break;
                }
                default: {
                    this.warn("Ignoring invalid value \"" + this.suspend + "\" for \"suspend\" param and defaulting to \"n\"");
                    this.suspend = "n";
                    break;
                }
            }
        } else {
            this.suspend = "n";
        }
        int port = 5005;
        if (this.debugPort != null && this.validPort.matcher(this.debugPort).matches()) {
            port = Integer.parseInt(this.debugPort);
        }
        if (this.debug != null) {
            if (!this.validDebug.matcher(this.debug).matches()) {
                throw new Exception("Invalid value for debug parameter: " + this.debug + " must be true|false|client|{port}");
            }
            if (this.validPort.matcher(this.debug).matches()) {
                port = Integer.parseInt(this.debug);
            }
        }
        if (port <= 0) {
            throw new Exception("The specified debug port must be greater than 0");
        }
        if (this.debug != null && this.debug.toLowerCase().equals("client")) {
            this.args.add("-agentlib:jdwp=transport=dt_socket,address=" + this.debugHost + ":" + port + ",server=n,suspend=" + this.suspend);
        } else if (this.debug == null || !this.debug.toLowerCase().equals("false")) {
            if (this.debugPortOk == null) {
                try (Socket socket = new Socket(this.getInetAddress(this.debugHost), port);){
                    this.error("Port " + port + " in use, not starting in debug mode");
                    this.debugPortOk = false;
                }
                catch (IOException e) {
                    this.debugPortOk = true;
                }
            }
            if (this.debugPortOk.booleanValue()) {
                this.args.add("-agentlib:jdwp=transport=dt_socket,address=" + this.debugHost + ":" + port + ",server=y,suspend=" + this.suspend);
            }
        }
        StringBuilder classPathManifest = new StringBuilder();
        DevModeContext devModeContext = new DevModeContext();
        for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
            devModeContext.getSystemProperties().put(e.getKey().toString(), (String)e.getValue());
        }
        devModeContext.setProjectDir(this.projectDir);
        devModeContext.getBuildSystemProperties().putAll(this.buildSystemProperties);
        devModeContext.getBuildSystemProperties().putIfAbsent("quarkus.application.name", this.applicationName);
        devModeContext.getBuildSystemProperties().putIfAbsent("quarkus.application.version", this.applicationVersion);
        devModeContext.setSourceEncoding(this.sourceEncoding);
        devModeContext.setCompilerOptions(this.compilerOptions);
        if (this.compilerPluginArtifacts != null) {
            devModeContext.setCompilerPluginArtifacts(this.compilerPluginArtifacts);
        }
        if (this.compilerPluginOptions != null) {
            devModeContext.setCompilerPluginsOptions(this.compilerPluginOptions);
        }
        devModeContext.setReleaseJavaVersion(this.releaseJavaVersion);
        devModeContext.setSourceJavaVersion(this.sourceJavaVersion);
        devModeContext.setTargetJvmVersion(this.targetJavaVersion);
        devModeContext.getLocalArtifacts().addAll(this.localArtifacts);
        devModeContext.setApplicationRoot(this.main);
        devModeContext.getAdditionalModules().addAll(this.dependencies);
        this.args.add("-Djava.util.logging.manager=org.jboss.logmanager.LogManager");
        File tempFile = new File(this.buildDir, this.applicationName + "-dev.jar");
        tempFile.delete();
        if (this.deleteDevJar) {
            tempFile.deleteOnExit();
        }
        this.debug("Executable jar: %s", tempFile.getAbsolutePath());
        devModeContext.setBaseName(this.baseName);
        devModeContext.setCacheDir(new File(this.buildDir, "transformer-cache").getAbsoluteFile());
        devModeContext.setDevModeRunnerJarFile(tempFile);
        if (this.entryPointCustomizer != null) {
            this.entryPointCustomizer.accept(devModeContext);
        }
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(tempFile));){
            out.putNextEntry(new ZipEntry("META-INF/"));
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            if (!this.classpath.isEmpty()) {
                this.classpath.forEach(file -> {
                    URI uri = file.toPath().toAbsolutePath().toUri();
                    classPathManifest.append(uri).append(" ");
                });
            }
            manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, classPathManifest.toString());
            manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, DevModeMain.class.getName());
            out.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
            manifest.write(out);
            out.putNextEntry(new ZipEntry("META-INF/dev-mode-context.dat"));
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            ObjectOutputStream obj = new ObjectOutputStream(new DataOutputStream(bytes));
            obj.writeObject(devModeContext);
            obj.close();
            out.write(bytes.toByteArray());
        }
        this.outputDir.mkdirs();
        if (devModeContext.isEnablePreview()) {
            this.args.add("--enable-preview");
        }
        this.args.add("-jar");
        this.args.add(tempFile.getAbsolutePath());
        if (this.applicationArgs != null) {
            this.args.addAll(Arrays.asList(CommandLineUtils.translateCommandline((String)this.applicationArgs)));
        }
    }

    private InetAddress getInetAddress(String host) throws UnknownHostException {
        if ("localhost".equals(host)) {
            return InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        }
        return InetAddress.getByName(host);
    }

    public Collection<Path> watchedBuildFiles() {
        return this.buildFiles;
    }

    public List<String> args() {
        return this.args;
    }

    protected abstract boolean isDebugEnabled();

    protected void debug(Object msg, Object ... args) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (msg == null) {
            return;
        }
        if (args.length == 0) {
            this.debug(msg);
            return;
        }
        this.debug(String.format(msg.toString(), args));
    }

    protected abstract void debug(Object var1);

    protected abstract void error(Object var1);

    protected abstract void warn(Object var1);

    public class Builder<R extends QuarkusDevModeLauncher, B extends Builder<R, B>> {
        protected Builder(String java) {
            QuarkusDevModeLauncher.this.args = new ArrayList<String>();
            String javaTool = java == null ? JavaBinFinder.findBin() : java;
            QuarkusDevModeLauncher.this.debug("Using javaTool: %s", javaTool);
            QuarkusDevModeLauncher.this.args.add(javaTool);
        }

        public B preventnoverify(boolean preventnoverify) {
            if (!preventnoverify && !JavaVersionUtil.isJava13OrHigher()) {
                QuarkusDevModeLauncher.this.args.add("-Xverify:none");
            }
            return (B)this;
        }

        public B jvmArgs(String jvmArgs) {
            QuarkusDevModeLauncher.this.args.add(jvmArgs);
            return (B)this;
        }

        public B jvmArgs(List<String> jvmArgs) {
            QuarkusDevModeLauncher.this.args.addAll(jvmArgs);
            return (B)this;
        }

        public B debug(String debug) {
            QuarkusDevModeLauncher.this.debug = debug;
            return (B)this;
        }

        public B debugPortOk(Boolean debugPortOk) {
            QuarkusDevModeLauncher.this.debugPortOk = debugPortOk;
            return (B)this;
        }

        public B suspend(String suspend) {
            QuarkusDevModeLauncher.this.suspend = suspend;
            return (B)this;
        }

        public B projectDir(File projectDir) {
            QuarkusDevModeLauncher.this.projectDir = projectDir;
            return (B)this;
        }

        public B buildDir(File buildDir) {
            QuarkusDevModeLauncher.this.buildDir = buildDir;
            return (B)this;
        }

        public B outputDir(File outputDir) {
            QuarkusDevModeLauncher.this.outputDir = outputDir;
            return (B)this;
        }

        public B buildSystemProperties(Map<String, String> buildSystemProperties) {
            QuarkusDevModeLauncher.this.buildSystemProperties = buildSystemProperties;
            return (B)this;
        }

        public B buildSystemProperty(String name, String value) {
            QuarkusDevModeLauncher.this.buildSystemProperties.put(name, value);
            return (B)this;
        }

        public B applicationName(String appName) {
            QuarkusDevModeLauncher.this.applicationName = appName;
            return (B)this;
        }

        public B applicationVersion(String appVersion) {
            QuarkusDevModeLauncher.this.applicationVersion = appVersion;
            return (B)this;
        }

        public B applicationArgs(String appArgs) {
            QuarkusDevModeLauncher.this.applicationArgs = appArgs;
            return (B)this;
        }

        public B sourceEncoding(String srcEncoding) {
            QuarkusDevModeLauncher.this.sourceEncoding = srcEncoding;
            return (B)this;
        }

        public B compilerOptions(String name, List<String> options) {
            QuarkusDevModeLauncher.this.compilerOptions.compute(name, (key, value) -> {
                if (value == null) {
                    return new HashSet(options);
                }
                value.addAll(options);
                return value;
            });
            return (B)this;
        }

        public B compilerOptions(Map<String, Set<String>> options) {
            QuarkusDevModeLauncher.this.compilerOptions.putAll(options);
            return (B)this;
        }

        public B compilerPluginArtifacts(List<String> artifacts) {
            QuarkusDevModeLauncher.this.compilerPluginArtifacts = artifacts;
            return (B)this;
        }

        public B compilerPluginOptions(List<String> options) {
            QuarkusDevModeLauncher.this.compilerPluginOptions = options;
            return (B)this;
        }

        public B releaseJavaVersion(String releaseJavaVersion) {
            QuarkusDevModeLauncher.this.releaseJavaVersion = releaseJavaVersion;
            return (B)this;
        }

        public B sourceJavaVersion(String sourceJavaVersion) {
            QuarkusDevModeLauncher.this.sourceJavaVersion = sourceJavaVersion;
            return (B)this;
        }

        public B targetJavaVersion(String targetJavaVersion) {
            QuarkusDevModeLauncher.this.targetJavaVersion = targetJavaVersion;
            return (B)this;
        }

        public B watchedBuildFile(Path buildFile) {
            QuarkusDevModeLauncher.this.buildFiles.add(buildFile);
            return (B)this;
        }

        public B deleteDevJar(boolean deleteDevJar) {
            QuarkusDevModeLauncher.this.deleteDevJar = deleteDevJar;
            return (B)this;
        }

        public B baseName(String baseName) {
            QuarkusDevModeLauncher.this.baseName = baseName;
            return (B)this;
        }

        public B remoteDev(boolean remoteDev) {
            QuarkusDevModeLauncher.this.entryPointCustomizer = new Consumer<DevModeContext>(){

                @Override
                public void accept(DevModeContext devModeContext) {
                    devModeContext.setMode(QuarkusBootstrap.Mode.REMOTE_DEV_CLIENT);
                    devModeContext.setAlternateEntryPoint(IsolatedRemoteDevModeMain.class.getName());
                }
            };
            return (B)this;
        }

        public B entryPointCustomizer(Consumer<DevModeContext> consumer) {
            QuarkusDevModeLauncher.this.entryPointCustomizer = consumer;
            return (B)this;
        }

        public B localArtifact(ArtifactKey localArtifact) {
            QuarkusDevModeLauncher.this.localArtifacts.add(localArtifact);
            return (B)this;
        }

        public boolean isLocal(ArtifactKey artifact) {
            return QuarkusDevModeLauncher.this.localArtifacts.contains(artifact);
        }

        public B mainModule(DevModeContext.ModuleInfo mainModule) {
            QuarkusDevModeLauncher.this.main = mainModule;
            return (B)this;
        }

        public B dependency(DevModeContext.ModuleInfo module) {
            QuarkusDevModeLauncher.this.dependencies.add(module);
            return (B)this;
        }

        public B classpathEntry(File f) {
            QuarkusDevModeLauncher.this.classpath.add(f);
            return (B)this;
        }

        public B debugHost(String host) {
            if (null != host && !host.isEmpty()) {
                QuarkusDevModeLauncher.this.debugHost = host;
            }
            return (B)this;
        }

        public B debugPort(String port) {
            if (null != port && !port.isEmpty()) {
                QuarkusDevModeLauncher.this.debugPort = port;
            }
            return (B)this;
        }

        public R build() throws Exception {
            QuarkusDevModeLauncher.this.prepare();
            return (R)QuarkusDevModeLauncher.this;
        }
    }
}

