/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.deployment.OutputFilter;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.util.ExecUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class IsDockerWorking
implements BooleanSupplier {
    private static final Logger LOGGER = Logger.getLogger((String)IsDockerWorking.class.getName());
    public static final int DOCKER_HOST_CHECK_TIMEOUT = 1000;
    public static final int DOCKER_CMD_CHECK_TIMEOUT = 3000;
    private final List<Strategy> strategies;

    public IsDockerWorking() {
        this(false);
    }

    public IsDockerWorking(boolean silent) {
        this.strategies = List.of(new TestContainersStrategy(silent), new DockerHostStrategy(), new DockerBinaryStrategy(silent));
    }

    @Override
    public boolean getAsBoolean() {
        for (Strategy strategy : this.strategies) {
            LOGGER.debugf("Checking Docker Environment using strategy %s", (Object)strategy.getClass().getName());
            Result result = (Result)((Object)strategy.get());
            if (result != Result.AVAILABLE) continue;
            return true;
        }
        return false;
    }

    private static enum Result {
        AVAILABLE,
        UNAVAILABLE,
        UNKNOWN;

    }

    private static class DockerBinaryStrategy
    implements Strategy {
        private final boolean silent;
        private final String binary;

        private DockerBinaryStrategy(boolean silent) {
            this.silent = silent;
            this.binary = ConfigProvider.getConfig().getOptionalValue("quarkus.docker.executable-name", String.class).orElse("docker");
        }

        @Override
        public Result get() {
            try {
                if (!ExecUtil.execSilentWithTimeout(Duration.ofMillis(3000L), this.binary, "-v")) {
                    LOGGER.warnf("'%s -v' returned an error code. Make sure your Docker binary is correct", (Object)this.binary);
                    return Result.UNKNOWN;
                }
            }
            catch (Exception e) {
                LOGGER.warnf("No %s binary found or general error: %s", (Object)this.binary, (Object)e);
                return Result.UNKNOWN;
            }
            try {
                OutputFilter filter = new OutputFilter();
                if (ExecUtil.execWithTimeout(new File("."), filter, Duration.ofMillis(3000L), "docker", "version", "--format", "'{{.Server.Version}}'")) {
                    LOGGER.debugf("Docker daemon found. Version: %s", (Object)filter.getOutput());
                    return Result.AVAILABLE;
                }
                if (!this.silent) {
                    LOGGER.warn((Object)"Could not determine version of Docker daemon");
                }
                return Result.UNAVAILABLE;
            }
            catch (Exception e) {
                LOGGER.warn((Object)"Unexpected error occurred while determining Docker daemon version", (Throwable)e);
                return Result.UNKNOWN;
            }
        }
    }

    private static class DockerHostStrategy
    implements Strategy {
        private DockerHostStrategy() {
        }

        @Override
        public Result get() {
            String dockerHost = System.getenv("DOCKER_HOST");
            if (dockerHost != null && !dockerHost.startsWith("unix:")) {
                Result result;
                URI url = new URI(dockerHost);
                Socket s = new Socket();
                try {
                    s.connect(new InetSocketAddress(url.getHost(), url.getPort()), 1000);
                    result = Result.AVAILABLE;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            try {
                                s.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            LOGGER.warnf("Unable to connect to DOCKER_HOST URI %s, make sure docker is running on the specified host", (Object)dockerHost);
                        }
                    }
                    catch (IllegalArgumentException | URISyntaxException e) {
                        LOGGER.warnf("Unable to parse DOCKER_HOST URI %s, it will be ignored for working docker detection", (Object)dockerHost);
                    }
                }
                s.close();
                return result;
            }
            return Result.UNKNOWN;
        }
    }

    private static class TestContainersStrategy
    implements Strategy {
        private final boolean silent;

        private TestContainersStrategy(boolean silent) {
            this.silent = silent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Result get() {
            try (StartupLogCompressor compressor = new StartupLogCompressor("Checking Docker Environment", Optional.empty(), null, s -> s.getName().startsWith("ducttape"));){
                Class<?> dockerClientFactoryClass = Thread.currentThread().getContextClassLoader().loadClass("org.testcontainers.DockerClientFactory");
                Object dockerClientFactoryInstance = dockerClientFactoryClass.getMethod("instance", new Class[0]).invoke(null, new Object[0]);
                Class<?> configurationClass = Thread.currentThread().getContextClassLoader().loadClass("org.testcontainers.utility.TestcontainersConfiguration");
                Object configurationInstance = configurationClass.getMethod("instance", new Class[0]).invoke(null, new Object[0]);
                String oldReusePropertyValue = (String)configurationClass.getMethod("getUserProperty", String.class, String.class).invoke(configurationInstance, "testcontainers.reuse.enable", "false");
                Method updateUserConfigMethod = configurationClass.getMethod("updateUserConfig", String.class, String.class);
                updateUserConfigMethod.invoke(configurationInstance, "testcontainers.reuse.enable", "true");
                boolean isAvailable = (Boolean)dockerClientFactoryClass.getMethod("isDockerAvailable", new Class[0]).invoke(dockerClientFactoryInstance, new Object[0]);
                if (!isAvailable) {
                    compressor.closeAndDumpCaptured();
                }
                updateUserConfigMethod.invoke(configurationInstance, "testcontainers.reuse.enable", oldReusePropertyValue);
                Result result = isAvailable ? Result.AVAILABLE : Result.UNAVAILABLE;
                return result;
            }
        }
    }

    private static interface Strategy
    extends Supplier<Result> {
    }

    public static class IsDockerRunningSilent
    extends IsDockerWorking {
        public IsDockerRunningSilent() {
            super(true);
        }
    }
}

