/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.FilteredClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.prebuild.CodeGenException;
import io.quarkus.deployment.CodeGenContext;
import io.quarkus.deployment.CodeGenProvider;
import io.quarkus.deployment.codegen.CodeGenData;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.paths.PathCollection;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.smallrye.config.KeyMap;
import io.smallrye.config.KeyMapBackedConfigSource;
import io.smallrye.config.NameIterator;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SysPropConfigSource;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class CodeGenerator {
    private static final String MP_CONFIG_SPI_CONFIG_SOURCE_PROVIDER = "META-INF/services/org.eclipse.microprofile.config.spi.ConfigSourceProvider";

    public static void initAndRun(QuarkusClassLoader classLoader, PathCollection sourceParentDirs, Path generatedSourcesDir, Path buildDir, Consumer<Path> sourceRegistrar, ApplicationModel appModel, Properties properties, String launchMode, boolean test) throws CodeGenException {
        List<CodeGenData> generators = CodeGenerator.init((ClassLoader)classLoader, sourceParentDirs, generatedSourcesDir, buildDir, sourceRegistrar);
        if (generators.isEmpty()) {
            return;
        }
        LaunchMode mode = LaunchMode.valueOf((String)launchMode);
        Config config = CodeGenerator.getConfig(appModel, mode, properties, classLoader);
        for (CodeGenData generator : generators) {
            generator.setRedirectIO(true);
            CodeGenerator.trigger((ClassLoader)classLoader, generator, appModel, config, test);
        }
    }

    private static List<CodeGenData> init(ClassLoader deploymentClassLoader, PathCollection sourceParentDirs, Path generatedSourcesDir, Path buildDir, Consumer<Path> sourceRegistrar) throws CodeGenException {
        return CodeGenerator.callWithClassloader(deploymentClassLoader, () -> {
            List<CodeGenProvider> codeGenProviders = CodeGenerator.loadCodeGenProviders(deploymentClassLoader);
            if (codeGenProviders.isEmpty()) {
                return List.of();
            }
            ArrayList<CodeGenData> result = new ArrayList<CodeGenData>(codeGenProviders.size());
            for (CodeGenProvider provider : codeGenProviders) {
                Path outputDir = CodeGenerator.codeGenOutDir(generatedSourcesDir, provider, sourceRegistrar);
                for (Path sourceParentDir : sourceParentDirs) {
                    result.add(new CodeGenData(provider, outputDir, sourceParentDir.resolve(provider.inputDirectory()), buildDir));
                }
            }
            return result;
        });
    }

    public static List<CodeGenData> init(ClassLoader deploymentClassLoader, Collection<DevModeContext.ModuleInfo> modules) throws CodeGenException {
        return CodeGenerator.callWithClassloader(deploymentClassLoader, () -> {
            List<CodeGenProvider> codeGenProviders = null;
            List<CodeGenData> codeGens = List.of();
            for (DevModeContext.ModuleInfo module : modules) {
                if (module.getSourceParents().isEmpty() || module.getPreBuildOutputDir() == null) continue;
                if (codeGenProviders == null && (codeGenProviders = CodeGenerator.loadCodeGenProviders(deploymentClassLoader)).isEmpty()) {
                    return List.of();
                }
                for (CodeGenProvider provider : codeGenProviders) {
                    Path outputDir = CodeGenerator.codeGenOutDir(Path.of(module.getPreBuildOutputDir(), new String[0]), provider, sourcePath -> module.addSourcePathFirst(sourcePath.toAbsolutePath().toString()));
                    for (Path sourceParentDir : module.getSourceParents()) {
                        if (codeGens.isEmpty()) {
                            codeGens = new ArrayList();
                        }
                        codeGens.add(new CodeGenData(provider, outputDir, sourceParentDir.resolve(provider.inputDirectory()), Path.of(module.getTargetDir(), new String[0])));
                    }
                }
            }
            return codeGens;
        });
    }

    private static List<CodeGenProvider> loadCodeGenProviders(ClassLoader deploymentClassLoader) throws CodeGenException {
        Class<?> codeGenProviderClass;
        try {
            codeGenProviderClass = deploymentClassLoader.loadClass(CodeGenProvider.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new CodeGenException("Failed to load CodeGenProvider class from deployment classloader", (Throwable)e);
        }
        Iterator<?> i = ServiceLoader.load(codeGenProviderClass, deploymentClassLoader).iterator();
        if (!i.hasNext()) {
            return List.of();
        }
        ArrayList<CodeGenProvider> codeGenProviders = new ArrayList<CodeGenProvider>();
        while (i.hasNext()) {
            codeGenProviders.add((CodeGenProvider)i.next());
        }
        return codeGenProviders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T callWithClassloader(ClassLoader deploymentClassLoader, CodeGenAction<T> supplier) throws CodeGenException {
        ClassLoader originalClassloader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(deploymentClassLoader);
            T t = supplier.fire();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassloader);
        }
    }

    public static boolean trigger(ClassLoader deploymentClassLoader, CodeGenData data, ApplicationModel appModel, Config config, boolean test) throws CodeGenException {
        return CodeGenerator.callWithClassloader(deploymentClassLoader, () -> {
            CodeGenProvider provider = data.provider;
            return provider.shouldRun(data.sourceDir, config) && provider.trigger(new CodeGenContext(appModel, data.outPath, data.buildDir, data.sourceDir, data.redirectIO, config, test));
        });
    }

    public static Config getConfig(ApplicationModel appModel, LaunchMode launchMode, Properties buildSystemProps, QuarkusClassLoader deploymentClassLoader) throws CodeGenException {
        if (appModel.getAppArtifact().getContentTree().contains(MP_CONFIG_SPI_CONFIG_SOURCE_PROVIDER)) {
            List allElements = deploymentClassLoader.getAllElements(false);
            QuarkusClassLoader.Builder configClBuilder = QuarkusClassLoader.builder((String)"CodeGenerator Config ClassLoader", (ClassLoader)QuarkusClassLoader.getSystemClassLoader(), (boolean)false);
            Collection appRoots = appModel.getAppArtifact().getContentTree().getRoots();
            for (ClassPathElement e : allElements) {
                if (appRoots.contains(e.getRoot())) {
                    configClBuilder.addElement((ClassPathElement)new FilteredClassPathElement(e, List.of(MP_CONFIG_SPI_CONFIG_SOURCE_PROVIDER)));
                    continue;
                }
                configClBuilder.addElement(e);
            }
            deploymentClassLoader = configClBuilder.build();
        }
        SmallRyeConfigBuilder builder = ConfigUtils.configBuilder((boolean)false, (LaunchMode)launchMode).forClassLoader((ClassLoader)deploymentClassLoader);
        PropertiesConfigSource pcs = new PropertiesConfigSource(buildSystemProps, "Build system");
        SysPropConfigSource spcs = new SysPropConfigSource();
        Map platformProperties = appModel.getPlatformProperties();
        if (platformProperties.isEmpty()) {
            builder.withSources(new ConfigSource[]{pcs, spcs});
        } else {
            KeyMap props = new KeyMap(platformProperties.size());
            for (Map.Entry prop : platformProperties.entrySet()) {
                props.findOrAdd(new NameIterator((String)prop.getKey())).putRootValue((Object)((String)prop.getValue()));
            }
            KeyMapBackedConfigSource platformConfigSource = new KeyMapBackedConfigSource("Quarkus platform", -2147482648, props);
            builder.withSources(new ConfigSource[]{platformConfigSource, pcs, spcs});
        }
        return builder.build();
    }

    private static Path codeGenOutDir(Path generatedSourcesDir, CodeGenProvider provider, Consumer<Path> sourceRegistrar) throws CodeGenException {
        Path outputDir = generatedSourcesDir.resolve(provider.providerId());
        try {
            Files.createDirectories(outputDir, new FileAttribute[0]);
            sourceRegistrar.accept(outputDir);
            return outputDir;
        }
        catch (IOException e) {
            throw new CodeGenException("Failed to create output directory for generated sources: " + outputDir.toAbsolutePath(), (Throwable)e);
        }
    }

    @FunctionalInterface
    private static interface CodeGenAction<T> {
        public T fire() throws CodeGenException;
    }
}

