/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.annotations.ConvertWith;
import io.quarkus.runtime.configuration.TrimmedStringConverter;
import io.quarkus.runtime.util.ContainerRuntimeUtil;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;

@ConfigRoot(phase=ConfigPhase.BUILD_TIME)
public class NativeConfig {
    public static final String DEFAULT_GRAALVM_BUILDER_IMAGE = "quay.io/quarkus/ubi-quarkus-graalvmce-builder-image:22.3-java17";
    public static final String DEFAULT_MANDREL_BUILDER_IMAGE = "quay.io/quarkus/ubi-quarkus-mandrel-builder-image:22.3-java17";
    @ConfigItem
    public Optional<List<String>> additionalBuildArgs;
    @ConfigItem(defaultValue="true")
    public boolean enableHttpUrlHandler;
    @ConfigItem
    public boolean enableHttpsUrlHandler;
    @ConfigItem
    @Deprecated
    public boolean enableAllSecurityServices;
    @Deprecated
    @ConfigItem(defaultValue="true")
    public boolean inlineBeforeAnalysis;
    @Deprecated
    @ConfigItem(defaultValue="true")
    public boolean enableJni;
    @ConfigItem(defaultValue="true")
    public boolean headless;
    @ConfigItem
    @ConvertWith(value=TrimmedStringConverter.class)
    @Deprecated
    public Optional<String> userLanguage;
    @ConfigItem
    @ConvertWith(value=TrimmedStringConverter.class)
    @Deprecated
    public Optional<String> userCountry;
    @ConfigItem(defaultValue="UTF-8")
    @ConvertWith(value=TrimmedStringConverter.class)
    public String fileEncoding;
    @ConfigItem
    public boolean addAllCharsets;
    @ConfigItem(defaultValue="${GRAALVM_HOME:}")
    public Optional<String> graalvmHome;
    @ConfigItem(defaultValue="${java.home}")
    public File javaHome;
    @ConfigItem
    public Optional<String> nativeImageXmx;
    @ConfigItem
    public boolean debugBuildProcess;
    @ConfigItem(defaultValue="true")
    public boolean publishDebugBuildProcessPort;
    @Deprecated
    @ConfigItem
    public boolean cleanupServer;
    @ConfigItem(defaultValue="true")
    public boolean enableIsolates;
    @ConfigItem
    public boolean enableFallbackImages;
    @Deprecated
    @ConfigItem
    public boolean enableServer;
    @ConfigItem
    public boolean autoServiceLoaderRegistration;
    @ConfigItem
    public boolean dumpProxies;
    @ConfigItem
    public Optional<Boolean> containerBuild;
    @ConfigItem
    public boolean remoteContainerBuild;
    @ConfigItem(defaultValue="${platform.quarkus.native.builder-image}")
    public String builderImage;
    @ConfigItem
    public Optional<ContainerRuntimeUtil.ContainerRuntime> containerRuntime;
    @ConfigItem
    public Optional<List<String>> containerRuntimeOptions;
    @ConfigItem
    public boolean enableVmInspection;
    @ConfigItem(defaultValue="true")
    public boolean fullStackTraces;
    @ConfigItem
    public boolean enableReports;
    @ConfigItem(defaultValue="true")
    public boolean reportExceptionStackTraces;
    @ConfigItem
    public boolean reportErrorsAtRuntime;
    @ConfigItem(defaultValue="false")
    public boolean reuseExisting;
    @ConfigItem
    public ResourcesConfig resources;
    @ConfigItem
    public Debug debug;
    @ConfigItem
    public boolean enableDashboardDump;
    @ConfigItem
    public Compression compression;

    public boolean isContainerBuild() {
        return this.containerBuild.orElse(this.containerRuntime.isPresent() || this.remoteContainerBuild);
    }

    public String getEffectiveBuilderImage() {
        String builderImageName = this.builderImage.toUpperCase();
        if (builderImageName.equals(BuilderImageProvider.GRAALVM.name())) {
            return DEFAULT_GRAALVM_BUILDER_IMAGE;
        }
        if (builderImageName.equals(BuilderImageProvider.MANDREL.name())) {
            return DEFAULT_MANDREL_BUILDER_IMAGE;
        }
        return this.builderImage;
    }

    public static enum BuilderImageProvider {
        GRAALVM,
        MANDREL;

    }

    @ConfigGroup
    public static class Compression {
        @ConfigItem
        public OptionalInt level;
        @ConfigItem
        public Optional<List<String>> additionalArgs;
    }

    @ConfigGroup
    public static class Debug {
        @ConfigItem
        public boolean enabled;
    }

    @ConfigGroup
    public static class ResourcesConfig {
        @ConfigItem
        public Optional<List<String>> includes;
        @ConfigItem
        public Optional<List<String>> excludes;
    }
}

