/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.GeneratedNativeImageClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ForceNonWeakReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.JPMSExportBuildItem;
import io.quarkus.deployment.builditem.nativeimage.JniRuntimeAccessBuildItem;
import io.quarkus.deployment.builditem.nativeimage.LambdaCapturingTypeBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourcePatternsBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveFieldBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedPackageBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeReinitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.builditem.nativeimage.UnsafeAccessedFieldBuildItem;
import io.quarkus.deployment.pkg.steps.GraalVM;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.runtime.NativeImageFeatureUtils;
import io.quarkus.runtime.ResourceHelper;
import io.quarkus.runtime.graal.WeakReflection;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.graalvm.home.Version;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public class NativeImageFeatureStep {
    public static final String GRAAL_FEATURE = "io.quarkus.runner.Feature";
    private static final MethodDescriptor VERSION_CURRENT = MethodDescriptor.ofMethod(Version.class, (String)"getCurrent", Version.class, (Class[])new Class[0]);
    private static final MethodDescriptor VERSION_COMPARE_TO = MethodDescriptor.ofMethod(Version.class, (String)"compareTo", Integer.TYPE, (Class[])new Class[]{int[].class});
    private static final MethodDescriptor IMAGE_SINGLETONS_LOOKUP = MethodDescriptor.ofMethod(ImageSingletons.class, (String)"lookup", Object.class, (Class[])new Class[]{Class.class});
    private static final MethodDescriptor BUILD_TIME_INITIALIZATION = MethodDescriptor.ofMethod(RuntimeClassInitialization.class, (String)"initializeAtBuildTime", Void.TYPE, (Class[])new Class[]{String[].class});
    private static final MethodDescriptor INITIALIZE_CLASSES_AT_RUN_TIME = MethodDescriptor.ofMethod(RuntimeClassInitialization.class, (String)"initializeAtRunTime", Void.TYPE, (Class[])new Class[]{Class[].class});
    private static final MethodDescriptor INITIALIZE_PACKAGES_AT_RUN_TIME = MethodDescriptor.ofMethod(RuntimeClassInitialization.class, (String)"initializeAtRunTime", Void.TYPE, (Class[])new Class[]{String[].class});
    public static final String RUNTIME_CLASS_INITIALIZATION_SUPPORT = "org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport";
    private static final MethodDescriptor RERUN_INITIALIZATION = MethodDescriptor.ofMethod((Object)"org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport", (String)"rerunInitialization", Void.TYPE, (Object[])new Object[]{Class.class, String.class});
    public static final String CONFIGURATION_CONDITION = "org.graalvm.nativeimage.impl.ConfigurationCondition";
    private static final MethodDescriptor CONFIGURATION_ALWAYS_TRUE = MethodDescriptor.ofMethod((String)"org.graalvm.nativeimage.impl.ConfigurationCondition", (String)"alwaysTrue", (String)"org.graalvm.nativeimage.impl.ConfigurationCondition", (String[])new String[0]);
    private static final MethodDescriptor REGISTER_LAMBDA_CAPTURING_CLASS = MethodDescriptor.ofMethod((Object)"org.graalvm.nativeimage.impl.RuntimeSerializationSupport", (String)"registerLambdaCapturingClass", Void.TYPE, (Object[])new Object[]{"org.graalvm.nativeimage.impl.ConfigurationCondition", String.class});
    private static final MethodDescriptor LOOKUP_METHOD = MethodDescriptor.ofMethod(NativeImageFeatureUtils.class, (String)"lookupMethod", Method.class, (Class[])new Class[]{Class.class, String.class, Class[].class});
    private static final MethodDescriptor FIND_MODULE_METHOD = MethodDescriptor.ofMethod(NativeImageFeatureUtils.class, (String)"findModule", Module.class, (Class[])new Class[]{String.class});
    private static final MethodDescriptor INVOKE = MethodDescriptor.ofMethod(Method.class, (String)"invoke", Object.class, (Class[])new Class[]{Object.class, Object[].class});
    static final String RUNTIME_REFLECTION = RuntimeReflection.class.getName();
    static final String LEGACY_JNI_RUNTIME_ACCESS = "com.oracle.svm.core.jni.JNIRuntimeAccess";
    static final String JNI_RUNTIME_ACCESS = "org.graalvm.nativeimage.hosted.RuntimeJNIAccess";
    static final String BEFORE_ANALYSIS_ACCESS = Feature.BeforeAnalysisAccess.class.getName();
    static final String DURING_SETUP_ACCESS = Feature.DuringSetupAccess.class.getName();
    static final String DYNAMIC_PROXY_REGISTRY = "com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry";
    static final String LOCALIZATION_FEATURE = "com.oracle.svm.core.jdk.localization.LocalizationFeature";
    static final String RUNTIME_RESOURCE_SUPPORT = "org.graalvm.nativeimage.impl.RuntimeResourceSupport";
    public static final MethodDescriptor WEAK_REFLECTION_REGISTRATION = MethodDescriptor.ofMethod(WeakReflection.class, (String)"register", Void.TYPE, (Class[])new Class[]{Feature.BeforeAnalysisAccess.class, Class.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
    public static final String RUNTIME_SERIALIZATION = "org.graalvm.nativeimage.hosted.RuntimeSerialization";

    @BuildStep
    GeneratedResourceBuildItem generateNativeResourcesList(List<NativeImageResourceBuildItem> resources, BuildProducer<NativeImageResourcePatternsBuildItem> resourcePatternsBuildItemBuildProducer) {
        StringBuilder sb = new StringBuilder();
        for (NativeImageResourceBuildItem i : resources) {
            for (String r : i.getResources()) {
                sb.append(r);
                sb.append("\n");
            }
        }
        resourcePatternsBuildItemBuildProducer.produce(NativeImageResourcePatternsBuildItem.builder().excludePattern("META-INF/quarkus-native-resources.txt").build());
        return new GeneratedResourceBuildItem("META-INF/quarkus-native-resources.txt", sb.toString().getBytes(StandardCharsets.UTF_8));
    }

    @BuildStep
    void addExportsToNativeImage(BuildProducer<JPMSExportBuildItem> features, List<JniRuntimeAccessBuildItem> jniRuntimeAccessibleClasses, List<LambdaCapturingTypeBuildItem> lambdaCapturingTypeBuildItems, List<NativeImageResourcePatternsBuildItem> resourcePatterns) {
        features.produce(new JPMSExportBuildItem("org.graalvm.sdk", "org.graalvm.nativeimage.impl"));
        if (jniRuntimeAccessibleClasses != null && !jniRuntimeAccessibleClasses.isEmpty()) {
            features.produce(new JPMSExportBuildItem("org.graalvm.nativeimage.builder", "com.oracle.svm.core.jni", null, GraalVM.Version.VERSION_22_3_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    @BuildStep
    void generateFeature(final BuildProducer<GeneratedNativeImageClassBuildItem> nativeImageClass, BuildProducer<JPMSExportBuildItem> exports, List<RuntimeInitializedClassBuildItem> runtimeInitializedClassBuildItems, List<RuntimeInitializedPackageBuildItem> runtimeInitializedPackageBuildItems, List<RuntimeReinitializedClassBuildItem> runtimeReinitializedClassBuildItems, List<NativeImageProxyDefinitionBuildItem> proxies, List<NativeImageResourcePatternsBuildItem> resourcePatterns, List<NativeImageResourceBundleBuildItem> resourceBundles, List<ReflectiveMethodBuildItem> reflectiveMethods, List<ReflectiveFieldBuildItem> reflectiveFields, List<ReflectiveClassBuildItem> reflectiveClassBuildItems, List<ForceNonWeakReflectiveClassBuildItem> nonWeakReflectiveClassBuildItems, List<ServiceProviderBuildItem> serviceProviderBuildItems, List<UnsafeAccessedFieldBuildItem> unsafeAccessedFields, List<JniRuntimeAccessBuildItem> jniRuntimeAccessibleClasses, List<LambdaCapturingTypeBuildItem> lambdaCapturingTypeBuildItems) {
        CatchBlockCreator cc;
        ResultHandle clazz;
        ResultHandle thisClass;
        TryBlock tc;
        ClassCreator file = new ClassCreator(new ClassOutput(){

            public void write(String s, byte[] bytes) {
                nativeImageClass.produce(new GeneratedNativeImageClassBuildItem(s, bytes));
            }
        }, GRAAL_FEATURE, null, Object.class.getName(), new String[]{Feature.class.getName()});
        MethodCreator getDescription = file.getMethodCreator("getDescription", String.class, new Class[0]);
        getDescription.returnValue(getDescription.load("Auto-generated class by Quarkus from the existing extensions"));
        MethodCreator duringSetup = file.getMethodCreator("duringSetup", "V", new String[]{DURING_SETUP_ACCESS});
        if (!lambdaCapturingTypeBuildItems.isEmpty()) {
            BranchResult graalVm22_3Test = duringSetup.ifGreaterEqualZero(duringSetup.invokeVirtualMethod(VERSION_COMPARE_TO, duringSetup.invokeStaticMethod(VERSION_CURRENT, new ResultHandle[0]), new ResultHandle[]{duringSetup.marshalAsArray(Integer.TYPE, new ResultHandle[]{duringSetup.load(22), duringSetup.load(3)})}));
            try (BytecodeCreator greaterThan22_2 = graalVm22_3Test.trueBranch();){
                MethodDescriptor registerLambdaCapturingClass = MethodDescriptor.ofMethod((Object)RUNTIME_SERIALIZATION, (String)"registerLambdaCapturingClass", Void.TYPE, (Object[])new Object[]{Class.class});
                for (LambdaCapturingTypeBuildItem lambdaCapturingTypeBuildItem : lambdaCapturingTypeBuildItems) {
                    TryBlock tryBlock = greaterThan22_2.tryBlock();
                    tryBlock.invokeStaticMethod(registerLambdaCapturingClass, new ResultHandle[]{tryBlock.loadClassFromTCCL(lambdaCapturingTypeBuildItem.getClassName())});
                    CatchBlockCreator catchBlock = tryBlock.addCatch(Throwable.class);
                    catchBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), catchBlock.getCaughtException(), new ResultHandle[0]);
                }
            }
            try (BytecodeCreator smallerThan22_3 = graalVm22_3Test.falseBranch();){
                ResultHandle runtimeSerializationSupportSingleton = smallerThan22_3.invokeStaticMethod(IMAGE_SINGLETONS_LOOKUP, new ResultHandle[]{smallerThan22_3.loadClassFromTCCL("org.graalvm.nativeimage.impl.RuntimeSerializationSupport")});
                ResultHandle configAlwaysTrue = smallerThan22_3.invokeStaticMethod(CONFIGURATION_ALWAYS_TRUE, new ResultHandle[0]);
                for (LambdaCapturingTypeBuildItem i : lambdaCapturingTypeBuildItems) {
                    TryBlock tryBlock = smallerThan22_3.tryBlock();
                    tryBlock.invokeInterfaceMethod(REGISTER_LAMBDA_CAPTURING_CLASS, runtimeSerializationSupportSingleton, new ResultHandle[]{configAlwaysTrue, tryBlock.load(i.getClassName())});
                    CatchBlockCreator catchBlockCreator = tryBlock.addCatch(Throwable.class);
                    catchBlockCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), catchBlockCreator.getCaughtException(), new ResultHandle[0]);
                }
            }
        }
        duringSetup.returnValue(null);
        MethodCreator beforeAn = file.getMethodCreator("beforeAnalysis", "V", new String[]{BEFORE_ANALYSIS_ACCESS});
        TryBlock overallCatch = beforeAn.tryBlock();
        ResultHandle beforeAnalysisParam = beforeAn.getMethodParam(0);
        for (UnsafeAccessedFieldBuildItem unsafeAccessedFieldBuildItem : unsafeAccessedFields) {
            tc = overallCatch.tryBlock();
            ResultHandle declaringClassHandle = tc.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class}), new ResultHandle[]{tc.load(unsafeAccessedFieldBuildItem.getDeclaringClass())});
            ResultHandle resultHandle = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredField", Field.class, (Class[])new Class[]{String.class}), declaringClassHandle, new ResultHandle[]{tc.load(unsafeAccessedFieldBuildItem.getFieldName())});
            tc.invokeInterfaceMethod(MethodDescriptor.ofMethod(Feature.BeforeAnalysisAccess.class, (String)"registerAsUnsafeAccessed", Void.TYPE, (Class[])new Class[]{Field.class}), beforeAnalysisParam, new ResultHandle[]{resultHandle});
            CatchBlockCreator catchBlockCreator = tc.addCatch(Throwable.class);
            catchBlockCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), catchBlockCreator.getCaughtException(), new ResultHandle[0]);
        }
        overallCatch.invokeStaticMethod(BUILD_TIME_INITIALIZATION, new ResultHandle[]{overallCatch.marshalAsArray(String.class, new ResultHandle[]{overallCatch.load("")})});
        if (!runtimeInitializedClassBuildItems.isEmpty()) {
            thisClass = overallCatch.loadClassFromTCCL(GRAAL_FEATURE);
            ResultHandle resultHandle = overallCatch.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getClassLoader", ClassLoader.class, (Class[])new Class[0]), thisClass, new ResultHandle[0]);
            ResultHandle classes = overallCatch.newArray(Class.class, overallCatch.load(runtimeInitializedClassBuildItems.size()));
            for (int i = 0; i < runtimeInitializedClassBuildItems.size(); ++i) {
                TryBlock tryBlock = overallCatch.tryBlock();
                ResultHandle resultHandle2 = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class}), new ResultHandle[]{tryBlock.load(runtimeInitializedClassBuildItems.get(i).getClassName()), tryBlock.load(false), resultHandle});
                tryBlock.writeArrayValue(classes, i, resultHandle2);
                CatchBlockCreator cc3 = tryBlock.addCatch(Throwable.class);
                cc3.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc3.getCaughtException(), new ResultHandle[0]);
            }
            overallCatch.invokeStaticMethod(INITIALIZE_CLASSES_AT_RUN_TIME, new ResultHandle[]{classes});
        }
        if (!runtimeInitializedPackageBuildItems.isEmpty()) {
            void var24_36;
            ResultHandle packages = overallCatch.newArray(String.class, overallCatch.load(runtimeInitializedPackageBuildItems.size()));
            boolean bl = false;
            while (var24_36 < runtimeInitializedPackageBuildItems.size()) {
                tc = overallCatch.tryBlock();
                ResultHandle pkg = tc.load(runtimeInitializedPackageBuildItems.get((int)var24_36).getPackageName());
                tc.writeArrayValue(packages, (int)var24_36, pkg);
                CatchBlockCreator catchBlockCreator = tc.addCatch(Throwable.class);
                catchBlockCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), catchBlockCreator.getCaughtException(), new ResultHandle[0]);
                ++var24_36;
            }
            overallCatch.invokeStaticMethod(INITIALIZE_PACKAGES_AT_RUN_TIME, new ResultHandle[]{packages});
        }
        if (!runtimeReinitializedClassBuildItems.isEmpty()) {
            thisClass = overallCatch.loadClassFromTCCL(GRAAL_FEATURE);
            ResultHandle resultHandle = overallCatch.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getClassLoader", ClassLoader.class, (Class[])new Class[0]), thisClass, new ResultHandle[0]);
            ResultHandle quarkus = overallCatch.load("Quarkus");
            ResultHandle imageSingleton = overallCatch.invokeStaticMethod(IMAGE_SINGLETONS_LOOKUP, new ResultHandle[]{overallCatch.loadClassFromTCCL(RUNTIME_CLASS_INITIALIZATION_SUPPORT)});
            for (RuntimeReinitializedClassBuildItem runtimeReinitializedClassBuildItem : runtimeReinitializedClassBuildItems) {
                TryBlock tc3 = overallCatch.tryBlock();
                clazz = tc3.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class}), new ResultHandle[]{tc3.load(runtimeReinitializedClassBuildItem.getClassName()), tc3.load(false), resultHandle});
                tc3.invokeInterfaceMethod(RERUN_INITIALIZATION, imageSingleton, new ResultHandle[]{clazz, quarkus});
                cc = tc3.addCatch(Throwable.class);
                cc.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc.getCaughtException(), new ResultHandle[0]);
            }
        }
        if (!proxies.isEmpty()) {
            exports.produce(new JPMSExportBuildItem("org.graalvm.nativeimage.builder", "com.oracle.svm.core.jdk.proxy", null, GraalVM.Version.VERSION_22_3_0));
            ResultHandle versionCompareto22_3Result = overallCatch.invokeVirtualMethod(VERSION_COMPARE_TO, overallCatch.invokeStaticMethod(VERSION_CURRENT, new ResultHandle[0]), new ResultHandle[]{overallCatch.marshalAsArray(Integer.TYPE, new ResultHandle[]{overallCatch.load(22), overallCatch.load(3)})});
            for (NativeImageProxyDefinitionBuildItem proxy : proxies) {
                ResultHandle array = overallCatch.newArray(Class.class, overallCatch.load(proxy.getClasses().size()));
                boolean bl = false;
                for (String p : proxy.getClasses()) {
                    void var27_67;
                    clazz = overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class}), new ResultHandle[]{overallCatch.load(p)});
                    overallCatch.writeArrayValue(array, (int)(++var27_67), clazz);
                }
                BranchResult branchResult = overallCatch.ifGreaterEqualZero(versionCompareto22_3Result);
                try (BytecodeCreator greaterThan22_2 = branchResult.trueBranch();){
                    MethodDescriptor registerMethod = MethodDescriptor.ofMethod((Object)"org.graalvm.nativeimage.hosted.RuntimeProxyCreation", (String)"register", Void.TYPE, (Object[])new Object[]{Class[].class});
                    greaterThan22_2.invokeStaticMethod(registerMethod, new ResultHandle[]{array});
                }
                BytecodeCreator smallerThan22_3 = branchResult.falseBranch();
                try {
                    ResultHandle proxySupportClass = smallerThan22_3.loadClassFromTCCL(DYNAMIC_PROXY_REGISTRY);
                    ResultHandle proxySupport = smallerThan22_3.invokeStaticMethod(IMAGE_SINGLETONS_LOOKUP, new ResultHandle[]{proxySupportClass});
                    smallerThan22_3.invokeInterfaceMethod(MethodDescriptor.ofMethod((Object)DYNAMIC_PROXY_REGISTRY, (String)"addProxyClass", Void.TYPE, (Object[])new Object[]{Class[].class}), proxySupport, new ResultHandle[]{array});
                }
                finally {
                    if (smallerThan22_3 == null) continue;
                    smallerThan22_3.close();
                }
            }
        }
        if (!resourcePatterns.isEmpty()) {
            exports.produce(new JPMSExportBuildItem("org.graalvm.nativeimage.builder", "com.oracle.svm.core.configure", null, GraalVM.Version.VERSION_22_3_0));
            TryBlock tc4 = overallCatch.tryBlock();
            ResultHandle resultHandle = tc4.marshalAsArray(Class.class, new ResultHandle[]{tc4.loadClassFromTCCL(CONFIGURATION_CONDITION), tc4.loadClassFromTCCL(String.class)});
            AssignableResultHandle resourcesArgs = tc4.createVariable(Object[].class);
            tc4.assign(resourcesArgs, tc4.marshalAsArray(Object.class, new ResultHandle[]{tc4.invokeStaticMethod(CONFIGURATION_ALWAYS_TRUE, new ResultHandle[0]), tc4.loadNull()}));
            AssignableResultHandle ignoreResourcesMethod = tc4.createVariable(Method.class);
            AssignableResultHandle assignableResultHandle = tc4.createVariable(Method.class);
            AssignableResultHandle assignableResultHandle2 = tc4.createVariable(Object.class);
            BranchResult graalVm22_3Test = tc4.ifGreaterEqualZero(tc4.invokeVirtualMethod(VERSION_COMPARE_TO, tc4.invokeStaticMethod(VERSION_CURRENT, new ResultHandle[0]), new ResultHandle[]{tc4.marshalAsArray(Integer.TYPE, new ResultHandle[]{tc4.load(22), tc4.load(3)})}));
            try (BytecodeCreator greaterThan22_2 = graalVm22_3Test.trueBranch();){
                ResultHandle runtimeResourceSupportClass = greaterThan22_2.loadClassFromTCCL(RUNTIME_RESOURCE_SUPPORT);
                greaterThan22_2.assign(assignableResultHandle2, greaterThan22_2.invokeStaticMethod(IMAGE_SINGLETONS_LOOKUP, new ResultHandle[]{runtimeResourceSupportClass}));
                greaterThan22_2.assign(ignoreResourcesMethod, greaterThan22_2.invokeStaticMethod(LOOKUP_METHOD, new ResultHandle[]{runtimeResourceSupportClass, greaterThan22_2.load("ignoreResources"), resultHandle}));
                greaterThan22_2.assign(assignableResultHandle, greaterThan22_2.invokeStaticMethod(LOOKUP_METHOD, new ResultHandle[]{runtimeResourceSupportClass, greaterThan22_2.load("addResources"), resultHandle}));
            }
            try (BytecodeCreator smallerThan22_3 = graalVm22_3Test.falseBranch();){
                ResultHandle resourceRegistryClass = smallerThan22_3.loadClassFromTCCL("com.oracle.svm.core.configure.ResourcesRegistry");
                smallerThan22_3.assign(assignableResultHandle2, smallerThan22_3.invokeStaticMethod(IMAGE_SINGLETONS_LOOKUP, new ResultHandle[]{resourceRegistryClass}));
                smallerThan22_3.assign(ignoreResourcesMethod, smallerThan22_3.invokeStaticMethod(LOOKUP_METHOD, new ResultHandle[]{resourceRegistryClass, smallerThan22_3.load("ignoreResources"), resultHandle}));
                smallerThan22_3.assign(assignableResultHandle, smallerThan22_3.invokeStaticMethod(LOOKUP_METHOD, new ResultHandle[]{resourceRegistryClass, smallerThan22_3.load("addResources"), resultHandle}));
            }
            ResultHandle indexOne = tc4.load(1);
            for (NativeImageResourcePatternsBuildItem nativeImageResourcePatternsBuildItem : resourcePatterns) {
                for (String pattern : nativeImageResourcePatternsBuildItem.getExcludePatterns()) {
                    tc4.writeArrayValue((ResultHandle)resourcesArgs, indexOne, tc4.load(pattern));
                    tc4.invokeVirtualMethod(INVOKE, (ResultHandle)ignoreResourcesMethod, new ResultHandle[]{assignableResultHandle2, resourcesArgs});
                }
                for (String pattern : nativeImageResourcePatternsBuildItem.getIncludePatterns()) {
                    tc4.writeArrayValue((ResultHandle)resourcesArgs, indexOne, tc4.load(pattern));
                    tc4.invokeVirtualMethod(INVOKE, (ResultHandle)assignableResultHandle, new ResultHandle[]{assignableResultHandle2, resourcesArgs});
                }
            }
            cc = tc4.addCatch(Throwable.class);
            cc.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc.getCaughtException(), new ResultHandle[0]);
        }
        for (ServiceProviderBuildItem serviceProviderBuildItem : serviceProviderBuildItems) {
            overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod(ResourceHelper.class, (String)"registerResources", Void.TYPE, (Class[])new Class[]{String.class}), new ResultHandle[]{overallCatch.load(serviceProviderBuildItem.serviceDescriptorFile())});
        }
        if (!resourceBundles.isEmpty()) {
            exports.produce(new JPMSExportBuildItem("org.graalvm.nativeimage.builder", "com.oracle.svm.core.jdk.localization", null, GraalVM.Version.VERSION_22_3_0));
            BranchResult graalVm22_3Test = overallCatch.ifGreaterEqualZero(overallCatch.invokeVirtualMethod(VERSION_COMPARE_TO, overallCatch.invokeStaticMethod(VERSION_CURRENT, new ResultHandle[0]), new ResultHandle[]{overallCatch.marshalAsArray(Integer.TYPE, new ResultHandle[]{overallCatch.load(22), overallCatch.load(3)})}));
            try (BytecodeCreator bytecodeCreator = graalVm22_3Test.trueBranch();){
                MethodDescriptor addResourceBundle = MethodDescriptor.ofMethod((Object)"org.graalvm.nativeimage.hosted.RuntimeResourceAccess", (String)"addResourceBundle", Void.TYPE, (Object[])new Object[]{Module.class, String.class});
                for (NativeImageResourceBundleBuildItem nativeImageResourceBundleBuildItem : resourceBundles) {
                    TryBlock tryBlock = bytecodeCreator.tryBlock();
                    String moduleName = nativeImageResourceBundleBuildItem.getModuleName();
                    ResultHandle moduleNameHandle = moduleName == null ? tryBlock.loadNull() : tryBlock.load(moduleName);
                    ResultHandle module = tryBlock.invokeStaticMethod(FIND_MODULE_METHOD, new ResultHandle[]{moduleNameHandle});
                    tryBlock.invokeStaticMethod(addResourceBundle, new ResultHandle[]{module, tryBlock.load(nativeImageResourceBundleBuildItem.getBundleName())});
                    CatchBlockCreator catchBlockCreator = tryBlock.addCatch(Throwable.class);
                }
            }
            try (BytecodeCreator bytecodeCreator = graalVm22_3Test.falseBranch();){
                ResultHandle locClass = bytecodeCreator.loadClassFromTCCL(LOCALIZATION_FEATURE);
                ResultHandle newParams = bytecodeCreator.marshalAsArray(Class.class, new ResultHandle[]{bytecodeCreator.loadClassFromTCCL(String.class)});
                ResultHandle resultHandle = bytecodeCreator.invokeStaticMethod(LOOKUP_METHOD, new ResultHandle[]{locClass, bytecodeCreator.load("prepareBundle"), newParams});
                ResultHandle resultHandle3 = bytecodeCreator.invokeStaticMethod(IMAGE_SINGLETONS_LOOKUP, new ResultHandle[]{locClass});
                for (NativeImageResourceBundleBuildItem i : resourceBundles) {
                    TryBlock et = bytecodeCreator.tryBlock();
                    et.invokeVirtualMethod(MethodDescriptor.ofMethod(Method.class, (String)"invoke", Object.class, (Class[])new Class[]{Object.class, Object[].class}), resultHandle, new ResultHandle[]{resultHandle3, et.marshalAsArray(Object.class, new ResultHandle[]{et.load(i.getBundleName())})});
                    CatchBlockCreator catchBlockCreator = et.addCatch(Throwable.class);
                }
            }
        }
        int count = 0;
        LinkedHashMap<String, ReflectionInfo> linkedHashMap = new LinkedHashMap<String, ReflectionInfo>();
        HashSet<String> forcedNonWeakClasses = new HashSet<String>();
        for (ForceNonWeakReflectiveClassBuildItem forceNonWeakReflectiveClassBuildItem : nonWeakReflectiveClassBuildItems) {
            forcedNonWeakClasses.add(forceNonWeakReflectiveClassBuildItem.getClassName());
        }
        for (ReflectiveClassBuildItem reflectiveClassBuildItem : reflectiveClassBuildItems) {
            this.addReflectiveClass(linkedHashMap, forcedNonWeakClasses, reflectiveClassBuildItem.isConstructors(), reflectiveClassBuildItem.isMethods(), reflectiveClassBuildItem.isFields(), reflectiveClassBuildItem.areFinalFieldsWritable(), reflectiveClassBuildItem.isWeak(), reflectiveClassBuildItem.isSerialization(), reflectiveClassBuildItem.getClassNames().toArray(new String[0]));
        }
        for (ReflectiveFieldBuildItem reflectiveFieldBuildItem : reflectiveFields) {
            this.addReflectiveField(linkedHashMap, reflectiveFieldBuildItem);
        }
        for (ReflectiveMethodBuildItem reflectiveMethodBuildItem : reflectiveMethods) {
            this.addReflectiveMethod(linkedHashMap, reflectiveMethodBuildItem);
        }
        for (ServiceProviderBuildItem serviceProviderBuildItem : serviceProviderBuildItems) {
            this.addReflectiveClass(linkedHashMap, forcedNonWeakClasses, true, false, false, false, false, false, serviceProviderBuildItem.providers().toArray(new String[0]));
        }
        MethodDescriptor registerSerializationMethod = null;
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            MethodCreator mv = file.getMethodCreator("registerClass" + count++, Void.TYPE, new Class[]{Feature.BeforeAnalysisAccess.class});
            mv.setModifiers(10);
            overallCatch.invokeStaticMethod(mv.getMethodDescriptor(), new ResultHandle[]{overallCatch.getMethodParam(0)});
            TryBlock tc6 = mv.tryBlock();
            ResultHandle clazz3 = tc6.loadClassFromTCCL((String)entry.getKey());
            ResultHandle resultHandle = tc6.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredConstructors", Constructor[].class, (Class[])new Class[0]), clazz3, new ResultHandle[0]);
            ResultHandle methods = tc6.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethods", Method[].class, (Class[])new Class[0]), clazz3, new ResultHandle[0]);
            ResultHandle fields = tc6.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredFields", Field[].class, (Class[])new Class[0]), clazz3, new ResultHandle[0]);
            if (!((ReflectionInfo)entry.getValue()).weak) {
                ResultHandle fhandle;
                String type;
                ResultHandle paramArray;
                ResultHandle farray;
                ResultHandle carray = tc6.newArray(Class.class, tc6.load(1));
                tc6.writeArrayValue(carray, 0, clazz3);
                tc6.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Class[].class}), new ResultHandle[]{carray});
                if (((ReflectionInfo)entry.getValue()).constructors) {
                    tc6.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{resultHandle});
                } else if (!((ReflectionInfo)entry.getValue()).ctorSet.isEmpty()) {
                    farray = tc6.newArray(Constructor.class, tc6.load(1));
                    for (ReflectiveMethodBuildItem ctor : ((ReflectionInfo)entry.getValue()).ctorSet) {
                        paramArray = tc6.newArray(Class.class, tc6.load(ctor.getParams().length));
                        for (int i = 0; i < ctor.getParams().length; ++i) {
                            type = ctor.getParams()[i];
                            tc6.writeArrayValue(paramArray, i, tc6.loadClassFromTCCL(type));
                        }
                        fhandle = tc6.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredConstructor", Constructor.class, (Class[])new Class[]{Class[].class}), clazz3, new ResultHandle[]{paramArray});
                        tc6.writeArrayValue(farray, 0, fhandle);
                        tc6.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{farray});
                    }
                }
                if (((ReflectionInfo)entry.getValue()).methods) {
                    tc6.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{methods});
                } else if (!((ReflectionInfo)entry.getValue()).methodSet.isEmpty()) {
                    farray = tc6.newArray(Method.class, tc6.load(1));
                    for (ReflectiveMethodBuildItem method : ((ReflectionInfo)entry.getValue()).methodSet) {
                        paramArray = tc6.newArray(Class.class, tc6.load(method.getParams().length));
                        for (int i = 0; i < method.getParams().length; ++i) {
                            type = method.getParams()[i];
                            tc6.writeArrayValue(paramArray, i, tc6.loadClassFromTCCL(type));
                        }
                        fhandle = tc6.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethod", Method.class, (Class[])new Class[]{String.class, Class[].class}), clazz3, new ResultHandle[]{tc6.load(method.getName()), paramArray});
                        tc6.writeArrayValue(farray, 0, fhandle);
                        tc6.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{farray});
                    }
                }
                if (((ReflectionInfo)entry.getValue()).fields) {
                    tc6.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Boolean.TYPE, Boolean.TYPE, Field[].class}), new ResultHandle[]{tc6.load(((ReflectionInfo)entry.getValue()).finalFieldsWritable), tc6.load(((ReflectionInfo)entry.getValue()).serialization), fields});
                } else if (!((ReflectionInfo)entry.getValue()).fieldSet.isEmpty()) {
                    farray = tc6.newArray(Field.class, tc6.load(1));
                    for (String field : ((ReflectionInfo)entry.getValue()).fieldSet) {
                        ResultHandle fhandle2 = tc6.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredField", Field.class, (Class[])new Class[]{String.class}), clazz3, new ResultHandle[]{tc6.load(field)});
                        tc6.writeArrayValue(farray, 0, fhandle2);
                        tc6.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Field[].class}), new ResultHandle[]{farray});
                    }
                }
            } else {
                tc6.invokeStaticMethod(WEAK_REFLECTION_REGISTRATION, new ResultHandle[]{tc6.getMethodParam(0), clazz3, tc6.load(((ReflectionInfo)entry.getValue()).constructors), tc6.load(((ReflectionInfo)entry.getValue()).methods), tc6.load(((ReflectionInfo)entry.getValue()).fields)});
            }
            if (((ReflectionInfo)entry.getValue()).serialization) {
                if (registerSerializationMethod == null) {
                    registerSerializationMethod = this.createRegisterSerializationForClassMethod(file);
                }
                tc6.invokeStaticMethod(registerSerializationMethod, new ResultHandle[]{clazz3});
            }
            CatchBlockCreator cc5 = tc6.addCatch(Throwable.class);
            mv.returnValue(null);
        }
        count = 0;
        for (JniRuntimeAccessBuildItem jniRuntimeAccessBuildItem : jniRuntimeAccessibleClasses) {
            for (String className : jniRuntimeAccessBuildItem.getClassNames()) {
                MethodCreator mv = file.getMethodCreator("registerJniAccessibleClass" + count++, "V", new String[0]);
                mv.setModifiers(10);
                overallCatch.invokeStaticMethod(mv.getMethodDescriptor(), new ResultHandle[0]);
                TryBlock tryBlock = mv.tryBlock();
                ResultHandle clazz4 = tryBlock.loadClassFromTCCL(className);
                ResultHandle constructors = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredConstructors", Constructor[].class, (Class[])new Class[0]), clazz4, new ResultHandle[0]);
                ResultHandle methods = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethods", Method[].class, (Class[])new Class[0]), clazz4, new ResultHandle[0]);
                ResultHandle fields = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredFields", Field[].class, (Class[])new Class[0]), clazz4, new ResultHandle[0]);
                ResultHandle carray = tryBlock.newArray(Class.class, tryBlock.load(1));
                tryBlock.writeArrayValue(carray, 0, clazz4);
                BranchResult graalVm22_3Test = tryBlock.ifGreaterEqualZero(tryBlock.invokeVirtualMethod(VERSION_COMPARE_TO, tryBlock.invokeStaticMethod(VERSION_CURRENT, new ResultHandle[0]), new ResultHandle[]{tryBlock.marshalAsArray(Integer.TYPE, new ResultHandle[]{tryBlock.load(22), tryBlock.load(3)})}));
                try (BytecodeCreator greaterThan22_2 = graalVm22_3Test.trueBranch();){
                    greaterThan22_2.invokeStaticMethod(MethodDescriptor.ofMethod((Object)JNI_RUNTIME_ACCESS, (String)"register", Void.TYPE, (Object[])new Object[]{Class[].class}), new ResultHandle[]{carray});
                    if (jniRuntimeAccessBuildItem.isConstructors()) {
                        greaterThan22_2.invokeStaticMethod(MethodDescriptor.ofMethod((Object)JNI_RUNTIME_ACCESS, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{constructors});
                    }
                    if (jniRuntimeAccessBuildItem.isMethods()) {
                        greaterThan22_2.invokeStaticMethod(MethodDescriptor.ofMethod((Object)JNI_RUNTIME_ACCESS, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{methods});
                    }
                    if (jniRuntimeAccessBuildItem.isFields()) {
                        greaterThan22_2.invokeStaticMethod(MethodDescriptor.ofMethod((Object)JNI_RUNTIME_ACCESS, (String)"register", Void.TYPE, (Object[])new Object[]{Field[].class}), new ResultHandle[]{fields});
                    }
                }
                try (BytecodeCreator smallerThan22_3 = graalVm22_3Test.falseBranch();){
                    smallerThan22_3.invokeStaticMethod(MethodDescriptor.ofMethod((Object)LEGACY_JNI_RUNTIME_ACCESS, (String)"register", Void.TYPE, (Object[])new Object[]{Class[].class}), new ResultHandle[]{carray});
                    if (jniRuntimeAccessBuildItem.isConstructors()) {
                        smallerThan22_3.invokeStaticMethod(MethodDescriptor.ofMethod((Object)LEGACY_JNI_RUNTIME_ACCESS, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{constructors});
                    }
                    if (jniRuntimeAccessBuildItem.isMethods()) {
                        smallerThan22_3.invokeStaticMethod(MethodDescriptor.ofMethod((Object)LEGACY_JNI_RUNTIME_ACCESS, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{methods});
                    }
                    if (jniRuntimeAccessBuildItem.isFields()) {
                        smallerThan22_3.invokeStaticMethod(MethodDescriptor.ofMethod((Object)LEGACY_JNI_RUNTIME_ACCESS, (String)"register", Void.TYPE, (Object[])new Object[]{Boolean.TYPE, Field[].class}), new ResultHandle[]{smallerThan22_3.load(jniRuntimeAccessBuildItem.isFinalFieldsWriteable()), fields});
                    }
                }
                CatchBlockCreator cc6 = tryBlock.addCatch(Throwable.class);
                mv.returnValue(null);
            }
        }
        CatchBlockCreator catchBlockCreator = overallCatch.addCatch(Throwable.class);
        catchBlockCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), catchBlockCreator.getCaughtException(), new ResultHandle[0]);
        beforeAn.loadClassFromTCCL("io.quarkus.runner.ApplicationImpl");
        beforeAn.returnValue(null);
        file.close();
    }

    private MethodDescriptor createRegisterSerializationForClassMethod(ClassCreator file) {
        MethodCreator addSerializationForClass = file.getMethodCreator("registerSerializationForClass", (Object)"V", new Object[]{Class.class});
        addSerializationForClass.setModifiers(10);
        ResultHandle clazz = addSerializationForClass.getMethodParam(0);
        TryBlock tc = addSerializationForClass.tryBlock();
        ResultHandle runtimeSerializationClass = tc.loadClassFromTCCL(RUNTIME_SERIALIZATION);
        ResultHandle registerArgTypes = tc.newArray(Class.class, tc.load(1));
        tc.writeArrayValue(registerArgTypes, 0, tc.loadClassFromTCCL(Class[].class));
        ResultHandle registerLookupMethod = tc.invokeStaticMethod(LOOKUP_METHOD, new ResultHandle[]{runtimeSerializationClass, tc.load("register"), registerArgTypes});
        ResultHandle registerArgs = tc.newArray(Object.class, tc.load(1));
        ResultHandle classesToRegister = tc.newArray(Class.class, tc.load(1));
        tc.writeArrayValue(classesToRegister, 0, clazz);
        tc.writeArrayValue(registerArgs, 0, classesToRegister);
        tc.invokeVirtualMethod(INVOKE, registerLookupMethod, new ResultHandle[]{tc.loadNull(), registerArgs});
        tc.returnValue(null);
        addSerializationForClass.returnValue(null);
        return addSerializationForClass.getMethodDescriptor();
    }

    public void addReflectiveMethod(Map<String, ReflectionInfo> reflectiveClasses, ReflectiveMethodBuildItem methodInfo) {
        String cl = methodInfo.getDeclaringClass();
        ReflectionInfo existing = reflectiveClasses.get(cl);
        if (existing == null) {
            existing = new ReflectionInfo(false, false, false, false, false, false);
            reflectiveClasses.put(cl, existing);
        }
        if (methodInfo.getName().equals("<init>")) {
            existing.ctorSet.add(methodInfo);
        } else {
            existing.methodSet.add(methodInfo);
        }
    }

    public void addReflectiveClass(Map<String, ReflectionInfo> reflectiveClasses, Set<String> forcedNonWeakClasses, boolean constructors, boolean method, boolean fields, boolean finalFieldsWritable, boolean weak, boolean serialization, String ... className) {
        for (String cl : className) {
            ReflectionInfo existing = reflectiveClasses.get(cl);
            if (existing == null) {
                reflectiveClasses.put(cl, new ReflectionInfo(constructors, method, fields, finalFieldsWritable, !forcedNonWeakClasses.contains(cl) && weak, serialization));
                continue;
            }
            if (constructors) {
                existing.constructors = true;
            }
            if (method) {
                existing.methods = true;
            }
            if (fields) {
                existing.fields = true;
            }
            if (!serialization) continue;
            existing.serialization = true;
        }
    }

    public void addReflectiveField(Map<String, ReflectionInfo> reflectiveClasses, ReflectiveFieldBuildItem fieldInfo) {
        String cl = fieldInfo.getDeclaringClass();
        ReflectionInfo existing = reflectiveClasses.get(cl);
        if (existing == null) {
            existing = new ReflectionInfo(false, false, false, false, false, false);
            reflectiveClasses.put(cl, existing);
        }
        existing.fieldSet.add(fieldInfo.getName());
    }

    static final class ReflectionInfo {
        boolean constructors;
        boolean methods;
        boolean fields;
        boolean finalFieldsWritable;
        boolean weak;
        boolean serialization;
        Set<String> fieldSet = new HashSet<String>();
        Set<ReflectiveMethodBuildItem> methodSet = new HashSet<ReflectiveMethodBuildItem>();
        Set<ReflectiveMethodBuildItem> ctorSet = new HashSet<ReflectiveMethodBuildItem>();

        private ReflectionInfo(boolean constructors, boolean methods, boolean fields, boolean finalFieldsWritable, boolean weak, boolean serialization) {
            this.methods = methods;
            this.fields = fields;
            this.constructors = constructors;
            this.finalFieldsWritable = finalFieldsWritable;
            this.weak = weak;
            this.serialization = serialization;
        }
    }
}

