/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.deployment.OutputFilter;
import io.quarkus.deployment.pkg.NativeConfig;
import io.quarkus.deployment.pkg.steps.LinuxIDUtil;
import io.quarkus.deployment.pkg.steps.NativeImageBuildContainerRunner;
import io.quarkus.deployment.util.ExecUtil;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.runtime.util.ContainerRuntimeUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SystemUtils;
import org.jboss.logging.Logger;

public class NativeImageBuildLocalContainerRunner
extends NativeImageBuildContainerRunner {
    private static final Logger LOGGER = Logger.getLogger((String)NativeImageBuildLocalContainerRunner.class.getName());

    public NativeImageBuildLocalContainerRunner(NativeConfig nativeConfig, Path outputDir) {
        super(nativeConfig, outputDir);
        if (SystemUtils.IS_OS_LINUX) {
            ArrayList<String> containerRuntimeArgs = new ArrayList<String>(Arrays.asList(this.baseContainerRuntimeArgs));
            if (NativeImageBuildLocalContainerRunner.isDockerRootless(this.containerRuntime)) {
                Collections.addAll(containerRuntimeArgs, "--user", String.valueOf(0));
            } else {
                String uid = LinuxIDUtil.getLinuxID("-ur");
                String gid = LinuxIDUtil.getLinuxID("-gr");
                if (uid != null && gid != null && !uid.isEmpty() && !gid.isEmpty()) {
                    Collections.addAll(containerRuntimeArgs, "--user", uid + ":" + gid);
                    if (this.containerRuntime == ContainerRuntimeUtil.ContainerRuntime.PODMAN) {
                        containerRuntimeArgs.add("--userns=keep-id");
                    }
                }
            }
            this.baseContainerRuntimeArgs = containerRuntimeArgs.toArray(this.baseContainerRuntimeArgs);
        }
    }

    private static boolean isDockerRootless(ContainerRuntimeUtil.ContainerRuntime containerRuntime) {
        int socketOwnerUid;
        if (containerRuntime != ContainerRuntimeUtil.ContainerRuntime.DOCKER) {
            return false;
        }
        String dockerEndpoint = NativeImageBuildLocalContainerRunner.fetchDockerEndpoint();
        String socketUriPrefix = "unix://";
        if (dockerEndpoint == null || !dockerEndpoint.startsWith(socketUriPrefix)) {
            return false;
        }
        String dockerSocket = dockerEndpoint.substring(socketUriPrefix.length());
        String currentUid = LinuxIDUtil.getLinuxID("-ur");
        if (currentUid == null || currentUid.isEmpty() || currentUid.equals(String.valueOf(0))) {
            return false;
        }
        try {
            socketOwnerUid = (Integer)Files.getAttribute(Path.of(dockerSocket, new String[0]), "unix:uid", LinkOption.NOFOLLOW_LINKS);
        }
        catch (IOException e) {
            LOGGER.infof("Owner UID lookup on '%s' failed with '%s'", (Object)dockerSocket, (Object)e.getMessage());
            return false;
        }
        return currentUid.equals(String.valueOf(socketOwnerUid));
    }

    private static String fetchDockerEndpoint() {
        String dockerHost = System.getenv("DOCKER_HOST");
        if (dockerHost != null) {
            return dockerHost;
        }
        OutputFilter outputFilter = new OutputFilter();
        if (!ExecUtil.execWithTimeout(new File("."), outputFilter, Duration.ofMillis(3000L), "docker", "context", "ls", "--format", "{{- if .Current -}} {{- .DockerEndpoint -}} {{- end -}}")) {
            LOGGER.debug((Object)"Docker context lookup didn't succeed in time");
            return null;
        }
        Set endpoints = outputFilter.getOutput().lines().filter(Objects::nonNull).filter(Predicate.not(String::isBlank)).collect(Collectors.toSet());
        if (endpoints.size() == 1) {
            return endpoints.stream().findFirst().orElse(null);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debugf("Found too many active Docker endpoints: [%s]", (Object)endpoints.stream().map(endpoint -> String.format("'%s'", endpoint)).collect(Collectors.joining(",")));
        }
        return null;
    }

    @Override
    protected List<String> getContainerRuntimeBuildArgs() {
        List<String> containerRuntimeArgs = super.getContainerRuntimeBuildArgs();
        String volumeOutputPath = this.outputPath;
        if (SystemUtils.IS_OS_WINDOWS) {
            volumeOutputPath = FileUtil.translateToVolumePath(volumeOutputPath);
        }
        String selinuxBindOption = ":z";
        if (SystemUtils.IS_OS_MAC && ContainerRuntimeUtil.detectContainerRuntime() == ContainerRuntimeUtil.ContainerRuntime.PODMAN) {
            selinuxBindOption = "";
        }
        Collections.addAll(containerRuntimeArgs, "-v", volumeOutputPath + ":/project" + selinuxBindOption);
        return containerRuntimeArgs;
    }
}

