/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.index;

import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.ApplicationArchiveImpl;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveBuildItem;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.QuarkusBuildCloseablesBuildItem;
import io.quarkus.deployment.configuration.ClassLoadingConfig;
import io.quarkus.deployment.index.IndexDependencyConfig;
import io.quarkus.deployment.index.IndexingUtil;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;

public class ApplicationArchiveBuildStep {
    private static final Logger LOGGER = Logger.getLogger(ApplicationArchiveBuildStep.class);
    IndexDependencyConfiguration config;

    @BuildStep
    void addConfiguredIndexedDependencies(BuildProducer<IndexDependencyBuildItem> indexDependencyBuildItemBuildProducer) {
        for (IndexDependencyConfig indexDependencyConfig : this.config.indexDependency.values()) {
            indexDependencyBuildItemBuildProducer.produce(new IndexDependencyBuildItem(indexDependencyConfig.groupId, indexDependencyConfig.artifactId, indexDependencyConfig.classifier.orElse(null)));
        }
    }

    @BuildStep
    ApplicationArchivesBuildItem build(QuarkusBuildCloseablesBuildItem buildCloseables, ArchiveRootBuildItem root, ApplicationIndexBuildItem appindex, List<AdditionalApplicationArchiveMarkerBuildItem> appMarkers, List<AdditionalApplicationArchiveBuildItem> additionalApplicationArchiveBuildItem, List<IndexDependencyBuildItem> indexDependencyBuildItems, LiveReloadBuildItem liveReloadContext, CurateOutcomeBuildItem curateOutcomeBuildItem, ClassLoadingConfig classLoadingConfig) throws IOException {
        HashSet<String> markerFiles = new HashSet<String>();
        for (AdditionalApplicationArchiveMarkerBuildItem i : appMarkers) {
            markerFiles.add(i.getFile());
        }
        IndexCache indexCache = liveReloadContext.getContextObject(IndexCache.class);
        if (indexCache == null) {
            indexCache = new IndexCache();
            liveReloadContext.setContextObject(IndexCache.class, indexCache);
        }
        HashMap<ArtifactKey, Set<String>> removedResources = new HashMap<ArtifactKey, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : classLoadingConfig.removedResources.entrySet()) {
            removedResources.put((ArtifactKey)new GACT(entry.getKey().split(":")), entry.getValue());
        }
        List<ApplicationArchive> applicationArchives = this.scanForOtherIndexes(buildCloseables, Thread.currentThread().getContextClassLoader(), markerFiles, root, additionalApplicationArchiveBuildItem, indexDependencyBuildItems, indexCache, curateOutcomeBuildItem, removedResources);
        return new ApplicationArchivesBuildItem(new ApplicationArchiveImpl((IndexView)appindex.getIndex(), (PathCollection)PathList.from((Iterable)root.getRootDirs()), (PathCollection)PathList.from((Iterable)root.getPaths()), null), applicationArchives);
    }

    private List<ApplicationArchive> scanForOtherIndexes(QuarkusBuildCloseablesBuildItem buildCloseables, ClassLoader classLoader, Set<String> applicationArchiveFiles, ArchiveRootBuildItem root, List<AdditionalApplicationArchiveBuildItem> additionalApplicationArchives, List<IndexDependencyBuildItem> indexDependencyBuildItem, IndexCache indexCache, CurateOutcomeBuildItem curateOutcomeBuildItem, Map<ArtifactKey, Set<String>> removedResources) throws IOException {
        ArrayList<ApplicationArchive> appArchives = new ArrayList<ApplicationArchive>();
        HashSet<Path> indexedPaths = new HashSet<Path>();
        HashSet<String> markers = new HashSet<String>(applicationArchiveFiles);
        markers.add("META-INF/jandex.idx");
        ApplicationArchiveBuildStep.addMarkerFilePaths(markers, root, curateOutcomeBuildItem, indexedPaths, appArchives, buildCloseables, classLoader, indexCache, removedResources);
        this.addIndexDependencyPaths(indexDependencyBuildItem, classLoader, root, indexedPaths, appArchives, buildCloseables, indexCache, curateOutcomeBuildItem, removedResources);
        for (AdditionalApplicationArchiveBuildItem i : additionalApplicationArchives) {
            for (Path apPath : i.getResolvedPaths()) {
                if (root.getPaths().contains(apPath) || !indexedPaths.add(apPath)) continue;
                appArchives.add(ApplicationArchiveBuildStep.createApplicationArchive(buildCloseables, classLoader, indexCache, apPath, null, removedResources));
            }
        }
        return appArchives;
    }

    public void addIndexDependencyPaths(List<IndexDependencyBuildItem> indexDependencyBuildItems, ClassLoader classLoader, ArchiveRootBuildItem root, Set<Path> indexedDeps, List<ApplicationArchive> appArchives, QuarkusBuildCloseablesBuildItem buildCloseables, IndexCache indexCache, CurateOutcomeBuildItem curateOutcomeBuildItem, Map<ArtifactKey, Set<String>> removedResources) {
        if (indexDependencyBuildItems.isEmpty()) {
            return;
        }
        Collection userDeps = curateOutcomeBuildItem.getApplicationModel().getRuntimeDependencies();
        HashMap<ArtifactKey, ResolvedDependency> userMap = new HashMap<ArtifactKey, ResolvedDependency>(userDeps.size());
        for (ResolvedDependency dep : userDeps) {
            userMap.put(dep.getKey(), dep);
        }
        try {
            for (IndexDependencyBuildItem indexDependencyBuildItem : indexDependencyBuildItems) {
                GACT key = new GACT(indexDependencyBuildItem.getGroupId(), indexDependencyBuildItem.getArtifactId(), indexDependencyBuildItem.getClassifier(), "jar");
                ResolvedDependency artifact = (ResolvedDependency)userMap.get(key);
                if (artifact == null) {
                    throw new RuntimeException("Could not resolve artifact " + (ArtifactKey)key + " among the runtime dependencies of the application");
                }
                for (Path path : artifact.getResolvedPaths()) {
                    if (root.isExcludedFromIndexing(path) || root.getPaths().contains(path) || !indexedDeps.add(path)) continue;
                    appArchives.add(ApplicationArchiveBuildStep.createApplicationArchive(buildCloseables, classLoader, indexCache, path, (ArtifactKey)key, removedResources));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static ApplicationArchive createApplicationArchive(QuarkusBuildCloseablesBuildItem buildCloseables, ClassLoader classLoader, IndexCache indexCache, Path dep, ArtifactKey artifactKey, Map<ArtifactKey, Set<String>> removedResources) throws IOException {
        Path rootDir = dep;
        if (!Files.isDirectory(dep, new LinkOption[0])) {
            FileSystem fs = buildCloseables.add(FileSystems.newFileSystem(dep, classLoader));
            rootDir = fs.getRootDirectories().iterator().next();
        }
        IndexView index = ApplicationArchiveBuildStep.indexPath(indexCache, dep, removedResources.get(artifactKey));
        return new ApplicationArchiveImpl(index, rootDir, dep, artifactKey);
    }

    private static IndexView indexPath(IndexCache indexCache, Path dep, Set<String> removed) throws IOException {
        LOGGER.debugf("Indexing dependency: %s", (Object)dep);
        return Files.isDirectory(dep, new LinkOption[0]) ? ApplicationArchiveBuildStep.handleFilePath(dep, removed) : ApplicationArchiveBuildStep.handleJarPath(dep, indexCache, removed);
    }

    private static void addMarkerFilePaths(Set<String> applicationArchiveFiles, ArchiveRootBuildItem root, CurateOutcomeBuildItem curateOutcomeBuildItem, Set<Path> indexedPaths, List<ApplicationArchive> appArchives, QuarkusBuildCloseablesBuildItem buildCloseables, ClassLoader classLoader, IndexCache indexCache, Map<ArtifactKey, Set<String>> removed) throws IOException {
        for (ResolvedDependency dep : curateOutcomeBuildItem.getApplicationModel().getRuntimeDependencies()) {
            PathCollection artifactPaths = dep.getResolvedPaths();
            boolean containsMarker = false;
            for (Path p : artifactPaths) {
                if (root.isExcludedFromIndexing(p)) continue;
                if (Files.isDirectory(p, new LinkOption[0])) {
                    containsMarker = ApplicationArchiveBuildStep.containsMarker(p, applicationArchiveFiles);
                    if (!containsMarker) continue;
                    break;
                }
                try {
                    FileSystem fs = FileSystems.newFileSystem(p, classLoader);
                    try {
                        containsMarker = ApplicationArchiveBuildStep.containsMarker(fs.getPath("/", new String[0]), applicationArchiveFiles);
                        if (!containsMarker) continue;
                        break;
                    }
                    finally {
                        if (fs == null) continue;
                        fs.close();
                    }
                }
                catch (ProviderNotFoundException providerNotFoundException) {}
            }
            if (!containsMarker) continue;
            PathList.Builder rootDirs = PathList.builder();
            ArrayList<IndexView> indexes = new ArrayList<IndexView>(artifactPaths.size());
            for (Path p : artifactPaths) {
                if (Files.isDirectory(p, new LinkOption[0])) {
                    rootDirs.add(p);
                } else {
                    FileSystem fs = buildCloseables.add(FileSystems.newFileSystem(p, classLoader));
                    fs.getRootDirectories().forEach(arg_0 -> ((PathList.Builder)rootDirs).add(arg_0));
                }
                indexes.add(ApplicationArchiveBuildStep.indexPath(indexCache, p, removed.get(dep.getKey())));
                indexedPaths.add(p);
            }
            appArchives.add(new ApplicationArchiveImpl((IndexView)(indexes.size() == 1 ? (IndexView)indexes.get(0) : CompositeIndex.create(indexes)), (PathCollection)rootDirs.build(), artifactPaths, dep.getKey()));
        }
    }

    private static boolean containsMarker(Path dir, Set<String> applicationArchiveFiles) throws IOException {
        for (String file : applicationArchiveFiles) {
            if (!Files.exists(dir.resolve(file), new LinkOption[0])) continue;
            return true;
        }
        return false;
    }

    private static Index handleFilePath(Path path, Set<String> removed) throws IOException {
        return ApplicationArchiveBuildStep.indexFilePath(path, removed);
    }

    private static Index indexFilePath(Path path, Set<String> removed) throws IOException {
        Indexer indexer = new Indexer();
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
            stream.forEach(path1 -> {
                String relative;
                if (removed != null && removed.contains(relative = path.relativize((Path)path1).toString().replace("\\", "/"))) {
                    return;
                }
                if (path1.toString().endsWith(".class")) {
                    try (FileInputStream in = new FileInputStream(path1.toFile());){
                        indexer.index((InputStream)in);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        return indexer.complete();
    }

    private static Index handleJarPath(Path path, IndexCache indexCache, final Set<String> removed) {
        return indexCache.cache.computeIfAbsent(path, new Function<Path, Index>(){

            @Override
            public Index apply(Path path) {
                try {
                    return IndexingUtil.indexJar(path, (Set<String>)removed);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to process " + path, e);
                }
            }
        });
    }

    private static final class IndexCache {
        final Map<Path, Index> cache = new HashMap<Path, Index>();

        private IndexCache() {
        }
    }

    @ConfigRoot(phase=ConfigPhase.BUILD_TIME)
    static final class IndexDependencyConfiguration {
        @ConfigItem(name="<<parent>>")
        Map<String, IndexDependencyConfig> indexDependency;

        IndexDependencyConfiguration() {
        }
    }
}

