/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.console;

import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleConfig;
import io.quarkus.deployment.console.ConsoleHelper;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.ConsoleStateManager;
import io.quarkus.deployment.dev.testing.TestConfig;
import io.quarkus.deployment.dev.testing.TestConsoleHandler;
import io.quarkus.deployment.dev.testing.TestListenerBuildItem;
import io.quarkus.deployment.dev.testing.TestSetupBuildItem;
import io.quarkus.deployment.dev.testing.TestSupport;
import io.quarkus.dev.console.QuarkusConsole;
import io.quarkus.runtime.console.ConsoleRuntimeConfig;
import org.eclipse.microprofile.config.ConfigProvider;

public class ConsoleProcessor {
    private static boolean consoleInstalled = false;

    @BuildStep(onlyIf={IsDevelopment.class})
    @Produce(value=TestSetupBuildItem.class)
    ConsoleInstalledBuildItem setupConsole(TestConfig config, BuildProducer<TestListenerBuildItem> testListenerBuildItemBuildProducer, LaunchModeBuildItem launchModeBuildItem, ConsoleConfig consoleConfig) {
        if (consoleInstalled) {
            return ConsoleInstalledBuildItem.INSTANCE;
        }
        consoleInstalled = true;
        if (config.console.orElse(consoleConfig.enabled).booleanValue()) {
            ConsoleRuntimeConfig consoleRuntimeConfig = new ConsoleRuntimeConfig();
            consoleRuntimeConfig.color = ConfigProvider.getConfig().getOptionalValue("quarkus.console.color", Boolean.class);
            io.quarkus.runtime.logging.ConsoleConfig loggingConsoleConfig = new io.quarkus.runtime.logging.ConsoleConfig();
            loggingConsoleConfig.color = ConfigProvider.getConfig().getOptionalValue("quarkus.log.console.color", Boolean.class);
            ConsoleHelper.installConsole(config, consoleConfig, consoleRuntimeConfig, loggingConsoleConfig, launchModeBuildItem.isTest());
            ConsoleStateManager.init(QuarkusConsole.INSTANCE, launchModeBuildItem.getDevModeType().get());
            if (TestSupport.instance().isEmpty() || config.continuousTesting == TestConfig.Mode.DISABLED || config.flatClassPath) {
                return ConsoleInstalledBuildItem.INSTANCE;
            }
            TestConsoleHandler consoleHandler = new TestConsoleHandler(launchModeBuildItem.getDevModeType().get());
            consoleHandler.install();
            testListenerBuildItemBuildProducer.produce(new TestListenerBuildItem(consoleHandler));
        }
        return ConsoleInstalledBuildItem.INSTANCE;
    }
}

