/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.console;

import io.quarkus.deployment.console.ConsoleCommand;
import io.quarkus.deployment.dev.RuntimeUpdatesProcessor;
import io.quarkus.deployment.dev.testing.TestSupport;
import io.quarkus.dev.console.QuarkusConsole;
import io.quarkus.dev.spi.DevModeType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.LogManager;

public class ConsoleStateManager {
    public static final ConsoleStateManager INSTANCE = new ConsoleStateManager();
    private final Map<Character, Holder> commands = new ConcurrentHashMap<Character, Holder>();
    private Level currentLevel;
    private List<Runnable> restoreLogLevelsTasks;
    private volatile String oldPrompt;
    private Consumer<int[]> consumer = new Consumer<int[]>(){
        StringBuilder readLineBuilder;
        Consumer<String> readLineConsumer;

        @Override
        public void accept(int[] ints) {
            for (int i : ints) {
                Holder command;
                if (this.readLineBuilder != null) {
                    if (i == 10) {
                        this.readLineConsumer.accept(this.readLineBuilder.toString());
                        this.readLineBuilder = null;
                        this.readLineConsumer = null;
                        continue;
                    }
                    this.readLineBuilder.append((char)i);
                    continue;
                }
                if (i == 10) {
                    System.out.println("");
                }
                if ((command = ConsoleStateManager.this.commands.get(Character.valueOf((char)i))) == null) continue;
                if (command.consoleCommand.getReadLineHandler() != null) {
                    QuarkusConsole.INSTANCE.doReadLine();
                    this.readLineBuilder = new StringBuilder();
                    this.readLineConsumer = command.consoleCommand.getReadLineHandler();
                    continue;
                }
                command.consoleCommand.getRunnable().run();
            }
        }
    };
    static volatile boolean initialized = false;

    public static void init(QuarkusConsole console, DevModeType devModeType) {
        if (initialized) {
            return;
        }
        initialized = true;
        if (console.isInputSupported()) {
            console.setInputHandler(ConsoleStateManager.INSTANCE.consumer);
            INSTANCE.installBuiltins(devModeType);
        }
    }

    void installBuiltins(DevModeType devModeType) {
        ArrayList<ConsoleCommand> commands = new ArrayList<ConsoleCommand>();
        if (devModeType != DevModeType.TEST_ONLY) {
            commands.add(new ConsoleCommand('s', "Force restart", null, () -> this.forceRestart()));
            commands.add(new ConsoleCommand('i', "Toggle instrumentation based reload", new ConsoleCommand.HelpState(() -> RuntimeUpdatesProcessor.INSTANCE.instrumentationEnabled()), () -> {
                if (TestSupport.instance().isPresent()) {
                    TestSupport.instance().get().toggleInstrumentation();
                } else {
                    RuntimeUpdatesProcessor.INSTANCE.toggleInstrumentation();
                }
            }));
            commands.add(new ConsoleCommand('l', "Toggle live reload", new ConsoleCommand.HelpState(() -> RuntimeUpdatesProcessor.INSTANCE.isLiveReloadEnabled()), () -> {
                if (TestSupport.instance().isPresent()) {
                    TestSupport.instance().get().toggleLiveReloadEnabled();
                } else {
                    RuntimeUpdatesProcessor.INSTANCE.toggleLiveReloadEnabled();
                }
            }));
        }
        ConsoleContext context = this.createContext("System");
        commands.add(new ConsoleCommand('j', "Toggle log levels", new ConsoleCommand.HelpState(() -> this.currentLevel == null ? "\u001b[94m" : "\u001b[91m", () -> this.currentLevel == null ? this.toLevel(((LogManager)LogManager.getLogManager()).getLogger("").getLevel()).toString() : this.currentLevel.toString()), this::toggleLogLevel));
        commands.add(new ConsoleCommand('\f', null, null, 10002, null, this::clearScreen));
        commands.add(new ConsoleCommand('\r', null, null, 10001, null, this::printBlankLine));
        commands.add(new ConsoleCommand('h', "Shows this help", "for more options", 10000, null, this::printHelp));
        commands.add(new ConsoleCommand('q', "Quits the application", null, this::exitQuarkus));
        context.reset(commands.toArray(new ConsoleCommand[0]));
    }

    private void forceRestart() {
        RuntimeUpdatesProcessor.INSTANCE.doScan(true, true);
    }

    private void exitQuarkus() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                System.exit(0);
            }
        }, "Quarkus exit thread").run();
    }

    private void toggleLogLevel() {
        if (this.currentLevel == null) {
            this.restoreLogLevelsTasks = new ArrayList<Runnable>();
            Iterator<String> names = LogManager.getLogManager().getLoggerNames().asIterator();
            while (names.hasNext()) {
                String name = names.next();
                final Logger logger = LogManager.getLogManager().getLogger(name);
                final java.util.logging.Level level = logger.getLevel();
                this.restoreLogLevelsTasks.add(new Runnable(){

                    @Override
                    public void run() {
                        logger.setLevel(level);
                    }
                });
                logger.setLevel((java.util.logging.Level)Level.DEBUG);
            }
            this.currentLevel = Level.DEBUG;
            System.out.println("Set log level to DEBUG");
        } else if (this.currentLevel == Level.DEBUG) {
            Iterator<String> names = LogManager.getLogManager().getLoggerNames().asIterator();
            while (names.hasNext()) {
                String name = names.next();
                Logger logger = LogManager.getLogManager().getLogger(name);
                logger.setLevel((java.util.logging.Level)Level.TRACE);
            }
            System.out.println("Set log level to TRACE");
            this.currentLevel = Level.TRACE;
        } else {
            for (Runnable i : this.restoreLogLevelsTasks) {
                i.run();
            }
            this.restoreLogLevelsTasks = null;
            this.currentLevel = null;
            System.out.println("Restored log levels to configured values");
        }
    }

    private void clearScreen() {
        System.out.println("\u001b[2J");
    }

    private void printBlankLine() {
        System.out.println("");
    }

    private void printHelp() {
        System.out.println("\nThe following commands are currently available:");
        HashSet<ConsoleContext> contexts = new HashSet<ConsoleContext>();
        for (Holder i : this.commands.values()) {
            contexts.add(i.context);
        }
        for (ConsoleContext ctx : contexts.stream().sorted(Comparator.comparing(ConsoleContext::getName)).collect(Collectors.toList())) {
            System.out.println("\n\u001b[91m==\u001b[39m \u001b[4m" + ctx.name + "\u001b[24m\n");
            for (ConsoleCommand i : ctx.internal) {
                if (i.getDescription() == null) continue;
                if (i.getHelpState() == null) {
                    System.out.println(ConsoleStateManager.helpOption(i.getKey(), i.getDescription()));
                    continue;
                }
                if (i.getHelpState().toggleState != null) {
                    System.out.println(ConsoleStateManager.helpOption(i.getKey(), i.getDescription(), i.getHelpState().toggleState.get()));
                    continue;
                }
                System.out.println(ConsoleStateManager.helpOption(i.getKey(), i.getDescription(), i.getHelpState().stateSupplier.get(), i.getHelpState().colorSupplier.get()));
            }
        }
    }

    public ConsoleContext createContext(String name) {
        return new ConsoleContext(name);
    }

    void redraw() {
        List sorted = this.commands.values().stream().map(s -> s.consoleCommand).filter(s -> s.getPromptString() != null).sorted(Comparator.comparingInt(ConsoleCommand::getPromptPriority)).collect(Collectors.toList());
        if (sorted.isEmpty()) {
            QuarkusConsole.INSTANCE.setPromptMessage(null);
        } else {
            StringBuilder sb = new StringBuilder("Press");
            boolean first = true;
            for (ConsoleCommand i : sorted) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(" [").append("\u001b[94m").append((String)(i.getKey() == ' ' ? "space" : "" + i.getKey())).append("\u001b[39m").append("] ").append(i.getPromptString());
            }
            sb.append(">");
            String newPrompt = sb.toString();
            if (!Objects.equals(newPrompt, this.oldPrompt)) {
                this.oldPrompt = newPrompt;
                QuarkusConsole.INSTANCE.setPromptMessage(sb.toString());
            }
        }
    }

    public static String helpOption(char key, String description) {
        return "[\u001b[94m" + key + "\u001b[39m] - " + description;
    }

    public static String helpOption(char key, String description, boolean enabled) {
        return ConsoleStateManager.helpOption(key, description) + ConsoleStateManager.toggleStatus(enabled);
    }

    public static String helpOption(char key, String description, String status, String color) {
        return ConsoleStateManager.helpOption(key, description) + " (" + color + status + "\u001b[39m)";
    }

    public static String toggleStatus(boolean enabled) {
        return " (" + (enabled ? "\u001b[32menabled\u001b[39m" : "\u001b[91mdisabled") + "\u001b[39m)";
    }

    private Level toLevel(java.util.logging.Level level) {
        if (level.intValue() >= Level.FATAL.intValue()) {
            return Level.FATAL;
        }
        if (level.intValue() >= Level.ERROR.intValue()) {
            return Level.ERROR;
        }
        if (level.intValue() >= Level.WARN.intValue()) {
            return Level.WARN;
        }
        if (level.intValue() >= Level.INFO.intValue()) {
            return Level.INFO;
        }
        if (level.intValue() >= Level.DEBUG.intValue()) {
            return Level.DEBUG;
        }
        return Level.TRACE;
    }

    public class ConsoleContext {
        private final String name;
        private final List<ConsoleCommand> internal = new ArrayList<ConsoleCommand>();

        public ConsoleContext(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void addCommand(ConsoleCommand consoleCommand) {
            this.addCommandInternal(consoleCommand);
            ConsoleStateManager.this.redraw();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addCommandInternal(ConsoleCommand consoleCommand) {
            Map<Character, Holder> map = ConsoleStateManager.this.commands;
            synchronized (map) {
                if (ConsoleStateManager.this.commands.containsKey(Character.valueOf(consoleCommand.getKey()))) {
                    throw new RuntimeException("Key " + consoleCommand.getKey() + " already registered");
                }
                ConsoleStateManager.this.commands.put(Character.valueOf(consoleCommand.getKey()), new Holder(consoleCommand, this));
                this.internal.add(consoleCommand);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset(ConsoleCommand ... command) {
            ConsoleCommand[] consoleCommandArray = ConsoleStateManager.this.commands;
            synchronized (ConsoleStateManager.this.commands) {
                this.internal.clear();
                ConsoleStateManager.this.commands.entrySet().removeIf(entry -> ((Holder)entry.getValue()).context == this);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                for (ConsoleCommand i : command) {
                    this.addCommandInternal(i);
                }
                ConsoleStateManager.this.redraw();
                return;
            }
        }
    }

    static class Holder {
        final ConsoleCommand consoleCommand;
        final ConsoleContext context;

        Holder(ConsoleCommand consoleCommand, ConsoleContext context) {
            this.consoleCommand = consoleCommand;
            this.context = context;
        }
    }
}

