/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.ide;

import io.quarkus.dev.console.DevConsoleManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public enum Ide {
    IDEA("idea", List.of("--line", "{lineNumber}", "{fileName}"), List.of("--help")),
    ECLIPSE("eclipse", List.of("--launcher.openFile", "{fileName}:{lineNumber}"), Collections.emptyList()),
    VSCODE("code", List.of("--goto", "{fileName}:{lineNumber}"), List.of("--version")),
    NETBEANS("netbeans", Collections.emptyList(), List.of("--help"));

    private static final Logger log;
    private final String defaultCommand;
    private final List<String> markerArgs;
    private final List<String> lineNumberArgs;
    private String machineSpecificCommand;
    private String effectiveCommand;

    private Ide(String defaultCommand, List<String> lineNumberArgs, List<String> markerArgs) {
        this.defaultCommand = defaultCommand;
        this.lineNumberArgs = lineNumberArgs;
        this.markerArgs = markerArgs;
    }

    public String getEffectiveCommand() {
        if (this.effectiveCommand != null) {
            return this.effectiveCommand;
        }
        this.effectiveCommand = this.doGetEffectiveCommand();
        return this.effectiveCommand;
    }

    private String doGetEffectiveCommand() {
        if (this.defaultCommand != null) {
            if (this.markerArgs.isEmpty()) {
                return this.defaultCommand;
            }
            try {
                ArrayList<String> command = new ArrayList<String>(1 + this.markerArgs.size());
                command.add(this.defaultCommand);
                command.addAll(this.markerArgs);
                log.debugf("Checking if IDE available with %s", command);
                new ProcessBuilder(command).redirectError(ProcessBuilder.Redirect.DISCARD.file()).redirectOutput(ProcessBuilder.Redirect.DISCARD.file()).start().waitFor(10L, TimeUnit.SECONDS);
                return this.defaultCommand;
            }
            catch (Exception e) {
                return this.machineSpecificCommand;
            }
        }
        return this.machineSpecificCommand;
    }

    public List<String> createFileOpeningArgs(String fileName, String line) {
        if (line == null || line.isEmpty()) {
            return Collections.singletonList(fileName);
        }
        if (this.lineNumberArgs.isEmpty()) {
            log.debug((Object)"No syntax provided for opening the file at a given line for this IDE so we will just open the file");
            return Collections.singletonList(fileName);
        }
        return this.lineNumberArgs.stream().map(arg -> arg.replace("{fileName}", fileName).replace("{lineNumber}", line)).collect(Collectors.toList());
    }

    public void setMachineSpecificCommand(String machineSpecificCommand) {
        this.machineSpecificCommand = machineSpecificCommand;
    }

    public static Path findSourceFile(String fileName) {
        for (Path i : DevConsoleManager.getHotReplacementContext().getSourcesDir()) {
            Path resolved = i.resolve(fileName);
            if (!Files.exists(resolved, new LinkOption[0])) continue;
            return resolved;
        }
        return null;
    }

    public String toString() {
        return "Ide{defaultCommand='" + this.defaultCommand + "'}";
    }

    static {
        log = Logger.getLogger(Ide.class);
    }
}

