/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.GeneratedNativeImageClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.JPMSExportBuildItem;
import io.quarkus.deployment.builditem.nativeimage.JniRuntimeAccessBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourcePatternsBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedPackageBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeReinitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.builditem.nativeimage.UnsafeAccessedFieldBuildItem;
import io.quarkus.deployment.pkg.steps.GraalVM;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.runtime.NativeImageFeatureUtils;
import io.quarkus.runtime.ResourceHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.graalvm.home.Version;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;

public class NativeImageFeatureStep {
    public static final String GRAAL_FEATURE = "io.quarkus.runner.Feature";
    private static final MethodDescriptor VERSION_CURRENT = MethodDescriptor.ofMethod(Version.class, (String)"getCurrent", Version.class, (Class[])new Class[0]);
    private static final MethodDescriptor VERSION_COMPARE_TO = MethodDescriptor.ofMethod(Version.class, (String)"compareTo", Integer.TYPE, (Class[])new Class[]{int[].class});
    private static final MethodDescriptor IMAGE_SINGLETONS_LOOKUP = MethodDescriptor.ofMethod(ImageSingletons.class, (String)"lookup", Object.class, (Class[])new Class[]{Class.class});
    private static final MethodDescriptor BUILD_TIME_INITIALIZATION = MethodDescriptor.ofMethod(RuntimeClassInitialization.class, (String)"initializeAtBuildTime", Void.TYPE, (Class[])new Class[]{String[].class});
    private static final MethodDescriptor INITIALIZE_CLASSES_AT_RUN_TIME = MethodDescriptor.ofMethod(RuntimeClassInitialization.class, (String)"initializeAtRunTime", Void.TYPE, (Class[])new Class[]{Class[].class});
    private static final MethodDescriptor INITIALIZE_PACKAGES_AT_RUN_TIME = MethodDescriptor.ofMethod(RuntimeClassInitialization.class, (String)"initializeAtRunTime", Void.TYPE, (Class[])new Class[]{String[].class});
    public static final String RUNTIME_CLASS_INITIALIZATION_SUPPORT = "org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport";
    private static final MethodDescriptor RERUN_INITIALIZATION = MethodDescriptor.ofMethod((Object)"org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport", (String)"rerunInitialization", Void.TYPE, (Object[])new Object[]{Class.class, String.class});
    public static final String CONFIGURATION_CONDITION = "org.graalvm.nativeimage.impl.ConfigurationCondition";
    private static final MethodDescriptor CONFIGURATION_ALWAYS_TRUE = MethodDescriptor.ofMethod((String)"org.graalvm.nativeimage.impl.ConfigurationCondition", (String)"alwaysTrue", (String)"org.graalvm.nativeimage.impl.ConfigurationCondition", (String[])new String[0]);
    private static final MethodDescriptor LOOKUP_METHOD = MethodDescriptor.ofMethod(NativeImageFeatureUtils.class, (String)"lookupMethod", Method.class, (Class[])new Class[]{Class.class, String.class, Class[].class});
    private static final MethodDescriptor FIND_MODULE_METHOD = MethodDescriptor.ofMethod(NativeImageFeatureUtils.class, (String)"findModule", Module.class, (Class[])new Class[]{String.class});
    private static final MethodDescriptor INVOKE = MethodDescriptor.ofMethod(Method.class, (String)"invoke", Object.class, (Class[])new Class[]{Object.class, Object[].class});
    static final String LEGACY_JNI_RUNTIME_ACCESS = "com.oracle.svm.core.jni.JNIRuntimeAccess";
    static final String JNI_RUNTIME_ACCESS = "org.graalvm.nativeimage.hosted.RuntimeJNIAccess";
    static final String BEFORE_ANALYSIS_ACCESS = Feature.BeforeAnalysisAccess.class.getName();
    static final String DYNAMIC_PROXY_REGISTRY = "com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry";
    static final String LOCALIZATION_FEATURE = "com.oracle.svm.core.jdk.localization.LocalizationFeature";
    static final String RUNTIME_RESOURCE_SUPPORT = "org.graalvm.nativeimage.impl.RuntimeResourceSupport";

    @BuildStep
    GeneratedResourceBuildItem generateNativeResourcesList(List<NativeImageResourceBuildItem> resources, BuildProducer<NativeImageResourcePatternsBuildItem> resourcePatternsBuildItemBuildProducer) {
        StringBuilder sb = new StringBuilder();
        for (NativeImageResourceBuildItem i : resources) {
            for (String r : i.getResources()) {
                sb.append(r);
                sb.append("\n");
            }
        }
        resourcePatternsBuildItemBuildProducer.produce(NativeImageResourcePatternsBuildItem.builder().excludePattern("META-INF/quarkus-native-resources.txt").build());
        return new GeneratedResourceBuildItem("META-INF/quarkus-native-resources.txt", sb.toString().getBytes(StandardCharsets.UTF_8));
    }

    @BuildStep
    void addExportsToNativeImage(BuildProducer<JPMSExportBuildItem> features, List<JniRuntimeAccessBuildItem> jniRuntimeAccessibleClasses) {
        features.produce(new JPMSExportBuildItem("org.graalvm.sdk", "org.graalvm.nativeimage.impl"));
        if (jniRuntimeAccessibleClasses != null && !jniRuntimeAccessibleClasses.isEmpty()) {
            features.produce(new JPMSExportBuildItem("org.graalvm.nativeimage.builder", "com.oracle.svm.core.jni", null, GraalVM.Version.VERSION_22_3_0));
        }
    }

    @BuildStep
    void generateFeature(final BuildProducer<GeneratedNativeImageClassBuildItem> nativeImageClass, BuildProducer<JPMSExportBuildItem> exports, List<RuntimeInitializedClassBuildItem> runtimeInitializedClassBuildItems, List<RuntimeInitializedPackageBuildItem> runtimeInitializedPackageBuildItems, List<RuntimeReinitializedClassBuildItem> runtimeReinitializedClassBuildItems, List<NativeImageProxyDefinitionBuildItem> proxies, List<NativeImageResourcePatternsBuildItem> resourcePatterns, List<NativeImageResourceBundleBuildItem> resourceBundles, List<ServiceProviderBuildItem> serviceProviderBuildItems, List<UnsafeAccessedFieldBuildItem> unsafeAccessedFields, List<JniRuntimeAccessBuildItem> jniRuntimeAccessibleClasses) {
        CatchBlockCreator cc;
        ResultHandle clazz;
        TryBlock tc;
        Object cl;
        ResultHandle thisClass;
        ClassCreator file = new ClassCreator(new ClassOutput(){

            public void write(String s, byte[] bytes) {
                nativeImageClass.produce(new GeneratedNativeImageClassBuildItem(s, bytes));
            }
        }, GRAAL_FEATURE, null, Object.class.getName(), new String[]{Feature.class.getName()});
        MethodCreator getDescription = file.getMethodCreator("getDescription", String.class, new Class[0]);
        getDescription.returnValue(getDescription.load("Auto-generated class by Quarkus from the existing extensions"));
        MethodCreator beforeAn = file.getMethodCreator("beforeAnalysis", "V", new String[]{BEFORE_ANALYSIS_ACCESS});
        TryBlock overallCatch = beforeAn.tryBlock();
        ResultHandle beforeAnalysisParam = beforeAn.getMethodParam(0);
        MethodCreator registerAsUnsafeAccessed = (MethodCreator)file.getMethodCreator("registerAsUnsafeAccessed", Void.TYPE, new Class[]{Feature.BeforeAnalysisAccess.class}).setModifiers(10);
        for (UnsafeAccessedFieldBuildItem unsafeAccessedField : unsafeAccessedFields) {
            TryBlock tc2 = registerAsUnsafeAccessed.tryBlock();
            ResultHandle declaringClassHandle = tc2.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class}), new ResultHandle[]{tc2.load(unsafeAccessedField.getDeclaringClass())});
            ResultHandle fieldHandle = tc2.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredField", Field.class, (Class[])new Class[]{String.class}), declaringClassHandle, new ResultHandle[]{tc2.load(unsafeAccessedField.getFieldName())});
            tc2.invokeInterfaceMethod(MethodDescriptor.ofMethod(Feature.BeforeAnalysisAccess.class, (String)"registerAsUnsafeAccessed", Void.TYPE, (Class[])new Class[]{Field.class}), registerAsUnsafeAccessed.getMethodParam(0), new ResultHandle[]{fieldHandle});
            CatchBlockCreator cc2 = tc2.addCatch(Throwable.class);
            cc2.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc2.getCaughtException(), new ResultHandle[0]);
        }
        registerAsUnsafeAccessed.returnVoid();
        overallCatch.invokeStaticMethod(registerAsUnsafeAccessed.getMethodDescriptor(), new ResultHandle[]{beforeAnalysisParam});
        overallCatch.invokeStaticMethod(BUILD_TIME_INITIALIZATION, new ResultHandle[]{overallCatch.marshalAsArray(String.class, new ResultHandle[]{overallCatch.load("")})});
        if (!runtimeInitializedClassBuildItems.isEmpty()) {
            MethodCreator runtimeInitializedClasses = (MethodCreator)file.getMethodCreator("runtimeInitializedClasses", Class[].class, new Class[0]).setModifiers(10);
            thisClass = runtimeInitializedClasses.loadClassFromTCCL(GRAAL_FEATURE);
            cl = runtimeInitializedClasses.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getClassLoader", ClassLoader.class, (Class[])new Class[0]), thisClass, new ResultHandle[0]);
            ResultHandle classesArray = runtimeInitializedClasses.newArray(Class.class, runtimeInitializedClasses.load(runtimeInitializedClassBuildItems.size()));
            for (int i = 0; i < runtimeInitializedClassBuildItems.size(); ++i) {
                TryBlock tc3 = runtimeInitializedClasses.tryBlock();
                ResultHandle resultHandle = tc3.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class}), new ResultHandle[]{tc3.load(runtimeInitializedClassBuildItems.get(i).getClassName()), tc3.load(false), cl});
                tc3.writeArrayValue(classesArray, i, resultHandle);
                CatchBlockCreator cc3 = tc3.addCatch(Throwable.class);
                cc3.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc3.getCaughtException(), new ResultHandle[0]);
            }
            runtimeInitializedClasses.returnValue(classesArray);
            ResultHandle classes = overallCatch.invokeStaticMethod(runtimeInitializedClasses.getMethodDescriptor(), new ResultHandle[0]);
            overallCatch.invokeStaticMethod(INITIALIZE_CLASSES_AT_RUN_TIME, new ResultHandle[]{classes});
        }
        if (!runtimeInitializedPackageBuildItems.isEmpty()) {
            MethodCreator runtimeInitializedPackages = (MethodCreator)file.getMethodCreator("runtimeInitializedPackages", String[].class, new Class[0]).setModifiers(10);
            ResultHandle packagesArray = runtimeInitializedPackages.newArray(String.class, runtimeInitializedPackages.load(runtimeInitializedPackageBuildItems.size()));
            for (int i = 0; i < runtimeInitializedPackageBuildItems.size(); ++i) {
                TryBlock tc4 = runtimeInitializedPackages.tryBlock();
                ResultHandle pkg = tc4.load(runtimeInitializedPackageBuildItems.get(i).getPackageName());
                tc4.writeArrayValue(packagesArray, i, pkg);
                CatchBlockCreator cc2 = tc4.addCatch(Throwable.class);
                cc2.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc2.getCaughtException(), new ResultHandle[0]);
            }
            runtimeInitializedPackages.returnValue(packagesArray);
            ResultHandle packages = overallCatch.invokeStaticMethod(runtimeInitializedPackages.getMethodDescriptor(), new ResultHandle[0]);
            overallCatch.invokeStaticMethod(INITIALIZE_PACKAGES_AT_RUN_TIME, new ResultHandle[]{packages});
        }
        if (!runtimeReinitializedClassBuildItems.isEmpty()) {
            MethodCreator runtimeReinitializedClasses = (MethodCreator)file.getMethodCreator("runtimeReinitializedClasses", Void.TYPE, new Class[0]).setModifiers(10);
            thisClass = runtimeReinitializedClasses.loadClassFromTCCL(GRAAL_FEATURE);
            cl = runtimeReinitializedClasses.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getClassLoader", ClassLoader.class, (Class[])new Class[0]), thisClass, new ResultHandle[0]);
            ResultHandle quarkus = runtimeReinitializedClasses.load("Quarkus");
            ResultHandle imageSingleton = runtimeReinitializedClasses.invokeStaticMethod(IMAGE_SINGLETONS_LOOKUP, new ResultHandle[]{runtimeReinitializedClasses.loadClassFromTCCL(RUNTIME_CLASS_INITIALIZATION_SUPPORT)});
            for (RuntimeReinitializedClassBuildItem runtimeReinitializedClassBuildItem : runtimeReinitializedClassBuildItems) {
                tc = runtimeReinitializedClasses.tryBlock();
                clazz = tc.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class}), new ResultHandle[]{tc.load(runtimeReinitializedClassBuildItem.getClassName()), tc.load(false), cl});
                tc.invokeInterfaceMethod(RERUN_INITIALIZATION, imageSingleton, new ResultHandle[]{clazz, quarkus});
                cc = tc.addCatch(Throwable.class);
                cc.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc.getCaughtException(), new ResultHandle[0]);
            }
            runtimeReinitializedClasses.returnVoid();
            overallCatch.invokeStaticMethod(runtimeReinitializedClasses.getMethodDescriptor(), new ResultHandle[0]);
        }
        if (!proxies.isEmpty()) {
            MethodCreator registerProxies = (MethodCreator)file.getMethodCreator("registerProxies", Void.TYPE, new Class[0]).setModifiers(10);
            exports.produce(new JPMSExportBuildItem("org.graalvm.nativeimage.builder", "com.oracle.svm.core.jdk.proxy", null, GraalVM.Version.VERSION_22_3_0));
            ResultHandle versionCompareto22_3Result = registerProxies.invokeVirtualMethod(VERSION_COMPARE_TO, registerProxies.invokeStaticMethod(VERSION_CURRENT, new ResultHandle[0]), new ResultHandle[]{registerProxies.marshalAsArray(Integer.TYPE, new ResultHandle[]{registerProxies.load(22), registerProxies.load(3)})});
            for (NativeImageProxyDefinitionBuildItem proxy : proxies) {
                ResultHandle array = registerProxies.newArray(Class.class, registerProxies.load(proxy.getClasses().size()));
                int i = 0;
                for (String p : proxy.getClasses()) {
                    clazz = registerProxies.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class}), new ResultHandle[]{registerProxies.load(p)});
                    registerProxies.writeArrayValue(array, i++, clazz);
                }
                BranchResult branchResult = registerProxies.ifGreaterEqualZero(versionCompareto22_3Result);
                try (BytecodeCreator greaterThan22_2 = branchResult.trueBranch();){
                    MethodDescriptor registerMethod = MethodDescriptor.ofMethod((Object)"org.graalvm.nativeimage.hosted.RuntimeProxyCreation", (String)"register", Void.TYPE, (Object[])new Object[]{Class[].class});
                    greaterThan22_2.invokeStaticMethod(registerMethod, new ResultHandle[]{array});
                }
                BytecodeCreator smallerThan22_3 = branchResult.falseBranch();
                try {
                    ResultHandle proxySupportClass = smallerThan22_3.loadClassFromTCCL(DYNAMIC_PROXY_REGISTRY);
                    ResultHandle proxySupport = smallerThan22_3.invokeStaticMethod(IMAGE_SINGLETONS_LOOKUP, new ResultHandle[]{proxySupportClass});
                    smallerThan22_3.invokeInterfaceMethod(MethodDescriptor.ofMethod((Object)DYNAMIC_PROXY_REGISTRY, (String)"addProxyClass", Void.TYPE, (Object[])new Object[]{Class[].class}), proxySupport, new ResultHandle[]{array});
                }
                finally {
                    if (smallerThan22_3 == null) continue;
                    smallerThan22_3.close();
                }
            }
            registerProxies.returnVoid();
            overallCatch.invokeStaticMethod(registerProxies.getMethodDescriptor(), new ResultHandle[0]);
        }
        if (!resourcePatterns.isEmpty()) {
            MethodCreator resourceIncludesExcludes = (MethodCreator)file.getMethodCreator("resourceIncludesExcludes", Void.TYPE, new Class[0]).setModifiers(10);
            exports.produce(new JPMSExportBuildItem("org.graalvm.nativeimage.builder", "com.oracle.svm.core.configure", null, GraalVM.Version.VERSION_22_3_0));
            TryBlock tc5 = resourceIncludesExcludes.tryBlock();
            ResultHandle resourcesArgTypes = tc5.marshalAsArray(Class.class, new ResultHandle[]{tc5.loadClassFromTCCL(CONFIGURATION_CONDITION), tc5.loadClassFromTCCL(String.class)});
            AssignableResultHandle resourcesArgs = tc5.createVariable(Object[].class);
            tc5.assign(resourcesArgs, tc5.marshalAsArray(Object.class, new ResultHandle[]{tc5.invokeStaticMethod(CONFIGURATION_ALWAYS_TRUE, new ResultHandle[0]), tc5.loadNull()}));
            AssignableResultHandle ignoreResourcesMethod = tc5.createVariable(Method.class);
            AssignableResultHandle addResourcesMethod = tc5.createVariable(Method.class);
            AssignableResultHandle assignableResultHandle = tc5.createVariable(Object.class);
            BranchResult graalVm22_3Test = tc5.ifGreaterEqualZero(tc5.invokeVirtualMethod(VERSION_COMPARE_TO, tc5.invokeStaticMethod(VERSION_CURRENT, new ResultHandle[0]), new ResultHandle[]{tc5.marshalAsArray(Integer.TYPE, new ResultHandle[]{tc5.load(22), tc5.load(3)})}));
            try (BytecodeCreator greaterThan22_2 = graalVm22_3Test.trueBranch();){
                ResultHandle runtimeResourceSupportClass = greaterThan22_2.loadClassFromTCCL(RUNTIME_RESOURCE_SUPPORT);
                greaterThan22_2.assign(assignableResultHandle, greaterThan22_2.invokeStaticMethod(IMAGE_SINGLETONS_LOOKUP, new ResultHandle[]{runtimeResourceSupportClass}));
                greaterThan22_2.assign(ignoreResourcesMethod, greaterThan22_2.invokeStaticMethod(LOOKUP_METHOD, new ResultHandle[]{runtimeResourceSupportClass, greaterThan22_2.load("ignoreResources"), resourcesArgTypes}));
                greaterThan22_2.assign(addResourcesMethod, greaterThan22_2.invokeStaticMethod(LOOKUP_METHOD, new ResultHandle[]{runtimeResourceSupportClass, greaterThan22_2.load("addResources"), resourcesArgTypes}));
            }
            try (BytecodeCreator smallerThan22_3 = graalVm22_3Test.falseBranch();){
                ResultHandle resourceRegistryClass = smallerThan22_3.loadClassFromTCCL("com.oracle.svm.core.configure.ResourcesRegistry");
                smallerThan22_3.assign(assignableResultHandle, smallerThan22_3.invokeStaticMethod(IMAGE_SINGLETONS_LOOKUP, new ResultHandle[]{resourceRegistryClass}));
                smallerThan22_3.assign(ignoreResourcesMethod, smallerThan22_3.invokeStaticMethod(LOOKUP_METHOD, new ResultHandle[]{resourceRegistryClass, smallerThan22_3.load("ignoreResources"), resourcesArgTypes}));
                smallerThan22_3.assign(addResourcesMethod, smallerThan22_3.invokeStaticMethod(LOOKUP_METHOD, new ResultHandle[]{resourceRegistryClass, smallerThan22_3.load("addResources"), resourcesArgTypes}));
            }
            ResultHandle indexOne = tc5.load(1);
            for (NativeImageResourcePatternsBuildItem resourcePatternsItem : resourcePatterns) {
                for (String pattern : resourcePatternsItem.getExcludePatterns()) {
                    tc5.writeArrayValue((ResultHandle)resourcesArgs, indexOne, tc5.load(pattern));
                    tc5.invokeVirtualMethod(INVOKE, (ResultHandle)ignoreResourcesMethod, new ResultHandle[]{assignableResultHandle, resourcesArgs});
                }
                for (String pattern : resourcePatternsItem.getIncludePatterns()) {
                    tc5.writeArrayValue((ResultHandle)resourcesArgs, indexOne, tc5.load(pattern));
                    tc5.invokeVirtualMethod(INVOKE, (ResultHandle)addResourcesMethod, new ResultHandle[]{assignableResultHandle, resourcesArgs});
                }
            }
            cc = tc5.addCatch(Throwable.class);
            cc.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc.getCaughtException(), new ResultHandle[0]);
            resourceIncludesExcludes.returnVoid();
            overallCatch.invokeStaticMethod(resourceIncludesExcludes.getMethodDescriptor(), new ResultHandle[0]);
        }
        MethodCreator registerServiceProviders = (MethodCreator)file.getMethodCreator("registerServiceProviders", Void.TYPE, new Class[0]).setModifiers(10);
        for (ServiceProviderBuildItem i : serviceProviderBuildItems) {
            registerServiceProviders.invokeStaticMethod(MethodDescriptor.ofMethod(ResourceHelper.class, (String)"registerResources", Void.TYPE, (Class[])new Class[]{String.class}), new ResultHandle[]{registerServiceProviders.load(i.serviceDescriptorFile())});
        }
        registerServiceProviders.returnVoid();
        overallCatch.invokeStaticMethod(registerServiceProviders.getMethodDescriptor(), new ResultHandle[0]);
        if (!resourceBundles.isEmpty()) {
            Object object;
            MethodCreator registerResourceBundles = (MethodCreator)file.getMethodCreator("registerResourceBundles", Void.TYPE, new Class[0]).setModifiers(10);
            exports.produce(new JPMSExportBuildItem("org.graalvm.nativeimage.builder", "com.oracle.svm.core.jdk.localization", null, GraalVM.Version.VERSION_22_3_0));
            BranchResult graalVm22_3Test = registerResourceBundles.ifGreaterEqualZero(registerResourceBundles.invokeVirtualMethod(VERSION_COMPARE_TO, registerResourceBundles.invokeStaticMethod(VERSION_CURRENT, new ResultHandle[0]), new ResultHandle[]{registerResourceBundles.marshalAsArray(Integer.TYPE, new ResultHandle[]{registerResourceBundles.load(22), registerResourceBundles.load(3)})}));
            try (BytecodeCreator greaterThan22_2 = graalVm22_3Test.trueBranch();){
                MethodDescriptor addResourceBundle = MethodDescriptor.ofMethod((Object)"org.graalvm.nativeimage.hosted.RuntimeResourceAccess", (String)"addResourceBundle", Void.TYPE, (Object[])new Object[]{Module.class, String.class});
                for (NativeImageResourceBundleBuildItem nativeImageResourceBundleBuildItem : resourceBundles) {
                    tc = greaterThan22_2.tryBlock();
                    String moduleName = nativeImageResourceBundleBuildItem.getModuleName();
                    ResultHandle moduleNameHandle = moduleName == null ? tc.loadNull() : tc.load(moduleName);
                    ResultHandle module = tc.invokeStaticMethod(FIND_MODULE_METHOD, new ResultHandle[]{moduleNameHandle});
                    tc.invokeStaticMethod(addResourceBundle, new ResultHandle[]{module, tc.load(nativeImageResourceBundleBuildItem.getBundleName())});
                    object = tc.addCatch(Throwable.class);
                }
            }
            try (BytecodeCreator smallerThan22_3 = graalVm22_3Test.falseBranch();){
                ResultHandle locClass = smallerThan22_3.loadClassFromTCCL(LOCALIZATION_FEATURE);
                ResultHandle newParams = smallerThan22_3.marshalAsArray(Class.class, new ResultHandle[]{smallerThan22_3.loadClassFromTCCL(String.class)});
                ResultHandle resultHandle = smallerThan22_3.invokeStaticMethod(LOOKUP_METHOD, new ResultHandle[]{locClass, smallerThan22_3.load("prepareBundle"), newParams});
                ResultHandle locSupport = smallerThan22_3.invokeStaticMethod(IMAGE_SINGLETONS_LOOKUP, new ResultHandle[]{locClass});
                for (NativeImageResourceBundleBuildItem i : resourceBundles) {
                    TryBlock et = smallerThan22_3.tryBlock();
                    et.invokeVirtualMethod(MethodDescriptor.ofMethod(Method.class, (String)"invoke", Object.class, (Class[])new Class[]{Object.class, Object[].class}), resultHandle, new ResultHandle[]{locSupport, et.marshalAsArray(Object.class, new ResultHandle[]{et.load(i.getBundleName())})});
                    object = et.addCatch(Throwable.class);
                }
            }
            registerResourceBundles.returnVoid();
            overallCatch.invokeStaticMethod(registerResourceBundles.getMethodDescriptor(), new ResultHandle[0]);
        }
        int count = 0;
        for (JniRuntimeAccessBuildItem jniAccessible : jniRuntimeAccessibleClasses) {
            for (String className : jniAccessible.getClassNames()) {
                MethodCreator methodCreator = file.getMethodCreator("registerJniAccessibleClass" + count++, "V", new String[0]);
                methodCreator.setModifiers(10);
                overallCatch.invokeStaticMethod(methodCreator.getMethodDescriptor(), new ResultHandle[0]);
                tc = methodCreator.tryBlock();
                clazz = tc.loadClassFromTCCL(className);
                ResultHandle constructors = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredConstructors", Constructor[].class, (Class[])new Class[0]), clazz, new ResultHandle[0]);
                ResultHandle methods = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethods", Method[].class, (Class[])new Class[0]), clazz, new ResultHandle[0]);
                ResultHandle fields = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredFields", Field[].class, (Class[])new Class[0]), clazz, new ResultHandle[0]);
                ResultHandle carray = tc.newArray(Class.class, tc.load(1));
                tc.writeArrayValue(carray, 0, clazz);
                BranchResult graalVm22_3Test = tc.ifGreaterEqualZero(tc.invokeVirtualMethod(VERSION_COMPARE_TO, tc.invokeStaticMethod(VERSION_CURRENT, new ResultHandle[0]), new ResultHandle[]{tc.marshalAsArray(Integer.TYPE, new ResultHandle[]{tc.load(22), tc.load(3)})}));
                try (BytecodeCreator greaterThan22_2 = graalVm22_3Test.trueBranch();){
                    greaterThan22_2.invokeStaticMethod(MethodDescriptor.ofMethod((Object)JNI_RUNTIME_ACCESS, (String)"register", Void.TYPE, (Object[])new Object[]{Class[].class}), new ResultHandle[]{carray});
                    if (jniAccessible.isConstructors()) {
                        greaterThan22_2.invokeStaticMethod(MethodDescriptor.ofMethod((Object)JNI_RUNTIME_ACCESS, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{constructors});
                    }
                    if (jniAccessible.isMethods()) {
                        greaterThan22_2.invokeStaticMethod(MethodDescriptor.ofMethod((Object)JNI_RUNTIME_ACCESS, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{methods});
                    }
                    if (jniAccessible.isFields()) {
                        greaterThan22_2.invokeStaticMethod(MethodDescriptor.ofMethod((Object)JNI_RUNTIME_ACCESS, (String)"register", Void.TYPE, (Object[])new Object[]{Field[].class}), new ResultHandle[]{fields});
                    }
                }
                try (BytecodeCreator smallerThan22_3 = graalVm22_3Test.falseBranch();){
                    smallerThan22_3.invokeStaticMethod(MethodDescriptor.ofMethod((Object)LEGACY_JNI_RUNTIME_ACCESS, (String)"register", Void.TYPE, (Object[])new Object[]{Class[].class}), new ResultHandle[]{carray});
                    if (jniAccessible.isConstructors()) {
                        smallerThan22_3.invokeStaticMethod(MethodDescriptor.ofMethod((Object)LEGACY_JNI_RUNTIME_ACCESS, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{constructors});
                    }
                    if (jniAccessible.isMethods()) {
                        smallerThan22_3.invokeStaticMethod(MethodDescriptor.ofMethod((Object)LEGACY_JNI_RUNTIME_ACCESS, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{methods});
                    }
                    if (jniAccessible.isFields()) {
                        smallerThan22_3.invokeStaticMethod(MethodDescriptor.ofMethod((Object)LEGACY_JNI_RUNTIME_ACCESS, (String)"register", Void.TYPE, (Object[])new Object[]{Boolean.TYPE, Field[].class}), new ResultHandle[]{smallerThan22_3.load(jniAccessible.isFinalFieldsWriteable()), fields});
                    }
                }
                CatchBlockCreator cc4 = tc.addCatch(Throwable.class);
                methodCreator.returnValue(null);
            }
        }
        CatchBlockCreator print = overallCatch.addCatch(Throwable.class);
        print.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), print.getCaughtException(), new ResultHandle[0]);
        beforeAn.loadClassFromTCCL("io.quarkus.runner.ApplicationImpl");
        beforeAn.returnValue(null);
        file.close();
    }
}

