/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.builder.Json;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.JniRuntimeAccessBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NativeImageJNIConfigStep {
    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void generateJniConfig(BuildProducer<GeneratedResourceBuildItem> jniConfig, List<JniRuntimeAccessBuildItem> jniRuntimeAccessibleClasses) {
        LinkedHashMap<String, JniInfo> jniClasses = new LinkedHashMap<String, JniInfo>();
        for (JniRuntimeAccessBuildItem jniRuntimeAccessBuildItem : jniRuntimeAccessibleClasses) {
            this.addJniClass(jniClasses, jniRuntimeAccessBuildItem);
        }
        Json.JsonArrayBuilder root = Json.array();
        for (Map.Entry entry : jniClasses.entrySet()) {
            Json.JsonObjectBuilder json = Json.object();
            json.put("name", (String)entry.getKey());
            JniInfo info = (JniInfo)entry.getValue();
            if (info.constructors) {
                json.put("allDeclaredConstructors", true);
            }
            if (info.methods) {
                json.put("allDeclaredMethods", true);
            }
            if (info.fields) {
                json.put("allDeclaredFields", true);
            }
            root.add(json);
        }
        try (StringWriter stringWriter = new StringWriter();){
            root.appendTo((Appendable)stringWriter);
            jniConfig.produce(new GeneratedResourceBuildItem("META-INF/native-image/jni-config.json", stringWriter.toString().getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private void addJniClass(Map<String, JniInfo> jniClasses, JniRuntimeAccessBuildItem jniRuntimeAccessBuildItem) {
        for (String cl : jniRuntimeAccessBuildItem.getClassNames()) {
            JniInfo existing = jniClasses.get(cl);
            if (existing == null) {
                jniClasses.put(cl, new JniInfo(jniRuntimeAccessBuildItem));
                continue;
            }
            if (jniRuntimeAccessBuildItem.isConstructors()) {
                existing.constructors = true;
            }
            if (jniRuntimeAccessBuildItem.isMethods()) {
                existing.methods = true;
            }
            if (!jniRuntimeAccessBuildItem.isFields()) continue;
            existing.fields = true;
        }
    }

    static final class JniInfo {
        boolean constructors;
        boolean methods;
        boolean fields;

        private JniInfo(JniRuntimeAccessBuildItem jniRuntimeAccessBuildItem) {
            this.methods = jniRuntimeAccessBuildItem.isMethods();
            this.fields = jniRuntimeAccessBuildItem.isFields();
            this.constructors = jniRuntimeAccessBuildItem.isConstructors();
        }
    }
}

