/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ConfigClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.util.ReflectUtil;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappingLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class ConfigMappingUtils {
    public static final DotName CONFIG_MAPPING_NAME = DotName.createSimple((String)ConfigMapping.class.getName());
    private static final DotName OPTIONAL = DotName.createSimple((String)Optional.class.getName());

    private ConfigMappingUtils() {
    }

    public static void generateConfigClasses(CombinedIndexBuildItem combinedIndex, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ConfigClassBuildItem> configClasses, DotName configAnnotation) {
        for (AnnotationInstance instance : combinedIndex.getIndex().getAnnotations(configAnnotation)) {
            AnnotationTarget target = instance.target();
            AnnotationValue annotationPrefix = instance.value("prefix");
            if (!target.kind().equals((Object)AnnotationTarget.Kind.CLASS)) continue;
            Class<?> configClass = ConfigMappingUtils.toClass(target.asClass().name());
            String prefix = Optional.ofNullable(annotationPrefix).map(AnnotationValue::asString).orElse("");
            ConfigClassBuildItem.Kind configClassKind = ConfigMappingUtils.getConfigClassType(instance);
            ConfigMappingUtils.processConfigClass(configClass, configClassKind, prefix, true, combinedIndex, generatedClasses, reflectiveClasses, configClasses);
        }
    }

    public static void processExtensionConfigMapping(Class<?> configClass, String prefix, CombinedIndexBuildItem combinedIndex, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ConfigClassBuildItem> configClasses) {
        ConfigMappingUtils.processConfigClass(configClass, ConfigClassBuildItem.Kind.MAPPING, prefix, false, combinedIndex, generatedClasses, reflectiveClasses, configClasses);
    }

    static void processConfigClass(Class<?> configClass, ConfigClassBuildItem.Kind configClassKind, String prefix, boolean isApplicationClass, CombinedIndexBuildItem combinedIndex, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ConfigClassBuildItem> configClasses) {
        List configMappingsMetadata = ConfigMappingLoader.getConfigMappingsMetadata(configClass);
        HashSet<String> generatedClassesNames = new HashSet<String>();
        HashSet mappingsInfo = new HashSet();
        configMappingsMetadata.forEach(mappingMetadata -> {
            generatedClasses.produce(new GeneratedClassBuildItem(isApplicationClass, mappingMetadata.getClassName(), mappingMetadata.getClassBytes()));
            reflectiveClasses.produce(ReflectiveClassBuildItem.builder(mappingMetadata.getInterfaceType()).methods().build());
            reflectiveClasses.produce(ReflectiveClassBuildItem.builder(mappingMetadata.getClassName()).methods().build());
            for (Class<?> parent : ConfigMappingUtils.getHierarchy(mappingMetadata.getInterfaceType())) {
                reflectiveClasses.produce(ReflectiveClassBuildItem.builder(parent).methods().build());
            }
            generatedClassesNames.add(mappingMetadata.getClassName());
            ClassInfo mappingInfo = combinedIndex.getIndex().getClassByName(DotName.createSimple((String)mappingMetadata.getInterfaceType().getName()));
            if (mappingInfo != null) {
                mappingsInfo.add(mappingInfo);
            }
        });
        for (ClassInfo classInfo : mappingsInfo) {
            for (MethodInfo method : classInfo.methods()) {
                Type type = method.returnType();
                if (type.name().equals((Object)OPTIONAL)) {
                    type = (Type)type.asParameterizedType().arguments().get(0);
                }
                reflectiveClasses.produce(ReflectiveClassBuildItem.builder(type.name().toString()).methods().build());
            }
        }
        configClasses.produce(new ConfigClassBuildItem(configClass, ConfigMappingUtils.collectTypes(combinedIndex, configClass), generatedClassesNames, prefix, configClassKind));
    }

    public static Object newInstance(Class<?> configClass) {
        if (configClass.isAnnotationPresent(ConfigMapping.class)) {
            return ReflectUtil.newInstance(ConfigMappingLoader.getImplementationClass(configClass));
        }
        return ReflectUtil.newInstance(configClass);
    }

    private static Class<?> toClass(DotName dotName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            return classLoader.loadClass(dotName.toString());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("The class (" + dotName + ") cannot be created during deployment.", e);
        }
    }

    private static ConfigClassBuildItem.Kind getConfigClassType(AnnotationInstance instance) {
        if (instance.name().equals((Object)CONFIG_MAPPING_NAME)) {
            return ConfigClassBuildItem.Kind.MAPPING;
        }
        return ConfigClassBuildItem.Kind.PROPERTIES;
    }

    private static List<Class<?>> getHierarchy(Class<?> mapping) {
        ArrayList interfaces = new ArrayList();
        for (Class<?> i : mapping.getInterfaces()) {
            interfaces.add(i);
            interfaces.addAll(ConfigMappingUtils.getHierarchy(i));
        }
        return interfaces;
    }

    private static Set<Type> collectTypes(CombinedIndexBuildItem combinedIndex, Class<?> configClass) {
        DotName configIfaceName;
        IndexView index = combinedIndex.getIndex();
        ClassInfo configIfaceInfo = index.getClassByName(configIfaceName = DotName.createSimple((String)configClass.getName()));
        if (configIfaceInfo == null || configIfaceInfo.interfaceNames().isEmpty()) {
            return Collections.singleton(Type.create((DotName)configIfaceName, (Type.Kind)Type.Kind.CLASS));
        }
        HashSet<DotName> allIfaces = new HashSet<DotName>();
        allIfaces.add(configIfaceName);
        ConfigMappingUtils.collectInterfacesRec(configIfaceInfo, index, allIfaces);
        HashSet<Type> result = new HashSet<Type>(allIfaces.size());
        for (DotName iface : allIfaces) {
            result.add(Type.create((DotName)iface, (Type.Kind)Type.Kind.CLASS));
        }
        return result;
    }

    private static void collectInterfacesRec(ClassInfo current, IndexView index, Set<DotName> result) {
        List interfaces = current.interfaceNames();
        if (interfaces.isEmpty()) {
            return;
        }
        for (DotName iface : interfaces) {
            ClassInfo classByName = index.getClassByName(iface);
            if (classByName == null) continue;
            result.add(iface);
            ConfigMappingUtils.collectInterfacesRec(classByName, index, result);
        }
    }
}

