/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalBootstrapConfigSourceProviderBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ConfigClassBuildItem;
import io.quarkus.deployment.builditem.ConfigMappingBuildItem;
import io.quarkus.deployment.builditem.ConfigurationBuildItem;
import io.quarkus.deployment.builditem.ConfigurationTypeBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigBuilderBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.StaticInitConfigBuilderBuildItem;
import io.quarkus.deployment.builditem.StaticInitConfigSourceFactoryBuildItem;
import io.quarkus.deployment.builditem.StaticInitConfigSourceProviderBuildItem;
import io.quarkus.deployment.builditem.SuppressNonRuntimeConfigChangedWarningBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.configuration.BuildTimeConfigurationReader;
import io.quarkus.deployment.configuration.ConfigMappingUtils;
import io.quarkus.deployment.configuration.RunTimeConfigurationGenerator;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.annotations.StaticInitSafe;
import io.quarkus.runtime.configuration.ConfigBuilder;
import io.quarkus.runtime.configuration.ConfigDiagnostic;
import io.quarkus.runtime.configuration.ConfigRecorder;
import io.quarkus.runtime.configuration.DefaultsConfigSource;
import io.quarkus.runtime.configuration.DisableableConfigSource;
import io.quarkus.runtime.configuration.QuarkusConfigValue;
import io.quarkus.runtime.configuration.RuntimeOverrideConfigSource;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.PropertiesLocationConfigSourceFactory;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.ConfigValue;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public class ConfigGenerationBuildStep {
    private static final MethodDescriptor CONFIG_BUILDER = MethodDescriptor.ofMethod(ConfigBuilder.class, (String)"configBuilder", SmallRyeConfigBuilder.class, (Class[])new Class[]{SmallRyeConfigBuilder.class});
    private static final MethodDescriptor WITH_SOURCES = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"withSources", SmallRyeConfigBuilder.class, (Class[])new Class[]{ConfigSource[].class});
    private static final MethodDescriptor WITH_MAPPING = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"withMapping", SmallRyeConfigBuilder.class, (Class[])new Class[]{Class.class, String.class});

    @BuildStep
    void staticInitSources(BuildProducer<StaticInitConfigSourceProviderBuildItem> staticInitConfigSourceProviderBuildItem, BuildProducer<StaticInitConfigSourceFactoryBuildItem> staticInitConfigSourceFactoryBuildItem) {
        staticInitConfigSourceFactoryBuildItem.produce(new StaticInitConfigSourceFactoryBuildItem(PropertiesLocationConfigSourceFactory.class.getName()));
    }

    @BuildStep
    void buildTimeRunTimeConfig(ConfigurationBuildItem configItem, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<StaticInitConfigBuilderBuildItem> staticInitConfigBuilder, BuildProducer<RunTimeConfigBuilderBuildItem> runTimeConfigBuilder) {
        String className = "io.quarkus.runtime.generated.BuildTimeRunTimeFixedConfigSource";
        ConfigGenerationBuildStep.generateDefaultsConfigSource(generatedClass, reflectiveClass, configItem.getReadResult().getBuildTimeRunTimeValues(), className, "BuildTime RunTime Fixed", Integer.MAX_VALUE);
        String builderClassName = className + "Builder";
        try (ClassCreator classCreator = ClassCreator.builder().classOutput((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClass, true)).className(builderClassName).interfaces(new Class[]{ConfigBuilder.class}).setFinal(true).build();){
            FieldDescriptor source = FieldDescriptor.of((String)classCreator.getClassName(), (String)"source", ConfigSource.class);
            classCreator.getFieldCreator(source).setModifiers(24);
            MethodCreator clinit = classCreator.getMethodCreator("<clinit>", Void.TYPE, new Class[0]);
            clinit.setModifiers(8);
            ResultHandle buildTimeRunTimeConfigSource = clinit.newInstance(MethodDescriptor.ofConstructor((String)className, (String[])new String[0]), new ResultHandle[0]);
            ResultHandle disableableConfigSource = clinit.newInstance(MethodDescriptor.ofConstructor(DisableableConfigSource.class, (Class[])new Class[]{ConfigSource.class}), new ResultHandle[]{buildTimeRunTimeConfigSource});
            clinit.writeStaticField(source, disableableConfigSource);
            clinit.returnVoid();
            MethodCreator method = classCreator.getMethodCreator(CONFIG_BUILDER);
            ResultHandle configBuilder = method.getMethodParam(0);
            ResultHandle configSources = method.newArray(ConfigSource.class, 1);
            method.writeArrayValue(configSources, 0, method.readStaticField(source));
            method.invokeVirtualMethod(WITH_SOURCES, configBuilder, new ResultHandle[]{configSources});
            method.returnValue(configBuilder);
        }
        reflectiveClass.produce(ReflectiveClassBuildItem.builder(builderClassName).build());
        staticInitConfigBuilder.produce(new StaticInitConfigBuilderBuildItem(builderClassName));
        runTimeConfigBuilder.produce(new RunTimeConfigBuilderBuildItem(builderClassName));
    }

    @BuildStep
    void runtimeDefaultsConfig(ConfigurationBuildItem configItem, List<RunTimeConfigurationDefaultBuildItem> runTimeDefaults, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<StaticInitConfigBuilderBuildItem> staticInitConfigBuilder, BuildProducer<RunTimeConfigBuilderBuildItem> runTimeConfigBuilder) {
        HashMap<String, String> defaults = new HashMap<String, String>();
        for (RunTimeConfigurationDefaultBuildItem e : runTimeDefaults) {
            defaults.put(e.getKey(), e.getValue());
        }
        defaults.putAll(configItem.getReadResult().getRunTimeDefaultValues());
        String className = "io.quarkus.runtime.generated.RunTimeDefaultsConfigSource";
        ConfigGenerationBuildStep.generateDefaultsConfigSource(generatedClass, reflectiveClass, defaults, className, "RunTime Defaults", -2147483548);
        String builderClassName = className + "Builder";
        try (ClassCreator classCreator = ClassCreator.builder().classOutput((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClass, true)).className(builderClassName).interfaces(new Class[]{ConfigBuilder.class}).setFinal(true).build();){
            FieldDescriptor source = FieldDescriptor.of((String)classCreator.getClassName(), (String)"source", ConfigSource.class);
            classCreator.getFieldCreator(source).setModifiers(24);
            MethodCreator clinit = classCreator.getMethodCreator("<clinit>", Void.TYPE, new Class[0]);
            clinit.setModifiers(8);
            ResultHandle runtimeDefaultsConfigSource = clinit.newInstance(MethodDescriptor.ofConstructor((String)className, (String[])new String[0]), new ResultHandle[0]);
            clinit.writeStaticField(source, runtimeDefaultsConfigSource);
            clinit.returnVoid();
            MethodCreator method = classCreator.getMethodCreator(CONFIG_BUILDER);
            ResultHandle configBuilder = method.getMethodParam(0);
            ResultHandle configSources = method.newArray(ConfigSource.class, 1);
            method.writeArrayValue(configSources, 0, method.readStaticField(source));
            method.invokeVirtualMethod(WITH_SOURCES, configBuilder, new ResultHandle[]{configSources});
            method.returnValue(configBuilder);
        }
        reflectiveClass.produce(ReflectiveClassBuildItem.builder(builderClassName).build());
        staticInitConfigBuilder.produce(new StaticInitConfigBuilderBuildItem(builderClassName));
        runTimeConfigBuilder.produce(new RunTimeConfigBuilderBuildItem(builderClassName));
    }

    @BuildStep
    void extensionMappings(ConfigurationBuildItem configItem, CombinedIndexBuildItem combinedIndex, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ConfigClassBuildItem> configClasses) {
        List<ConfigMappings.ConfigClassWithPrefix> buildTimeRunTimeMappings = configItem.getReadResult().getBuildTimeRunTimeMappings();
        for (ConfigMappings.ConfigClassWithPrefix buildTimeRunTimeMapping : buildTimeRunTimeMappings) {
            ConfigMappingUtils.processExtensionConfigMapping(buildTimeRunTimeMapping.getKlass(), buildTimeRunTimeMapping.getPrefix(), combinedIndex, generatedClasses, reflectiveClasses, configClasses);
        }
        List<ConfigMappings.ConfigClassWithPrefix> runTimeMappings = configItem.getReadResult().getRunTimeMappings();
        for (ConfigMappings.ConfigClassWithPrefix runTimeMapping : runTimeMappings) {
            ConfigMappingUtils.processExtensionConfigMapping(runTimeMapping.getKlass(), runTimeMapping.getPrefix(), combinedIndex, generatedClasses, reflectiveClasses, configClasses);
        }
    }

    @BuildStep
    void builderMappings(ConfigurationBuildItem configItem, List<ConfigMappingBuildItem> configMappings, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<StaticInitConfigBuilderBuildItem> staticInitConfigBuilder, BuildProducer<RunTimeConfigBuilderBuildItem> runTimeConfigBuilder) {
        HashSet<ConfigMappings.ConfigClassWithPrefix> staticMappings = new HashSet<ConfigMappings.ConfigClassWithPrefix>();
        staticMappings.addAll(ConfigGenerationBuildStep.staticSafeConfigMappings(configMappings));
        staticMappings.addAll(configItem.getReadResult().getBuildTimeRunTimeMappings());
        String staticInitMappingsConfigBuilder = "io.quarkus.runtime.generated.StaticInitMappingsConfigBuilder";
        ConfigGenerationBuildStep.generateMappingsConfigBuilder(generatedClass, reflectiveClass, staticInitMappingsConfigBuilder, staticMappings);
        staticInitConfigBuilder.produce(new StaticInitConfigBuilderBuildItem(staticInitMappingsConfigBuilder));
        HashSet<ConfigMappings.ConfigClassWithPrefix> runTimeMappings = new HashSet<ConfigMappings.ConfigClassWithPrefix>();
        runTimeMappings.addAll(ConfigGenerationBuildStep.runtimeConfigMappings(configMappings));
        runTimeMappings.addAll(configItem.getReadResult().getBuildTimeRunTimeMappings());
        runTimeMappings.addAll(configItem.getReadResult().getRunTimeMappings());
        String runTimeMappingsConfigBuilder = "io.quarkus.runtime.generated.RunTimeMappingsConfigBuilder";
        ConfigGenerationBuildStep.generateMappingsConfigBuilder(generatedClass, reflectiveClass, runTimeMappingsConfigBuilder, runTimeMappings);
        runTimeConfigBuilder.produce(new RunTimeConfigBuilderBuildItem(runTimeMappingsConfigBuilder));
    }

    @BuildStep
    void generateConfigClass(ConfigurationBuildItem configItem, List<ConfigurationTypeBuildItem> typeItems, LaunchModeBuildItem launchModeBuildItem, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, LiveReloadBuildItem liveReloadBuildItem, List<AdditionalBootstrapConfigSourceProviderBuildItem> additionalBootstrapConfigSourceProviders, List<StaticInitConfigSourceProviderBuildItem> staticInitConfigSourceProviders, List<StaticInitConfigSourceFactoryBuildItem> staticInitConfigSourceFactories, List<ConfigMappingBuildItem> configMappings, List<StaticInitConfigBuilderBuildItem> staticInitConfigBuilders, List<RunTimeConfigBuilderBuildItem> runTimeConfigBuilders) throws IOException {
        ConfigGenerationBuildStep.reportUnknownBuildProperties(launchModeBuildItem.getLaunchMode(), configItem.getReadResult().getUnknownBuildProperties());
        if (liveReloadBuildItem.isLiveReload()) {
            return;
        }
        Set<String> discoveredConfigSources = ConfigGenerationBuildStep.discoverService(ConfigSource.class, reflectiveClass);
        Set<String> discoveredConfigSourceProviders = ConfigGenerationBuildStep.discoverService(ConfigSourceProvider.class, reflectiveClass);
        Set<String> discoveredConfigSourceFactories = ConfigGenerationBuildStep.discoverService(ConfigSourceFactory.class, reflectiveClass);
        HashSet<String> staticConfigSourceProviders = new HashSet<String>();
        staticConfigSourceProviders.addAll(ConfigGenerationBuildStep.staticSafeServices(discoveredConfigSourceProviders));
        staticConfigSourceProviders.addAll(staticInitConfigSourceProviders.stream().map(StaticInitConfigSourceProviderBuildItem::getProviderClassName).collect(Collectors.toSet()));
        HashSet<String> staticConfigSourceFactories = new HashSet<String>();
        staticConfigSourceFactories.addAll(ConfigGenerationBuildStep.staticSafeServices(discoveredConfigSourceFactories));
        staticConfigSourceFactories.addAll(staticInitConfigSourceFactories.stream().map(StaticInitConfigSourceFactoryBuildItem::getFactoryClassName).collect(Collectors.toSet()));
        HashSet<ConfigMappings.ConfigClassWithPrefix> staticMappings = new HashSet<ConfigMappings.ConfigClassWithPrefix>();
        staticMappings.addAll(ConfigGenerationBuildStep.staticSafeConfigMappings(configMappings));
        staticMappings.addAll(configItem.getReadResult().getBuildTimeRunTimeMappings());
        HashSet<ConfigMappings.ConfigClassWithPrefix> runtimeMappings = new HashSet<ConfigMappings.ConfigClassWithPrefix>();
        runtimeMappings.addAll(ConfigGenerationBuildStep.runtimeConfigMappings(configMappings));
        runtimeMappings.addAll(configItem.getReadResult().getBuildTimeRunTimeMappings());
        runtimeMappings.addAll(configItem.getReadResult().getRunTimeMappings());
        Set<String> runtimeConfigBuilderClassNames = runTimeConfigBuilders.stream().map(RunTimeConfigBuilderBuildItem::getBuilderClassName).collect(Collectors.toSet());
        reflectiveClass.produce(ReflectiveClassBuildItem.builder(runtimeConfigBuilderClassNames.toArray(new String[0])).build());
        RunTimeConfigurationGenerator.GenerateOperation.builder().setBuildTimeReadResult(configItem.getReadResult()).setClassOutput(new GeneratedClassGizmoAdaptor(generatedClass, false)).setLaunchMode(launchModeBuildItem.getLaunchMode()).setLiveReloadPossible(launchModeBuildItem.getLaunchMode() == LaunchMode.DEVELOPMENT || launchModeBuildItem.isAuxiliaryApplication()).setAdditionalTypes(typeItems.stream().map(ConfigurationTypeBuildItem::getValueType).collect(Collectors.toList())).setAdditionalBootstrapConfigSourceProviders(ConfigGenerationBuildStep.getAdditionalBootstrapConfigSourceProviders(additionalBootstrapConfigSourceProviders)).setStaticConfigSources(ConfigGenerationBuildStep.staticSafeServices(discoveredConfigSources)).setStaticConfigSourceProviders(staticConfigSourceProviders).setStaticConfigSourceFactories(staticConfigSourceFactories).setStaticConfigMappings(staticMappings).setStaticConfigBuilders(staticInitConfigBuilders.stream().map(StaticInitConfigBuilderBuildItem::getBuilderClassName).collect(Collectors.toSet())).setRuntimeConfigSources(discoveredConfigSources).setRuntimeConfigSourceProviders(discoveredConfigSourceProviders).setRuntimeConfigSourceFactories(discoveredConfigSourceFactories).setRuntimeConfigMappings(runtimeMappings).setRuntimeConfigBuilders(runtimeConfigBuilderClassNames).build().run();
    }

    private static void reportUnknownBuildProperties(LaunchMode launchMode, Set<String> unknownBuildProperties) {
        if (!launchMode.isDevOrTest()) {
            ConfigDiagnostic.unknownProperties(unknownBuildProperties);
        }
    }

    private static List<String> getAdditionalBootstrapConfigSourceProviders(List<AdditionalBootstrapConfigSourceProviderBuildItem> additionalBootstrapConfigSourceProviders) {
        if (additionalBootstrapConfigSourceProviders.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(additionalBootstrapConfigSourceProviders.size());
        for (AdditionalBootstrapConfigSourceProviderBuildItem provider : additionalBootstrapConfigSourceProviders) {
            result.add(provider.getProviderClassName());
        }
        return result;
    }

    @BuildStep
    public void suppressNonRuntimeConfigChanged(BuildProducer<SuppressNonRuntimeConfigChangedWarningBuildItem> suppressNonRuntimeConfigChanged) {
        suppressNonRuntimeConfigChanged.produce(new SuppressNonRuntimeConfigChangedWarningBuildItem("quarkus.profile"));
        suppressNonRuntimeConfigChanged.produce(new SuppressNonRuntimeConfigChangedWarningBuildItem("quarkus.uuid"));
        suppressNonRuntimeConfigChanged.produce(new SuppressNonRuntimeConfigChangedWarningBuildItem("quarkus.default-locale"));
        suppressNonRuntimeConfigChanged.produce(new SuppressNonRuntimeConfigChangedWarningBuildItem("quarkus.locales"));
        suppressNonRuntimeConfigChanged.produce(new SuppressNonRuntimeConfigChangedWarningBuildItem("quarkus.test.arg-line"));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void checkForBuildTimeConfigChange(RecorderContext recorderContext, ConfigRecorder recorder, ConfigurationBuildItem configItem, List<SuppressNonRuntimeConfigChangedWarningBuildItem> suppressNonRuntimeConfigChangedWarningItems) {
        recorderContext.registerSubstitution(io.smallrye.config.ConfigValue.class, QuarkusConfigValue.class, QuarkusConfigValue.Substitution.class);
        BuildTimeConfigurationReader.ReadResult readResult = configItem.getReadResult();
        Config config = ConfigProvider.getConfig();
        HashSet<String> excludedConfigKeys = new HashSet<String>(suppressNonRuntimeConfigChangedWarningItems.size());
        for (SuppressNonRuntimeConfigChangedWarningBuildItem item : suppressNonRuntimeConfigChangedWarningItems) {
            excludedConfigKeys.add(item.getConfigKey());
        }
        HashMap<String, ConfigValue> values = new HashMap<String, ConfigValue>();
        for (Map.Entry<String, String> entry : readResult.getAllBuildTimeValues().entrySet()) {
            if (excludedConfigKeys.contains(entry.getKey())) continue;
            values.putIfAbsent(entry.getKey(), config.getConfigValue(entry.getKey()));
        }
        for (Map.Entry<String, String> entry : readResult.getBuildTimeRunTimeValues().entrySet()) {
            if (excludedConfigKeys.contains(entry.getKey())) continue;
            values.put(entry.getKey(), config.getConfigValue(entry.getKey()));
        }
        recorder.handleConfigChange(values);
    }

    @BuildStep(onlyIfNot={IsNormal.class})
    public void setupConfigOverride(BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer) {
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClassBuildItemBuildProducer, true);
        try (ClassCreator clazz = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(RuntimeOverrideConfigSource.GENERATED_CLASS_NAME).build();){
            clazz.getFieldCreator("CONFIG", Map.class).setModifiers(73);
        }
    }

    @BuildStep
    public void watchConfigFiles(BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFiles) {
        ArrayList<String> configWatchedFiles = new ArrayList<String>();
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        String userDir = System.getProperty("user.dir");
        configWatchedFiles.add("application.properties");
        configWatchedFiles.add("META-INF/microprofile-config.properties");
        configWatchedFiles.add(Paths.get(userDir, ".env").toAbsolutePath().toString());
        configWatchedFiles.add(Paths.get(userDir, "config", "application.properties").toAbsolutePath().toString());
        for (String profile : config.getProfiles()) {
            configWatchedFiles.add(String.format("application-%s.properties", profile));
            configWatchedFiles.add(String.format("META-INF/microprofile-config-%s.properties", profile));
            configWatchedFiles.add(Paths.get(userDir, String.format(".env-%s", profile)).toAbsolutePath().toString());
            configWatchedFiles.add(Paths.get(userDir, "config", String.format("application-%s.properties", profile)).toAbsolutePath().toString());
        }
        Optional optionalLocations = config.getOptionalValues("smallrye.config.locations", URI.class);
        optionalLocations.ifPresent(locations -> {
            for (URI location : locations) {
                Path path = location.getScheme() != null ? Paths.get(location) : Paths.get(location.getPath(), new String[0]);
                if (Files.isDirectory(path, new LinkOption[0])) continue;
                configWatchedFiles.add(path.toString());
                for (String profile : config.getProfiles()) {
                    configWatchedFiles.add(this.appendProfileToFilename(path, profile));
                }
            }
        });
        for (String configWatchedFile : configWatchedFiles) {
            watchedFiles.produce(new HotDeploymentWatchedFileBuildItem(configWatchedFile));
        }
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void warnDifferentProfileUsedBetweenBuildAndRunTime(ConfigRecorder configRecorder) {
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        configRecorder.handleNativeProfileChange(config.getProfiles());
    }

    private String appendProfileToFilename(Path path, String activeProfile) {
        String pathWithoutExtension = ConfigGenerationBuildStep.getPathWithoutExtension(path);
        return String.format("%s-%s.%s", pathWithoutExtension, activeProfile, ConfigGenerationBuildStep.getFileExtension(path));
    }

    private static String getFileExtension(Path path) {
        Objects.requireNonNull(path, "path should not be null");
        String fileName = path.getFileName().toString();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? "" : fileName.substring(dotIndex + 1);
    }

    private static String getPathWithoutExtension(Path path) {
        Objects.requireNonNull(path, "path should not be null");
        String fileName = path.toString();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
    }

    private static void generateDefaultsConfigSource(BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, Map<String, String> defaults, String className, String sourceName, int sourceOrdinal) {
        try (ClassCreator classCreator = ClassCreator.builder().classOutput((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClass, true)).className(className).superClass(DefaultsConfigSource.class).setFinal(true).build();){
            FieldDescriptor properties = FieldDescriptor.of((String)classCreator.getClassName(), (String)"properties", Map.class);
            classCreator.getFieldCreator(properties).setModifiers(24);
            MethodCreator clinit = classCreator.getMethodCreator("<clinit>", Void.TYPE, new Class[0]);
            clinit.setModifiers(8);
            clinit.writeStaticField(properties, clinit.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]));
            ResultHandle map = clinit.readStaticField(properties);
            MethodDescriptor put = MethodDescriptor.ofMethod(Map.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class});
            for (Map.Entry<String, String> entry : defaults.entrySet()) {
                clinit.invokeInterfaceMethod(put, map, new ResultHandle[]{clinit.load(entry.getKey()), clinit.load(entry.getValue())});
            }
            clinit.returnVoid();
            MethodCreator ctor = classCreator.getMethodCreator("<init>", Void.TYPE, new Class[0]);
            MethodDescriptor superCtor = MethodDescriptor.ofConstructor(DefaultsConfigSource.class, (Class[])new Class[]{Map.class, String.class, Integer.TYPE});
            ctor.invokeSpecialMethod(superCtor, ctor.getThis(), new ResultHandle[]{ctor.readStaticField(properties), ctor.load(sourceName), ctor.load(sourceOrdinal)});
            ctor.returnVoid();
        }
        reflectiveClass.produce(ReflectiveClassBuildItem.builder(className).build());
    }

    private static void generateMappingsConfigBuilder(BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, String className, Set<ConfigMappings.ConfigClassWithPrefix> mappings) {
        try (ClassCreator classCreator = ClassCreator.builder().classOutput((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClass, true)).className(className).interfaces(new Class[]{ConfigBuilder.class}).setFinal(true).build();){
            MethodCreator method = classCreator.getMethodCreator(CONFIG_BUILDER);
            ResultHandle configBuilder = method.getMethodParam(0);
            for (ConfigMappings.ConfigClassWithPrefix mapping : mappings) {
                method.invokeVirtualMethod(WITH_MAPPING, configBuilder, new ResultHandle[]{method.loadClass(mapping.getKlass()), method.load(mapping.getPrefix())});
            }
            method.returnValue(configBuilder);
        }
        reflectiveClass.produce(ReflectiveClassBuildItem.builder(className).build());
    }

    private static Set<String> discoverService(Class<?> serviceClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        HashSet<String> services = new HashSet<String>();
        for (String service : ServiceUtil.classNamesNamedIn(classLoader, "META-INF/services/" + serviceClass.getName())) {
            services.add(service);
            reflectiveClass.produce(ReflectiveClassBuildItem.builder(service).build());
        }
        return services;
    }

    private static Set<String> staticSafeServices(Set<String> services) {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        HashSet<String> staticSafe = new HashSet<String>();
        for (String service : services) {
            try {
                Class<?> serviceClass = classloader.loadClass(service);
                if (!serviceClass.isAnnotationPresent(StaticInitSafe.class)) continue;
                staticSafe.add(service);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return staticSafe;
    }

    private static Set<ConfigMappings.ConfigClassWithPrefix> staticSafeConfigMappings(List<ConfigMappingBuildItem> configMappings) {
        return configMappings.stream().filter(ConfigMappingBuildItem::isStaticInitSafe).map(configMapping -> ConfigMappings.ConfigClassWithPrefix.configClassWithPrefix(configMapping.getConfigClass(), (String)configMapping.getPrefix())).collect(Collectors.toSet());
    }

    private static Set<ConfigMappings.ConfigClassWithPrefix> runtimeConfigMappings(List<ConfigMappingBuildItem> configMappings) {
        return configMappings.stream().map(configMapping -> ConfigMappings.ConfigClassWithPrefix.configClassWithPrefix(configMapping.getConfigClass(), (String)configMapping.getPrefix())).collect(Collectors.toSet());
    }
}

