/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg;

import io.quarkus.deployment.pkg.ManifestConfig;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.List;
import java.util.Optional;
import java.util.Set;

@ConfigRoot
public class PackageConfig {
    @Deprecated
    public static final String JAR = BuiltInType.JAR.name;
    @Deprecated
    public static final String UBER_JAR = BuiltInType.UBER_JAR.name;
    @Deprecated
    public static final String FAST_JAR = BuiltInType.FAST_JAR.name;
    @Deprecated
    public static final String MUTABLE_JAR = BuiltInType.MUTABLE_JAR.name;
    @Deprecated
    public static final String LEGACY = BuiltInType.LEGACY.name;
    @Deprecated
    public static final String LEGACY_JAR = BuiltInType.LEGACY_JAR.name;
    @Deprecated
    public static final String NATIVE = BuiltInType.NATIVE.name;
    @Deprecated
    public static final String NATIVE_SOURCES = BuiltInType.NATIVE_SOURCES.name;
    @ConfigItem(defaultValue="jar")
    public String type;
    @ConfigItem
    public ManifestConfig manifest;
    @ConfigItem
    public Optional<String> mainClass;
    @ConfigItem
    public Optional<List<String>> userConfiguredIgnoredEntries;
    @ConfigItem
    public Optional<Set<String>> includedOptionalDependencies;
    @ConfigItem(defaultValue="false")
    public boolean filterOptionalDependencies;
    @ConfigItem(defaultValue="-runner")
    public String runnerSuffix;
    @ConfigItem(defaultValue="true")
    public boolean addRunnerSuffix;
    @ConfigItem
    public Optional<String> outputDirectory;
    @ConfigItem
    public Optional<String> outputName;
    @ConfigItem
    public boolean createAppcds;
    @ConfigItem
    public Optional<String> appcdsBuilderImage;
    @ConfigItem(defaultValue="true")
    public boolean appcdsUseContainer;
    @ConfigItem
    public Optional<String> userProvidersDirectory;
    @ConfigItem(defaultValue="true")
    public boolean includeDependencyList;
    @ConfigItem
    public QuiltFlowerConfig quiltflower;
    @ConfigItem
    public boolean writeTransformedBytecodeToBuildOutput;

    public boolean isAnyJarType() {
        return this.type.equalsIgnoreCase(JAR) || this.type.equalsIgnoreCase(FAST_JAR) || this.type.equalsIgnoreCase(UBER_JAR) || this.type.equalsIgnoreCase(LEGACY_JAR) || this.type.equalsIgnoreCase(LEGACY) || this.type.equalsIgnoreCase(MUTABLE_JAR);
    }

    public boolean isFastJar() {
        return this.type.equalsIgnoreCase(JAR) || this.type.equalsIgnoreCase(FAST_JAR) || this.type.equalsIgnoreCase(MUTABLE_JAR);
    }

    public boolean isLegacyJar() {
        return this.type.equalsIgnoreCase(LEGACY_JAR) || this.type.equalsIgnoreCase(LEGACY);
    }

    public boolean isUberJar() {
        return this.type.equalsIgnoreCase(UBER_JAR);
    }

    public String getRunnerSuffix() {
        return this.addRunnerSuffix ? this.runnerSuffix : "";
    }

    @ConfigGroup
    public static class QuiltFlowerConfig {
        @ConfigItem(defaultValue="false")
        public boolean enabled;
        @ConfigItem(defaultValue="1.8.1")
        public String version;
        @ConfigItem(defaultValue="${user.home}/.quarkus")
        public String jarDirectory;
    }

    public static enum BuiltInType {
        JAR("jar"),
        UBER_JAR("uber-jar"),
        FAST_JAR("fast-jar"),
        MUTABLE_JAR("mutable-jar"),
        LEGACY("legacy"),
        LEGACY_JAR("legacy-jar"),
        NATIVE("native"),
        NATIVE_SOURCES("native-sources");

        private final String name;

        private BuiltInType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static BuiltInType fromString(String name) {
            for (BuiltInType type : BuiltInType.values()) {
                if (!type.toString().equals(name)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown Quarkus package type '" + name + "'");
        }
    }
}

