/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.deployment.pkg.NativeConfig;
import io.quarkus.deployment.pkg.steps.NativeImageBuildContainerRunner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.logging.Logger;

public class NativeImageBuildRemoteContainerRunner
extends NativeImageBuildContainerRunner {
    private static final Logger log = Logger.getLogger(NativeImageBuildRemoteContainerRunner.class);
    private static final String CONTAINER_BUILD_VOLUME_NAME = "quarkus-native-builder-image-project-volume";
    private String containerId;

    protected NativeImageBuildRemoteContainerRunner(NativeConfig nativeConfig) {
        super(nativeConfig);
    }

    @Override
    protected void preBuild(Path outputDir, List<String> buildArgs) throws InterruptedException, IOException {
        this.rmVolume(null);
        List<String> containerRuntimeArgs = Arrays.asList("-v", "quarkus-native-builder-image-project-volume:/project");
        String[] createTempContainerCommand = this.buildCommand("create", containerRuntimeArgs, Collections.emptyList());
        this.containerId = this.runCommandAndReadOutput(createTempContainerCommand, "Failed to create temp container.");
        String[] copyCommand = new String[]{this.containerRuntime.getExecutableName(), "cp", outputDir.toAbsolutePath() + "/.", this.containerId + ":/project"};
        NativeImageBuildRemoteContainerRunner.runCommand(copyCommand, "Failed to copy source-jar and libs from host to builder container", null);
        super.preBuild(outputDir, buildArgs);
    }

    private String runCommandAndReadOutput(String[] command, String errorMsg) throws IOException, InterruptedException {
        log.info((Object)String.join((CharSequence)" ", command).replace("$", "\\$"));
        Process process = new ProcessBuilder(command).start();
        if (process.waitFor() != 0) {
            throw new RuntimeException(errorMsg);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String string = reader.readLine();
            return string;
        }
    }

    @Override
    protected void postBuild(Path outputDir, String nativeImageName, String resultingExecutableName) {
        this.copyFromContainerVolume(outputDir, resultingExecutableName, "Failed to copy native image from container volume back to the host.");
        if (this.nativeConfig.debug.enabled) {
            this.copyFromContainerVolume(outputDir, "sources", "Failed to copy sources from container volume back to the host.");
            String symbols = String.format("%s.debug", nativeImageName);
            this.copyFromContainerVolume(outputDir, symbols, "Failed to copy debug symbols from container volume back to the host.");
        }
        String[] rmTempContainerCommand = new String[]{this.containerRuntime.getExecutableName(), "container", "rm", this.containerId};
        NativeImageBuildRemoteContainerRunner.runCommand(rmTempContainerCommand, "Failed to remove container: " + this.containerId, null);
        this.rmVolume("Failed to remove volume: quarkus-native-builder-image-project-volume");
    }

    private void rmVolume(String errorMsg) {
        String[] rmVolumeCommand = new String[]{this.containerRuntime.getExecutableName(), "volume", "rm", CONTAINER_BUILD_VOLUME_NAME};
        NativeImageBuildRemoteContainerRunner.runCommand(rmVolumeCommand, errorMsg, null);
    }

    private void copyFromContainerVolume(Path outputDir, String path, String errorMsg) {
        String[] copyCommand = new String[]{this.containerRuntime.getExecutableName(), "cp", this.containerId + ":/project/" + path, outputDir.toAbsolutePath().toString()};
        NativeImageBuildRemoteContainerRunner.runCommand(copyCommand, errorMsg, null);
    }

    @Override
    protected List<String> getContainerRuntimeBuildArgs(Path outputDir) {
        List<String> containerRuntimeArgs = super.getContainerRuntimeBuildArgs(outputDir);
        Collections.addAll(containerRuntimeArgs, "-v", "quarkus-native-builder-image-project-volume:/project");
        return containerRuntimeArgs;
    }
}

