/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class GraalVM {

    static enum Distribution {
        ORACLE,
        MANDREL;

    }

    public static final class Version
    implements Comparable<Version> {
        private static final Pattern OLD_VERS_PATTERN = Pattern.compile("(GraalVM|native-image)( Version)? (?<VERSION>[1-9][0-9]*(\\.[0-9]+)+(-dev\\p{XDigit}*)?)(?<distro>.*?)?(\\(Java Version (?<jfeature>[0-9]+)(\\.(?<jinterim>[0-9]*)\\.(?<jupdate>[0-9]*))?.*)?$");
        static final Version UNVERSIONED = new Version("Undefined", "snapshot", Distribution.ORACLE);
        static final Version VERSION_21_3 = new Version("GraalVM 21.3", "21.3", Distribution.ORACLE);
        static final Version VERSION_21_3_0 = new Version("GraalVM 21.3.0", "21.3.0", Distribution.ORACLE);
        public static final Version VERSION_22_3_0 = new Version("GraalVM 22.3.0", "22.3.0", Distribution.ORACLE);
        public static final Version VERSION_22_2_0 = new Version("GraalVM 22.2.0", "22.2.0", Distribution.ORACLE);
        public static final Version VERSION_23_0_0 = new Version("GraalVM 23.0.0", "23.0.0", Distribution.ORACLE);
        public static final Version MINIMUM = VERSION_22_2_0;
        public static final Version CURRENT = VERSION_22_3_0;
        public static final int UNDEFINED = -1;
        final String fullVersion;
        final org.graalvm.home.Version version;
        public final int javaFeatureVersion;
        public final int javaUpdateVersion;
        final Distribution distribution;

        Version(String fullVersion, String version, Distribution distro) {
            this(fullVersion, version, 11, -1, distro);
        }

        Version(String fullVersion, String version, int javaFeatureVersion, int javaUpdateVersion, Distribution distro) {
            this.fullVersion = fullVersion;
            this.version = org.graalvm.home.Version.parse((String)version);
            this.javaFeatureVersion = javaFeatureVersion;
            this.javaUpdateVersion = javaUpdateVersion;
            this.distribution = distro;
        }

        String getFullVersion() {
            return this.fullVersion;
        }

        boolean isDetected() {
            return this != UNVERSIONED;
        }

        boolean isObsolete() {
            return this.compareTo(MINIMUM) < 0;
        }

        boolean isMandrel() {
            return this.distribution == Distribution.MANDREL;
        }

        boolean isNewerThan(Version version) {
            return this.compareTo(version) > 0;
        }

        boolean isOlderThan(Version version) {
            return this.compareTo(version) < 0;
        }

        public boolean jdkVersionGreaterOrEqualTo(int feature, int update) {
            return this.javaFeatureVersion > feature || this.javaFeatureVersion == feature && this.javaUpdateVersion >= update;
        }

        boolean is(Version version) {
            return this.compareTo(version) == 0;
        }

        @Override
        public int compareTo(Version o) {
            return this.version.compareTo(o.version);
        }

        static Version of(Stream<String> lines) {
            String line;
            Matcher oldVersMatcher;
            List<String> linesList = Version.toList(lines);
            if (linesList.size() == 3) {
                Version v = VersionParseHelper.parse(linesList);
                if (v != VersionParseHelper.UNKNOWN_VERSION) {
                    return v;
                }
            } else if (linesList.size() == 1 && (oldVersMatcher = OLD_VERS_PATTERN.matcher(line = linesList.get(0))).find()) {
                String version = oldVersMatcher.group("VERSION");
                String distro = oldVersMatcher.group("distro");
                String jFeatureMatch = oldVersMatcher.group("jfeature");
                int jFeature = jFeatureMatch == null ? 11 : Integer.parseInt(jFeatureMatch);
                String jUpdateMatch = oldVersMatcher.group("jupdate");
                int jUpdate = jUpdateMatch == null ? -1 : Integer.parseInt(jUpdateMatch);
                return new Version(line, version, jFeature, jUpdate, Version.isMandrel(distro) ? Distribution.MANDREL : Distribution.ORACLE);
            }
            return UNVERSIONED;
        }

        private static <T> List<T> toList(Stream<String> stream) {
            return Collections.unmodifiableList(new ArrayList<Object>(Arrays.asList(stream.toArray())));
        }

        private static boolean isMandrel(String s) {
            return s != null && s.contains("Mandrel Distribution");
        }

        public String toString() {
            return "Version{version=" + this.version + ", fullVersion=" + this.fullVersion + ", distribution=" + this.distribution + ", javaFeatureVersion=" + this.javaFeatureVersion + ", javaUpdateVersion=" + this.javaUpdateVersion + "}";
        }

        public boolean isJava17() {
            return this.javaFeatureVersion == 17;
        }
    }

    static final class VersionParseHelper {
        private static final String JVMCI_BUILD_PREFIX = "jvmci-";
        private static final String MANDREL_VERS_PREFIX = "Mandrel-";
        private static final String VNUM = "(?<VNUM>[1-9][0-9]*(?:(?:\\.0)*\\.[1-9][0-9]*)*)";
        private static final String PRE = "(?:-(?<PRE>[a-zA-Z0-9]+))?";
        private static final String BUILD = "(?:(?<PLUS>\\+)(?<BUILD>0|[1-9][0-9]*)?)?";
        private static final String OPT = "(?:-(?<OPT>[-a-zA-Z0-9.]+))?";
        private static final String VSTR_FORMAT = "(?<VNUM>[1-9][0-9]*(?:(?:\\.0)*\\.[1-9][0-9]*)*)(?:-(?<PRE>[a-zA-Z0-9]+))?(?:(?<PLUS>\\+)(?<BUILD>0|[1-9][0-9]*)?)?(?:-(?<OPT>[-a-zA-Z0-9.]+))?";
        private static final String VNUM_GROUP = "VNUM";
        private static final String VENDOR_VERSION_GROUP = "VENDOR";
        private static final String BUILD_INFO_GROUP = "BUILDINFO";
        private static final String VENDOR_VERS = "(?<VENDOR>.*)";
        private static final String JDK_DEBUG = "[^\\)]*";
        private static final String RUNTIME_NAME = "(?<RUNTIME>(?:OpenJDK|GraalVM) Runtime Environment) ";
        private static final String BUILD_INFO = "(?<BUILDINFO>.*)";
        private static final String VM_NAME = "(?<VM>(?:OpenJDK 64-Bit Server|Substrate) VM) ";
        private static final String FIRST_LINE_PATTERN = "native-image (?<VNUM>[1-9][0-9]*(?:(?:\\.0)*\\.[1-9][0-9]*)*)(?:-(?<PRE>[a-zA-Z0-9]+))?(?:(?<PLUS>\\+)(?<BUILD>0|[1-9][0-9]*)?)?(?:-(?<OPT>[-a-zA-Z0-9.]+))? .*$";
        private static final String SECOND_LINE_PATTERN = "(?<RUNTIME>(?:OpenJDK|GraalVM) Runtime Environment) (?<VENDOR>.*) \\([^\\)]*build (?<BUILDINFO>.*)\\)$";
        private static final String THIRD_LINE_PATTERN = "(?<VM>(?:OpenJDK 64-Bit Server|Substrate) VM) (?<VENDOR>.*) \\([^\\)]*build .*\\)$";
        private static final Pattern FIRST_PATTERN = Pattern.compile("native-image (?<VNUM>[1-9][0-9]*(?:(?:\\.0)*\\.[1-9][0-9]*)*)(?:-(?<PRE>[a-zA-Z0-9]+))?(?:(?<PLUS>\\+)(?<BUILD>0|[1-9][0-9]*)?)?(?:-(?<OPT>[-a-zA-Z0-9.]+))? .*$");
        private static final Pattern SECOND_PATTERN = Pattern.compile("(?<RUNTIME>(?:OpenJDK|GraalVM) Runtime Environment) (?<VENDOR>.*) \\([^\\)]*build (?<BUILDINFO>.*)\\)$");
        private static final Pattern THIRD_PATTERN = Pattern.compile("(?<VM>(?:OpenJDK 64-Bit Server|Substrate) VM) (?<VENDOR>.*) \\([^\\)]*build .*\\)$");
        private static final String VERS_FORMAT = "(?<VERSION>[1-9][0-9]*(\\.[0-9]+)+(-dev\\p{XDigit}*)?)";
        private static final String VERSION_GROUP = "VERSION";
        private static final Pattern VERSION_PATTERN = Pattern.compile("(?<VERSION>[1-9][0-9]*(\\.[0-9]+)+(-dev\\p{XDigit}*)?)");
        private static final Version UNKNOWN_VERSION = null;

        VersionParseHelper() {
        }

        static Version parse(List<String> lines) {
            Matcher firstMatcher = FIRST_PATTERN.matcher(lines.get(0));
            Matcher secondMatcher = SECOND_PATTERN.matcher(lines.get(1));
            Matcher thirdMatcher = THIRD_PATTERN.matcher(lines.get(2));
            if (firstMatcher.find() && secondMatcher.find() && thirdMatcher.find()) {
                String javaVersion = firstMatcher.group(VNUM_GROUP);
                Runtime.Version v = null;
                try {
                    v = Runtime.Version.parse(javaVersion);
                }
                catch (IllegalArgumentException e) {
                    return UNKNOWN_VERSION;
                }
                String vendorVersion = secondMatcher.group(VENDOR_VERSION_GROUP);
                String buildInfo = secondMatcher.group(BUILD_INFO_GROUP);
                String graalVersion = VersionParseHelper.graalVersion(buildInfo);
                String mandrelVersion = VersionParseHelper.mandrelVersion(vendorVersion);
                Distribution dist = VersionParseHelper.isMandrel(vendorVersion) ? Distribution.MANDREL : Distribution.ORACLE;
                String versNum = dist == Distribution.MANDREL ? mandrelVersion : graalVersion;
                return new Version(lines.stream().collect(Collectors.joining("\n")), versNum, v.feature(), v.update(), dist);
            }
            return UNKNOWN_VERSION;
        }

        private static boolean isMandrel(String vendorVersion) {
            if (vendorVersion == null) {
                return false;
            }
            return !vendorVersion.isBlank() && vendorVersion.startsWith(MANDREL_VERS_PREFIX);
        }

        private static String mandrelVersion(String vendorVersion) {
            if (vendorVersion == null) {
                return null;
            }
            int idx = vendorVersion.indexOf(MANDREL_VERS_PREFIX);
            if (idx < 0) {
                return null;
            }
            String version = vendorVersion.substring(idx + MANDREL_VERS_PREFIX.length());
            return VersionParseHelper.matchVersion(version);
        }

        private static String matchVersion(String version) {
            Matcher versMatcher = VERSION_PATTERN.matcher(version);
            if (versMatcher.find()) {
                return versMatcher.group(VERSION_GROUP);
            }
            return null;
        }

        private static String graalVersion(String buildInfo) {
            if (buildInfo == null) {
                return null;
            }
            int idx = buildInfo.indexOf(JVMCI_BUILD_PREFIX);
            if (idx < 0) {
                return null;
            }
            String version = buildInfo.substring(idx + JVMCI_BUILD_PREFIX.length());
            return VersionParseHelper.matchVersion(version);
        }
    }
}

