/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.console;

import io.quarkus.deployment.console.AeshConsole;
import io.quarkus.deployment.console.ConsoleConfig;
import io.quarkus.deployment.dev.testing.TestConfig;
import io.quarkus.dev.console.BasicConsole;
import io.quarkus.dev.console.QuarkusConsole;
import io.quarkus.runtime.console.ConsoleRuntimeConfig;
import io.quarkus.runtime.util.ColorSupport;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.aesh.readline.tty.terminal.TerminalConnection;
import org.aesh.terminal.Connection;

public class ConsoleHelper {
    public static synchronized void installConsole(final TestConfig config, final ConsoleConfig consoleConfig, ConsoleRuntimeConfig consoleRuntimeConfig, io.quarkus.runtime.logging.ConsoleConfig logConfig, boolean test) {
        boolean inputSupport;
        if (QuarkusConsole.installed) {
            return;
        }
        final boolean colorEnabled = ColorSupport.isColorEnabled((ConsoleRuntimeConfig)consoleRuntimeConfig, (io.quarkus.runtime.logging.ConsoleConfig)logConfig);
        QuarkusConsole.installed = true;
        boolean bl = inputSupport = !test && config.disableConsoleInput.orElse(consoleConfig.disableInput) == false;
        if (!inputSupport) {
            QuarkusConsole.INSTANCE = new BasicConsole(colorEnabled, false, QuarkusConsole.ORIGINAL_OUT, System.console());
            return;
        }
        try {
            new TerminalConnection((Consumer)new Consumer<Connection>(){

                @Override
                public void accept(Connection connection) {
                    if (connection.supportsAnsi() && !config.basicConsole.orElse(consoleConfig.basic).booleanValue()) {
                        QuarkusConsole.INSTANCE = new AeshConsole(connection);
                    } else {
                        final LinkedBlockingDeque queue = new LinkedBlockingDeque();
                        if (inputSupport) {
                            connection.openNonBlocking();
                        }
                        connection.setStdinHandler((Consumer)new Consumer<int[]>(){

                            @Override
                            public void accept(int[] ints) {
                                QuarkusConsole.StateChangeInputStream redirectIn = QuarkusConsole.REDIRECT_IN;
                                for (int i : ints) {
                                    if (redirectIn == null || redirectIn.acceptInput(i)) continue;
                                    queue.add(i);
                                }
                            }
                        });
                        connection.setSignalHandler(event -> {
                            switch (event) {
                                case INT: {
                                    new Thread(new Runnable(){

                                        @Override
                                        public void run() {
                                            System.exit(0);
                                        }
                                    }).start();
                                }
                            }
                        });
                        connection.setCloseHandler((Consumer)new Consumer<Void>(){

                            @Override
                            public void accept(Void unused) {
                                queue.add(-1);
                            }
                        });
                        QuarkusConsole.INSTANCE = new BasicConsole(colorEnabled, inputSupport, arg_0 -> ((Connection)connection).write(arg_0), (Supplier)new Supplier<Integer>(){

                            @Override
                            public Integer get() {
                                try {
                                    return (Integer)queue.takeFirst();
                                }
                                catch (InterruptedException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        });
                    }
                }
            });
        }
        catch (IOException e) {
            QuarkusConsole.INSTANCE = new BasicConsole(colorEnabled, false, QuarkusConsole.ORIGINAL_OUT, System.console());
        }
        QuarkusConsole.installRedirects();
    }
}

