/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.ExtensionLoader;
import io.quarkus.deployment.configuration.BuildTimeConfigurationReader;
import io.quarkus.deployment.util.ReflectUtil;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class BooleanSupplierFactoryBuildItem
extends SimpleBuildItem {
    private final BuildTimeConfigurationReader.ReadResult readResult;
    private final LaunchMode launchMode;
    private final DevModeType devModeType;
    private final ClassValue<BooleanSupplier> suppliers = new ClassValue<BooleanSupplier>(){

        @Override
        protected BooleanSupplier computeValue(Class<?> type) {
            BooleanSupplier bs;
            Consumer<BooleanSupplier> setup = o -> {};
            Constructor<?>[] ctors = type.getDeclaredConstructors();
            if (ctors.length != 1) {
                throw ExtensionLoader.reportError(type, "Conditional class must declare exactly one constructor");
            }
            Constructor<?> ctor = ctors[0];
            ctor.setAccessible(true);
            ArrayList<Supplier<Object>> paramSuppList = new ArrayList<Supplier<Object>>();
            for (Parameter parameter : ctor.getParameters()) {
                Class<?> parameterClass = parameter.getType();
                if (parameterClass == LaunchMode.class) {
                    paramSuppList.add(() -> BooleanSupplierFactoryBuildItem.this.launchMode);
                    continue;
                }
                if (parameterClass == DevModeType.class) {
                    paramSuppList.add(() -> BooleanSupplierFactoryBuildItem.this.devModeType);
                    continue;
                }
                if (parameterClass.isAnnotationPresent(ConfigRoot.class)) {
                    ConfigRoot annotation = parameterClass.getAnnotation(ConfigRoot.class);
                    ConfigPhase phase = annotation.phase();
                    if (phase.isAvailableAtBuild()) {
                        paramSuppList.add(() -> BooleanSupplierFactoryBuildItem.this.readResult.requireObjectForClass(parameterClass));
                        continue;
                    }
                    if (phase.isReadAtMain()) {
                        throw ExtensionLoader.reportError(parameter, phase + " configuration cannot be consumed here");
                    }
                    throw ExtensionLoader.reportError(parameter, "Unsupported conditional class configuration build phase " + phase);
                }
                throw ExtensionLoader.reportError(parameter, "Unsupported conditional class constructor parameter type " + parameterClass);
            }
            for (AnnotatedElement annotatedElement : type.getDeclaredFields()) {
                Class<?> fieldClass;
                int fieldMods = ((Field)annotatedElement).getModifiers();
                if (Modifier.isStatic(fieldMods) || Modifier.isFinal(fieldMods)) continue;
                if (!Modifier.isPublic(fieldMods) || !Modifier.isPublic(((Field)annotatedElement).getDeclaringClass().getModifiers())) {
                    ((Field)annotatedElement).setAccessible(true);
                }
                if ((fieldClass = ((Field)annotatedElement).getType()) == LaunchMode.class) {
                    setup = setup.andThen(arg_0 -> this.lambda$computeValue$4((Field)annotatedElement, arg_0));
                    continue;
                }
                if (fieldClass.isAnnotationPresent(ConfigRoot.class)) {
                    ConfigRoot annotation = fieldClass.getAnnotation(ConfigRoot.class);
                    ConfigPhase phase = annotation.phase();
                    if (phase.isAvailableAtBuild()) {
                        setup = setup.andThen(arg_0 -> this.lambda$computeValue$5((Field)annotatedElement, fieldClass, arg_0));
                        continue;
                    }
                    if (phase.isReadAtMain()) {
                        throw ExtensionLoader.reportError(annotatedElement, phase + " configuration cannot be consumed here");
                    }
                    throw ExtensionLoader.reportError(annotatedElement, "Unsupported conditional class configuration build phase " + phase);
                }
                throw ExtensionLoader.reportError(annotatedElement, "Unsupported conditional class field type " + fieldClass);
            }
            Object[] args = new Object[paramSuppList.size()];
            int idx = 0;
            for (Supplier supplier : paramSuppList) {
                args[idx++] = supplier.get();
            }
            try {
                bs = (BooleanSupplier)ctor.newInstance(args);
            }
            catch (InstantiationException instantiationException) {
                throw ReflectUtil.toError(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw ReflectUtil.toError(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    throw invocationTargetException.getCause();
                }
                catch (Error | RuntimeException e2) {
                    throw e2;
                }
                catch (Throwable throwable) {
                    throw new IllegalStateException(throwable);
                }
            }
            setup.accept(bs);
            return bs;
        }

        private /* synthetic */ void lambda$computeValue$5(Field field, Class fieldClass, BooleanSupplier o) {
            ReflectUtil.setFieldVal(field, o, BooleanSupplierFactoryBuildItem.this.readResult.requireObjectForClass(fieldClass));
        }

        private /* synthetic */ void lambda$computeValue$4(Field field, BooleanSupplier o) {
            ReflectUtil.setFieldVal(field, o, BooleanSupplierFactoryBuildItem.this.launchMode);
        }
    };

    BooleanSupplierFactoryBuildItem(BuildTimeConfigurationReader.ReadResult readResult, LaunchMode launchMode, DevModeType devModeType) {
        this.readResult = readResult;
        this.launchMode = launchMode;
        this.devModeType = devModeType;
    }

    public <T extends BooleanSupplier> T get(Class<T> type) {
        return (T)this.suppliers.get(type);
    }
}

