/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ConfigClassBuildItem;
import io.quarkus.deployment.builditem.ConfigMappingBuildItem;
import io.quarkus.deployment.builditem.ConfigurationBuildItem;
import io.quarkus.deployment.builditem.ConfigurationTypeBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.QuarkusBuildCloseablesBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigBuilderBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.StaticInitConfigBuilderBuildItem;
import io.quarkus.deployment.builditem.SuppressNonRuntimeConfigChangedWarningBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.deployment.configuration.BuildTimeConfigurationReader;
import io.quarkus.deployment.configuration.ConfigMappingUtils;
import io.quarkus.deployment.configuration.RunTimeConfigurationGenerator;
import io.quarkus.deployment.configuration.tracker.ConfigTrackingConfig;
import io.quarkus.deployment.configuration.tracker.ConfigTrackingInterceptor;
import io.quarkus.deployment.configuration.tracker.ConfigTrackingWriter;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.BuildSystemTargetBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.hibernate.validator.spi.AdditionalConstrainedClassBuildItem;
import io.quarkus.paths.PathCollection;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.StaticInitSafe;
import io.quarkus.runtime.configuration.AbstractConfigBuilder;
import io.quarkus.runtime.configuration.ConfigBuilder;
import io.quarkus.runtime.configuration.ConfigDiagnostic;
import io.quarkus.runtime.configuration.ConfigRecorder;
import io.quarkus.runtime.configuration.DisableableConfigSource;
import io.quarkus.runtime.configuration.QuarkusConfigValue;
import io.quarkus.runtime.configuration.RuntimeConfigBuilder;
import io.quarkus.runtime.configuration.RuntimeOverrideConfigSource;
import io.quarkus.runtime.configuration.RuntimeOverrideConfigSourceBuilder;
import io.quarkus.runtime.configuration.StaticInitConfigBuilder;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorFactory;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.DefaultValuesConfigSource;
import io.smallrye.config.ProfileConfigSourceInterceptor;
import io.smallrye.config.SecretKeysHandler;
import io.smallrye.config.SecretKeysHandlerFactory;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilderCustomizer;
import jakarta.annotation.Priority;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.eclipse.microprofile.config.spi.Converter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public class ConfigGenerationBuildStep {
    private static final MethodDescriptor CONFIG_BUILDER = MethodDescriptor.ofMethod(ConfigBuilder.class, (String)"configBuilder", SmallRyeConfigBuilder.class, (Class[])new Class[]{SmallRyeConfigBuilder.class});
    private static final MethodDescriptor WITH_SOURCES = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"withSources", SmallRyeConfigBuilder.class, (Class[])new Class[]{ConfigSource[].class});
    private static final MethodDescriptor BUILDER_CUSTOMIZER = MethodDescriptor.ofMethod(SmallRyeConfigBuilderCustomizer.class, (String)"configBuilder", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class});
    private static final MethodDescriptor WITH_DEFAULT = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withDefaultValue", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, String.class, String.class});
    private static final MethodDescriptor WITH_CONVERTER = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withConverter", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, String.class, Integer.TYPE, Converter.class});
    private static final MethodDescriptor WITH_INTERCEPTOR = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withInterceptor", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, ConfigSourceInterceptor.class});
    private static final MethodDescriptor WITH_INTERCEPTOR_FACTORY = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withInterceptorFactory", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, ConfigSourceInterceptorFactory.class});
    private static final MethodDescriptor WITH_SOURCE = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withSource", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, ConfigSource.class});
    private static final MethodDescriptor WITH_SOURCE_PROVIDER = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withSource", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, ConfigSourceProvider.class});
    private static final MethodDescriptor WITH_SOURCE_FACTORY = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withSource", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, ConfigSourceFactory.class});
    private static final MethodDescriptor WITH_SECRET_HANDLER = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withSecretKeyHandler", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, SecretKeysHandler.class});
    private static final MethodDescriptor WITH_SECRET_HANDLER_FACTORY = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withSecretKeyHandler", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, SecretKeysHandlerFactory.class});
    private static final MethodDescriptor WITH_MAPPING = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withMapping", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, String.class, String.class});
    private static final MethodDescriptor WITH_CUSTOMIZER = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withCustomizer", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, SmallRyeConfigBuilderCustomizer.class});
    private static final MethodDescriptor WITH_BUILDER = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withBuilder", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, ConfigBuilder.class});
    private static final DotName CONVERTER_NAME = DotName.createSimple((String)Converter.class.getName());
    private static final DotName PRIORITY_NAME = DotName.createSimple((String)Priority.class.getName());

    @BuildStep
    void buildTimeRunTimeConfig(ConfigurationBuildItem configItem, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<StaticInitConfigBuilderBuildItem> staticInitConfigBuilder, BuildProducer<RunTimeConfigBuilderBuildItem> runTimeConfigBuilder) {
        String builderClassName = "io.quarkus.runtime.generated.BuildTimeRunTimeFixedConfigSourceBuilder";
        try (ClassCreator classCreator = ClassCreator.builder().classOutput((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClass, true)).className(builderClassName).interfaces(new Class[]{ConfigBuilder.class}).setFinal(true).build();){
            FieldDescriptor source = FieldDescriptor.of((String)classCreator.getClassName(), (String)"source", ConfigSource.class);
            classCreator.getFieldCreator(source).setModifiers(24);
            MethodCreator clinit = classCreator.getMethodCreator("<clinit>", Void.TYPE, new Class[0]);
            clinit.setModifiers(8);
            ResultHandle map = clinit.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
            MethodDescriptor put = MethodDescriptor.ofMethod(Map.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class});
            for (Map.Entry<String, ConfigValue> entry : configItem.getReadResult().getBuildTimeRunTimeValues().entrySet()) {
                clinit.invokeInterfaceMethod(put, map, new ResultHandle[]{clinit.load(entry.getKey()), clinit.load(entry.getValue().getValue())});
            }
            ResultHandle defaultValuesSource = clinit.newInstance(MethodDescriptor.ofConstructor(DefaultValuesConfigSource.class, (Class[])new Class[]{Map.class, String.class, Integer.TYPE}), new ResultHandle[]{map, clinit.load("BuildTime RunTime Fixed"), clinit.load(Integer.MAX_VALUE)});
            ResultHandle disableableConfigSource = clinit.newInstance(MethodDescriptor.ofConstructor(DisableableConfigSource.class, (Class[])new Class[]{ConfigSource.class}), new ResultHandle[]{defaultValuesSource});
            clinit.writeStaticField(source, disableableConfigSource);
            clinit.returnVoid();
            MethodCreator method = classCreator.getMethodCreator(CONFIG_BUILDER);
            ResultHandle configBuilder = method.getMethodParam(0);
            ResultHandle configSources = method.newArray(ConfigSource.class, 1);
            method.writeArrayValue(configSources, 0, method.readStaticField(source));
            method.invokeVirtualMethod(WITH_SOURCES, configBuilder, new ResultHandle[]{configSources});
            method.returnValue(configBuilder);
        }
        reflectiveClass.produce(ReflectiveClassBuildItem.builder(builderClassName).reason(this.getClass().getName()).build());
        staticInitConfigBuilder.produce(new StaticInitConfigBuilderBuildItem(builderClassName));
        runTimeConfigBuilder.produce(new RunTimeConfigBuilderBuildItem(builderClassName));
    }

    @BuildStep(onlyIfNot={IsNormal.class})
    void runtimeOverrideConfig(BuildProducer<StaticInitConfigBuilderBuildItem> staticInitConfigBuilder, BuildProducer<RunTimeConfigBuilderBuildItem> runTimeConfigBuilder) {
        staticInitConfigBuilder.produce(new StaticInitConfigBuilderBuildItem(RuntimeOverrideConfigSourceBuilder.class.getName()));
        runTimeConfigBuilder.produce(new RunTimeConfigBuilderBuildItem(RuntimeOverrideConfigSourceBuilder.class.getName()));
    }

    @BuildStep
    void generateMappings(ConfigurationBuildItem configItem, CombinedIndexBuildItem combinedIndex, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods, BuildProducer<ConfigClassBuildItem> configClasses, BuildProducer<AdditionalConstrainedClassBuildItem> additionalConstrainedClasses) {
        ConfigMappingUtils.processConfigMapping(combinedIndex, generatedClasses, reflectiveClasses, reflectiveMethods, configClasses, additionalConstrainedClasses);
        List<ConfigMappings.ConfigClass> buildTimeRunTimeMappings = configItem.getReadResult().getBuildTimeRunTimeMappings();
        for (ConfigMappings.ConfigClass buildTimeRunTimeMapping : buildTimeRunTimeMappings) {
            ConfigMappingUtils.processExtensionConfigMapping(buildTimeRunTimeMapping, combinedIndex, generatedClasses, reflectiveClasses, reflectiveMethods, configClasses, additionalConstrainedClasses);
        }
        List<ConfigMappings.ConfigClass> runTimeMappings = configItem.getReadResult().getRunTimeMappings();
        for (ConfigMappings.ConfigClass runTimeMapping : runTimeMappings) {
            ConfigMappingUtils.processExtensionConfigMapping(runTimeMapping, combinedIndex, generatedClasses, reflectiveClasses, reflectiveMethods, configClasses, additionalConstrainedClasses);
        }
    }

    @BuildStep
    void generateBuilders(ConfigurationBuildItem configItem, CombinedIndexBuildItem combinedIndex, List<ConfigMappingBuildItem> configMappings, List<RunTimeConfigurationDefaultBuildItem> runTimeDefaults, List<StaticInitConfigBuilderBuildItem> staticInitConfigBuilders, List<RunTimeConfigBuilderBuildItem> runTimeConfigBuilders, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) throws Exception {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        for (Map.Entry<String, ConfigValue> entry : configItem.getReadResult().getRunTimeDefaultValues().entrySet()) {
            defaultValues.put(entry.getKey(), entry.getValue().getRawValue());
        }
        for (RunTimeConfigurationDefaultBuildItem e : runTimeDefaults) {
            defaultValues.put(e.getKey(), e.getValue());
        }
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        List profiles = config.getProfiles();
        for (Map.Entry<String, ConfigValue> entry : configItem.getReadResult().getRunTimeValues().entrySet()) {
            if ("DefaultValuesConfigSource".equals(entry.getValue().getConfigSourceName())) continue;
            String activeName = ProfileConfigSourceInterceptor.activeName((String)entry.getKey(), (List)profiles);
            if (!configItem.getReadResult().getRunTimeDefaultValues().containsKey(activeName)) {
                defaultValues.remove(activeName);
            }
            defaultValues.put(entry.getKey(), entry.getValue().getRawValue());
        }
        Set<String> converters = ConfigGenerationBuildStep.discoverService(Converter.class, reflectiveClass);
        Set<String> interceptors = ConfigGenerationBuildStep.discoverService(ConfigSourceInterceptor.class, reflectiveClass);
        Set<String> interceptorFactories = ConfigGenerationBuildStep.discoverService(ConfigSourceInterceptorFactory.class, reflectiveClass);
        Set<String> configSources = ConfigGenerationBuildStep.discoverService(ConfigSource.class, reflectiveClass);
        Set<String> configSourceProviders = ConfigGenerationBuildStep.discoverService(ConfigSourceProvider.class, reflectiveClass);
        Set<String> configSourceFactories = ConfigGenerationBuildStep.discoverService(ConfigSourceFactory.class, reflectiveClass);
        Set<String> secretKeyHandlers = ConfigGenerationBuildStep.discoverService(SecretKeysHandler.class, reflectiveClass);
        Set<String> secretKeyHandlerFactories = ConfigGenerationBuildStep.discoverService(SecretKeysHandlerFactory.class, reflectiveClass);
        Set<String> configCustomizers = ConfigGenerationBuildStep.discoverService(SmallRyeConfigBuilderCustomizer.class, reflectiveClass);
        HashSet<ConfigMappings.ConfigClass> staticMappings = new HashSet<ConfigMappings.ConfigClass>();
        staticMappings.addAll(ConfigGenerationBuildStep.staticSafeConfigMappings(configMappings));
        staticMappings.addAll(configItem.getReadResult().getBuildTimeRunTimeMappings());
        HashSet<String> staticCustomizers = new HashSet<String>(ConfigGenerationBuildStep.staticSafeServices(configCustomizers));
        staticCustomizers.add(StaticInitConfigBuilder.class.getName());
        ConfigGenerationBuildStep.generateConfigBuilder(generatedClass, reflectiveClass, "io.quarkus.runtime.generated.StaticInitConfig", combinedIndex, defaultValues, converters, interceptors, ConfigGenerationBuildStep.staticSafeServices(interceptorFactories), ConfigGenerationBuildStep.staticSafeServices(configSources), ConfigGenerationBuildStep.staticSafeServices(configSourceProviders), ConfigGenerationBuildStep.staticSafeServices(configSourceFactories), secretKeyHandlers, ConfigGenerationBuildStep.staticSafeServices(secretKeyHandlerFactories), staticMappings, staticCustomizers, staticInitConfigBuilders.stream().map(StaticInitConfigBuilderBuildItem::getBuilderClassName).collect(Collectors.toSet()));
        reflectiveClass.produce(ReflectiveClassBuildItem.builder("io.quarkus.runtime.generated.StaticInitConfig").build());
        HashSet<ConfigMappings.ConfigClass> runTimeMappings = new HashSet<ConfigMappings.ConfigClass>();
        runTimeMappings.addAll(ConfigGenerationBuildStep.runtimeConfigMappings(configMappings));
        runTimeMappings.addAll(configItem.getReadResult().getBuildTimeRunTimeMappings());
        runTimeMappings.addAll(configItem.getReadResult().getRunTimeMappings());
        HashSet<String> runtimeCustomizers = new HashSet<String>(configCustomizers);
        runtimeCustomizers.add(RuntimeConfigBuilder.class.getName());
        ConfigGenerationBuildStep.generateConfigBuilder(generatedClass, reflectiveClass, "io.quarkus.runtime.generated.RunTimeConfig", combinedIndex, defaultValues, converters, interceptors, interceptorFactories, configSources, configSourceProviders, configSourceFactories, secretKeyHandlers, secretKeyHandlerFactories, runTimeMappings, runtimeCustomizers, runTimeConfigBuilders.stream().map(RunTimeConfigBuilderBuildItem::getBuilderClassName).collect(Collectors.toSet()));
        reflectiveClass.produce(ReflectiveClassBuildItem.builder("io.quarkus.runtime.generated.RunTimeConfig").build());
    }

    @BuildStep
    void generateConfigClass(ConfigurationBuildItem configItem, List<ConfigurationTypeBuildItem> typeItems, LaunchModeBuildItem launchModeBuildItem, BuildProducer<GeneratedClassBuildItem> generatedClass, LiveReloadBuildItem liveReloadBuildItem) {
        if (!launchModeBuildItem.getLaunchMode().isDevOrTest()) {
            ConfigDiagnostic.unknownProperties(configItem.getReadResult().getUnknownBuildProperties());
        }
        if (liveReloadBuildItem.isLiveReload()) {
            return;
        }
        RunTimeConfigurationGenerator.GenerateOperation.builder().setBuildTimeReadResult(configItem.getReadResult()).setClassOutput(new GeneratedClassGizmoAdaptor(generatedClass, false)).setLaunchMode(launchModeBuildItem.getLaunchMode()).setLiveReloadPossible(launchModeBuildItem.getLaunchMode() == LaunchMode.DEVELOPMENT || launchModeBuildItem.isAuxiliaryApplication()).setAdditionalTypes(typeItems.stream().map(ConfigurationTypeBuildItem::getValueType).collect(Collectors.toList())).build().run();
    }

    @BuildStep
    public void suppressNonRuntimeConfigChanged(BuildProducer<SuppressNonRuntimeConfigChangedWarningBuildItem> suppressNonRuntimeConfigChanged) {
        suppressNonRuntimeConfigChanged.produce(new SuppressNonRuntimeConfigChangedWarningBuildItem("quarkus.profile"));
        suppressNonRuntimeConfigChanged.produce(new SuppressNonRuntimeConfigChangedWarningBuildItem("quarkus.default-locale"));
        suppressNonRuntimeConfigChanged.produce(new SuppressNonRuntimeConfigChangedWarningBuildItem("quarkus.locales"));
        suppressNonRuntimeConfigChanged.produce(new SuppressNonRuntimeConfigChangedWarningBuildItem("quarkus.test.arg-line"));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void releaseConfigOnShutdown(ShutdownContextBuildItem shutdownContext, ConfigRecorder recorder) {
        recorder.releaseConfig((ShutdownContext)shutdownContext);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void checkForBuildTimeConfigChange(RecorderContext recorderContext, ConfigRecorder recorder, ConfigurationBuildItem configItem, List<SuppressNonRuntimeConfigChangedWarningBuildItem> suppressNonRuntimeConfigChangedWarningItems) {
        recorderContext.registerSubstitution(ConfigValue.class, QuarkusConfigValue.class, QuarkusConfigValue.Substitution.class);
        HashSet<String> excludedConfigKeys = new HashSet<String>(suppressNonRuntimeConfigChangedWarningItems.size());
        for (SuppressNonRuntimeConfigChangedWarningBuildItem item : suppressNonRuntimeConfigChangedWarningItems) {
            excludedConfigKeys.add(item.getConfigKey());
        }
        HashMap<String, ConfigValue> values = new HashMap<String, ConfigValue>();
        BuildTimeConfigurationReader.ReadResult readResult = configItem.getReadResult();
        for (Map.Entry<String, ConfigValue> entry : readResult.getAllBuildTimeValues().entrySet()) {
            if (excludedConfigKeys.contains(entry.getKey())) continue;
            values.putIfAbsent(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, ConfigValue> entry : readResult.getBuildTimeRunTimeValues().entrySet()) {
            if (excludedConfigKeys.contains(entry.getKey())) continue;
            values.put(entry.getKey(), entry.getValue());
        }
        recorder.handleConfigChange(values);
    }

    @BuildStep(onlyIfNot={IsNormal.class})
    public void setupConfigOverride(BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer) {
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClassBuildItemBuildProducer, true);
        try (ClassCreator clazz = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(RuntimeOverrideConfigSource.GENERATED_CLASS_NAME).build();){
            clazz.getFieldCreator("CONFIG", Map.class).setModifiers(73);
        }
    }

    @BuildStep
    public void watchConfigFiles(BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFiles) {
        ArrayList<String> configWatchedFiles = new ArrayList<String>();
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        String userDir = System.getProperty("user.dir");
        configWatchedFiles.add("application.properties");
        configWatchedFiles.add("META-INF/microprofile-config.properties");
        configWatchedFiles.add(Paths.get(userDir, ".env").toAbsolutePath().toString());
        configWatchedFiles.add(Paths.get(userDir, "config", "application.properties").toAbsolutePath().toString());
        for (String profile : config.getProfiles()) {
            configWatchedFiles.add(String.format("application-%s.properties", profile));
            configWatchedFiles.add(String.format("META-INF/microprofile-config-%s.properties", profile));
            configWatchedFiles.add(Paths.get(userDir, String.format(".env-%s", profile)).toAbsolutePath().toString());
            configWatchedFiles.add(Paths.get(userDir, "config", String.format("application-%s.properties", profile)).toAbsolutePath().toString());
        }
        Optional optionalLocations = config.getOptionalValues("smallrye.config.locations", URI.class);
        optionalLocations.ifPresent(locations -> {
            for (URI location : locations) {
                Path path;
                Path path2 = path = location.getScheme() != null && location.getScheme().equals("file") ? Paths.get(location) : Paths.get(location.getPath(), new String[0]);
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    configWatchedFiles.add(path.toAbsolutePath().toString());
                    for (String profile : config.getProfiles()) {
                        configWatchedFiles.add(this.appendProfileToFilename(path.toAbsolutePath(), profile));
                    }
                    continue;
                }
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                try {
                    DirectoryStream<Path> files = Files.newDirectoryStream(path, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
                    try {
                        for (Path file : files) {
                            configWatchedFiles.add(file.toAbsolutePath().toString());
                        }
                    }
                    finally {
                        if (files == null) continue;
                        files.close();
                    }
                }
                catch (IOException iOException) {
                }
            }
        });
        for (String configWatchedFile : configWatchedFiles) {
            watchedFiles.produce(new HotDeploymentWatchedFileBuildItem(configWatchedFile));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void unknownConfigFiles(ApplicationArchivesBuildItem applicationArchives, LaunchModeBuildItem launchModeBuildItem, ConfigRecorder configRecorder) throws Exception {
        PathCollection rootDirectories = applicationArchives.getRootArchive().getRootDirectories();
        if (!rootDirectories.isSinglePath()) {
            return;
        }
        HashSet buildTimeFiles = new HashSet();
        buildTimeFiles.addAll(ConfigDiagnostic.configFiles((Path)rootDirectories.getSinglePath()));
        buildTimeFiles.addAll(ConfigDiagnostic.configFilesFromLocations());
        ConfigDiagnostic.unknownConfigFiles(buildTimeFiles);
        if (!launchModeBuildItem.getLaunchMode().isDevOrTest()) {
            configRecorder.unknownConfigFiles();
        }
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void warnDifferentProfileUsedBetweenBuildAndRunTime(ConfigRecorder configRecorder) {
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        configRecorder.handleNativeProfileChange(config.getProfiles());
    }

    @BuildStep(onlyIf={IsNormal.class})
    void persistReadConfigOptions(BuildProducer<ArtifactResultBuildItem> dummy, QuarkusBuildCloseablesBuildItem closeables, final LaunchModeBuildItem launchModeBuildItem, final BuildSystemTargetBuildItem buildSystemTargetBuildItem, final ConfigurationBuildItem configBuildItem, final ConfigTrackingConfig configTrackingConfig) {
        final ConfigTrackingInterceptor.ReadOptionsProvider readOptionsProvider = configBuildItem.getReadResult().getReadOptionsProvider();
        if (readOptionsProvider != null) {
            closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    ConfigTrackingWriter.write(readOptionsProvider.getReadOptions(), configTrackingConfig, configBuildItem.getReadResult(), launchModeBuildItem.getLaunchMode(), buildSystemTargetBuildItem.getOutputDirectory());
                }
            });
        }
    }

    private String appendProfileToFilename(Path path, String activeProfile) {
        String pathWithoutExtension = ConfigGenerationBuildStep.getPathWithoutExtension(path);
        return String.format("%s-%s.%s", pathWithoutExtension, activeProfile, ConfigGenerationBuildStep.getFileExtension(path));
    }

    private static String getFileExtension(Path path) {
        Objects.requireNonNull(path, "path should not be null");
        String fileName = path.getFileName().toString();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? "" : fileName.substring(dotIndex + 1);
    }

    private static String getPathWithoutExtension(Path path) {
        Objects.requireNonNull(path, "path should not be null");
        String fileName = path.toString();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
    }

    private static void generateConfigBuilder(BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, String className, CombinedIndexBuildItem combinedIndex, Map<String, String> defaultValues, Set<String> converters, Set<String> interceptors, Set<String> interceptorFactories, Set<String> configSources, Set<String> configSourceProviders, Set<String> configSourceFactories, Set<String> secretKeyHandlers, Set<String> secretKeyHandlerFactories, Set<ConfigMappings.ConfigClass> mappings, Set<String> configCustomizers, Set<String> configBuilders) {
        ResultHandle configBuilder;
        MethodCreator method;
        try (ClassCreator classCreator = ClassCreator.builder().classOutput((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClass, true)).className(className + "Customizer").superClass(AbstractConfigBuilder.class).interfaces(new Class[]{SmallRyeConfigBuilderCustomizer.class}).setFinal(true).build();){
            method = classCreator.getMethodCreator(BUILDER_CUSTOMIZER);
            configBuilder = method.getMethodParam(0);
            for (Map.Entry<String, String> entry : defaultValues.entrySet()) {
                method.invokeStaticMethod(WITH_DEFAULT, new ResultHandle[]{configBuilder, method.load(entry.getKey()), method.load(entry.getValue())});
            }
            for (String converter : converters) {
                ClassInfo converterClass = combinedIndex.getComputingIndex().getClassByName(converter);
                Type type = ConfigGenerationBuildStep.getConverterType(converterClass, combinedIndex);
                AnnotationInstance priorityAnnotation = converterClass.annotation(PRIORITY_NAME);
                int priority = priorityAnnotation != null ? priorityAnnotation.value().asInt() : 100;
                method.invokeStaticMethod(WITH_CONVERTER, new ResultHandle[]{configBuilder, method.load(type.name().toString()), method.load(priority), method.newInstance(MethodDescriptor.ofConstructor((String)converter, (String[])new String[0]), new ResultHandle[0])});
            }
            for (String interceptor : interceptors) {
                method.invokeStaticMethod(WITH_INTERCEPTOR, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)interceptor, (String[])new String[0]), new ResultHandle[0])});
            }
            for (String interceptorFactory : interceptorFactories) {
                method.invokeStaticMethod(WITH_INTERCEPTOR_FACTORY, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)interceptorFactory, (String[])new String[0]), new ResultHandle[0])});
            }
            for (String configSource : configSources) {
                method.invokeStaticMethod(WITH_SOURCE, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)configSource, (String[])new String[0]), new ResultHandle[0])});
            }
            for (String configSourceProvider : configSourceProviders) {
                method.invokeStaticMethod(WITH_SOURCE_PROVIDER, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)configSourceProvider, (String[])new String[0]), new ResultHandle[0])});
            }
            for (String configSourceFactory : configSourceFactories) {
                method.invokeStaticMethod(WITH_SOURCE_FACTORY, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)configSourceFactory, (String[])new String[0]), new ResultHandle[0])});
            }
            for (String secretKeyHandler : secretKeyHandlers) {
                method.invokeStaticMethod(WITH_SECRET_HANDLER, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)secretKeyHandler, (String[])new String[0]), new ResultHandle[0])});
            }
            for (String secretKeyHandlerFactory : secretKeyHandlerFactories) {
                method.invokeStaticMethod(WITH_SECRET_HANDLER_FACTORY, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)secretKeyHandlerFactory, (String[])new String[0]), new ResultHandle[0])});
            }
            for (ConfigMappings.ConfigClass mapping : mappings) {
                method.invokeStaticMethod(WITH_MAPPING, new ResultHandle[]{configBuilder, method.load(mapping.getKlass().getName()), method.load(mapping.getPrefix())});
            }
            method.returnVoid();
        }
        configCustomizers.add(className + "Customizer");
        classCreator = ClassCreator.builder().classOutput((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClass, true)).className(className).superClass(AbstractConfigBuilder.class).interfaces(new Class[]{SmallRyeConfigBuilderCustomizer.class}).setFinal(true).build();
        try {
            method = classCreator.getMethodCreator(BUILDER_CUSTOMIZER);
            configBuilder = method.getMethodParam(0);
            for (String configCustomizer : configCustomizers) {
                method.invokeStaticMethod(WITH_CUSTOMIZER, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)configCustomizer, (String[])new String[0]), new ResultHandle[0])});
            }
            for (String builder : configBuilders) {
                method.invokeStaticMethod(WITH_BUILDER, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)builder, (String[])new String[0]), new ResultHandle[0])});
            }
            method.returnVoid();
        }
        finally {
            if (classCreator != null) {
                classCreator.close();
            }
        }
        reflectiveClass.produce(ReflectiveClassBuildItem.builder(className).build());
    }

    private static Set<String> discoverService(Class<?> serviceClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        HashSet<String> services = new HashSet<String>();
        for (String service : ServiceUtil.classNamesNamedIn(classLoader, "META-INF/services/" + serviceClass.getName())) {
            if (!QuarkusClassLoader.isClassPresentAtRuntime((String)service)) continue;
            services.add(service);
            reflectiveClass.produce(ReflectiveClassBuildItem.builder(service).build());
        }
        return services;
    }

    private static Set<String> staticSafeServices(Set<String> services) {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        HashSet<String> staticSafe = new HashSet<String>();
        for (String service : services) {
            if (service.startsWith("io.smallrye.config.")) {
                staticSafe.add(service);
                continue;
            }
            try {
                Class<?> serviceClass = classloader.loadClass(service);
                if (!serviceClass.isAnnotationPresent(StaticInitSafe.class)) continue;
                staticSafe.add(service);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return staticSafe;
    }

    private static Set<ConfigMappings.ConfigClass> staticSafeConfigMappings(List<ConfigMappingBuildItem> configMappings) {
        return configMappings.stream().filter(ConfigMappingBuildItem::isStaticInitSafe).map(ConfigMappingBuildItem::toConfigClass).collect(Collectors.toSet());
    }

    private static Set<ConfigMappings.ConfigClass> runtimeConfigMappings(List<ConfigMappingBuildItem> configMappings) {
        return configMappings.stream().map(ConfigMappingBuildItem::toConfigClass).collect(Collectors.toSet());
    }

    private static Type getConverterType(ClassInfo converter, CombinedIndexBuildItem combinedIndex) {
        if (converter.name().toString().equals(Object.class.getName())) {
            throw new IllegalArgumentException("Can not add converter " + converter.name() + " that is not parameterized with a type");
        }
        for (Type type : converter.interfaceTypes()) {
            ParameterizedType parameterizedType;
            if (!(type instanceof ParameterizedType) || !(parameterizedType = type.asParameterizedType()).name().equals((Object)CONVERTER_NAME)) continue;
            List arguments = parameterizedType.arguments();
            if (arguments.size() != 1) {
                throw new IllegalArgumentException("Converter " + converter.name() + " must be parameterized with a single type");
            }
            return (Type)arguments.get(0);
        }
        return ConfigGenerationBuildStep.getConverterType(combinedIndex.getComputingIndex().getClassByName(converter.superName()), combinedIndex);
    }
}

