/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.quarkus.deployment.AccessorFinder;
import io.quarkus.deployment.configuration.BuildTimeConfigurationReader;
import io.quarkus.deployment.configuration.definition.ClassDefinition;
import io.quarkus.deployment.configuration.definition.GroupDefinition;
import io.quarkus.deployment.configuration.definition.RootDefinition;
import io.quarkus.deployment.configuration.matching.ConfigPatternMap;
import io.quarkus.deployment.configuration.matching.Container;
import io.quarkus.deployment.configuration.matching.FieldContainer;
import io.quarkus.deployment.configuration.matching.MapContainer;
import io.quarkus.deployment.configuration.type.ArrayOf;
import io.quarkus.deployment.configuration.type.CollectionOf;
import io.quarkus.deployment.configuration.type.ConverterType;
import io.quarkus.deployment.configuration.type.Leaf;
import io.quarkus.deployment.configuration.type.LowerBoundCheckOf;
import io.quarkus.deployment.configuration.type.MinMaxValidated;
import io.quarkus.deployment.configuration.type.OptionalOf;
import io.quarkus.deployment.configuration.type.PatternValidated;
import io.quarkus.deployment.configuration.type.UpperBoundCheckOf;
import io.quarkus.deployment.util.ReflectUtil;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.configuration.AbstractConfigBuilder;
import io.quarkus.runtime.configuration.ConfigDiagnostic;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.runtime.configuration.HyphenateEnumConverter;
import io.quarkus.runtime.configuration.NameIterator;
import io.quarkus.runtime.configuration.PropertiesUtil;
import io.quarkus.runtime.configuration.QuarkusConfigFactory;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.Converters;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.Converter;
import org.wildfly.common.Assert;

public final class RunTimeConfigurationGenerator {
    public static final String CONFIG_CLASS_NAME = "io.quarkus.runtime.generated.Config";
    public static final String CONFIG_STATIC_NAME = "io.quarkus.runtime.generated.StaticInitConfig";
    public static final String CONFIG_RUNTIME_NAME = "io.quarkus.runtime.generated.RunTimeConfig";
    public static final MethodDescriptor C_CREATE_RUN_TIME_CONFIG = MethodDescriptor.ofMethod((Object)"io.quarkus.runtime.generated.Config", (String)"createRunTimeConfig", Void.TYPE, (Object[])new Object[0]);
    public static final MethodDescriptor C_ENSURE_INITIALIZED = MethodDescriptor.ofMethod((Object)"io.quarkus.runtime.generated.Config", (String)"ensureInitialized", Void.TYPE, (Object[])new Object[0]);
    public static final MethodDescriptor REINIT = MethodDescriptor.ofMethod((Object)"io.quarkus.runtime.generated.Config", (String)"reinit", Void.TYPE, (Object[])new Object[0]);
    public static final MethodDescriptor C_READ_CONFIG = MethodDescriptor.ofMethod((Object)"io.quarkus.runtime.generated.Config", (String)"readConfig", Void.TYPE, (Object[])new Object[0]);
    static final FieldDescriptor C_UNKNOWN = FieldDescriptor.of((String)"io.quarkus.runtime.generated.Config", (String)"unknown", Set.class);
    static final FieldDescriptor C_UNKNOWN_RUNTIME = FieldDescriptor.of((String)"io.quarkus.runtime.generated.Config", (String)"unknownRuntime", Set.class);
    static final MethodDescriptor CD_INVALID_VALUE = MethodDescriptor.ofMethod(ConfigDiagnostic.class, (String)"invalidValue", Void.TYPE, (Class[])new Class[]{String.class, IllegalArgumentException.class});
    static final MethodDescriptor CD_IS_ERROR = MethodDescriptor.ofMethod(ConfigDiagnostic.class, (String)"isError", Boolean.TYPE, (Class[])new Class[0]);
    static final MethodDescriptor CD_GET_ERROR_KEYS = MethodDescriptor.ofMethod(ConfigDiagnostic.class, (String)"getErrorKeys", Set.class, (Class[])new Class[0]);
    static final MethodDescriptor CD_MISSING_VALUE = MethodDescriptor.ofMethod(ConfigDiagnostic.class, (String)"missingValue", Void.TYPE, (Class[])new Class[]{String.class, NoSuchElementException.class});
    static final MethodDescriptor CD_RESET_ERROR = MethodDescriptor.ofMethod(ConfigDiagnostic.class, (String)"resetError", Void.TYPE, (Class[])new Class[0]);
    static final MethodDescriptor CD_REPORT_UNKNOWN = MethodDescriptor.ofMethod(ConfigDiagnostic.class, (String)"reportUnknown", Void.TYPE, (Class[])new Class[]{Set.class});
    static final MethodDescriptor CD_REPORT_UNKNOWN_RUNTIME = MethodDescriptor.ofMethod(ConfigDiagnostic.class, (String)"reportUnknownRuntime", Void.TYPE, (Class[])new Class[]{Set.class});
    static final MethodDescriptor CONVS_NEW_ARRAY_CONVERTER = MethodDescriptor.ofMethod(Converters.class, (String)"newArrayConverter", Converter.class, (Class[])new Class[]{Converter.class, Class.class});
    static final MethodDescriptor CONVS_NEW_COLLECTION_CONVERTER = MethodDescriptor.ofMethod(Converters.class, (String)"newCollectionConverter", Converter.class, (Class[])new Class[]{Converter.class, IntFunction.class});
    static final MethodDescriptor CONVS_NEW_OPTIONAL_CONVERTER = MethodDescriptor.ofMethod(Converters.class, (String)"newOptionalConverter", Converter.class, (Class[])new Class[]{Converter.class});
    static final MethodDescriptor CONVS_RANGE_VALUE_STRING_CONVERTER = MethodDescriptor.ofMethod(Converters.class, (String)"rangeValueStringConverter", Converter.class, (Class[])new Class[]{Converter.class, String.class, Boolean.TYPE, String.class, Boolean.TYPE});
    static final MethodDescriptor CONVS_MINIMUM_VALUE_STRING_CONVERTER = MethodDescriptor.ofMethod(Converters.class, (String)"minimumValueStringConverter", Converter.class, (Class[])new Class[]{Converter.class, String.class, Boolean.TYPE});
    static final MethodDescriptor CONVS_MAXIMUM_VALUE_STRING_CONVERTER = MethodDescriptor.ofMethod(Converters.class, (String)"maximumValueStringConverter", Converter.class, (Class[])new Class[]{Converter.class, String.class, Boolean.TYPE});
    static final MethodDescriptor CONVS_PATTERN_CONVERTER = MethodDescriptor.ofMethod(Converters.class, (String)"patternConverter", Converter.class, (Class[])new Class[]{Converter.class, Pattern.class});
    static final MethodDescriptor CU_LIST_FACTORY = MethodDescriptor.ofMethod(ConfigUtils.class, (String)"listFactory", IntFunction.class, (Class[])new Class[0]);
    static final MethodDescriptor CU_SET_FACTORY = MethodDescriptor.ofMethod(ConfigUtils.class, (String)"setFactory", IntFunction.class, (Class[])new Class[0]);
    static final MethodDescriptor CU_SORTED_SET_FACTORY = MethodDescriptor.ofMethod(ConfigUtils.class, (String)"sortedSetFactory", IntFunction.class, (Class[])new Class[0]);
    static final MethodDescriptor ITRA_ITERATOR = MethodDescriptor.ofMethod(Iterable.class, (String)"iterator", Iterator.class, (Class[])new Class[0]);
    static final MethodDescriptor ITR_HAS_NEXT = MethodDescriptor.ofMethod(Iterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]);
    static final MethodDescriptor ITR_NEXT = MethodDescriptor.ofMethod(Iterator.class, (String)"next", Object.class, (Class[])new Class[0]);
    static final MethodDescriptor MAP_GET = MethodDescriptor.ofMethod(Map.class, (String)"get", Object.class, (Class[])new Class[]{Object.class});
    static final MethodDescriptor MAP_PUT = MethodDescriptor.ofMethod(Map.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class});
    static final MethodDescriptor NI_GET_ALL_PREVIOUS_SEGMENTS = MethodDescriptor.ofMethod(NameIterator.class, (String)"getAllPreviousSegments", String.class, (Class[])new Class[0]);
    static final MethodDescriptor NI_GET_NAME = MethodDescriptor.ofMethod(NameIterator.class, (String)"getName", String.class, (Class[])new Class[0]);
    static final MethodDescriptor NI_GET_PREVIOUS_SEGMENT = MethodDescriptor.ofMethod(NameIterator.class, (String)"getPreviousSegment", String.class, (Class[])new Class[0]);
    static final MethodDescriptor NI_HAS_NEXT = MethodDescriptor.ofMethod(NameIterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]);
    static final MethodDescriptor NI_NEW_STRING = MethodDescriptor.ofConstructor(NameIterator.class, (Class[])new Class[]{String.class});
    static final MethodDescriptor NI_NEXT_EQUALS = MethodDescriptor.ofMethod(NameIterator.class, (String)"nextSegmentEquals", Boolean.TYPE, (Class[])new Class[]{String.class});
    static final MethodDescriptor NI_NEXT = MethodDescriptor.ofMethod(NameIterator.class, (String)"next", Void.TYPE, (Class[])new Class[0]);
    static final MethodDescriptor NI_PREVIOUS = MethodDescriptor.ofMethod(NameIterator.class, (String)"previous", Void.TYPE, (Class[])new Class[0]);
    static final MethodDescriptor NI_GO_TO_START = MethodDescriptor.ofMethod(NameIterator.class, (String)"goToStart", Void.TYPE, (Class[])new Class[0]);
    static final MethodDescriptor OBJ_TO_STRING = MethodDescriptor.ofMethod(Object.class, (String)"toString", String.class, (Class[])new Class[0]);
    static final MethodDescriptor OPT_EMPTY = MethodDescriptor.ofMethod(Optional.class, (String)"empty", Optional.class, (Class[])new Class[0]);
    static final MethodDescriptor OPT_GET = MethodDescriptor.ofMethod(Optional.class, (String)"get", Object.class, (Class[])new Class[0]);
    static final MethodDescriptor OPT_IS_PRESENT = MethodDescriptor.ofMethod(Optional.class, (String)"isPresent", Boolean.TYPE, (Class[])new Class[0]);
    static final MethodDescriptor OPT_OF = MethodDescriptor.ofMethod(Optional.class, (String)"of", Optional.class, (Class[])new Class[]{Object.class});
    static final MethodDescriptor SB_NEW = MethodDescriptor.ofConstructor(StringBuilder.class, (Class[])new Class[0]);
    static final MethodDescriptor SB_NEW_STR = MethodDescriptor.ofConstructor(StringBuilder.class, (Class[])new Class[]{String.class});
    static final MethodDescriptor SB_APPEND_STRING = MethodDescriptor.ofMethod(StringBuilder.class, (String)"append", StringBuilder.class, (Class[])new Class[]{String.class});
    static final MethodDescriptor SB_APPEND_CHAR = MethodDescriptor.ofMethod(StringBuilder.class, (String)"append", StringBuilder.class, (Class[])new Class[]{Character.TYPE});
    static final MethodDescriptor SB_LENGTH = MethodDescriptor.ofMethod(StringBuilder.class, (String)"length", Integer.TYPE, (Class[])new Class[0]);
    static final MethodDescriptor SB_SET_LENGTH = MethodDescriptor.ofMethod(StringBuilder.class, (String)"setLength", Void.TYPE, (Class[])new Class[]{Integer.TYPE});
    static final MethodDescriptor QCF_SET_CONFIG = MethodDescriptor.ofMethod(QuarkusConfigFactory.class, (String)"setConfig", Void.TYPE, (Class[])new Class[]{SmallRyeConfig.class});
    static final MethodDescriptor SRC_GET_CONVERTER = MethodDescriptor.ofMethod(SmallRyeConfig.class, (String)"getConverter", Converter.class, (Class[])new Class[]{Class.class});
    static final MethodDescriptor SRC_GET_PROPERTY_NAMES = MethodDescriptor.ofMethod(SmallRyeConfig.class, (String)"getPropertyNames", Iterable.class, (Class[])new Class[0]);
    static final MethodDescriptor SRC_GET_VALUE = MethodDescriptor.ofMethod(SmallRyeConfig.class, (String)"getValue", Object.class, (Class[])new Class[]{String.class, Converter.class});
    static final MethodDescriptor SRCB_NEW = MethodDescriptor.ofConstructor(SmallRyeConfigBuilder.class, (Class[])new Class[0]);
    static final MethodDescriptor SRCB_WITH_CONVERTER = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"withConverter", ConfigBuilder.class, (Class[])new Class[]{Class.class, Integer.TYPE, Converter.class});
    static final MethodDescriptor SRCB_WITH_CUSTOMIZER = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withCustomizer", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, String.class});
    static final MethodDescriptor SRCB_BUILD = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"build", SmallRyeConfig.class, (Class[])new Class[0]);
    static final MethodDescriptor PU_IS_MAPPED = MethodDescriptor.ofMethod(PropertiesUtil.class, (String)"isMapped", Boolean.TYPE, (Class[])new Class[]{NameIterator.class, String.class});
    static final MethodDescriptor PU_IS_PROPERTY_QUARKUS_COMPOUND_NAME = MethodDescriptor.ofMethod(PropertiesUtil.class, (String)"isPropertyQuarkusCompoundName", Boolean.TYPE, (Class[])new Class[]{NameIterator.class});
    static final MethodDescriptor PU_IS_PROPERTY_IN_ROOTS = MethodDescriptor.ofMethod(PropertiesUtil.class, (String)"isPropertyInRoots", Boolean.TYPE, (Class[])new Class[]{String.class, Set.class});
    static final MethodDescriptor HS_NEW = MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]);
    static final MethodDescriptor HS_NEW_SIZED = MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[]{Integer.TYPE});
    static final MethodDescriptor HS_ADD = MethodDescriptor.ofMethod(HashSet.class, (String)"add", Boolean.TYPE, (Class[])new Class[]{Object.class});
    static final MethodDescriptor TM_NEW = MethodDescriptor.ofConstructor(TreeMap.class, (Class[])new Class[0]);
    static final MethodDescriptor EMPTY_PARSER = MethodDescriptor.ofMethod((Object)"io.quarkus.runtime.generated.Config", (String)"emptyParseKey", Void.TYPE, (Object[])new Object[]{SmallRyeConfig.class, NameIterator.class});
    static final MethodDescriptor RT_EMPTY_PARSER = MethodDescriptor.ofMethod((Object)"io.quarkus.runtime.generated.Config", (String)"rtEmptyParseKey", Void.TYPE, (Object[])new Object[]{SmallRyeConfig.class, NameIterator.class});

    private RunTimeConfigurationGenerator() {
    }

    private static boolean isFieldEligibleForDirectAccess(ClassDefinition.ClassMember classMember) {
        return Modifier.isPublic(classMember.getField().getModifiers()) && Modifier.isPublic(classMember.getEnclosingDefinition().getConfigurationClass().getModifiers()) && Modifier.isPublic(classMember.getField().getType().getModifiers());
    }

    private static enum Type {
        BUILD_TIME("si"),
        RUNTIME("rt");

        final String methodPrefix;

        private Type(String methodPrefix) {
            this.methodPrefix = methodPrefix;
        }
    }

    public static final class GenerateOperation
    implements AutoCloseable {
        final boolean liveReloadPossible;
        final LaunchMode launchMode;
        final AccessorFinder accessorFinder;
        final ClassOutput classOutput;
        final ClassCreator cc;
        final MethodCreator clinit;
        final MethodCreator reinit;
        final BytecodeCreator converterSetup;
        final MethodCreator readConfig;
        final ResultHandle readConfigNameBuilder;
        final ResultHandle clinitNameBuilder;
        final BuildTimeConfigurationReader.ReadResult buildTimeConfigResult;
        final List<RootDefinition> roots;
        final Map<Container, MethodDescriptor> enclosingMemberMethods = new HashMap<Container, MethodDescriptor>();
        final Map<Class<?>, MethodDescriptor> groupInitMethods = new HashMap();
        final Map<Class<?>, FieldDescriptor> configRootsByType = new HashMap();
        final ResultHandle clinitConfig;
        final Map<FieldDescriptor, Class<?>> convertersToRegister = new HashMap();
        final List<Class<?>> additionalTypes;
        final Map<ConverterType, FieldDescriptor> convertersByType = new HashMap<ConverterType, FieldDescriptor>();
        final Map<FieldDescriptor, ResultHandle> instanceCache = new HashMap<FieldDescriptor, ResultHandle>();
        int converterIndex = 0;

        GenerateOperation(Builder builder) {
            this.launchMode = builder.launchMode;
            this.liveReloadPossible = builder.liveReloadPossible;
            BuildTimeConfigurationReader.ReadResult buildTimeReadResult = builder.buildTimeReadResult;
            this.buildTimeConfigResult = (BuildTimeConfigurationReader.ReadResult)Assert.checkNotNullParam((String)"buildTimeReadResult", (Object)buildTimeReadResult);
            this.classOutput = (ClassOutput)Assert.checkNotNullParam((String)"classOutput", (Object)builder.getClassOutput());
            this.roots = (List)Assert.checkNotNullParam((String)"builder.roots", builder.getBuildTimeReadResult().getAllRoots());
            this.additionalTypes = (List)Assert.checkNotNullParam((String)"additionalTypes", builder.getAdditionalTypes());
            this.cc = ClassCreator.builder().classOutput(this.classOutput).className(RunTimeConfigurationGenerator.CONFIG_CLASS_NAME).setFinal(true).build();
            this.generateEmptyParsers();
            try (MethodCreator mc = this.cc.getMethodCreator(MethodDescriptor.ofConstructor((String)RunTimeConfigurationGenerator.CONFIG_CLASS_NAME, (String[])new String[0]));){
                mc.setModifiers(2);
                mc.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), mc.getThis(), new ResultHandle[0]);
                mc.returnValue(null);
            }
            if (this.liveReloadPossible) {
                this.reinit = this.cc.getMethodCreator(REINIT);
                this.reinit.setModifiers(9);
            } else {
                this.reinit = null;
            }
            this.clinit = this.cc.getMethodCreator(MethodDescriptor.ofMethod((Object)RunTimeConfigurationGenerator.CONFIG_CLASS_NAME, (String)"<clinit>", Void.TYPE, (Object[])new Object[0]));
            this.clinit.setModifiers(8);
            this.cc.getFieldCreator(C_UNKNOWN).setModifiers(8);
            this.clinit.writeStaticField(C_UNKNOWN, this.clinit.newInstance(HS_NEW, new ResultHandle[0]));
            this.cc.getFieldCreator(C_UNKNOWN_RUNTIME).setModifiers(8);
            this.clinit.writeStaticField(C_UNKNOWN_RUNTIME, this.clinit.newInstance(HS_NEW, new ResultHandle[0]));
            this.generateIsMapped();
            this.clinitNameBuilder = this.clinit.newInstance(SB_NEW, new ResultHandle[0]);
            ResultHandle buildTimeBuilder = this.clinit.newInstance(SRCB_NEW, new ResultHandle[0]);
            this.clinit.invokeStaticMethod(SRCB_WITH_CUSTOMIZER, new ResultHandle[]{buildTimeBuilder, this.clinit.load(RunTimeConfigurationGenerator.CONFIG_STATIC_NAME)});
            this.clinitConfig = this.clinit.checkCast(this.clinit.invokeVirtualMethod(SRCB_BUILD, buildTimeBuilder, new ResultHandle[0]), SmallRyeConfig.class);
            this.converterSetup = this.clinit.createScope();
            this.readConfig = this.cc.getMethodCreator(C_READ_CONFIG);
            this.readConfigNameBuilder = this.readConfig.newInstance(SB_NEW, new ResultHandle[0]);
            this.accessorFinder = new AccessorFinder();
        }

        public void run() {
            this.installConfiguration(this.clinitConfig, this.clinit);
            if (this.liveReloadPossible) {
                ResultHandle buildTimeBuilder = this.reinit.newInstance(SRCB_NEW, new ResultHandle[0]);
                this.reinit.invokeStaticMethod(SRCB_WITH_CUSTOMIZER, new ResultHandle[]{buildTimeBuilder, this.reinit.load(RunTimeConfigurationGenerator.CONFIG_STATIC_NAME)});
                ResultHandle clinitConfig = this.reinit.checkCast(this.reinit.invokeVirtualMethod(SRCB_BUILD, buildTimeBuilder, new ResultHandle[0]), SmallRyeConfig.class);
                this.installConfiguration(clinitConfig, this.reinit);
                this.reinit.returnValue(null);
            }
            for (RootDefinition root : this.roots) {
                this.configRootsByType.put(root.getConfigurationClass(), root.getDescriptor());
            }
            ConfigPatternMap<Container> buildTimePatternMap = this.buildTimeConfigResult.getBuildTimePatternMap();
            ConfigPatternMap<Container> buildTimeRunTimePatternMap = this.buildTimeConfigResult.getBuildTimeRunTimePatternMap();
            ConfigPatternMap<Container> runTimePatternMap = this.buildTimeConfigResult.getRunTimePatternMap();
            BiFunction<Container, Container, Container> combinator = (a, b) -> a == null ? b : a;
            ConfigPatternMap<Container> buildTimeRunTimeIgnored = ConfigPatternMap.merge(buildTimePatternMap, runTimePatternMap, combinator);
            ConfigPatternMap<Container> runTimeIgnored = ConfigPatternMap.merge(buildTimePatternMap, buildTimeRunTimePatternMap, combinator);
            MethodDescriptor siParserBody = this.generateParserBody(buildTimeRunTimePatternMap, buildTimeRunTimeIgnored, new StringBuilder("siParseKey"), false, Type.BUILD_TIME);
            MethodDescriptor rtParserBody = this.generateParserBody(runTimePatternMap, runTimeIgnored, new StringBuilder("rtParseKey"), false, Type.RUNTIME);
            ResultHandle runTimeBuilder = this.readConfig.newInstance(SRCB_NEW, new ResultHandle[0]);
            for (Class<?> clazz : this.additionalTypes) {
                Leaf type = new Leaf(clazz, null);
                FieldDescriptor fd = this.convertersByType.get(type);
                if (fd != null) continue;
                ResultHandle clazzHandle = this.converterSetup.loadClassFromTCCL(clazz);
                fd = FieldDescriptor.of((String)this.cc.getClassName(), (String)("conv$" + this.converterIndex++), Converter.class);
                ResultHandle converter = this.converterSetup.invokeVirtualMethod(SRC_GET_CONVERTER, this.clinitConfig, new ResultHandle[]{clazzHandle});
                this.cc.getFieldCreator(fd).setModifiers(24);
                this.converterSetup.writeStaticField(fd, converter);
                this.convertersByType.put(type, fd);
                this.instanceCache.put(fd, converter);
                this.convertersToRegister.put(fd, clazz);
            }
            if (!this.convertersToRegister.isEmpty()) {
                for (Map.Entry entry : this.convertersToRegister.entrySet()) {
                    FieldDescriptor descriptor = (FieldDescriptor)entry.getKey();
                    Class type = (Class)entry.getValue();
                    this.readConfig.invokeVirtualMethod(SRCB_WITH_CONVERTER, runTimeBuilder, new ResultHandle[]{this.readConfig.loadClassFromTCCL(type), this.readConfig.load(100), this.readConfig.readStaticField(descriptor)});
                }
            }
            this.readConfig.invokeStaticMethod(SRCB_WITH_CUSTOMIZER, new ResultHandle[]{runTimeBuilder, this.readConfig.load(RunTimeConfigurationGenerator.CONFIG_RUNTIME_NAME)});
            ResultHandle runTimeConfig = this.readConfig.invokeVirtualMethod(SRCB_BUILD, runTimeBuilder, new ResultHandle[0]);
            this.installConfiguration(runTimeConfig, this.readConfig);
            ResultHandle resultHandle = this.clinit.invokeVirtualMethod(SB_LENGTH, this.clinitNameBuilder, new ResultHandle[0]);
            ResultHandle rcOldLen = this.readConfig.invokeVirtualMethod(SB_LENGTH, this.readConfigNameBuilder, new ResultHandle[0]);
            for (RootDefinition root : this.roots) {
                ResultHandle instance;
                Class<?> configurationClass = root.getConfigurationClass();
                FieldDescriptor rootFieldDescriptor = root.getDescriptor();
                MethodDescriptor initGroup = null;
                if (root.getConfigPhase() != ConfigPhase.BUILD_TIME) {
                    initGroup = this.generateInitGroup(root);
                }
                MethodDescriptor accessorCtor = null;
                if (!Modifier.isPublic(configurationClass.getModifiers())) {
                    accessorCtor = this.accessorFinder.getConstructorFor(MethodDescriptor.ofConstructor(configurationClass, (Class[])new Class[0]));
                }
                if (root.getConfigPhase() == ConfigPhase.BUILD_AND_RUN_TIME_FIXED) {
                    this.cc.getFieldCreator(rootFieldDescriptor).setModifiers(9 | (this.liveReloadPossible ? 64 : 16));
                    instance = accessorCtor == null ? this.clinit.newInstance(MethodDescriptor.ofConstructor(configurationClass, (Class[])new Class[0]), new ResultHandle[0]) : this.clinit.invokeStaticMethod(accessorCtor, new ResultHandle[0]);
                    this.clinit.writeStaticField(rootFieldDescriptor, instance);
                    this.instanceCache.put(rootFieldDescriptor, instance);
                    this.clinit.invokeVirtualMethod(SB_APPEND_STRING, this.clinitNameBuilder, new ResultHandle[]{this.clinit.load(root.getName())});
                    this.clinit.invokeStaticMethod(initGroup, new ResultHandle[]{this.clinitConfig, this.clinitNameBuilder, instance});
                    this.clinit.invokeVirtualMethod(SB_SET_LENGTH, this.clinitNameBuilder, new ResultHandle[]{resultHandle});
                    if (!this.liveReloadPossible) continue;
                    instance = this.readConfig.readStaticField(rootFieldDescriptor);
                    this.readConfig.invokeVirtualMethod(SB_APPEND_STRING, this.readConfigNameBuilder, new ResultHandle[]{this.readConfig.load(root.getName())});
                    this.readConfig.invokeStaticMethod(initGroup, new ResultHandle[]{runTimeConfig, this.readConfigNameBuilder, instance});
                    this.readConfig.invokeVirtualMethod(SB_SET_LENGTH, this.readConfigNameBuilder, new ResultHandle[]{rcOldLen});
                    continue;
                }
                if (root.getConfigPhase() == ConfigPhase.RUN_TIME) {
                    this.cc.getFieldCreator(rootFieldDescriptor).setModifiers(73);
                    instance = accessorCtor == null ? this.readConfig.newInstance(MethodDescriptor.ofConstructor(configurationClass, (Class[])new Class[0]), new ResultHandle[0]) : this.readConfig.invokeStaticMethod(accessorCtor, new ResultHandle[0]);
                    this.readConfig.writeStaticField(rootFieldDescriptor, instance);
                    this.readConfig.invokeVirtualMethod(SB_APPEND_STRING, this.readConfigNameBuilder, new ResultHandle[]{this.readConfig.load(root.getName())});
                    this.readConfig.invokeStaticMethod(initGroup, new ResultHandle[]{runTimeConfig, this.readConfigNameBuilder, instance});
                    this.readConfig.invokeVirtualMethod(SB_SET_LENGTH, this.readConfigNameBuilder, new ResultHandle[]{rcOldLen});
                    continue;
                }
                assert (root.getConfigPhase() == ConfigPhase.BUILD_TIME);
            }
            this.configSweepLoop(siParserBody, this.clinit, this.clinitConfig, this.getRegisteredRoots(ConfigPhase.BUILD_AND_RUN_TIME_FIXED), Type.BUILD_TIME);
            this.clinit.invokeStaticMethod(CD_REPORT_UNKNOWN, new ResultHandle[]{this.clinit.readStaticField(C_UNKNOWN)});
            if (this.liveReloadPossible) {
                this.configSweepLoop(siParserBody, this.readConfig, runTimeConfig, this.getRegisteredRoots(ConfigPhase.RUN_TIME), Type.RUNTIME);
            }
            this.configSweepLoop(rtParserBody, this.readConfig, runTimeConfig, this.getRegisteredRoots(ConfigPhase.RUN_TIME), Type.RUNTIME);
            this.readConfig.invokeStaticMethod(CD_REPORT_UNKNOWN_RUNTIME, new ResultHandle[]{this.readConfig.readStaticField(C_UNKNOWN_RUNTIME)});
            try (MethodCreator mc = this.cc.getMethodCreator(C_ENSURE_INITIALIZED);){
                mc.setModifiers(9);
                mc.returnValue(null);
            }
            mc = this.cc.getMethodCreator(C_CREATE_RUN_TIME_CONFIG);
            try {
                mc.setModifiers(9);
                ResultHandle instance = mc.newInstance(MethodDescriptor.ofConstructor((String)RunTimeConfigurationGenerator.CONFIG_CLASS_NAME, (String[])new String[0]), new ResultHandle[0]);
                mc.invokeVirtualMethod(C_READ_CONFIG, instance, new ResultHandle[0]);
                mc.returnValue(null);
            }
            finally {
                if (mc != null) {
                    mc.close();
                }
            }
            BytecodeCreator isError = this.readConfig.ifNonZero(this.readConfig.invokeStaticMethod(CD_IS_ERROR, new ResultHandle[0])).trueBranch();
            ResultHandle niceErrorMessage = isError.invokeStaticMethod(MethodDescriptor.ofMethod(ConfigDiagnostic.class, (String)"getNiceErrorMessage", String.class, (Class[])new Class[0]), new ResultHandle[0]);
            ResultHandle errorKeys = isError.invokeStaticMethod(CD_GET_ERROR_KEYS, new ResultHandle[0]);
            isError.invokeStaticMethod(CD_RESET_ERROR, new ResultHandle[0]);
            ResultHandle finalErrorMessageBuilder = isError.newInstance(SB_NEW, new ResultHandle[0]);
            isError.invokeVirtualMethod(SB_APPEND_STRING, finalErrorMessageBuilder, new ResultHandle[]{isError.load("One or more configuration errors have prevented the application from starting. The errors are:\n")});
            isError.invokeVirtualMethod(SB_APPEND_STRING, finalErrorMessageBuilder, new ResultHandle[]{niceErrorMessage});
            ResultHandle finalErrorMessage = isError.invokeVirtualMethod(OBJ_TO_STRING, finalErrorMessageBuilder, new ResultHandle[0]);
            ResultHandle configurationException = isError.newInstance(MethodDescriptor.ofConstructor(ConfigurationException.class, (Class[])new Class[]{String.class, Set.class}), new ResultHandle[]{finalErrorMessage, errorKeys});
            ResultHandle emptyStackTraceElement = isError.newArray(StackTraceElement.class, 0);
            isError.invokeVirtualMethod(MethodDescriptor.ofMethod(ConfigurationException.class, (String)"setStackTrace", Void.TYPE, (Class[])new Class[]{StackTraceElement[].class}), configurationException, new ResultHandle[]{emptyStackTraceElement});
            isError.throwException(configurationException);
            this.readConfig.returnValue(null);
            this.readConfig.close();
            this.clinit.returnValue(null);
            this.clinit.close();
            this.cc.close();
        }

        private void configSweepLoop(MethodDescriptor parserBody, MethodCreator method, ResultHandle config, Set<String> registeredRoots, Type type) {
            ResultHandle propertyNames = method.invokeVirtualMethod(SRC_GET_PROPERTY_NAMES, config, new ResultHandle[0]);
            ResultHandle iterator = method.invokeInterfaceMethod(ITRA_ITERATOR, propertyNames, new ResultHandle[0]);
            ResultHandle rootSet = method.newInstance(HS_NEW, new ResultHandle[0]);
            for (String registeredRoot : registeredRoots) {
                method.invokeVirtualMethod(HS_ADD, rootSet, new ResultHandle[]{method.load(registeredRoot)});
            }
            try (BytecodeCreator sweepLoop = method.createScope();
                 BytecodeCreator hasNext = sweepLoop.ifNonZero(sweepLoop.invokeInterfaceMethod(ITR_HAS_NEXT, iterator, new ResultHandle[0])).trueBranch();){
                ResultHandle key = hasNext.checkCast(hasNext.invokeInterfaceMethod(ITR_NEXT, iterator, new ResultHandle[0]), String.class);
                ResultHandle keyIter = hasNext.newInstance(NI_NEW_STRING, new ResultHandle[]{key});
                ResultHandle isMappedName = hasNext.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RunTimeConfigurationGenerator.CONFIG_CLASS_NAME, (String)"isMapped", Boolean.TYPE, (Object[])new Object[]{NameIterator.class}), new ResultHandle[]{keyIter});
                try (BytecodeCreator isMappedPropertyTrue = hasNext.ifTrue(isMappedName).trueBranch();){
                    isMappedPropertyTrue.continueScope(sweepLoop);
                }
                hasNext.invokeVirtualMethod(NI_GO_TO_START, keyIter, new ResultHandle[0]);
                BranchResult quarkusCompoundName = hasNext.ifNonZero(hasNext.invokeStaticMethod(PU_IS_PROPERTY_QUARKUS_COMPOUND_NAME, new ResultHandle[]{keyIter}));
                try (BytecodeCreator trueBranch = quarkusCompoundName.trueBranch();){
                    ResultHandle unknown = type == Type.BUILD_TIME ? trueBranch.readStaticField(C_UNKNOWN) : trueBranch.readStaticField(C_UNKNOWN_RUNTIME);
                    trueBranch.invokeVirtualMethod(HS_ADD, unknown, new ResultHandle[]{key});
                }
                hasNext.ifNonZero(hasNext.invokeStaticMethod(PU_IS_PROPERTY_IN_ROOTS, new ResultHandle[]{key, rootSet})).falseBranch().continueScope(sweepLoop);
                hasNext.ifNonZero(hasNext.invokeVirtualMethod(NI_HAS_NEXT, keyIter, new ResultHandle[0])).falseBranch().continueScope(sweepLoop);
                hasNext.invokeStaticMethod(parserBody, new ResultHandle[]{config, keyIter});
                hasNext.continueScope(sweepLoop);
            }
        }

        private Set<String> getRegisteredRoots(ConfigPhase configPhase) {
            HashSet<String> registeredRoots = new HashSet<String>();
            for (RootDefinition root : this.roots) {
                if (!root.getConfigPhase().equals((Object)configPhase)) continue;
                registeredRoots.add(root.getName());
            }
            if (ConfigPhase.BUILD_AND_RUN_TIME_FIXED.equals((Object)configPhase)) {
                for (ConfigMappings.ConfigClass mapping : this.buildTimeConfigResult.getBuildTimeRunTimeMappings()) {
                    registeredRoots.add(mapping.getPrefix());
                }
            }
            if (ConfigPhase.RUN_TIME.equals((Object)configPhase)) {
                for (ConfigMappings.ConfigClass mapping : this.buildTimeConfigResult.getRunTimeMappings()) {
                    registeredRoots.add(mapping.getPrefix());
                }
            }
            return registeredRoots;
        }

        private void installConfiguration(ResultHandle config, MethodCreator methodCreator) {
            methodCreator.invokeStaticMethod(QCF_SET_CONFIG, new ResultHandle[]{config});
        }

        private MethodDescriptor generateInitGroup(ClassDefinition definition) {
            Class<?> clazz = definition.getConfigurationClass();
            MethodDescriptor methodDescriptor = this.groupInitMethods.get(clazz);
            if (methodDescriptor != null) {
                return methodDescriptor;
            }
            methodDescriptor = MethodDescriptor.ofMethod((Object)RunTimeConfigurationGenerator.CONFIG_CLASS_NAME, (String)("initGroup$" + clazz.getName().replace('.', '$')), Void.TYPE, (Object[])new Object[]{SmallRyeConfig.class, StringBuilder.class, Object.class});
            MethodCreator bc = (MethodCreator)this.cc.getMethodCreator(methodDescriptor).setModifiers(8);
            ResultHandle config = bc.getMethodParam(0);
            ResultHandle nameBuilder = bc.getMethodParam(1);
            ResultHandle instance = bc.getMethodParam(2);
            ResultHandle length = bc.invokeVirtualMethod(SB_LENGTH, nameBuilder, new ResultHandle[0]);
            for (ClassDefinition.ClassMember member : definition.getMembers()) {
                String propertyName;
                block39: {
                    propertyName = member.getPropertyName();
                    MethodDescriptor setter = null;
                    if (!RunTimeConfigurationGenerator.isFieldEligibleForDirectAccess(member)) {
                        setter = this.accessorFinder.getSetterFor(member.getDescriptor());
                    }
                    if (!propertyName.isEmpty()) {
                        bc.invokeVirtualMethod(SB_APPEND_CHAR, nameBuilder, new ResultHandle[]{bc.load('.')});
                        bc.invokeVirtualMethod(SB_APPEND_STRING, nameBuilder, new ResultHandle[]{bc.load(propertyName)});
                    }
                    if (member instanceof ClassDefinition.ItemMember) {
                        ClassDefinition.ItemMember leafMember = (ClassDefinition.ItemMember)member;
                        FieldDescriptor convField = this.getOrCreateConverterInstance(leafMember.getField());
                        ResultHandle name = bc.invokeVirtualMethod(OBJ_TO_STRING, nameBuilder, new ResultHandle[0]);
                        ResultHandle converter = bc.readStaticField(convField);
                        try (TryBlock tryBlock = bc.tryBlock();){
                            ResultHandle val = tryBlock.invokeVirtualMethod(SRC_GET_VALUE, config, new ResultHandle[]{name, converter});
                            if (setter == null) {
                                tryBlock.writeInstanceField(member.getDescriptor(), instance, val);
                            } else {
                                tryBlock.invokeStaticMethod(setter, new ResultHandle[]{instance, val});
                            }
                            try (CatchBlockCreator catchBadValue = tryBlock.addCatch(IllegalArgumentException.class);){
                                catchBadValue.invokeStaticMethod(CD_INVALID_VALUE, new ResultHandle[]{name, catchBadValue.getCaughtException()});
                            }
                            try (CatchBlockCreator catchNoValue = tryBlock.addCatch(NoSuchElementException.class);){
                                catchNoValue.invokeStaticMethod(CD_MISSING_VALUE, new ResultHandle[]{name, catchNoValue.getCaughtException()});
                                break block39;
                            }
                        }
                    }
                    if (member instanceof ClassDefinition.GroupMember) {
                        ClassDefinition.GroupMember groupMember = (ClassDefinition.GroupMember)member;
                        if (groupMember.isOptional()) {
                            ResultHandle val = bc.invokeStaticMethod(OPT_EMPTY, new ResultHandle[0]);
                            if (setter == null) {
                                bc.writeInstanceField(member.getDescriptor(), instance, val);
                            } else {
                                bc.invokeStaticMethod(setter, new ResultHandle[]{instance, val});
                            }
                        } else {
                            ResultHandle nestedInstance;
                            GroupDefinition groupDefinition = groupMember.getGroupDefinition();
                            MethodDescriptor nested = this.generateInitGroup(groupDefinition);
                            if (Modifier.isPublic(groupDefinition.getConfigurationClass().getModifiers())) {
                                nestedInstance = bc.newInstance(MethodDescriptor.ofConstructor(groupDefinition.getConfigurationClass(), (Class[])new Class[0]), new ResultHandle[0]);
                            } else {
                                MethodDescriptor ctor = this.accessorFinder.getConstructorFor(MethodDescriptor.ofConstructor(groupDefinition.getConfigurationClass(), (Class[])new Class[0]));
                                nestedInstance = bc.invokeStaticMethod(ctor, new ResultHandle[0]);
                            }
                            bc.invokeStaticMethod(nested, new ResultHandle[]{config, nameBuilder, nestedInstance});
                            if (setter == null) {
                                bc.writeInstanceField(member.getDescriptor(), instance, nestedInstance);
                            } else {
                                bc.invokeStaticMethod(setter, new ResultHandle[]{instance, nestedInstance});
                            }
                        }
                    } else {
                        assert (member instanceof ClassDefinition.MapMember);
                        ResultHandle map = bc.newInstance(TM_NEW, new ResultHandle[0]);
                        if (setter == null) {
                            bc.writeInstanceField(member.getDescriptor(), instance, map);
                        } else {
                            bc.invokeStaticMethod(setter, new ResultHandle[]{instance, map});
                        }
                    }
                }
                if (propertyName.isEmpty()) continue;
                bc.invokeVirtualMethod(SB_SET_LENGTH, nameBuilder, new ResultHandle[]{length});
            }
            bc.returnValue(null);
            this.groupInitMethods.put(clazz, methodDescriptor);
            return methodDescriptor;
        }

        private void generateEmptyParsers() {
            MethodCreator body = this.cc.getMethodCreator(RT_EMPTY_PARSER);
            body.setModifiers(10);
            ResultHandle keyIter = body.getMethodParam(1);
            try (BytecodeCreator matchedBody = body.ifNonZero(body.invokeVirtualMethod(NI_HAS_NEXT, keyIter, new ResultHandle[0])).falseBranch();){
                matchedBody.returnValue(null);
            }
            this.reportUnknownRuntime((BytecodeCreator)body, keyIter);
            body.returnValue(null);
            body = this.cc.getMethodCreator(EMPTY_PARSER);
            body.setModifiers(10);
            keyIter = body.getMethodParam(1);
            matchedBody = body.ifNonZero(body.invokeVirtualMethod(NI_HAS_NEXT, keyIter, new ResultHandle[0])).falseBranch();
            try {
                matchedBody.returnValue(null);
            }
            finally {
                if (matchedBody != null) {
                    matchedBody.close();
                }
            }
            this.reportUnknown((BytecodeCreator)body, keyIter);
            body.returnValue(null);
        }

        private MethodDescriptor generateParserBody(ConfigPatternMap<Container> keyMap, ConfigPatternMap<?> ignoredMap, StringBuilder methodName, boolean dynamic, Type type) {
            Object ignoreMatched;
            Container matched = keyMap == null ? null : keyMap.getMatched();
            Object v0 = ignoreMatched = ignoredMap == null ? null : ignoredMap.getMatched();
            if (!(matched != null || ignoreMatched == null || keyMap != null && keyMap.childNames().iterator().hasNext())) {
                Iterable<String> names = ignoredMap.childNames();
                boolean needsCode = false;
                for (String name : names) {
                    if (name.equals("{*}")) {
                        needsCode = true;
                        break;
                    }
                    ConfigPatternMap<Container> keyChildMap = keyMap == null ? null : keyMap.getChild(name);
                    if (keyChildMap != null) continue;
                    needsCode = true;
                    break;
                }
                if (!needsCode) {
                    return type == Type.BUILD_TIME ? EMPTY_PARSER : RT_EMPTY_PARSER;
                }
            }
            try (MethodCreator body = this.cc.getMethodCreator(methodName.toString(), Void.TYPE, new Class[]{SmallRyeConfig.class, NameIterator.class});){
                Iterable<String> names;
                body.setModifiers(10);
                ResultHandle config = body.getMethodParam(0);
                ResultHandle keyIter = body.getMethodParam(1);
                try (BytecodeCreator matchedBody = body.ifNonZero(body.invokeVirtualMethod(NI_HAS_NEXT, keyIter, new ResultHandle[0])).falseBranch();){
                    if (matched != null) {
                        ClassDefinition.ClassMember member = matched.getClassMember();
                        assert (member instanceof ClassDefinition.ItemMember);
                        Iterator<String> itemMember = (ClassDefinition.ItemMember)member;
                        if (matched instanceof FieldContainer) {
                            FieldContainer fieldContainer = (FieldContainer)matched;
                            if (dynamic) {
                                this.generateConsumeSegments(matchedBody, keyIter, ((ClassDefinition.ItemMember)((Object)itemMember)).getPropertyName());
                                matchedBody.invokeStaticMethod(this.generateGetEnclosing(fieldContainer, type), new ResultHandle[]{keyIter, config});
                            }
                        } else {
                            assert (matched instanceof MapContainer);
                            MapContainer mapContainer = (MapContainer)matched;
                            ResultHandle lastSeg = matchedBody.invokeVirtualMethod(NI_GET_PREVIOUS_SEGMENT, keyIter, new ResultHandle[0]);
                            matchedBody.invokeVirtualMethod(NI_PREVIOUS, keyIter, new ResultHandle[0]);
                            ResultHandle mapHandle = matchedBody.invokeStaticMethod(this.generateGetEnclosing(mapContainer, type), new ResultHandle[]{keyIter, config});
                            Field field = mapContainer.findField();
                            FieldDescriptor fd = this.getOrCreateConverterInstance(field);
                            ResultHandle key = matchedBody.invokeVirtualMethod(NI_GET_NAME, keyIter, new ResultHandle[0]);
                            ResultHandle converter = matchedBody.readStaticField(fd);
                            ResultHandle value = matchedBody.invokeVirtualMethod(SRC_GET_VALUE, config, new ResultHandle[]{key, converter});
                            matchedBody.invokeInterfaceMethod(MAP_PUT, mapHandle, new ResultHandle[]{lastSeg, value});
                        }
                    } else if (ignoreMatched == null) {
                        if (type == Type.BUILD_TIME) {
                            this.reportUnknown(matchedBody, keyIter);
                        } else {
                            this.reportUnknownRuntime(matchedBody, keyIter);
                        }
                    }
                    matchedBody.returnValue(null);
                }
                boolean hasWildCard = false;
                if (keyMap != null) {
                    names = keyMap.childNames();
                    for (String name : names) {
                        if (name.equals("{*}")) {
                            hasWildCard = true;
                            continue;
                        }
                        try (BytecodeCreator nameMatched = body.ifNonZero(body.invokeVirtualMethod(NI_NEXT_EQUALS, keyIter, new ResultHandle[]{body.load(name)})).trueBranch();){
                            nameMatched.invokeVirtualMethod(NI_NEXT, keyIter, new ResultHandle[0]);
                            int length = methodName.length();
                            methodName.append(':').append(name);
                            nameMatched.invokeStaticMethod(this.generateParserBody(keyMap.getChild(name), ignoredMap == null ? null : ignoredMap.getChild(name), methodName, dynamic, type), new ResultHandle[]{config, keyIter});
                            methodName.setLength(length);
                            nameMatched.returnValue(null);
                        }
                    }
                }
                if (ignoredMap != null) {
                    names = ignoredMap.childNames();
                    for (String name : names) {
                        ConfigPatternMap<Container> keyChildMap;
                        if (name.equals("{*}")) {
                            hasWildCard = true;
                            continue;
                        }
                        ConfigPatternMap<Container> configPatternMap = keyChildMap = keyMap == null ? null : keyMap.getChild(name);
                        if (keyChildMap != null) continue;
                        try (BytecodeCreator nameMatched = body.ifNonZero(body.invokeVirtualMethod(NI_NEXT_EQUALS, keyIter, new ResultHandle[]{body.load(name)})).trueBranch();){
                            nameMatched.invokeVirtualMethod(NI_NEXT, keyIter, new ResultHandle[0]);
                            int length = methodName.length();
                            methodName.append(':').append(name);
                            nameMatched.invokeStaticMethod(this.generateParserBody(null, ignoredMap.getChild(name), methodName, false, type), new ResultHandle[]{config, keyIter});
                            methodName.setLength(length);
                            nameMatched.returnValue(null);
                        }
                    }
                }
                if (hasWildCard) {
                    assert (keyMap != null || ignoredMap != null);
                    try (BytecodeCreator matchedBody = body.ifNonZero(body.invokeVirtualMethod(NI_HAS_NEXT, keyIter, new ResultHandle[0])).trueBranch();){
                        matchedBody.invokeVirtualMethod(NI_NEXT, keyIter, new ResultHandle[0]);
                        int length = methodName.length();
                        methodName.append(":*");
                        matchedBody.invokeStaticMethod(this.generateParserBody(keyMap == null ? null : keyMap.getChild("{*}"), ignoredMap == null ? null : ignoredMap.getChild("{*}"), methodName, true, type), new ResultHandle[]{config, keyIter});
                        methodName.setLength(length);
                        matchedBody.returnValue(null);
                    }
                }
                if (type == Type.BUILD_TIME) {
                    this.reportUnknown((BytecodeCreator)body, keyIter);
                } else {
                    this.reportUnknownRuntime((BytecodeCreator)body, keyIter);
                }
                body.returnValue(null);
                MethodDescriptor methodDescriptor = body.getMethodDescriptor();
                return methodDescriptor;
            }
        }

        private MethodDescriptor generateGetEnclosing(FieldContainer matchNode, Type type) {
            MethodDescriptor md = this.enclosingMemberMethods.get(matchNode);
            if (md != null) {
                return md;
            }
            md = MethodDescriptor.ofMethod((Object)RunTimeConfigurationGenerator.CONFIG_CLASS_NAME, (String)(type.methodPrefix + "GetEnclosing:" + matchNode.getCombinedName()), Object.class, (Object[])new Object[]{NameIterator.class, SmallRyeConfig.class});
            try (MethodCreator mc = this.cc.getMethodCreator(md);){
                mc.setModifiers(8);
                ResultHandle keyIter = mc.getMethodParam(0);
                ResultHandle config = mc.getMethodParam(1);
                ClassDefinition.ClassMember member = matchNode.getClassMember();
                Container parent = matchNode.getParent();
                if (parent == null) {
                    RootDefinition definition = (RootDefinition)member.getEnclosingDefinition();
                    FieldDescriptor fieldDescriptor = this.configRootsByType.get(definition.getConfigurationClass());
                    assert (fieldDescriptor != null) : "Field descriptor defined for " + String.valueOf(definition.getConfigurationClass());
                    mc.returnValue(mc.readStaticField(fieldDescriptor));
                } else if (parent instanceof FieldContainer) {
                    ResultHandle fieldVal;
                    FieldContainer fieldContainer = (FieldContainer)parent;
                    ClassDefinition.ClassMember classMember = fieldContainer.getClassMember();
                    int consumedSegmentsCount = this.generateConsumeSegments((BytecodeCreator)mc, keyIter, classMember.getPropertyName());
                    ResultHandle enclosing = mc.invokeStaticMethod(this.generateGetEnclosing(fieldContainer, type), new ResultHandle[]{keyIter, config});
                    if (RunTimeConfigurationGenerator.isFieldEligibleForDirectAccess(classMember)) {
                        fieldVal = mc.readInstanceField(classMember.getDescriptor(), enclosing);
                    } else {
                        MethodDescriptor getter = this.accessorFinder.getGetterFor(classMember.getDescriptor());
                        fieldVal = mc.invokeStaticMethod(getter, new ResultHandle[]{enclosing});
                    }
                    AssignableResultHandle group = mc.createVariable(Object.class);
                    if (classMember instanceof ClassDefinition.GroupMember && ((ClassDefinition.GroupMember)classMember).isOptional()) {
                        ResultHandle instance;
                        BranchResult isPresent = mc.ifNonZero(mc.invokeVirtualMethod(OPT_IS_PRESENT, fieldVal, new ResultHandle[0]));
                        BytecodeCreator trueBranch = isPresent.trueBranch();
                        BytecodeCreator falseBranch = isPresent.falseBranch();
                        trueBranch.assign(group, trueBranch.invokeVirtualMethod(OPT_GET, fieldVal, new ResultHandle[0]));
                        if (Modifier.isPublic(member.getEnclosingDefinition().getConfigurationClass().getModifiers())) {
                            instance = falseBranch.newInstance(MethodDescriptor.ofConstructor(member.getEnclosingDefinition().getConfigurationClass(), (Class[])new Class[0]), new ResultHandle[0]);
                        } else {
                            MethodDescriptor ctor = this.accessorFinder.getConstructorFor(MethodDescriptor.ofConstructor(member.getEnclosingDefinition().getConfigurationClass(), (Class[])new Class[0]));
                            instance = falseBranch.invokeStaticMethod(ctor, new ResultHandle[0]);
                        }
                        ResultHandle precedingKey = falseBranch.invokeVirtualMethod(NI_GET_ALL_PREVIOUS_SEGMENTS, keyIter, new ResultHandle[0]);
                        ResultHandle nameBuilder = falseBranch.newInstance(SB_NEW_STR, new ResultHandle[]{precedingKey});
                        falseBranch.invokeStaticMethod(this.generateInitGroup(member.getEnclosingDefinition()), new ResultHandle[]{config, nameBuilder, instance});
                        ResultHandle val = falseBranch.invokeStaticMethod(OPT_OF, new ResultHandle[]{instance});
                        if (RunTimeConfigurationGenerator.isFieldEligibleForDirectAccess(member)) {
                            falseBranch.writeInstanceField(member.getDescriptor(), instance, val);
                        } else {
                            MethodDescriptor setter = this.accessorFinder.getSetterFor(classMember.getDescriptor());
                            falseBranch.invokeStaticMethod(setter, new ResultHandle[]{fieldVal, val});
                        }
                        falseBranch.assign(group, instance);
                    } else {
                        mc.assign(group, fieldVal);
                    }
                    this.generateRestoreSegments((BytecodeCreator)mc, keyIter, consumedSegmentsCount);
                    mc.returnValue((ResultHandle)group);
                } else {
                    ResultHandle instance;
                    assert (parent instanceof MapContainer);
                    MapContainer mapContainer = (MapContainer)parent;
                    ResultHandle key = mc.invokeVirtualMethod(NI_GET_PREVIOUS_SEGMENT, keyIter, new ResultHandle[0]);
                    mc.invokeVirtualMethod(NI_PREVIOUS, keyIter, new ResultHandle[0]);
                    ResultHandle map = mc.invokeStaticMethod(this.generateGetEnclosing(mapContainer, type), new ResultHandle[]{keyIter, config});
                    mc.invokeVirtualMethod(NI_NEXT, keyIter, new ResultHandle[0]);
                    ResultHandle existing = mc.invokeInterfaceMethod(MAP_GET, map, new ResultHandle[]{key});
                    mc.ifNull(existing).falseBranch().returnValue(existing);
                    if (Modifier.isPublic(member.getEnclosingDefinition().getConfigurationClass().getModifiers())) {
                        instance = mc.newInstance(MethodDescriptor.ofConstructor(member.getEnclosingDefinition().getConfigurationClass(), (Class[])new Class[0]), new ResultHandle[0]);
                    } else {
                        MethodDescriptor ctor = this.accessorFinder.getConstructorFor(MethodDescriptor.ofConstructor(member.getEnclosingDefinition().getConfigurationClass(), (Class[])new Class[0]));
                        instance = mc.invokeStaticMethod(ctor, new ResultHandle[0]);
                    }
                    ResultHandle precedingKey = mc.invokeVirtualMethod(NI_GET_ALL_PREVIOUS_SEGMENTS, keyIter, new ResultHandle[0]);
                    ResultHandle nameBuilder = mc.newInstance(SB_NEW_STR, new ResultHandle[]{precedingKey});
                    mc.invokeStaticMethod(this.generateInitGroup(member.getEnclosingDefinition()), new ResultHandle[]{config, nameBuilder, instance});
                    mc.invokeInterfaceMethod(MAP_PUT, map, new ResultHandle[]{key, instance});
                    mc.returnValue(instance);
                }
            }
            this.enclosingMemberMethods.put(matchNode, md);
            return md;
        }

        private MethodDescriptor generateGetEnclosing(MapContainer matchNode, Type type) {
            MethodDescriptor md = this.enclosingMemberMethods.get(matchNode);
            if (md != null) {
                return md;
            }
            md = MethodDescriptor.ofMethod((Object)RunTimeConfigurationGenerator.CONFIG_CLASS_NAME, (String)(type.methodPrefix + "GetEnclosing:" + matchNode.getCombinedName()), Object.class, (Object[])new Object[]{NameIterator.class, SmallRyeConfig.class});
            try (MethodCreator mc = this.cc.getMethodCreator(md);){
                mc.setModifiers(8);
                ResultHandle keyIter = mc.getMethodParam(0);
                ResultHandle config = mc.getMethodParam(1);
                Container parent = matchNode.getParent();
                if (parent instanceof FieldContainer) {
                    ResultHandle result;
                    FieldContainer fieldContainer = (FieldContainer)parent;
                    int consumedSegmentsCount = this.generateConsumeSegments((BytecodeCreator)mc, keyIter, fieldContainer.getClassMember().getPropertyName());
                    ResultHandle enclosing = mc.invokeStaticMethod(this.generateGetEnclosing(fieldContainer, type), new ResultHandle[]{keyIter, config});
                    this.generateRestoreSegments((BytecodeCreator)mc, keyIter, consumedSegmentsCount);
                    if (RunTimeConfigurationGenerator.isFieldEligibleForDirectAccess(fieldContainer.getClassMember())) {
                        result = mc.readInstanceField(fieldContainer.getClassMember().getDescriptor(), enclosing);
                    } else {
                        MethodDescriptor getter = this.accessorFinder.getGetterFor(fieldContainer.getClassMember().getDescriptor());
                        result = mc.invokeStaticMethod(getter, new ResultHandle[]{enclosing});
                    }
                    mc.returnValue(result);
                } else {
                    assert (parent instanceof MapContainer);
                    MapContainer mapContainer = (MapContainer)parent;
                    ResultHandle key = mc.invokeVirtualMethod(NI_GET_PREVIOUS_SEGMENT, keyIter, new ResultHandle[0]);
                    mc.invokeVirtualMethod(NI_PREVIOUS, keyIter, new ResultHandle[0]);
                    ResultHandle map = mc.invokeStaticMethod(this.generateGetEnclosing(mapContainer, type), new ResultHandle[]{keyIter, config});
                    mc.invokeVirtualMethod(NI_NEXT, keyIter, new ResultHandle[0]);
                    ResultHandle existing = mc.invokeInterfaceMethod(MAP_GET, map, new ResultHandle[]{key});
                    mc.ifNull(existing).falseBranch().returnValue(existing);
                    ResultHandle instance = mc.newInstance(TM_NEW, new ResultHandle[0]);
                    mc.invokeInterfaceMethod(MAP_PUT, map, new ResultHandle[]{key, instance});
                    mc.returnValue(instance);
                }
            }
            this.enclosingMemberMethods.put(matchNode, md);
            return md;
        }

        private int generateConsumeSegments(BytecodeCreator bc, ResultHandle keyIter, String propertyName) {
            if (propertyName.isEmpty()) {
                return 0;
            }
            bc.invokeVirtualMethod(NI_PREVIOUS, keyIter, new ResultHandle[0]);
            int consumedSegmentsCount = 1;
            int dotIndex = propertyName.indexOf(46);
            while (dotIndex >= 0) {
                bc.invokeVirtualMethod(NI_PREVIOUS, keyIter, new ResultHandle[0]);
                ++consumedSegmentsCount;
                dotIndex = propertyName.indexOf(46, dotIndex + 1);
            }
            return consumedSegmentsCount;
        }

        private void generateRestoreSegments(BytecodeCreator bc, ResultHandle keyIter, int consumedSegmentsCount) {
            for (int i = 0; i < consumedSegmentsCount; ++i) {
                bc.invokeVirtualMethod(NI_NEXT, keyIter, new ResultHandle[0]);
            }
        }

        private FieldDescriptor getOrCreateConverterInstance(Field field) {
            return this.getOrCreateConverterInstance(field, ConverterType.of(field));
        }

        private FieldDescriptor getOrCreateConverterInstance(Field field, ConverterType type) {
            ResultHandle converter;
            FieldDescriptor fd = this.convertersByType.get(type);
            if (fd != null) {
                return fd;
            }
            fd = FieldDescriptor.of((String)this.cc.getClassName(), (String)("conv$" + this.converterIndex++), Converter.class);
            boolean storeConverter = false;
            if (type instanceof Leaf) {
                Leaf leaf = (Leaf)type;
                Class<? extends Converter<?>> convertWith = leaf.getConvertWith();
                if (convertWith != null) {
                    converter = convertWith == HyphenateEnumConverter.class.asSubclass(Converter.class) ? this.converterSetup.newInstance(MethodDescriptor.ofConstructor(convertWith, (Class[])new Class[]{Class.class}), new ResultHandle[]{this.converterSetup.loadClassFromTCCL(type.getLeafType())}) : this.converterSetup.newInstance(MethodDescriptor.ofConstructor(convertWith, (Class[])new Class[0]), new ResultHandle[0]);
                } else {
                    ResultHandle clazzHandle = this.converterSetup.loadClassFromTCCL(leaf.getLeafType());
                    converter = this.converterSetup.invokeVirtualMethod(SRC_GET_CONVERTER, this.clinitConfig, new ResultHandle[]{clazzHandle});
                    storeConverter = true;
                }
            } else if (type instanceof ArrayOf) {
                ArrayOf arrayOf = (ArrayOf)type;
                ResultHandle nestedConv = this.instanceCache.get(this.getOrCreateConverterInstance(field, arrayOf.getElementType()));
                converter = this.converterSetup.invokeStaticMethod(CONVS_NEW_ARRAY_CONVERTER, new ResultHandle[]{nestedConv, this.converterSetup.loadClassFromTCCL(arrayOf.getArrayType())});
            } else if (type instanceof CollectionOf) {
                ResultHandle factory;
                CollectionOf collectionOf = (CollectionOf)type;
                ResultHandle nestedConv = this.instanceCache.get(this.getOrCreateConverterInstance(field, collectionOf.getElementType()));
                Class<?> collectionClass = collectionOf.getCollectionClass();
                if (collectionClass == List.class) {
                    factory = this.converterSetup.invokeStaticMethod(CU_LIST_FACTORY, new ResultHandle[0]);
                } else if (collectionClass == Set.class) {
                    factory = this.converterSetup.invokeStaticMethod(CU_SET_FACTORY, new ResultHandle[0]);
                } else if (collectionClass == SortedSet.class) {
                    factory = this.converterSetup.invokeStaticMethod(CU_SORTED_SET_FACTORY, new ResultHandle[0]);
                } else {
                    throw ReflectUtil.reportError(field, "Unsupported configuration collection type: %s", collectionClass);
                }
                converter = this.converterSetup.invokeStaticMethod(CONVS_NEW_COLLECTION_CONVERTER, new ResultHandle[]{nestedConv, factory});
            } else if (type instanceof LowerBoundCheckOf) {
                LowerBoundCheckOf boundCheckOf = (LowerBoundCheckOf)type;
                converter = this.instanceCache.get(this.getOrCreateConverterInstance(field, boundCheckOf.getClassConverterType()));
            } else if (type instanceof UpperBoundCheckOf) {
                UpperBoundCheckOf boundCheckOf = (UpperBoundCheckOf)type;
                converter = this.instanceCache.get(this.getOrCreateConverterInstance(field, boundCheckOf.getClassConverterType()));
            } else if (type instanceof MinMaxValidated) {
                MinMaxValidated minMaxValidated = (MinMaxValidated)type;
                String min = minMaxValidated.getMin();
                boolean minInclusive = minMaxValidated.isMinInclusive();
                String max = minMaxValidated.getMax();
                boolean maxInclusive = minMaxValidated.isMaxInclusive();
                ResultHandle nestedConv = this.instanceCache.get(this.getOrCreateConverterInstance(field, minMaxValidated.getNestedType()));
                if (min != null) {
                    converter = max != null ? this.converterSetup.invokeStaticMethod(CONVS_RANGE_VALUE_STRING_CONVERTER, new ResultHandle[]{nestedConv, this.converterSetup.load(min), this.converterSetup.load(minInclusive), this.converterSetup.load(max), this.converterSetup.load(maxInclusive)}) : this.converterSetup.invokeStaticMethod(CONVS_MINIMUM_VALUE_STRING_CONVERTER, new ResultHandle[]{nestedConv, this.converterSetup.load(min), this.converterSetup.load(minInclusive)});
                } else {
                    assert (min == null && max != null);
                    converter = this.converterSetup.invokeStaticMethod(CONVS_MAXIMUM_VALUE_STRING_CONVERTER, new ResultHandle[]{nestedConv, this.converterSetup.load(max), this.converterSetup.load(maxInclusive)});
                }
            } else if (type instanceof OptionalOf) {
                OptionalOf optionalOf = (OptionalOf)type;
                ResultHandle nestedConv = this.instanceCache.get(this.getOrCreateConverterInstance(field, optionalOf.getNestedType()));
                converter = this.converterSetup.invokeStaticMethod(CONVS_NEW_OPTIONAL_CONVERTER, new ResultHandle[]{nestedConv});
            } else if (type instanceof PatternValidated) {
                PatternValidated patternValidated = (PatternValidated)type;
                ResultHandle nestedConv = this.instanceCache.get(this.getOrCreateConverterInstance(field, patternValidated.getNestedType()));
                ResultHandle patternStr = this.converterSetup.load(patternValidated.getPatternString());
                converter = this.converterSetup.invokeStaticMethod(CONVS_PATTERN_CONVERTER, new ResultHandle[]{nestedConv, patternStr});
            } else {
                throw Assert.unreachableCode();
            }
            this.cc.getFieldCreator(fd).setModifiers(24);
            this.converterSetup.writeStaticField(fd, converter);
            this.convertersByType.put(type, fd);
            this.instanceCache.put(fd, converter);
            if (storeConverter) {
                this.convertersToRegister.put(fd, type.getLeafType());
            }
            return fd;
        }

        private void generateIsMapped() {
            ConfigPatternMap<Boolean> patterns = new ConfigPatternMap<Boolean>();
            List<ConfigMappings.ConfigClass> configMappings = this.buildTimeConfigResult.getAllMappings();
            for (ConfigMappings.ConfigClass configMapping : configMappings) {
                Set names = ConfigMappings.getProperties((ConfigMappings.ConfigClass)configMapping).keySet();
                for (String name : names) {
                    NameIterator ni = new NameIterator(name);
                    ConfigPatternMap<Boolean> current = patterns;
                    while (ni.hasNext()) {
                        String segment = ni.getNextSegment();
                        ConfigPatternMap<Boolean> child = current.getChild(segment);
                        if (child == null) {
                            child = new ConfigPatternMap();
                            current.addChild(segment, child);
                        }
                        current = child;
                        ni.next();
                    }
                    current.setMatched(true);
                }
            }
            this.generateIsMapped("isMapped", patterns);
        }

        private void generateIsMapped(String methodName, ConfigPatternMap<Boolean> names) {
            MethodDescriptor method = MethodDescriptor.ofMethod((Object)RunTimeConfigurationGenerator.CONFIG_CLASS_NAME, (String)methodName, Boolean.TYPE, (Object[])new Object[]{NameIterator.class});
            MethodCreator mc = this.cc.getMethodCreator(method);
            mc.setModifiers(10);
            ResultHandle nameIterator = mc.getMethodParam(0);
            BranchResult hasNext = mc.ifTrue(mc.invokeVirtualMethod(NI_HAS_NEXT, nameIterator, new ResultHandle[0]));
            try (BytecodeCreator hasNextTrue = hasNext.trueBranch();){
                ArrayDeque<String> childNames = new ArrayDeque<String>();
                for (String childName : names.childNames()) {
                    if (childName.startsWith("*")) {
                        childNames.addLast(childName);
                        continue;
                    }
                    childNames.addFirst(childName);
                }
                for (String childName : childNames) {
                    ConfigPatternMap<Boolean> child = names.getChild(childName);
                    BranchResult nextEquals = hasNextTrue.ifTrue(hasNextTrue.invokeStaticMethod(PU_IS_MAPPED, new ResultHandle[]{nameIterator, hasNextTrue.load(childName)}));
                    BytecodeCreator nextEqualsTrue = nextEquals.trueBranch();
                    try {
                        String childMethodName = methodName + "$" + childName.replace("[*]", "-collection");
                        if (child.getMatched() == null) {
                            this.generateIsMapped(childMethodName, child);
                            nextEqualsTrue.invokeVirtualMethod(NI_NEXT, nameIterator, new ResultHandle[0]);
                            nextEqualsTrue.returnValue(nextEqualsTrue.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RunTimeConfigurationGenerator.CONFIG_CLASS_NAME, (String)childMethodName, Boolean.TYPE, (Object[])new Object[]{NameIterator.class}), new ResultHandle[]{nameIterator}));
                            continue;
                        }
                        nextEqualsTrue.returnBoolean(true);
                    }
                    finally {
                        if (nextEqualsTrue == null) continue;
                        nextEqualsTrue.close();
                    }
                }
                hasNextTrue.returnBoolean(false);
            }
            try (BytecodeCreator hasNextFalse = hasNext.falseBranch();){
                hasNextFalse.returnBoolean(false);
            }
            mc.returnBoolean(false);
            mc.close();
        }

        private void reportUnknown(BytecodeCreator bc, ResultHandle unknownProperty) {
            ResultHandle property = bc.invokeVirtualMethod(NI_GET_NAME, unknownProperty, new ResultHandle[0]);
            ResultHandle unknown = bc.readStaticField(C_UNKNOWN);
            bc.invokeVirtualMethod(HS_ADD, unknown, new ResultHandle[]{property});
        }

        private void reportUnknownRuntime(BytecodeCreator bc, ResultHandle unknownProperty) {
            ResultHandle property = bc.invokeVirtualMethod(NI_GET_NAME, unknownProperty, new ResultHandle[0]);
            ResultHandle unknown = bc.readStaticField(C_UNKNOWN_RUNTIME);
            bc.invokeVirtualMethod(HS_ADD, unknown, new ResultHandle[]{property});
        }

        @Override
        public void close() {
            try {
                this.clinit.close();
            }
            finally {
                this.cc.close();
            }
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public boolean liveReloadPossible;
            private LaunchMode launchMode;
            private ClassOutput classOutput;
            private BuildTimeConfigurationReader.ReadResult buildTimeReadResult;
            private List<Class<?>> additionalTypes;

            Builder() {
            }

            ClassOutput getClassOutput() {
                return this.classOutput;
            }

            public Builder setClassOutput(ClassOutput classOutput) {
                this.classOutput = classOutput;
                return this;
            }

            public Builder setLiveReloadPossible(boolean liveReloadPossible) {
                this.liveReloadPossible = liveReloadPossible;
                return this;
            }

            BuildTimeConfigurationReader.ReadResult getBuildTimeReadResult() {
                return this.buildTimeReadResult;
            }

            public Builder setBuildTimeReadResult(BuildTimeConfigurationReader.ReadResult buildTimeReadResult) {
                this.buildTimeReadResult = buildTimeReadResult;
                return this;
            }

            List<Class<?>> getAdditionalTypes() {
                return this.additionalTypes;
            }

            public Builder setAdditionalTypes(List<Class<?>> additionalTypes) {
                this.additionalTypes = additionalTypes;
                return this;
            }

            public LaunchMode getLaunchMode() {
                return this.launchMode;
            }

            public Builder setLaunchMode(LaunchMode launchMode) {
                this.launchMode = launchMode;
                return this;
            }

            public GenerateOperation build() {
                return new GenerateOperation(this);
            }
        }
    }
}

