/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.CompiledJavaVersionBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.JvmStartupOptimizerArchiveContainerImageBuildItem;
import io.quarkus.deployment.pkg.builditem.JvmStartupOptimizerArchiveRequestedBuildItem;
import io.quarkus.deployment.pkg.builditem.JvmStartupOptimizerArchiveResultBuildItem;
import io.quarkus.deployment.pkg.builditem.JvmStartupOptimizerArchiveType;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.steps.LinuxIDUtil;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.deployment.util.ContainerRuntimeUtil;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.utilities.JavaBinFinder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import org.apache.commons.lang3.SystemUtils;
import org.jboss.logging.Logger;

public class JvmStartupOptimizerArchiveBuildStep {
    private static final Logger log = Logger.getLogger(JvmStartupOptimizerArchiveBuildStep.class);
    public static final String CLASSES_LIST_FILE_NAME = "classes.lst";
    private static final String CONTAINER_IMAGE_BASE_BUILD_DIR = "/tmp/quarkus";
    private static final String CONTAINER_IMAGE_APPCDS_DIR = "/tmp/quarkus/appcds";

    @BuildStep(onlyIf={AppCDSRequired.class})
    public void requested(PackageConfig packageConfig, OutputTargetBuildItem outputTarget, BuildProducer<JvmStartupOptimizerArchiveRequestedBuildItem> producer) throws IOException {
        Path archiveDir = outputTarget.getOutputDirectory().resolve("jvmstartuparchive");
        IoUtils.createOrEmptyDir((Path)archiveDir);
        producer.produce(new JvmStartupOptimizerArchiveRequestedBuildItem(outputTarget.getOutputDirectory().resolve("jvmstartuparchive"), packageConfig.jar().appcds().useAot() ? JvmStartupOptimizerArchiveType.AOT : JvmStartupOptimizerArchiveType.AppCDS));
    }

    @BuildStep(onlyIfNot={NativeOrNativeSourcesBuild.class})
    public void build(Optional<JvmStartupOptimizerArchiveRequestedBuildItem> requested, JarBuildItem jarResult, OutputTargetBuildItem outputTarget, PackageConfig packageConfig, CompiledJavaVersionBuildItem compiledJavaVersion, Optional<JvmStartupOptimizerArchiveContainerImageBuildItem> jvmStartupOptimizerArchiveContainerImage, BuildProducer<JvmStartupOptimizerArchiveResultBuildItem> jvmStartupOptimizerArchive, BuildProducer<ArtifactResultBuildItem> artifactResult) throws Exception {
        Path archivePath;
        boolean isFastJar;
        if (requested.isEmpty()) {
            return;
        }
        String containerImage = this.determineContainerImage(packageConfig, jvmStartupOptimizerArchiveContainerImage);
        String javaBinPath = null;
        if (containerImage == null && !new File(javaBinPath = System.getProperty("java.home") + File.separator + "bin" + File.separator + JavaBinFinder.simpleBinaryName()).canExecute()) {
            log.warnf("In order to create AppCDS the JDK used to build the Quarkus application must contain an executable named '%s' in its 'bin' directory.", (Object)javaBinPath);
            return;
        }
        JvmStartupOptimizerArchiveType archiveType = requested.get().getType();
        log.infof("Launching %s creation process.", (Object)archiveType);
        boolean bl = isFastJar = packageConfig.jar().type() == PackageConfig.JarConfig.JarType.FAST_JAR;
        if (archiveType == JvmStartupOptimizerArchiveType.AppCDS) {
            archivePath = this.createAppCDSFromExit(jarResult, outputTarget, javaBinPath, containerImage, isFastJar);
        } else if (archiveType == JvmStartupOptimizerArchiveType.AOT) {
            archivePath = this.createAot(jarResult, outputTarget, javaBinPath, containerImage, isFastJar);
        } else {
            throw new IllegalStateException("Unsupported archive type: " + String.valueOf((Object)archiveType));
        }
        if (archivePath == null) {
            log.warnf("Unable to create %s.", (Object)archiveType);
            return;
        }
        log.infof("%s archive successfully created at: '%s'.", (Object)archiveType, (Object)archivePath.toAbsolutePath().toString());
        if (containerImage == null) {
            if (archiveType == JvmStartupOptimizerArchiveType.AppCDS) {
                log.infof("To ensure they are loaded properly, run the application jar from its directory and also add the '-XX:SharedArchiveFile=app-cds.jsa' JVM flag.\nMoreover, make sure to use the exact same Java version (%s) to run the application as was used to build it.", (Object)System.getProperty("java.version"));
            } else {
                log.infof("To ensure they are loaded properly, run the application jar from its directory and also add the '-XX:AOTCache=app.aot' JVM flag.\nMoreover, make sure to use the exact same Java version (%s) to run the application as was used to build it.", (Object)System.getProperty("java.version"));
            }
        }
        jvmStartupOptimizerArchive.produce(new JvmStartupOptimizerArchiveResultBuildItem(archivePath));
        artifactResult.produce(new ArtifactResultBuildItem(archivePath, "appCDS", Collections.emptyMap()));
    }

    private String determineContainerImage(PackageConfig packageConfig, Optional<JvmStartupOptimizerArchiveContainerImageBuildItem> jvmStartupOptimizerArchiveContainer) {
        if (!packageConfig.jar().appcds().useContainer()) {
            return null;
        }
        if (packageConfig.jar().appcds().builderImage().isPresent()) {
            return packageConfig.jar().appcds().builderImage().get();
        }
        if (jvmStartupOptimizerArchiveContainer.isPresent()) {
            return jvmStartupOptimizerArchiveContainer.get().getContainerImage();
        }
        return null;
    }

    private List<String> dockerRunCommands(OutputTargetBuildItem outputTarget, String containerImage, String containerWorkingDir) {
        ContainerRuntimeUtil.ContainerRuntime containerRuntime = ContainerRuntimeUtil.detectContainerRuntime(true, new ContainerRuntimeUtil.ContainerRuntime[0]);
        ArrayList<String> command = new ArrayList<String>(10);
        command.add(containerRuntime.getExecutableName());
        command.add("run");
        command.add("-v");
        command.add(outputTarget.getOutputDirectory().toAbsolutePath().toString() + ":/tmp/quarkus:z");
        if (SystemUtils.IS_OS_LINUX) {
            if (containerRuntime.isDocker() && containerRuntime.isRootless()) {
                Collections.addAll(command, "--user", String.valueOf(0));
            } else {
                String uid = LinuxIDUtil.getLinuxID("-ur");
                String gid = LinuxIDUtil.getLinuxID("-gr");
                if (uid != null && gid != null && !uid.isEmpty() && !gid.isEmpty()) {
                    Collections.addAll(command, "--user", uid + ":" + gid);
                    if (containerRuntime.isPodman() && containerRuntime.isRootless()) {
                        command.add("--userns=keep-id");
                    }
                }
            }
        }
        command.add("-w");
        command.add(containerWorkingDir);
        command.add("--rm");
        command.add(containerImage);
        return command;
    }

    private Path createAppCDSFromExit(JarBuildItem jarResult, OutputTargetBuildItem outputTarget, String javaBinPath, String containerImage, boolean isFastJar) {
        ArrayList<String> command;
        ArchivePathsContainer appCDSPathsContainer = ArchivePathsContainer.appCDSFromQuarkusJar(jarResult.getPath());
        Path workingDirectory = appCDSPathsContainer.workingDirectory;
        Path appCDSPath = appCDSPathsContainer.resultingFile;
        boolean debug = log.isDebugEnabled();
        ArrayList<Object> javaArgs = new ArrayList<Object>(debug ? 4 : 3);
        javaArgs.add("-XX:ArchiveClassesAtExit=" + appCDSPath.getFileName().toString());
        javaArgs.add(String.format("-D%s=true", "quarkus.appcds.generate"));
        if (debug) {
            javaArgs.add("-Xlog:cds=debug");
        }
        javaArgs.add("-jar");
        if (containerImage != null) {
            List<String> dockerRunCommand = this.dockerRunCommands(outputTarget, containerImage, (String)(isFastJar ? "/tmp/quarkus/quarkus-app" : "/tmp/quarkus/" + jarResult.getPath().getFileName().toString()));
            command = new ArrayList(dockerRunCommand.size() + 1 + javaArgs.size());
            command.addAll(dockerRunCommand);
            command.add("java");
            command.addAll(javaArgs);
            if (isFastJar) {
                command.add("quarkus-run.jar");
            } else {
                command.add(jarResult.getPath().getFileName().toString());
            }
        } else {
            command = new ArrayList<String>(2 + javaArgs.size());
            command.add(javaBinPath);
            command.addAll(javaArgs);
            if (isFastJar) {
                command.add(jarResult.getLibraryDir().getParent().resolve("quarkus-run.jar").getFileName().toString());
            } else {
                command.add(jarResult.getPath().getFileName().toString());
            }
        }
        return this.launchArchiveCreateCommand(workingDirectory, appCDSPath, command);
    }

    private Path createAot(JarBuildItem jarResult, OutputTargetBuildItem outputTarget, String javaBinPath, String containerImage, boolean isFastJar) {
        ArchivePathsContainer aotConfigPathContainers = ArchivePathsContainer.aotConfFromQuarkusJar(jarResult.getPath());
        Path aotConfPath = this.launchArchiveCreateCommand(aotConfigPathContainers.workingDirectory, aotConfigPathContainers.resultingFile, this.recordAotConfCommand(jarResult, outputTarget, javaBinPath, containerImage, isFastJar, aotConfigPathContainers));
        if (aotConfPath == null) {
            return null;
        }
        ArchivePathsContainer aotPathContainers = ArchivePathsContainer.aotFromQuarkusJar(jarResult.getPath());
        return this.launchArchiveCreateCommand(aotPathContainers.workingDirectory, aotPathContainers.resultingFile, this.createAotCommand(jarResult, outputTarget, javaBinPath, containerImage, isFastJar, aotConfPath));
    }

    private List<String> recordAotConfCommand(JarBuildItem jarResult, OutputTargetBuildItem outputTarget, String javaBinPath, String containerImage, boolean isFastJar, ArchivePathsContainer aotConfigPathContainers) {
        ArrayList<String> command;
        ArrayList<Object> javaArgs = new ArrayList<Object>();
        javaArgs.add("-XX:AOTMode=record");
        javaArgs.add("-XX:AOTConfiguration=" + aotConfigPathContainers.resultingFile.getFileName().toString());
        javaArgs.add(String.format("-D%s=true", "quarkus.appcds.generate"));
        javaArgs.add("-jar");
        if (containerImage != null) {
            List<String> dockerRunCommand = this.dockerRunCommands(outputTarget, containerImage, (String)(isFastJar ? "/tmp/quarkus/quarkus-app" : "/tmp/quarkus/" + jarResult.getPath().getFileName().toString()));
            command = new ArrayList(dockerRunCommand.size() + 1 + javaArgs.size());
            command.addAll(dockerRunCommand);
            command.add("java");
            command.addAll(javaArgs);
            if (isFastJar) {
                command.add("quarkus-run.jar");
            } else {
                command.add(jarResult.getPath().getFileName().toString());
            }
        } else {
            command = new ArrayList<String>(2 + javaArgs.size());
            command.add(javaBinPath);
            command.addAll(javaArgs);
            if (isFastJar) {
                command.add(jarResult.getLibraryDir().getParent().resolve("quarkus-run.jar").getFileName().toString());
            } else {
                command.add(jarResult.getPath().getFileName().toString());
            }
        }
        return command;
    }

    private List<String> createAotCommand(JarBuildItem jarResult, OutputTargetBuildItem outputTarget, String javaBinPath, String containerImage, boolean isFastJar, Path aotConfPath) {
        ArrayList<String> command;
        ArrayList<Object> javaArgs = new ArrayList<Object>();
        javaArgs.add("-XX:AOTMode=create");
        javaArgs.add("-XX:AOTConfiguration=" + aotConfPath.getFileName().toString());
        javaArgs.add("-XX:AOTCache=app.aot");
        javaArgs.add("-jar");
        if (containerImage != null) {
            List<String> dockerRunCommand = this.dockerRunCommands(outputTarget, containerImage, (String)(isFastJar ? "/tmp/quarkus/quarkus-app" : "/tmp/quarkus/" + jarResult.getPath().getFileName().toString()));
            command = new ArrayList(dockerRunCommand.size() + 1 + javaArgs.size());
            command.addAll(dockerRunCommand);
            command.add("java");
            command.addAll(javaArgs);
            if (isFastJar) {
                command.add("quarkus-run.jar");
            } else {
                command.add(jarResult.getPath().getFileName().toString());
            }
        } else {
            command = new ArrayList<String>(2 + javaArgs.size());
            command.add(javaBinPath);
            command.addAll(javaArgs);
            if (isFastJar) {
                command.add(jarResult.getLibraryDir().getParent().resolve("quarkus-run.jar").getFileName().toString());
            } else {
                command.add(jarResult.getPath().getFileName().toString());
            }
        }
        return command;
    }

    private Path launchArchiveCreateCommand(Path workingDirectory, Path archivePath, List<String> command) {
        int exitCode;
        if (log.isDebugEnabled()) {
            log.debugf("Launching command: '%s'", (Object)String.join((CharSequence)" ", command));
        }
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(command).directory(workingDirectory.toFile());
            if (log.isDebugEnabled()) {
                processBuilder.inheritIO();
            } else {
                processBuilder.redirectError(ProcessBuilder.Redirect.DISCARD).redirectOutput(ProcessBuilder.Redirect.DISCARD);
            }
            exitCode = processBuilder.start().waitFor();
        }
        catch (Exception e) {
            log.debug((Object)"Failed to launch process used to create archive.", (Throwable)e);
            return null;
        }
        if (exitCode != 0) {
            log.debugf("The process that was supposed to create an archive exited with error code: %d.", exitCode);
            return null;
        }
        if (!archivePath.toFile().exists()) {
            return null;
        }
        return archivePath;
    }

    private record ArchivePathsContainer(Path workingDirectory, Path resultingFile) {
        public static ArchivePathsContainer appCDSFromQuarkusJar(Path jar) {
            return ArchivePathsContainer.doCreate(jar, "app-cds.jsa");
        }

        public static ArchivePathsContainer aotConfFromQuarkusJar(Path jar) {
            return ArchivePathsContainer.doCreate(jar, "app.aotconf");
        }

        public static ArchivePathsContainer aotFromQuarkusJar(Path jar) {
            return ArchivePathsContainer.doCreate(jar, "app.aot");
        }

        private static ArchivePathsContainer doCreate(Path jar, String fileName) {
            Path workingDirectory = jar.getParent();
            Path appCDSPath = workingDirectory.resolve(fileName);
            if (appCDSPath.toFile().exists()) {
                try {
                    Files.delete(appCDSPath);
                }
                catch (IOException e) {
                    log.debugf((Throwable)e, "Unable to delete existing '%s' file.", (Object)fileName);
                }
            }
            return new ArchivePathsContainer(workingDirectory, appCDSPath);
        }
    }

    static class AppCDSRequired
    implements BooleanSupplier {
        private final PackageConfig packageConfig;
        private final LaunchMode launchMode;

        AppCDSRequired(PackageConfig packageConfig, LaunchMode launchMode) {
            this.packageConfig = packageConfig;
            this.launchMode = launchMode;
        }

        @Override
        public boolean getAsBoolean() {
            if (this.launchMode != LaunchMode.NORMAL) {
                return false;
            }
            return this.packageConfig.jar().appcds().enabled() && this.packageConfig.jar().enabled();
        }
    }
}

