/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileUtil {
    public static void deleteIfExists(Path path) throws IOException {
        BasicFileAttributes attributes;
        try {
            attributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException ignored) {
            return;
        }
        if (attributes.isDirectory()) {
            FileUtil.deleteDirectoryIfExists(path);
        } else if (attributes.isRegularFile()) {
            Files.deleteIfExists(path);
        }
    }

    public static void deleteDirectory(Path directory) throws IOException {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            return;
        }
        FileUtil.deleteDirectoryIfExists(directory);
    }

    private static void deleteDirectoryIfExists(Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                try {
                    Files.delete(file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                try {
                    Files.delete(dir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static byte[] readFileContents(InputStream inputStream) throws IOException {
        return inputStream.readAllBytes();
    }

    public static String translateToVolumePath(String windowsStylePath) {
        String translated = windowsStylePath.replace('\\', '/');
        Pattern p = Pattern.compile("^(\\w)(?:$|:(/)?(.*))");
        Matcher m = p.matcher(translated);
        if (m.matches()) {
            String slash = Optional.ofNullable(m.group(2)).orElse("/");
            String path = Optional.ofNullable(m.group(3)).orElse("");
            return "/" + m.group(1).toLowerCase() + slash + path;
        }
        return translated;
    }
}

