/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.SupplierMap;
import io.quarkus.deployment.builditem.Startable;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class DevServicesResultBuildItem
extends MultiBuildItem {
    private final String name;
    private final String description;
    private final String containerId;
    private final Map<String, String> config;
    private final String serviceName;
    private final Object serviceConfig;
    private final Supplier<Startable> startableSupplier;
    private final Consumer<Startable> postStartAction;
    private final Map<String, Function<Startable, String>> applicationConfigProvider;

    public static DiscoveredServiceBuilder discovered() {
        return new DiscoveredServiceBuilder();
    }

    public static <T extends Startable> OwnedServiceBuilder<T> owned() {
        return new OwnedServiceBuilder();
    }

    @Deprecated
    public DevServicesResultBuildItem(String name, String containerId, Map<String, String> config) {
        this(name, null, containerId, config);
    }

    @Deprecated
    public DevServicesResultBuildItem(String name, String description, String containerId, Map<String, String> config) {
        this.name = name;
        this.description = description;
        this.containerId = containerId;
        this.config = config;
        this.serviceName = null;
        this.serviceConfig = null;
        this.applicationConfigProvider = null;
        this.startableSupplier = null;
        this.postStartAction = null;
    }

    @Deprecated
    public DevServicesResultBuildItem(String name, String description, String serviceName, Object serviceConfig, Map<String, String> config, Supplier<Startable> startableSupplier, Consumer<Startable> postStartAction, Map<String, Function<Startable, String>> applicationConfigProvider) {
        this.name = name;
        this.description = description;
        this.containerId = null;
        this.config = config == null ? Collections.emptyMap() : Collections.unmodifiableMap(config);
        this.serviceName = serviceName;
        this.serviceConfig = serviceConfig;
        this.startableSupplier = startableSupplier;
        this.postStartAction = postStartAction;
        this.applicationConfigProvider = applicationConfigProvider;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public boolean isStartable() {
        return this.startableSupplier != null;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Object getServiceConfig() {
        return this.serviceConfig;
    }

    public Supplier<Startable> getStartableSupplier() {
        return this.startableSupplier;
    }

    public Consumer<Startable> getPostStartAction() {
        return this.postStartAction;
    }

    public Map<String, Function<Startable, String>> getApplicationConfigProvider() {
        return this.applicationConfigProvider;
    }

    public Map<String, String> getConfig(Startable startable) {
        SupplierMap<String, String> map = new SupplierMap<String, String>();
        if (this.config != null && !this.config.isEmpty()) {
            map.putAll(this.config);
        }
        for (Map.Entry<String, Function<Startable, String>> entry : this.applicationConfigProvider.entrySet()) {
            map.put(entry.getKey(), (String)((Object)((Supplier<String>)() -> (String)((Function)entry.getValue()).apply(startable))));
        }
        return map;
    }

    public static class DiscoveredServiceBuilder {
        private String name;
        private String containerId;
        private Map<String, String> config;
        private String description;

        public DiscoveredServiceBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DiscoveredServiceBuilder feature(Feature feature) {
            this.name = feature.getName();
            return this;
        }

        public DiscoveredServiceBuilder containerId(String containerId) {
            this.containerId = containerId;
            return this;
        }

        public DiscoveredServiceBuilder config(Map<String, String> config) {
            this.config = config;
            return this;
        }

        public DiscoveredServiceBuilder description(String description) {
            this.description = description;
            return this;
        }

        public DevServicesResultBuildItem build() {
            return new DevServicesResultBuildItem(this.name, this.description, this.containerId, this.config);
        }
    }

    public static class OwnedServiceBuilder<T extends Startable> {
        private String name;
        private String description;
        private Map<String, String> config;
        private String serviceName;
        private Object serviceConfig;
        private Supplier<? extends Startable> startableSupplier;
        private Consumer<? extends Startable> postStartAction;
        private Map<String, Function<Startable, String>> applicationConfigProvider;

        public OwnedServiceBuilder<T> name(String name) {
            this.name = name;
            return this;
        }

        public OwnedServiceBuilder<T> feature(Feature feature) {
            this.name = feature.getName();
            return this;
        }

        public OwnedServiceBuilder<T> description(String description) {
            this.description = description;
            return this;
        }

        public OwnedServiceBuilder<T> config(Map<String, String> config) {
            this.config = config;
            return this;
        }

        public OwnedServiceBuilder<T> serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public OwnedServiceBuilder<T> serviceConfig(Object serviceConfig) {
            this.serviceConfig = serviceConfig;
            return this;
        }

        public <S extends Startable> OwnedServiceBuilder<S> startable(Supplier<S> startableSupplier) {
            this.startableSupplier = startableSupplier;
            return this;
        }

        public OwnedServiceBuilder<T> postStartHook(Consumer<T> postStartAction) {
            this.postStartAction = postStartAction;
            return this;
        }

        public OwnedServiceBuilder<T> configProvider(Map<String, Function<T, String>> applicationConfigProvider) {
            this.applicationConfigProvider = applicationConfigProvider;
            return this;
        }

        public DevServicesResultBuildItem build() {
            return new DevServicesResultBuildItem(this.name, this.description, this.serviceName, this.serviceConfig, this.config, this.startableSupplier, this.postStartAction, this.applicationConfigProvider);
        }
    }

    @Deprecated
    public static class RunningDevService
    implements Closeable {
        protected final String name;
        protected final String description;
        protected final String containerId;
        protected final Map<String, String> config;
        protected final Closeable closeable;
        protected volatile boolean isRunning = true;

        private static Map<String, String> mapOf(String key, String value) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(key, value);
            return map;
        }

        public RunningDevService(String name, String containerId, Closeable closeable, String key, String value) {
            this(name, null, containerId, closeable, RunningDevService.mapOf(key, value));
        }

        public RunningDevService(String name, String description, String containerId, Closeable closeable, String key, String value) {
            this(name, description, containerId, closeable, RunningDevService.mapOf(key, value));
        }

        public RunningDevService(String name, String containerId, Closeable closeable, Map<String, String> config) {
            this(name, null, containerId, closeable, config);
        }

        public RunningDevService(String name, String description, String containerId, Closeable closeable, Map<String, String> config) {
            this.name = name;
            this.description = description;
            this.containerId = containerId;
            this.closeable = closeable;
            this.config = Collections.unmodifiableMap(config);
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getContainerId() {
            return this.containerId;
        }

        public Map<String, String> getConfig() {
            return this.config;
        }

        public Closeable getCloseable() {
            return this.closeable;
        }

        public boolean isOwner() {
            return this.closeable != null;
        }

        @Override
        public void close() throws IOException {
            if (this.closeable != null) {
                this.closeable.close();
                this.isRunning = false;
            }
        }

        public DevServicesResultBuildItem toBuildItem() {
            return DevServicesResultBuildItem.discovered().name(this.name).description(this.description).containerId(this.getContainerId()).config(this.getConfig()).build();
        }
    }
}

