/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.jar;

import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.builditem.TransformedClassesBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.jar.AbstractLegacyThinJarBuilder;
import io.quarkus.maven.dependency.ArtifactKey;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.jboss.logging.Logger;

public class LegacyThinJarBuilder
extends AbstractLegacyThinJarBuilder<JarBuildItem> {
    private static final Logger LOG = Logger.getLogger(LegacyThinJarBuilder.class);

    public LegacyThinJarBuilder(CurateOutcomeBuildItem curateOutcome, OutputTargetBuildItem outputTarget, ApplicationInfoBuildItem applicationInfo, PackageConfig packageConfig, MainClassBuildItem mainClass, ApplicationArchivesBuildItem applicationArchives, TransformedClassesBuildItem transformedClasses, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedResourceBuildItem> generatedResources, Set<ArtifactKey> removedArtifactKeys, ExecutorService executorService) {
        super(curateOutcome, outputTarget, applicationInfo, packageConfig, mainClass, applicationArchives, transformedClasses, generatedClasses, generatedResources, removedArtifactKeys, executorService);
    }

    @Override
    public JarBuildItem build() throws IOException {
        Path runnerJar = this.outputTarget.getOutputDirectory().resolve(this.outputTarget.getBaseName() + this.packageConfig.computedRunnerSuffix() + ".jar");
        Path libDir = this.outputTarget.getOutputDirectory().resolve("lib");
        Files.deleteIfExists(runnerJar);
        IoUtils.createOrEmptyDir((Path)libDir);
        LOG.info((Object)("Building thin jar: " + String.valueOf(runnerJar)));
        this.doBuild(runnerJar, libDir);
        return new JarBuildItem(runnerJar, null, libDir, this.packageConfig.jar().type(), LegacyThinJarBuilder.suffixToClassifier(this.packageConfig.computedRunnerSuffix()));
    }
}

