/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.NativeConfig;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.runtime.LocalesBuildTimeConfig;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Locale;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class LocaleProcessor {
    private static final Logger log = Logger.getLogger(LocaleProcessor.class);
    public static final String DEPRECATED_USER_LANGUAGE_WARNING = "Your application is setting the deprecated 'quarkus.native.user-language' configuration property. Please, consider using only 'quarkus.default-locale' configuration property instead.";
    public static final String DEPRECATED_USER_COUNTRY_WARNING = "Your application is setting the deprecated 'quarkus.native.user-country' configuration property. Please, consider using only 'quarkus.default-locale' configuration property instead.";

    @BuildStep(onlyIf={NativeBuild.class, NonDefaultLocale.class})
    void nativeResources(BuildProducer<NativeImageResourceBundleBuildItem> resources) {
        resources.produce(new NativeImageResourceBundleBuildItem("sun.util.resources.LocaleNames", "java.base"));
        resources.produce(new NativeImageResourceBundleBuildItem("sun.util.resources.CurrencyNames", "java.base"));
    }

    @BuildStep(onlyIf={NativeBuild.class, NonDefaultLocale.class})
    ReflectiveClassBuildItem setupReflectionClasses() {
        return ReflectiveClassBuildItem.builder("sun.util.resources.provider.SupplementaryLocaleDataProvider", "sun.util.resources.provider.LocaleDataProvider").build();
    }

    @BuildStep(onlyIf={NativeBuild.class, NonDefaultLocale.class})
    void servicesResource(BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<GeneratedResourceBuildItem> generatedResources) {
        String r1 = "META-INF/services/sun.util.resources.LocaleData$SupplementaryResourceBundleProvider";
        String r2 = "META-INF/services/sun.util.resources.LocaleData$CommonResourceBundleProvider";
        nativeImageResources.produce(new NativeImageResourceBuildItem("META-INF/services/sun.util.resources.LocaleData$SupplementaryResourceBundleProvider", "META-INF/services/sun.util.resources.LocaleData$CommonResourceBundleProvider"));
        generatedResources.produce(new GeneratedResourceBuildItem("META-INF/services/sun.util.resources.LocaleData$SupplementaryResourceBundleProvider", "sun.util.resources.provider.SupplementaryLocaleDataProvider".getBytes(StandardCharsets.UTF_8)));
        generatedResources.produce(new GeneratedResourceBuildItem("META-INF/services/sun.util.resources.LocaleData$CommonResourceBundleProvider", "sun.util.resources.provider.LocaleDataProvider".getBytes(StandardCharsets.UTF_8)));
    }

    @BuildStep(onlyIf={NativeBuild.class})
    void setDefaults(BuildProducer<NativeImageSystemPropertyBuildItem> buildtimeSystemProperties, NativeConfig nativeConfig, LocalesBuildTimeConfig localesBuildTimeConfig) {
        String country;
        String language = LocaleProcessor.nativeImageUserLanguage(nativeConfig, localesBuildTimeConfig);
        if (!language.isEmpty()) {
            buildtimeSystemProperties.produce(new NativeImageSystemPropertyBuildItem("user.language", language));
        }
        if (!(country = LocaleProcessor.nativeImageUserCountry(nativeConfig, localesBuildTimeConfig)).isEmpty()) {
            buildtimeSystemProperties.produce(new NativeImageSystemPropertyBuildItem("user.country", country));
        }
    }

    @Deprecated
    public static String nativeImageUserLanguage(NativeConfig nativeConfig, LocalesBuildTimeConfig localesBuildTimeConfig) {
        String language = System.getProperty("user.language", "en");
        if (localesBuildTimeConfig.defaultLocale().isPresent()) {
            language = ((Locale)localesBuildTimeConfig.defaultLocale().get()).getLanguage();
        }
        if (nativeConfig.userLanguage().isPresent()) {
            log.warn((Object)DEPRECATED_USER_LANGUAGE_WARNING);
            language = nativeConfig.userLanguage().get();
        }
        return language;
    }

    @Deprecated
    public static String nativeImageUserCountry(NativeConfig nativeConfig, LocalesBuildTimeConfig localesBuildTimeConfig) {
        String country = System.getProperty("user.country", "");
        if (localesBuildTimeConfig.defaultLocale().isPresent()) {
            country = ((Locale)localesBuildTimeConfig.defaultLocale().get()).getCountry();
        }
        if (nativeConfig.userCountry().isPresent()) {
            log.warn((Object)DEPRECATED_USER_COUNTRY_WARNING);
            country = nativeConfig.userCountry().get();
        }
        return country;
    }

    public static String nativeImageIncludeLocales(NativeConfig nativeConfig, LocalesBuildTimeConfig localesBuildTimeConfig) {
        HashSet<Locale> additionalLocales = new HashSet<Locale>(localesBuildTimeConfig.locales());
        if (additionalLocales.contains(Locale.ROOT)) {
            return "all";
        }
        if (nativeConfig.userCountry().isPresent() && nativeConfig.userLanguage().isPresent()) {
            additionalLocales.add(new Locale(nativeConfig.userLanguage().get(), nativeConfig.userCountry().get()));
        } else if (nativeConfig.userLanguage().isPresent()) {
            additionalLocales.add(new Locale(nativeConfig.userLanguage().get()));
        } else if (localesBuildTimeConfig.defaultLocale().isPresent()) {
            additionalLocales.add((Locale)localesBuildTimeConfig.defaultLocale().get());
        }
        return additionalLocales.stream().map(l -> l.getLanguage() + (String)(l.getCountry().isEmpty() ? "" : "-" + l.getCountry())).collect(Collectors.joining(","));
    }

    static final class NonDefaultLocale
    implements BooleanSupplier {
        private final NativeConfig nativeConfig;
        private final LocalesBuildTimeConfig localesBuildTimeConfig;

        public NonDefaultLocale(NativeConfig nativeConfig, LocalesBuildTimeConfig localesBuildTimeConfig) {
            this.nativeConfig = nativeConfig;
            this.localesBuildTimeConfig = localesBuildTimeConfig;
        }

        @Override
        public boolean getAsBoolean() {
            return this.nativeConfig.userLanguage().isPresent() && !Locale.getDefault().getLanguage().equals(this.nativeConfig.userLanguage().get()) || this.nativeConfig.userCountry().isPresent() && !Locale.getDefault().getCountry().equals(this.nativeConfig.userCountry().get()) || this.localesBuildTimeConfig.defaultLocale().isPresent() && !Locale.getDefault().equals(this.localesBuildTimeConfig.defaultLocale().get()) || this.localesBuildTimeConfig.locales().stream().anyMatch(l -> !Locale.getDefault().equals(l));
        }
    }
}

