/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem;

import io.quarkus.builder.item.MultiBuildItem;

public final class GeneratedClassBuildItem
extends MultiBuildItem {
    final boolean applicationClass;
    final String name;
    String binaryName;
    String internalName;
    final byte[] classData;
    final String source;

    public GeneratedClassBuildItem(boolean applicationClass, String name, byte[] classData) {
        this(applicationClass, name, classData, null);
    }

    public GeneratedClassBuildItem(boolean applicationClass, String name, byte[] classData, String source) {
        if (name.startsWith("/")) {
            throw new IllegalArgumentException("Name cannot start with '/':" + name);
        }
        this.applicationClass = applicationClass;
        this.name = name;
        this.classData = classData;
        this.source = source;
    }

    public boolean isApplicationClass() {
        return this.applicationClass;
    }

    @Deprecated(forRemoval=true)
    public String getName() {
        return this.name;
    }

    public String binaryName() {
        String binaryName = this.binaryName;
        if (binaryName == null) {
            binaryName = this.binaryName = this.name.replace('/', '.');
        }
        return binaryName;
    }

    public String internalName() {
        String internalName = this.internalName;
        if (internalName == null) {
            internalName = this.internalName = this.name.replace('.', '/');
        }
        return internalName;
    }

    public byte[] getClassData() {
        return this.classData;
    }

    public String getSource() {
        return this.source;
    }

    public String toString() {
        return "GeneratedClassBuildItem[" + this.binaryName() + "]";
    }
}

