/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.runtime.ResettableSystemProperties;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

public abstract class IsContainerRuntimeWorking
implements BooleanSupplier {
    private static final Logger LOGGER = Logger.getLogger(IsContainerRuntimeWorking.class);
    private static final int DOCKER_HOST_CHECK_TIMEOUT = 1000;
    private final List<Strategy> strategies;

    protected IsContainerRuntimeWorking(List<Strategy> strategies) {
        this.strategies = strategies;
    }

    @Override
    public boolean getAsBoolean() {
        for (Strategy strategy : this.strategies) {
            LOGGER.debugf("Checking container runtime Environment using strategy %s", (Object)strategy.getClass().getName());
            Result result = (Result)((Object)strategy.get());
            if (result != Result.AVAILABLE) continue;
            return true;
        }
        return false;
    }

    protected static interface Strategy
    extends Supplier<Result> {
    }

    protected static enum Result {
        AVAILABLE,
        UNAVAILABLE,
        UNKNOWN;

    }

    protected static class DockerHostStrategy
    implements Strategy {
        private static final String UNIX_SCHEME = "unix";
        private final boolean silent;

        public DockerHostStrategy() {
            this.silent = false;
        }

        public DockerHostStrategy(boolean silent) {
            this.silent = silent;
        }

        @Override
        public Result get() {
            block15: {
                Result result;
                String dockerHost = System.getenv("DOCKER_HOST");
                if (dockerHost == null) {
                    return Result.UNKNOWN;
                }
                URI dockerHostUri = new URI(dockerHost);
                if (UNIX_SCHEME.equals(dockerHostUri.getScheme())) {
                    Path dockerSocketPath = Path.of(dockerHostUri.getPath(), new String[0]);
                    if (Files.isWritable(dockerSocketPath)) {
                        return Result.AVAILABLE;
                    }
                    if (!this.silent) {
                        LOGGER.warnf("Unix socket defined in DOCKER_HOST %s is not writable, make sure Docker is running on the specified host", (Object)dockerHost);
                    }
                    break block15;
                }
                Socket s = new Socket();
                try {
                    s.connect(new InetSocketAddress(dockerHostUri.getHost(), dockerHostUri.getPort()), 1000);
                    result = Result.AVAILABLE;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            try {
                                s.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            if (!this.silent) {
                                LOGGER.warnf("Unable to connect to DOCKER_HOST URI %s, make sure Docker is running on the specified host", (Object)dockerHost);
                            }
                        }
                    }
                    catch (IllegalArgumentException | URISyntaxException e) {
                        LOGGER.warnf("Unable to parse DOCKER_HOST URI %s, it will be ignored for working Docker detection", (Object)dockerHost);
                    }
                }
                s.close();
                return result;
            }
            return Result.UNKNOWN;
        }
    }

    protected static class TestContainersStrategy
    implements Strategy {
        private final boolean silent;

        protected TestContainersStrategy(boolean silent) {
            this.silent = silent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Result get() {
            try (StartupLogCompressor compressor = new StartupLogCompressor("Checking Docker Environment", Optional.empty(), null, s -> s.getName().startsWith("ducttape"));){
                Result result;
                block13: {
                    ResettableSystemProperties ignored = ResettableSystemProperties.of((String)"api.version", (String)"1.44");
                    try {
                        Class<?> dockerClientFactoryClass = Thread.currentThread().getContextClassLoader().loadClass("org.testcontainers.DockerClientFactory");
                        Object dockerClientFactoryInstance = dockerClientFactoryClass.getMethod("instance", new Class[0]).invoke(null, new Object[0]);
                        Class<?> configurationClass = Thread.currentThread().getContextClassLoader().loadClass("org.testcontainers.utility.TestcontainersConfiguration");
                        Object configurationInstance = configurationClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                        String oldReusePropertyValue = (String)configurationClass.getMethod("getEnvVarOrUserProperty", String.class, String.class).invoke(configurationInstance, "testcontainers.reuse.enable", "false");
                        Method updateUserConfigMethod = configurationClass.getMethod("updateUserConfig", String.class, String.class);
                        updateUserConfigMethod.invoke(configurationInstance, "testcontainers.reuse.enable", "true");
                        Class<?> dockerClientProviderStrategyClass = Thread.currentThread().getContextClassLoader().loadClass("org.testcontainers.dockerclient.DockerClientProviderStrategy");
                        Field failFastAlwaysField = dockerClientProviderStrategyClass.getDeclaredField("FAIL_FAST_ALWAYS");
                        failFastAlwaysField.setAccessible(true);
                        AtomicBoolean failFastAlways = (AtomicBoolean)failFastAlwaysField.get(null);
                        failFastAlways.set(false);
                        boolean isAvailable = (Boolean)dockerClientFactoryClass.getMethod("isDockerAvailable", new Class[0]).invoke(dockerClientFactoryInstance, new Object[0]);
                        if (!isAvailable && !this.silent) {
                            compressor.closeAndDumpCaptured();
                        }
                        updateUserConfigMethod.invoke(configurationInstance, "testcontainers.reuse.enable", oldReusePropertyValue);
                        Result result2 = result = isAvailable ? Result.AVAILABLE : Result.UNAVAILABLE;
                        if (ignored == null) break block13;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (ignored != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                            if (!this.silent) {
                                compressor.closeAndDumpCaptured();
                                LOGGER.debug((Object)"Unable to use Testcontainers to determine if Docker is working", (Throwable)e);
                            }
                            Result result3 = Result.UNKNOWN;
                            return result3;
                        }
                    }
                    ignored.close();
                }
                return result;
            }
        }
    }
}

