/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.pkg.builditem.BuildSystemTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.CompiledJavaVersionBuildItem;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.logging.Logger;

public class CompiledJavaVersionBuildStep {
    private static final Logger log = Logger.getLogger(CompiledJavaVersionBuildStep.class);

    @BuildStep
    public CompiledJavaVersionBuildItem compiledJavaVersion(BuildSystemTargetBuildItem buildSystemTarget) {
        if (buildSystemTarget.getOutputDirectory() == null || !Files.exists(buildSystemTarget.getOutputDirectory(), new LinkOption[0])) {
            log.debug((Object)"Skipping because output directory does not exist");
            return CompiledJavaVersionBuildItem.unknown();
        }
        final AtomicReference<Object> majorVersion = new AtomicReference<Object>(null);
        try {
            log.debugf("Walking directory '%s'", (Object)buildSystemTarget.getOutputDirectory().toAbsolutePath().toString());
            Files.walkFileTree(buildSystemTarget.getOutputDirectory(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (!file.getFileName().toString().endsWith(".class")) return FileVisitResult.CONTINUE;
                    log.debugf("Checking file '%s'", (Object)file.toAbsolutePath().toString());
                    try (FileInputStream in = new FileInputStream(file.toFile());){
                        DataInputStream data = new DataInputStream(in);
                        if (-889275714 != data.readInt()) return FileVisitResult.CONTINUE;
                        data.readUnsignedShort();
                        int v = data.readUnsignedShort();
                        majorVersion.set(v);
                        log.debugf("Determined compile java version to be %d", v);
                        FileVisitResult fileVisitResult = FileVisitResult.TERMINATE;
                        return fileVisitResult;
                    }
                    catch (IOException e) {
                        log.debugf((Throwable)e, "Encountered exception while processing file '%s'", (Object)file.toAbsolutePath().toString());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (majorVersion.get() == null) {
            log.debug((Object)"No .class files located");
            return CompiledJavaVersionBuildItem.unknown();
        }
        return CompiledJavaVersionBuildItem.fromMajorJavaVersion((Integer)majorVersion.get());
    }
}

