/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.LambdaCapturingTypeBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.steps.KotlinUtil;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.runtime.annotations.RegisterForReflection;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.logging.Logger;

public class RegisterForReflectionBuildStep {
    private static final Logger log = Logger.getLogger(RegisterForReflectionBuildStep.class);

    @BuildStep
    public void build(CombinedIndexBuildItem combinedIndexBuildItem, Capabilities capabilities, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveClassHierarchy, BuildProducer<LambdaCapturingTypeBuildItem> lambdaCapturingTypeProducer) {
        ReflectiveHierarchyBuildItem.Builder builder = new ReflectiveHierarchyBuildItem.Builder();
        HashSet<DotName> processedReflectiveHierarchies = new HashSet<DotName>();
        IndexView index = combinedIndexBuildItem.getComputingIndex();
        for (AnnotationInstance i : combinedIndexBuildItem.getIndex().getAnnotations(DotName.createSimple((String)RegisterForReflection.class.getName()))) {
            String[] classNames;
            int n;
            boolean methods = i.valueWithDefault(index, "methods").asBoolean();
            boolean fields = i.valueWithDefault(index, "fields").asBoolean();
            boolean ignoreNested = i.valueWithDefault(index, "ignoreNested").asBoolean();
            boolean serialization = i.valueWithDefault(index, "serialization").asBoolean();
            boolean unsafeAllocated = i.valueWithDefault(index, "unsafeAllocated").asBoolean();
            boolean registerFullHierarchyValue = i.valueWithDefault(index, "registerFullHierarchy").asBoolean();
            AnnotationValue targetsValue = i.value("targets");
            AnnotationValue classNamesValue = i.value("classNames");
            AnnotationValue lambdaCapturingTypesValue = i.value("lambdaCapturingTypes");
            if (lambdaCapturingTypesValue != null) {
                for (String lambdaCapturingType : lambdaCapturingTypesValue.asStringArray()) {
                    lambdaCapturingTypeProducer.produce(new LambdaCapturingTypeBuildItem(lambdaCapturingType));
                }
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (targetsValue == null && classNamesValue == null) {
                ClassInfo classInfo = i.target().asClass();
                if (capabilities.isPresent("io.quarkus.kotlin") && ignoreNested && KotlinUtil.isKotlinClass(classInfo)) {
                    ignoreNested = false;
                }
                this.registerClass(classLoader, classInfo.name().toString(), methods, fields, ignoreNested, serialization, unsafeAllocated, reflectiveClass, reflectiveClassHierarchy, processedReflectiveHierarchies, registerFullHierarchyValue, builder);
                continue;
            }
            if (targetsValue != null) {
                Type[] targets;
                Type[] typeArray = targets = targetsValue.asClassArray();
                int n2 = typeArray.length;
                for (n = 0; n < n2; ++n) {
                    Type type = typeArray[n];
                    this.registerClass(classLoader, type.name().toString(), methods, fields, ignoreNested, serialization, unsafeAllocated, reflectiveClass, reflectiveClassHierarchy, processedReflectiveHierarchies, registerFullHierarchyValue, builder);
                }
            }
            if (classNamesValue == null) continue;
            String[] stringArray = classNames = classNamesValue.asStringArray();
            int n3 = stringArray.length;
            for (n = 0; n < n3; ++n) {
                String className = stringArray[n];
                this.registerClass(classLoader, className, methods, fields, ignoreNested, serialization, unsafeAllocated, reflectiveClass, reflectiveClassHierarchy, processedReflectiveHierarchies, registerFullHierarchyValue, builder);
            }
        }
    }

    private void registerClass(ClassLoader classLoader, String className, boolean methods, boolean fields, boolean ignoreNested, boolean serialization, boolean unsafeAllocated, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveClassHierarchy, Set<DotName> processedReflectiveHierarchies, boolean registerFullHierarchyValue, ReflectiveHierarchyBuildItem.Builder builder) {
        reflectiveClass.produce(serialization ? ReflectiveClassBuildItem.builder(className).serialization().unsafeAllocated(unsafeAllocated).build() : ReflectiveClassBuildItem.builder(className).constructors().methods(methods).fields(fields).unsafeAllocated(unsafeAllocated).build());
        if (registerFullHierarchyValue) {
            this.registerClassDependencies(reflectiveClassHierarchy, classLoader, processedReflectiveHierarchies, methods, builder, className);
        }
        if (ignoreNested) {
            return;
        }
        try {
            Class<?>[] declaredClasses;
            for (Class<?> clazz : declaredClasses = classLoader.loadClass(className).getDeclaredClasses()) {
                this.registerClass(classLoader, clazz.getName(), methods, fields, false, serialization, unsafeAllocated, reflectiveClass, reflectiveClassHierarchy, processedReflectiveHierarchies, registerFullHierarchyValue, builder);
            }
        }
        catch (ClassNotFoundException e) {
            log.warnf((Throwable)e, "Failed to load Class %s", (Object)className);
        }
    }

    private void registerClassDependencies(BuildProducer<ReflectiveHierarchyBuildItem> reflectiveClassHierarchy, ClassLoader classLoader, Set<DotName> processedReflectiveHierarchies, boolean methods, ReflectiveHierarchyBuildItem.Builder builder, String className) {
        try {
            DotName dotName = DotName.createSimple((String)className);
            if (!processedReflectiveHierarchies.contains(dotName) && !ReflectiveHierarchyBuildItem.DefaultIgnoreTypePredicate.INSTANCE.test(dotName)) {
                processedReflectiveHierarchies.add(dotName);
                Index indexView = Index.of((Class[])new Class[]{classLoader.loadClass(className)});
                reflectiveClassHierarchy.produce(builder.type(Type.create((DotName)dotName, (Type.Kind)Type.Kind.CLASS)).index((IndexView)indexView).build());
                ClassInfo classInfo = indexView.getClassByName(dotName);
                if (methods) {
                    this.addMethodsForReflection(reflectiveClassHierarchy, classLoader, processedReflectiveHierarchies, (IndexView)indexView, dotName, builder, classInfo, methods);
                }
                this.registerClassFields(reflectiveClassHierarchy, classLoader, processedReflectiveHierarchies, (IndexView)indexView, dotName, builder, classInfo, methods);
            }
        }
        catch (IOException | ClassNotFoundException ignored) {
            log.error((Object)("Cannot load class for reflection: " + className));
        }
    }

    private void addMethodsForReflection(BuildProducer<ReflectiveHierarchyBuildItem> reflectiveClassHierarchy, ClassLoader classLoader, Set<DotName> processedReflectiveHierarchies, IndexView indexView, DotName initialName, ReflectiveHierarchyBuildItem.Builder builder, ClassInfo classInfo, boolean methods) {
        List methodList = classInfo.methods();
        for (MethodInfo methodInfo : methodList) {
            if (methodInfo.parameters().size() > 0 || Modifier.isStatic(methodInfo.flags()) || methodInfo.returnType().kind() == Type.Kind.VOID || methodInfo.returnType().kind() == Type.Kind.PRIMITIVE) continue;
            this.registerType(reflectiveClassHierarchy, classLoader, processedReflectiveHierarchies, methods, builder, RegisterForReflectionBuildStep.getMethodReturnType(indexView, initialName, classInfo, methodInfo));
        }
    }

    private void registerClassFields(BuildProducer<ReflectiveHierarchyBuildItem> reflectiveClassHierarchy, ClassLoader classLoader, Set<DotName> processedReflectiveHierarchies, IndexView indexView, DotName initialName, ReflectiveHierarchyBuildItem.Builder builder, ClassInfo classInfo, boolean methods) {
        List fieldList = classInfo.fields();
        for (FieldInfo fieldInfo : fieldList) {
            if (Modifier.isStatic(fieldInfo.flags()) || fieldInfo.name().startsWith("this$") || fieldInfo.name().startsWith("val$")) continue;
            this.registerType(reflectiveClassHierarchy, classLoader, processedReflectiveHierarchies, methods, builder, fieldInfo.type());
        }
    }

    private void registerType(BuildProducer<ReflectiveHierarchyBuildItem> reflectiveClassHierarchy, ClassLoader classLoader, Set<DotName> processedReflectiveHierarchies, boolean methods, ReflectiveHierarchyBuildItem.Builder builder, Type type) {
        if (type.kind().equals((Object)Type.Kind.ARRAY)) {
            type = type.asArrayType().constituent();
        }
        if (type.kind() != Type.Kind.PRIMITIVE && !processedReflectiveHierarchies.contains(type.name())) {
            this.registerClassDependencies(reflectiveClassHierarchy, classLoader, processedReflectiveHierarchies, methods, builder, type.name().toString());
        }
    }

    private static Type getMethodReturnType(IndexView indexView, DotName initialName, ClassInfo info, MethodInfo method) {
        Type methodReturnType = method.returnType();
        if (methodReturnType.kind() == Type.Kind.TYPE_VARIABLE && info.typeParameters().size() == 1 && methodReturnType.asTypeVariable().identifier().equals(((TypeVariable)info.typeParameters().get(0)).identifier())) {
            List<Type> types = JandexUtil.resolveTypeParameters(initialName, info.name(), indexView);
            methodReturnType = types.get(0);
        }
        return methodReturnType;
    }
}

