/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import java.math.BigDecimal;
import org.jboss.logging.Logger;

public class Timing {
    private static volatile long bootStartTime = -1L;
    private static volatile long bootStopTime = -1L;
    private static volatile String httpServerInfo = "";

    public static void staticInitStarted() {
        if (bootStartTime < 0L) {
            bootStartTime = System.nanoTime();
        }
    }

    public static void staticInitStopped() {
        if (bootStopTime < 0L) {
            bootStopTime = System.nanoTime();
        }
    }

    public static void setHttpServer(String info) {
        httpServerInfo = info;
    }

    public static void mainStarted() {
    }

    public static void restart() {
        bootStartTime = System.nanoTime();
    }

    public static void printStartupTime(String version, String features) {
        long bootTimeNanoSeconds = System.nanoTime() - bootStartTime;
        Logger logger = Logger.getLogger((String)"io.quarkus");
        BigDecimal secondsRepresentation = Timing.convertToBigDecimalSeconds(bootTimeNanoSeconds);
        logger.infof("Quarkus %s started in %ss. %s", (Object)version, (Object)secondsRepresentation, (Object)httpServerInfo);
        logger.infof("Installed features: [%s]", (Object)features);
    }

    public static void printStopTime() {
        long stopTimeNanoSeconds = System.nanoTime() - bootStopTime;
        Logger logger = Logger.getLogger((String)"io.quarkus");
        BigDecimal secondsRepresentation = Timing.convertToBigDecimalSeconds(stopTimeNanoSeconds);
        logger.infof("Quarkus stopped in %ss", (Object)secondsRepresentation);
    }

    public static BigDecimal convertToBigDecimalSeconds(long timeNanoSeconds) {
        BigDecimal secondsRepresentation = BigDecimal.valueOf(timeNanoSeconds).divide(BigDecimal.valueOf(1000000L), 4).divide(BigDecimal.valueOf(1000L), 3, 4);
        return secondsRepresentation;
    }
}

