/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.configuration.AbstractDelegatingConfigSource;
import io.quarkus.runtime.configuration.ConfigExpander;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.wildfly.common.expression.Expression;

public class ExpandingConfigSource
extends AbstractDelegatingConfigSource {
    private final ConcurrentHashMap<String, Expression> exprCache = new ConcurrentHashMap();
    public static final UnaryOperator<ConfigSource> WRAPPER = ExpandingConfigSource::new;

    public ExpandingConfigSource(ConfigSource delegate) {
        super(delegate);
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.delegate.getPropertyNames();
    }

    public String getValue(String propertyName) {
        return this.expand(this.delegate.getValue(propertyName));
    }

    String expand(String value) {
        if (value == null) {
            return null;
        }
        Expression compiled = this.exprCache.computeIfAbsent(value, str -> Expression.compile((String)str, (Expression.Flag[])new Expression.Flag[]{Expression.Flag.ESCAPES, Expression.Flag.LENIENT_SYNTAX}));
        return compiled.evaluate((BiConsumer)ConfigExpander.INSTANCE);
    }

    public void flush() {
        this.exprCache.clear();
    }
}

