/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.logging;

import io.quarkus.runtime.logging.LogCleanupFilterElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.LogRecord;
import org.jboss.logging.Logger;
import org.jboss.logmanager.Level;

public class LogCleanupFilter
implements Filter {
    private Map<String, LogCleanupFilterElement> filterElements = new HashMap<String, LogCleanupFilterElement>();

    public LogCleanupFilter(List<LogCleanupFilterElement> filterElements) {
        for (LogCleanupFilterElement element : filterElements) {
            this.filterElements.put(element.getLoggerName(), element);
        }
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        if (record.getLevel().intValue() != java.util.logging.Level.INFO.intValue()) {
            return true;
        }
        LogCleanupFilterElement filterElement = this.filterElements.get(record.getLoggerName());
        if (filterElement != null && record.getMessage().startsWith(filterElement.getMessageStart())) {
            record.setLevel((java.util.logging.Level)Level.DEBUG);
            return Logger.getLogger((String)record.getLoggerName()).isDebugEnabled();
        }
        return true;
    }
}

