/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.configuration.AbstractDelegatingConfigSource;
import io.quarkus.runtime.configuration.ConfigExpander;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.wildfly.common.expression.Expression;

public class ExpandingConfigSource
extends AbstractDelegatingConfigSource {
    private final ConcurrentHashMap<String, Expression> exprCache = new ConcurrentHashMap();
    private static final ThreadLocal<Boolean> NO_EXPAND = new ThreadLocal();
    public static final UnaryOperator<ConfigSource> WRAPPER = ExpandingConfigSource::new;

    public ExpandingConfigSource(ConfigSource delegate) {
        super(delegate);
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.delegate.getPropertyNames();
    }

    public String getValue(String propertyName) {
        String delegateValue = this.delegate.getValue(propertyName);
        return ExpandingConfigSource.isExpanding() ? this.expand(delegateValue) : delegateValue;
    }

    String expand(String value) {
        if (value == null) {
            return null;
        }
        Expression compiled = this.exprCache.computeIfAbsent(value, str -> Expression.compile((String)str, (Expression.Flag[])new Expression.Flag[]{Expression.Flag.ESCAPES, Expression.Flag.LENIENT_SYNTAX}));
        return compiled.evaluate((BiConsumer)ConfigExpander.INSTANCE);
    }

    public void flush() {
        this.exprCache.clear();
    }

    private static boolean isExpanding() {
        return NO_EXPAND.get() != Boolean.TRUE;
    }

    public static boolean setExpanding(boolean newValue) {
        try {
            boolean bl = NO_EXPAND.get() != Boolean.TRUE;
            return bl;
        }
        finally {
            if (newValue) {
                NO_EXPAND.remove();
            } else {
                NO_EXPAND.set(Boolean.TRUE);
            }
        }
    }
}

