/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.deployment.ClassOutput;
import io.quarkus.deployment.ExtensionLoader;
import io.quarkus.deployment.QuarkusConfig;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveBuildItem;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.ClassOutputBuildItem;
import io.quarkus.deployment.builditem.ExtensionClassLoaderBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.runtime.LaunchMode;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jboss.builder.BuildChain;
import org.jboss.builder.BuildChainBuilder;
import org.jboss.builder.BuildExecutionBuilder;
import org.jboss.builder.BuildResult;
import org.jboss.builder.item.BuildItem;
import org.jboss.builder.item.MultiBuildItem;
import org.jboss.logging.Logger;

public class QuarkusAugmentor {
    private static final Logger log = Logger.getLogger(QuarkusAugmentor.class);
    private final ClassOutput output;
    private final ClassLoader classLoader;
    private final Path root;
    private final Set<Class<? extends BuildItem>> finalResults;
    private final List<Consumer<BuildChainBuilder>> buildChainCustomizers;
    private final LaunchMode launchMode;
    private final List<Path> additionalApplicationArchives;

    QuarkusAugmentor(Builder builder) {
        this.output = builder.output;
        this.classLoader = builder.classLoader;
        this.root = builder.root;
        this.finalResults = new HashSet<Class<? extends BuildItem>>(builder.finalResults);
        this.buildChainCustomizers = new ArrayList<Consumer<BuildChainBuilder>>(builder.buildChainCustomizers);
        this.launchMode = builder.launchMode;
        this.additionalApplicationArchives = new ArrayList<Path>(builder.additionalApplicationArchives);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildResult run() throws Exception {
        long time = System.currentTimeMillis();
        log.info((Object)"Beginning quarkus augmentation");
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            BuildChainBuilder chainBuilder = BuildChain.builder();
            ExtensionLoader.loadStepsFrom(this.classLoader).accept(chainBuilder);
            chainBuilder.loadProviders(this.classLoader);
            chainBuilder.addInitial(QuarkusConfig.class).addInitial(ArchiveRootBuildItem.class).addInitial(ShutdownContextBuildItem.class).addInitial(ClassOutputBuildItem.class).addInitial(LaunchModeBuildItem.class).addInitial(AdditionalApplicationArchiveBuildItem.class).addInitial(ExtensionClassLoaderBuildItem.class);
            for (Class<? extends BuildItem> clazz : this.finalResults) {
                chainBuilder.addFinal(clazz);
            }
            chainBuilder.addFinal(GeneratedClassBuildItem.class).addFinal(GeneratedResourceBuildItem.class);
            for (Consumer consumer : this.buildChainCustomizers) {
                consumer.accept(chainBuilder);
            }
            BuildChain chain = chainBuilder.build();
            BuildExecutionBuilder buildExecutionBuilder = chain.createExecutionBuilder("main").produce((BuildItem)QuarkusConfig.INSTANCE).produce((BuildItem)new ArchiveRootBuildItem(this.root)).produce((BuildItem)new ClassOutputBuildItem(this.output)).produce((BuildItem)new ShutdownContextBuildItem()).produce((BuildItem)new LaunchModeBuildItem(this.launchMode)).produce((BuildItem)new ExtensionClassLoaderBuildItem(this.classLoader));
            for (Path i : this.additionalApplicationArchives) {
                buildExecutionBuilder.produce((BuildItem)new AdditionalApplicationArchiveBuildItem(i));
            }
            BuildResult buildResult = buildExecutionBuilder.execute();
            for (MultiBuildItem i : buildResult.consumeMulti(GeneratedClassBuildItem.class)) {
                this.output.writeClass(i.isApplicationClass(), i.getName(), i.getClassData());
            }
            for (MultiBuildItem i : buildResult.consumeMulti(GeneratedResourceBuildItem.class)) {
                this.output.writeResource(i.getName(), i.getClassData());
            }
            log.info((Object)("Quarkus augmentation completed in " + (System.currentTimeMillis() - time) + "ms"));
            BuildResult buildResult2 = buildResult;
            return buildResult2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        List<Path> additionalApplicationArchives = new ArrayList<Path>();
        ClassOutput output;
        ClassLoader classLoader;
        Path root;
        Set<Class<? extends BuildItem>> finalResults = new HashSet<Class<? extends BuildItem>>();
        private final List<Consumer<BuildChainBuilder>> buildChainCustomizers = new ArrayList<Consumer<BuildChainBuilder>>();
        LaunchMode launchMode = LaunchMode.NORMAL;

        public Builder addBuildChainCustomizer(Consumer<BuildChainBuilder> customizer) {
            this.buildChainCustomizers.add(customizer);
            return this;
        }

        public List<Path> getAdditionalApplicationArchives() {
            return this.additionalApplicationArchives;
        }

        public Builder addAdditionalApplicationArchive(Path archive) {
            this.additionalApplicationArchives.add(archive);
            return this;
        }

        public ClassOutput getOutput() {
            return this.output;
        }

        public Builder setOutput(ClassOutput output) {
            this.output = output;
            return this;
        }

        public LaunchMode getLaunchMode() {
            return this.launchMode;
        }

        public Builder setLaunchMode(LaunchMode launchMode) {
            this.launchMode = launchMode;
            return this;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public Builder setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Path getRoot() {
            return this.root;
        }

        public <T extends BuildItem> Builder addFinal(Class<T> clazz) {
            this.finalResults.add(clazz);
            return this;
        }

        public Builder setRoot(Path root) {
            this.root = root;
            return this;
        }

        public QuarkusAugmentor build() {
            return new QuarkusAugmentor(this);
        }
    }
}

