/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem.substrate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.builder.item.MultiBuildItem;

public final class ReflectiveClassBuildItem
extends MultiBuildItem {
    private final List<String> className;
    private final boolean methods;
    private final boolean fields;
    private final boolean constructors;

    public ReflectiveClassBuildItem(boolean methods, boolean fields, Class<?> ... className) {
        this(true, methods, fields, className);
    }

    public ReflectiveClassBuildItem(boolean constructors, boolean methods, boolean fields, Class<?> ... className) {
        ArrayList<String> names = new ArrayList<String>();
        for (Class<?> i : className) {
            if (i == null) {
                throw new NullPointerException();
            }
            names.add(i.getName());
        }
        this.className = names;
        this.methods = methods;
        this.fields = fields;
        this.constructors = constructors;
    }

    public ReflectiveClassBuildItem(boolean methods, boolean fields, String ... className) {
        this(true, methods, fields, className);
    }

    public ReflectiveClassBuildItem(boolean constructors, boolean methods, boolean fields, String ... className) {
        for (String i : className) {
            if (i != null) continue;
            throw new NullPointerException();
        }
        this.className = Arrays.asList(className);
        this.methods = methods;
        this.fields = fields;
        this.constructors = constructors;
    }

    public List<String> getClassNames() {
        return this.className;
    }

    public boolean isMethods() {
        return this.methods;
    }

    public boolean isFields() {
        return this.fields;
    }

    public boolean isConstructors() {
        return this.constructors;
    }
}

