/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.quarkus.deployment.AccessorFinder;
import io.quarkus.deployment.configuration.CompoundConfigType;
import io.quarkus.deployment.configuration.GroupConfigType;
import io.quarkus.deployment.configuration.LeafConfigType;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.configuration.NameIterator;
import io.smallrye.config.SmallRyeConfig;
import java.lang.reflect.Field;
import java.util.OptionalLong;
import org.wildfly.common.Assert;

public class LongConfigType
extends LeafConfigType {
    private static final MethodDescriptor OPTLONG_OR_ELSE_METHOD = MethodDescriptor.ofMethod(OptionalLong.class, (String)"orElse", Long.TYPE, (Class[])new Class[]{Long.TYPE});
    private static final MethodDescriptor LONG_VALUE_METHOD = MethodDescriptor.ofMethod(Long.class, (String)"longValue", Long.TYPE, (Class[])new Class[0]);
    final String defaultValue;

    public LongConfigType(String containingName, CompoundConfigType container, boolean consumeSegment, String defaultValue) {
        super(containingName, container, consumeSegment);
        Assert.checkNotEmptyParam((String)"defaultValue", (String)defaultValue);
        this.defaultValue = defaultValue;
    }

    @Override
    public void acceptConfigurationValue(NameIterator name, SmallRyeConfig config) {
        GroupConfigType container = this.getContainer(GroupConfigType.class);
        if (this.isConsumeSegment()) {
            name.previous();
        }
        container.acceptConfigurationValueIntoLeaf(this, name, config);
    }

    @Override
    public void generateAcceptConfigurationValue(BytecodeCreator body, ResultHandle name, ResultHandle config) {
        GroupConfigType container = this.getContainer(GroupConfigType.class);
        if (this.isConsumeSegment()) {
            body.invokeVirtualMethod(NI_PREV_METHOD, name, new ResultHandle[0]);
        }
        container.generateAcceptConfigurationValueIntoLeaf(body, this, name, config);
    }

    @Override
    public void acceptConfigurationValueIntoGroup(Object enclosing, Field field, NameIterator name, SmallRyeConfig config) {
        try {
            field.setLong(enclosing, ((OptionalLong)config.getValue(name.toString(), OptionalLong.class)).orElse((Long)config.convert(this.defaultValue, Long.class)));
        }
        catch (IllegalAccessException e) {
            throw LongConfigType.toError(e);
        }
    }

    @Override
    public void generateAcceptConfigurationValueIntoGroup(BytecodeCreator body, ResultHandle enclosing, MethodDescriptor setter, ResultHandle name, ResultHandle config) {
        ResultHandle optionalValue = body.checkCast(body.invokeVirtualMethod(SRC_GET_VALUE, config, new ResultHandle[]{body.invokeVirtualMethod(OBJ_TO_STRING_METHOD, name, new ResultHandle[0]), body.loadClass(OptionalLong.class)}), OptionalLong.class);
        ResultHandle convertedDefault = this.getConvertedDefault(body, config);
        ResultHandle defaultedValue = body.checkCast(body.invokeVirtualMethod(OPTLONG_OR_ELSE_METHOD, optionalValue, new ResultHandle[]{convertedDefault}), Long.class);
        ResultHandle longValue = body.invokeVirtualMethod(LONG_VALUE_METHOD, defaultedValue, new ResultHandle[0]);
        body.invokeStaticMethod(setter, new ResultHandle[]{enclosing, longValue});
    }

    @Override
    public Class<?> getItemClass() {
        return Long.TYPE;
    }

    @Override
    void getDefaultValueIntoEnclosingGroup(Object enclosing, SmallRyeConfig config, Field field) {
        try {
            field.setLong(enclosing, (Long)config.convert(this.defaultValue, Long.class));
        }
        catch (IllegalAccessException e) {
            throw LongConfigType.toError(e);
        }
    }

    @Override
    void generateGetDefaultValueIntoEnclosingGroup(BytecodeCreator body, ResultHandle enclosing, MethodDescriptor setter, ResultHandle config) {
        body.invokeStaticMethod(setter, new ResultHandle[]{enclosing, body.invokeVirtualMethod(LONG_VALUE_METHOD, this.getConvertedDefault(body, config), new ResultHandle[0])});
    }

    @Override
    public ResultHandle writeInitialization(BytecodeCreator body, AccessorFinder accessorFinder, ResultHandle smallRyeConfig) {
        return body.invokeVirtualMethod(LONG_VALUE_METHOD, this.getConvertedDefault(body, smallRyeConfig), new ResultHandle[0]);
    }

    private ResultHandle getConvertedDefault(BytecodeCreator body, ResultHandle config) {
        return body.checkCast(body.invokeVirtualMethod(SRC_CONVERT_METHOD, config, new ResultHandle[]{body.load(this.defaultValue), body.loadClass(Long.class)}), Long.class);
    }
}

