/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.ClassOutput;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ClassOutputBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveFieldBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveMethodBuildItem;
import io.quarkus.deployment.builditem.substrate.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.substrate.RuntimeReinitializedClassBuildItem;
import io.quarkus.deployment.builditem.substrate.ServiceProviderBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateOutputBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateResourceBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateResourceBundleBuildItem;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.runtime.ResourceHelper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SubstrateAutoFeatureStep {
    private static final String GRAAL_AUTOFEATURE = "io.quarkus/runner/AutoFeature";

    @BuildStep
    SubstrateOutputBuildItem generateFeature(ClassOutputBuildItem output, List<RuntimeInitializedClassBuildItem> runtimeInitializedClassBuildItems, List<RuntimeReinitializedClassBuildItem> runtimeReinitializedClassBuildItems, List<SubstrateProxyDefinitionBuildItem> proxies, List<SubstrateResourceBuildItem> resources, List<SubstrateResourceBundleBuildItem> resourceBundles, List<ReflectiveMethodBuildItem> reflectiveMethods, List<ReflectiveFieldBuildItem> reflectiveFields, List<ReflectiveClassBuildItem> reflectiveClassBuildItems, List<ServiceProviderBuildItem> serviceProviderBuildItems) {
        CatchBlockCreator cc;
        Object clazz;
        TryBlock tc;
        Object cl;
        ResultHandle array;
        ClassCreator file = new ClassCreator(ClassOutput.gizmoAdaptor(output.getClassOutput(), true), GRAAL_AUTOFEATURE, null, Object.class.getName(), new String[]{"org/graalvm/nativeimage/Feature"});
        file.addAnnotation("com/oracle/svm/core/annotate/AutomaticFeature");
        MethodCreator beforeAn = file.getMethodCreator("beforeAnalysis", "V", new String[]{"org/graalvm/nativeimage/Feature$BeforeAnalysisAccess"});
        TryBlock overallCatch = beforeAn.tryBlock();
        if (!runtimeInitializedClassBuildItems.isEmpty()) {
            array = overallCatch.newArray(Class.class, overallCatch.load(1));
            ResultHandle resultHandle = overallCatch.loadClass(GRAAL_AUTOFEATURE);
            cl = overallCatch.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getClassLoader", ClassLoader.class, (Class[])new Class[0]), resultHandle, new ResultHandle[0]);
            for (String i : runtimeInitializedClassBuildItems.stream().map(RuntimeInitializedClassBuildItem::getClassName).collect(Collectors.toList())) {
                tc = overallCatch.tryBlock();
                clazz = tc.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class}), new ResultHandle[]{tc.load(i), tc.load(false), cl});
                tc.writeArrayValue(array, 0, (ResultHandle)clazz);
                tc.invokeStaticMethod(MethodDescriptor.ofMethod((Object)"org.graalvm.nativeimage.RuntimeClassInitialization", (String)"delayClassInitialization", Void.TYPE, (Object[])new Object[]{Class[].class}), new ResultHandle[]{array});
                cc = tc.addCatch(Throwable.class);
                cc.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc.getCaughtException(), new ResultHandle[0]);
            }
        }
        array = overallCatch.newArray(Class.class, overallCatch.load(1));
        ResultHandle resultHandle = overallCatch.loadClass(GRAAL_AUTOFEATURE);
        cl = overallCatch.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getClassLoader", ClassLoader.class, (Class[])new Class[0]), resultHandle, new ResultHandle[0]);
        TryBlock tryBlock = overallCatch.tryBlock();
        ResultHandle clazz2 = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class}), new ResultHandle[]{tryBlock.load("org.wildfly.common.net.HostName"), tryBlock.load(false), cl});
        tryBlock.writeArrayValue(array, 0, clazz2);
        tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod((Object)"org.graalvm.nativeimage.RuntimeClassInitialization", (String)"rerunClassInitialization", Void.TYPE, (Object[])new Object[]{Class[].class}), new ResultHandle[]{array});
        CatchBlockCreator cc2 = tryBlock.addCatch(Throwable.class);
        cc2.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc2.getCaughtException(), new ResultHandle[0]);
        TryBlock tryBlock2 = overallCatch.tryBlock();
        ResultHandle clazz3 = tryBlock2.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class}), new ResultHandle[]{tryBlock2.load("org.wildfly.common.os.Process"), tryBlock2.load(false), cl});
        tryBlock2.writeArrayValue(array, 0, clazz3);
        tryBlock2.invokeStaticMethod(MethodDescriptor.ofMethod((Object)"org.graalvm.nativeimage.RuntimeClassInitialization", (String)"rerunClassInitialization", Void.TYPE, (Object[])new Object[]{Class[].class}), new ResultHandle[]{array});
        CatchBlockCreator cc3 = tryBlock2.addCatch(Throwable.class);
        cc3.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc3.getCaughtException(), new ResultHandle[0]);
        for (String i : runtimeReinitializedClassBuildItems.stream().map(RuntimeReinitializedClassBuildItem::getClassName).collect(Collectors.toList())) {
            tc = overallCatch.tryBlock();
            clazz = tc.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class}), new ResultHandle[]{tc.load(i), tc.load(false), cl});
            tc.writeArrayValue(array, 0, (ResultHandle)clazz);
            tc.invokeStaticMethod(MethodDescriptor.ofMethod((Object)"org.graalvm.nativeimage.RuntimeClassInitialization", (String)"rerunClassInitialization", Void.TYPE, (Object[])new Object[]{Class[].class}), new ResultHandle[]{array});
            cc = tc.addCatch(Throwable.class);
            cc.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc.getCaughtException(), new ResultHandle[0]);
        }
        if (!proxies.isEmpty()) {
            ResultHandle proxySupportClass = overallCatch.loadClass("com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry");
            ResultHandle resultHandle2 = overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod((Object)"org.graalvm.nativeimage.ImageSingletons", (String)"lookup", Object.class, (Object[])new Object[]{Class.class}), new ResultHandle[]{proxySupportClass});
            for (SubstrateProxyDefinitionBuildItem substrateProxyDefinitionBuildItem : proxies) {
                ResultHandle array2 = overallCatch.newArray(Class.class, overallCatch.load(substrateProxyDefinitionBuildItem.getClasses().size()));
                int i = 0;
                for (String p : substrateProxyDefinitionBuildItem.getClasses()) {
                    ResultHandle clazz32 = overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class}), new ResultHandle[]{overallCatch.load(p)});
                    overallCatch.writeArrayValue(array2, i++, clazz32);
                }
                overallCatch.invokeInterfaceMethod(MethodDescriptor.ofMethod((Object)"com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry", (String)"addProxyClass", Void.TYPE, (Object[])new Object[]{Class[].class}), resultHandle2, new ResultHandle[]{array2});
            }
        }
        for (SubstrateResourceBuildItem substrateResourceBuildItem : resources) {
            for (String string : substrateResourceBuildItem.getResources()) {
                overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod(ResourceHelper.class, (String)"registerResources", Void.TYPE, (Class[])new Class[]{String.class}), new ResultHandle[]{overallCatch.load(string)});
            }
        }
        for (ServiceProviderBuildItem serviceProviderBuildItem : serviceProviderBuildItems) {
            overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod(ResourceHelper.class, (String)"registerResources", Void.TYPE, (Class[])new Class[]{String.class}), new ResultHandle[]{overallCatch.load(serviceProviderBuildItem.serviceDescriptorFile())});
        }
        if (!resourceBundles.isEmpty()) {
            ResultHandle locClass = overallCatch.loadClass("com.oracle.svm.core.jdk.LocalizationSupport");
            ResultHandle resultHandle3 = overallCatch.marshalAsArray(Class.class, new ResultHandle[]{overallCatch.loadClass(String.class)});
            Iterator<Object> registerMethod = overallCatch.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethod", Method.class, (Class[])new Class[]{String.class, Class[].class}), locClass, new ResultHandle[]{overallCatch.load("addBundleToCache"), resultHandle3});
            overallCatch.invokeVirtualMethod(MethodDescriptor.ofMethod(AccessibleObject.class, (String)"setAccessible", Void.TYPE, (Class[])new Class[]{Boolean.TYPE}), registerMethod, new ResultHandle[]{overallCatch.load(true)});
            ResultHandle resultHandle4 = overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod((Object)"org.graalvm.nativeimage.ImageSingletons", (String)"lookup", Object.class, (Object[])new Object[]{Class.class}), new ResultHandle[]{locClass});
            for (SubstrateResourceBundleBuildItem i : resourceBundles) {
                String p;
                TryBlock et = overallCatch.tryBlock();
                et.invokeVirtualMethod(MethodDescriptor.ofMethod(Method.class, (String)"invoke", Object.class, (Class[])new Class[]{Object.class, Object[].class}), registerMethod, new ResultHandle[]{resultHandle4, et.marshalAsArray(Object.class, new ResultHandle[]{et.load(i.getBundleName())})});
                p = et.addCatch(Throwable.class);
            }
        }
        int count = 0;
        LinkedHashMap<String, ReflectionInfo> linkedHashMap = new LinkedHashMap<String, ReflectionInfo>();
        for (ReflectiveClassBuildItem reflectiveClassBuildItem : reflectiveClassBuildItems) {
            this.addReflectiveClass(linkedHashMap, reflectiveClassBuildItem.isConstructors(), reflectiveClassBuildItem.isMethods(), reflectiveClassBuildItem.isFields(), reflectiveClassBuildItem.getClassNames().toArray(new String[0]));
        }
        for (ReflectiveFieldBuildItem reflectiveFieldBuildItem : reflectiveFields) {
            this.addReflectiveField(linkedHashMap, reflectiveFieldBuildItem);
        }
        for (ReflectiveMethodBuildItem reflectiveMethodBuildItem : reflectiveMethods) {
            this.addReflectiveMethod(linkedHashMap, reflectiveMethodBuildItem);
        }
        for (ServiceProviderBuildItem serviceProviderBuildItem : serviceProviderBuildItems) {
            this.addReflectiveClass(linkedHashMap, true, false, false, serviceProviderBuildItem.providers().toArray(new String[0]));
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            ResultHandle fhandle;
            String type;
            ResultHandle paramArray;
            ResultHandle farray;
            MethodCreator mv = file.getMethodCreator("registerClass" + count++, "V", new String[0]);
            mv.setModifiers(10);
            overallCatch.invokeStaticMethod(mv.getMethodDescriptor(), new ResultHandle[0]);
            TryBlock tc3 = mv.tryBlock();
            clazz = tc3.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class}), new ResultHandle[]{tc3.load((String)entry.getKey())});
            ResultHandle constructors = tc3.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredConstructors", Constructor[].class, (Class[])new Class[0]), (ResultHandle)clazz, new ResultHandle[0]);
            ResultHandle methods = tc3.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethods", Method[].class, (Class[])new Class[0]), (ResultHandle)clazz, new ResultHandle[0]);
            ResultHandle fields = tc3.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredFields", Field[].class, (Class[])new Class[0]), (ResultHandle)clazz, new ResultHandle[0]);
            ResultHandle carray = tc3.newArray(Class.class, tc3.load(1));
            tc3.writeArrayValue(carray, 0, (ResultHandle)clazz);
            tc3.invokeStaticMethod(MethodDescriptor.ofMethod((Object)"org/graalvm/nativeimage/RuntimeReflection", (String)"register", Void.TYPE, (Object[])new Object[]{Class[].class}), new ResultHandle[]{carray});
            if (((ReflectionInfo)entry.getValue()).constructors) {
                tc3.invokeStaticMethod(MethodDescriptor.ofMethod((Object)"org/graalvm/nativeimage/RuntimeReflection", (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{constructors});
            } else if (!((ReflectionInfo)entry.getValue()).ctorSet.isEmpty()) {
                farray = tc3.newArray(Constructor.class, tc3.load(1));
                for (ReflectiveMethodBuildItem ctor : ((ReflectionInfo)entry.getValue()).ctorSet) {
                    paramArray = tc3.newArray(Class.class, tc3.load(ctor.getParams().length));
                    for (int i = 0; i < ctor.getParams().length; ++i) {
                        type = ctor.getParams()[i];
                        tc3.writeArrayValue(paramArray, i, tc3.loadClass(type));
                    }
                    fhandle = tc3.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredConstructor", Constructor.class, (Class[])new Class[]{Class[].class}), (ResultHandle)clazz, new ResultHandle[]{paramArray});
                    tc3.writeArrayValue(farray, 0, fhandle);
                    tc3.invokeStaticMethod(MethodDescriptor.ofMethod((Object)"org/graalvm/nativeimage/RuntimeReflection", (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{farray});
                }
            }
            if (((ReflectionInfo)entry.getValue()).methods) {
                tc3.invokeStaticMethod(MethodDescriptor.ofMethod((Object)"org/graalvm/nativeimage/RuntimeReflection", (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{methods});
            } else if (!((ReflectionInfo)entry.getValue()).methodSet.isEmpty()) {
                farray = tc3.newArray(Method.class, tc3.load(1));
                for (ReflectiveMethodBuildItem method : ((ReflectionInfo)entry.getValue()).methodSet) {
                    paramArray = tc3.newArray(Class.class, tc3.load(method.getParams().length));
                    for (int i = 0; i < method.getParams().length; ++i) {
                        type = method.getParams()[i];
                        tc3.writeArrayValue(paramArray, i, tc3.loadClass(type));
                    }
                    fhandle = tc3.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethod", Method.class, (Class[])new Class[]{String.class, Class[].class}), (ResultHandle)clazz, new ResultHandle[]{tc3.load(method.getName()), paramArray});
                    tc3.writeArrayValue(farray, 0, fhandle);
                    tc3.invokeStaticMethod(MethodDescriptor.ofMethod((Object)"org/graalvm/nativeimage/RuntimeReflection", (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{farray});
                }
            }
            if (((ReflectionInfo)entry.getValue()).fields) {
                tc3.invokeStaticMethod(MethodDescriptor.ofMethod((Object)"org/graalvm/nativeimage/RuntimeReflection", (String)"register", Void.TYPE, (Object[])new Object[]{Field[].class}), new ResultHandle[]{fields});
            } else if (!((ReflectionInfo)entry.getValue()).fieldSet.isEmpty()) {
                farray = tc3.newArray(Field.class, tc3.load(1));
                for (String field : ((ReflectionInfo)entry.getValue()).fieldSet) {
                    ResultHandle fhandle2 = tc3.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredField", Field.class, (Class[])new Class[]{String.class}), (ResultHandle)clazz, new ResultHandle[]{tc3.load(field)});
                    tc3.writeArrayValue(farray, 0, fhandle2);
                    tc3.invokeStaticMethod(MethodDescriptor.ofMethod((Object)"org/graalvm/nativeimage/RuntimeReflection", (String)"register", Void.TYPE, (Object[])new Object[]{Field[].class}), new ResultHandle[]{farray});
                }
            }
            CatchBlockCreator cc32 = tc3.addCatch(Throwable.class);
            mv.returnValue(null);
        }
        CatchBlockCreator print = overallCatch.addCatch(Throwable.class);
        print.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), print.getCaughtException(), new ResultHandle[0]);
        beforeAn.loadClass("io.quarkus.runner.ApplicationImpl");
        beforeAn.returnValue(null);
        file.close();
        return new SubstrateOutputBuildItem();
    }

    public void addReflectiveMethod(Map<String, ReflectionInfo> reflectiveClasses, ReflectiveMethodBuildItem methodInfo) {
        String cl = methodInfo.getDeclaringClass();
        ReflectionInfo existing = reflectiveClasses.get(cl);
        if (existing == null) {
            existing = new ReflectionInfo(false, false, false);
            reflectiveClasses.put(cl, existing);
        }
        if (methodInfo.getName().equals("<init>")) {
            existing.ctorSet.add(methodInfo);
        } else {
            existing.methodSet.add(methodInfo);
        }
    }

    public void addReflectiveClass(Map<String, ReflectionInfo> reflectiveClasses, boolean constructors, boolean method, boolean fields, String ... className) {
        for (String cl : className) {
            ReflectionInfo existing = reflectiveClasses.get(cl);
            if (existing == null) {
                reflectiveClasses.put(cl, new ReflectionInfo(constructors, method, fields));
                continue;
            }
            if (constructors) {
                existing.constructors = true;
            }
            if (method) {
                existing.methods = true;
            }
            if (!fields) continue;
            existing.fields = true;
        }
    }

    public void addReflectiveField(Map<String, ReflectionInfo> reflectiveClasses, ReflectiveFieldBuildItem fieldInfo) {
        String cl = fieldInfo.getDeclaringClass();
        ReflectionInfo existing = reflectiveClasses.get(cl);
        if (existing == null) {
            existing = new ReflectionInfo(false, false, false);
            reflectiveClasses.put(cl, existing);
        }
        existing.fieldSet.add(fieldInfo.getName());
    }

    static final class ReflectionInfo {
        boolean constructors;
        boolean methods;
        boolean fields;
        Set<String> fieldSet = new HashSet<String>();
        Set<ReflectiveMethodBuildItem> methodSet = new HashSet<ReflectiveMethodBuildItem>();
        Set<ReflectiveMethodBuildItem> ctorSet = new HashSet<ReflectiveMethodBuildItem>();

        private ReflectionInfo(boolean constructors, boolean methods, boolean fields) {
            this.methods = methods;
            this.fields = fields;
            this.constructors = constructors;
        }
    }
}

