/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.util;

import io.quarkus.deployment.annotations.BuildProducer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class ReflectUtil {
    private ReflectUtil() {
    }

    public static boolean rawTypeIs(Type type, Class<?> clazz) {
        return type instanceof Class && clazz == type || type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() == clazz || type instanceof GenericArrayType && clazz.isArray() && ReflectUtil.rawTypeIs(((GenericArrayType)type).getGenericComponentType(), clazz.getComponentType());
    }

    public static boolean rawTypeExtends(Type type, Class<?> clazz) {
        return type instanceof Class && clazz.isAssignableFrom((Class)type) || type instanceof ParameterizedType && ReflectUtil.rawTypeExtends(((ParameterizedType)type).getRawType(), clazz) || type instanceof GenericArrayType && ReflectUtil.rawTypeExtends(((GenericArrayType)type).getGenericComponentType(), clazz.getComponentType());
    }

    public static boolean isListOf(Type type, Class<?> nestedType) {
        return ReflectUtil.isThingOf(type, List.class, nestedType);
    }

    public static boolean isConsumerOf(Type type, Class<?> nestedType) {
        return ReflectUtil.isThingOf(type, Consumer.class, nestedType);
    }

    public static boolean isBuildProducerOf(Type type, Class<?> nestedType) {
        return ReflectUtil.isThingOf(type, BuildProducer.class, nestedType);
    }

    public static boolean isSupplierOf(Type type, Class<?> nestedType) {
        return ReflectUtil.isThingOf(type, Supplier.class, nestedType);
    }

    public static boolean isSupplierOfOptionalOf(Type type, Class<?> nestedType) {
        return type instanceof ParameterizedType && ReflectUtil.rawTypeIs(type, Supplier.class) && ReflectUtil.isOptionalOf(ReflectUtil.typeOfParameter(type, 0), nestedType);
    }

    public static boolean isOptionalOf(Type type, Class<?> nestedType) {
        return ReflectUtil.isThingOf(type, Optional.class, nestedType);
    }

    public static boolean isThingOf(Type type, Class<?> thing, Class<?> nestedType) {
        return type instanceof ParameterizedType && ReflectUtil.rawTypeIs(type, thing) && ReflectUtil.rawTypeExtends(ReflectUtil.typeOfParameter(type, 0), nestedType);
    }

    public static Class<?> rawTypeOf(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ReflectUtil.rawTypeOf(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(ReflectUtil.rawTypeOf(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        throw new IllegalArgumentException("Type has no raw type class: " + type);
    }

    public static Type typeOfParameter(Type type, int paramIdx) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[paramIdx];
        }
        throw new IllegalArgumentException("Type is not parameterized: " + type);
    }

    public static Class<?> rawTypeOfParameter(Type type, int paramIdx) {
        return ReflectUtil.rawTypeOf(ReflectUtil.typeOfParameter(type, paramIdx));
    }

    public static void setFieldVal(Field field, Object obj, Object value) {
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            throw ReflectUtil.toError(e);
        }
    }

    public static InstantiationError toError(InstantiationException e) {
        InstantiationError error = new InstantiationError(e.getMessage());
        error.setStackTrace(e.getStackTrace());
        return error;
    }

    public static IllegalAccessError toError(IllegalAccessException e) {
        IllegalAccessError error = new IllegalAccessError(e.getMessage());
        error.setStackTrace(e.getStackTrace());
        return error;
    }

    public static NoSuchMethodError toError(NoSuchMethodException e) {
        NoSuchMethodError error = new NoSuchMethodError(e.getMessage());
        error.setStackTrace(e.getStackTrace());
        return error;
    }

    public static NoSuchFieldError toError(NoSuchFieldException e) {
        NoSuchFieldError error = new NoSuchFieldError(e.getMessage());
        error.setStackTrace(e.getStackTrace());
        return error;
    }
}

