/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import io.quarkus.runtime.Timing;
import io.quarkus.runtime.graal.DiagnosticPrinter;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import org.graalvm.nativeimage.ImageInfo;
import org.jboss.logging.Logger;
import org.jboss.threads.Locks;
import org.wildfly.common.Assert;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public abstract class Application {
    private static final Logger LOG = Logger.getLogger(Application.class);
    private static final int ST_INITIAL = 0;
    private static final int ST_STARTING = 1;
    private static final int ST_STARTED = 2;
    private static final int ST_STOPPING = 3;
    private static final int ST_STOPPED = 4;
    private static final int ST_EXIT = 5;
    private final Lock stateLock = Locks.reentrantLock();
    private final Condition stateCond = this.stateLock.newCondition();
    private int state = 0;
    private volatile boolean shutdownRequested;

    protected Application() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(String[] args) {
        Lock stateLock = this.stateLock;
        stateLock.lock();
        try {
            block19: while (true) {
                switch (this.state) {
                    case 0: {
                        break block19;
                    }
                    case 1: {
                        try {
                            this.stateCond.await();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw Application.interruptedOnAwaitStart();
                        }
                    }
                    continue block19;
                    case 2: {
                        return;
                    }
                    default: {
                        throw new IllegalStateException("The application is stopping");
                    }
                }
                break;
            }
            this.state = 1;
        }
        finally {
            stateLock.unlock();
        }
        try {
            this.doStart(args);
        }
        catch (Throwable t) {
            stateLock.lock();
            try {
                this.state = 4;
                this.stateCond.signalAll();
            }
            finally {
                stateLock.unlock();
            }
            throw t;
        }
        stateLock.lock();
        try {
            this.state = 2;
            this.stateCond.signalAll();
        }
        finally {
            stateLock.unlock();
        }
    }

    protected abstract void doStart(String[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Lock stateLock = this.stateLock;
        stateLock.lock();
        try {
            block23: while (true) {
                switch (this.state) {
                    case 0: {
                        throw new IllegalStateException("The application has not been started");
                    }
                    case 1: {
                        try {
                            this.stateCond.await();
                            continue block23;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw Application.interruptedOnAwaitStart();
                        }
                    }
                    case 2: {
                        break block23;
                    }
                    case 3: {
                        try {
                            this.stateCond.await();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw Application.interruptedOnAwaitStop();
                        }
                    }
                    continue block23;
                    case 4: 
                    case 5: {
                        return;
                    }
                    default: {
                        throw Assert.impossibleSwitchCase((int)this.state);
                    }
                }
                break;
            }
            this.state = 3;
        }
        finally {
            stateLock.unlock();
        }
        Timing.staticInitStopped();
        try {
            this.doStop();
        }
        finally {
            stateLock.lock();
            try {
                this.state = 4;
                Timing.printStopTime();
                this.stateCond.signalAll();
            }
            finally {
                stateLock.unlock();
            }
        }
    }

    protected abstract void doStop();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run(String[] args) {
        try {
            String property = "DISABLE_SIGNAL_HANDLERS";
            if (ImageInfo.inImageRuntimeCode() && System.getenv("DISABLE_SIGNAL_HANDLERS") == null) {
                SignalHandler handler = new SignalHandler(){

                    @Override
                    public void handle(Signal signal) {
                        System.exit(signal.getNumber() + 128);
                    }
                };
                Signal.handle(new Signal("INT"), handler);
                Signal.handle(new Signal("TERM"), handler);
                Signal.handle(new Signal("HUP"), handler);
                Signal.handle(new Signal("QUIT"), new SignalHandler(){

                    @Override
                    public void handle(Signal signal) {
                        DiagnosticPrinter.printDiagnostics(System.out);
                    }
                });
            } else {
                LOG.warn((Object)"Installation of signal handlers disabled by the presence of the environment variable: DISABLE_SIGNAL_HANDLERS");
            }
            ShutdownHookThread shutdownHookThread = new ShutdownHookThread(Thread.currentThread());
            Runtime.getRuntime().addShutdownHook(shutdownHookThread);
            this.start(args);
            try {
                while (!this.shutdownRequested) {
                    Thread.interrupted();
                    LockSupport.park(shutdownHookThread);
                }
            }
            finally {
                this.stop();
            }
        }
        finally {
            this.exit();
        }
    }

    private void exit() {
        this.stateLock.lock();
        try {
            System.out.flush();
            System.err.flush();
            this.state = 5;
            this.stateCond.signalAll();
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private static IllegalStateException interruptedOnAwaitStart() {
        return new IllegalStateException("Interrupted while waiting for another thread to start the application");
    }

    private static IllegalStateException interruptedOnAwaitStop() {
        return new IllegalStateException("Interrupted while waiting for another thread to stop the application");
    }

    class ShutdownHookThread
    extends Thread {
        private final Thread mainThread;

        ShutdownHookThread(Thread mainThread) {
            super("Shutdown thread");
            this.mainThread = mainThread;
            this.setDaemon(false);
        }

        @Override
        public void run() {
            Application.this.shutdownRequested = true;
            LockSupport.unpark(this.mainThread);
            Lock stateLock = Application.this.stateLock;
            Condition stateCond = Application.this.stateCond;
            stateLock.lock();
            try {
                while (Application.this.state != 5) {
                    stateCond.awaitUninterruptibly();
                }
            }
            finally {
                stateLock.unlock();
            }
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }
}

