/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Template;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.threads.EnhancedQueueExecutor;
import org.jboss.threads.JBossExecutors;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.common.cpu.ProcessorInfo;

@Template
public class ExecutorTemplate {
    static final Config config = ConfigProvider.getConfig();
    public static final String CORE_POOL_SIZE = "executor.core-pool-size";
    public static final String MAX_POOL_SIZE = "executor.max-pool-size";
    public static final String QUEUE_SIZE = "executor.queue-size";
    public static final String GROWTH_RESISTANCE = "executor.growth-resistance";
    public static final String KEEP_ALIVE_MILLIS = "executor.keep-alive-millis";

    public Executor setupRunTime(ShutdownContext shutdownContext, int defaultCoreSize, int defaultMaxSize, int defaultQueueSize, float defaultGrowthResistance, int defaultKeepAliveMillis) {
        JBossThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("executor"), Boolean.TRUE, null, "executor-thread-%t", JBossExecutors.loggingExceptionHandler((String)"org.jboss.executor.uncaught"), null);
        EnhancedQueueExecutor.Builder builder = new EnhancedQueueExecutor.Builder().setRegisterMBean(false).setHandoffExecutor(JBossExecutors.rejectingExecutor()).setThreadFactory(JBossExecutors.resettingThreadFactory((ThreadFactory)threadFactory));
        int cpus = ProcessorInfo.availableProcessors();
        builder.setCorePoolSize(ExecutorTemplate.getIntConfigVal(CORE_POOL_SIZE, defaultCoreSize == -1 ? 4 * cpus : defaultCoreSize));
        builder.setMaximumPoolSize(ExecutorTemplate.getIntConfigVal(MAX_POOL_SIZE, defaultMaxSize == -1 ? 10 * cpus : defaultMaxSize));
        builder.setMaximumQueueSize(ExecutorTemplate.getIntConfigVal(QUEUE_SIZE, defaultQueueSize));
        builder.setGrowthResistance(ExecutorTemplate.getFloatConfigVal(GROWTH_RESISTANCE, defaultGrowthResistance));
        builder.setKeepAliveTime((long)ExecutorTemplate.getIntConfigVal(KEEP_ALIVE_MILLIS, defaultKeepAliveMillis), TimeUnit.MILLISECONDS);
        final EnhancedQueueExecutor executor = builder.build();
        shutdownContext.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                executor.shutdown();
                while (true) {
                    try {
                        executor.awaitTermination(Long.MAX_VALUE, TimeUnit.HOURS);
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        });
        return executor;
    }

    public static float getFloatConfigVal(String key, float defVal) {
        Optional val = config.getOptionalValue(key, Float.class);
        return val.isPresent() ? ((Float)val.get()).floatValue() : defVal;
    }

    public static int getIntConfigVal(String key, int defVal) {
        Optional val = config.getOptionalValue(key, Integer.class);
        return val.isPresent() ? (Integer)val.get() : defVal;
    }
}

