/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.ThreadPoolConfig;
import io.quarkus.runtime.annotations.Template;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.threads.EnhancedQueueExecutor;
import org.jboss.threads.JBossExecutors;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.common.cpu.ProcessorInfo;

@Template
public class ExecutorTemplate {
    static ExecutorService devModeExecutor;

    public ExecutorService setupRunTime(ShutdownContext shutdownContext, final ThreadPoolConfig threadPoolConfig, LaunchMode launchMode) {
        if (devModeExecutor != null) {
            return devModeExecutor;
        }
        JBossThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("executor"), Boolean.TRUE, null, "executor-thread-%t", JBossExecutors.loggingExceptionHandler((String)"org.jboss.executor.uncaught"), null);
        EnhancedQueueExecutor.Builder builder = new EnhancedQueueExecutor.Builder().setRegisterMBean(false).setHandoffExecutor(JBossExecutors.rejectingExecutor()).setThreadFactory(JBossExecutors.resettingThreadFactory((ThreadFactory)threadFactory));
        int cpus = ProcessorInfo.availableProcessors();
        builder.setCorePoolSize(threadPoolConfig.coreThreads);
        builder.setMaximumPoolSize(threadPoolConfig.maxThreads <= 0 ? 8 * cpus : threadPoolConfig.maxThreads);
        builder.setMaximumQueueSize(threadPoolConfig.queueSize);
        builder.setGrowthResistance(threadPoolConfig.growthResistance);
        builder.setKeepAliveTime(threadPoolConfig.keepAliveTime);
        final EnhancedQueueExecutor executor = builder.build();
        Runnable shutdownTask = new Runnable(){

            @Override
            public void run() {
                executor.shutdown();
                while (true) {
                    try {
                        if (!executor.awaitTermination(threadPoolConfig.shutdownTimeout.toMillis(), TimeUnit.MILLISECONDS)) {
                            List tasks = executor.shutdownNow();
                            for (Runnable i : tasks) {
                                Thread t = new Thread(i, "Shutdown thread");
                                t.setDaemon(true);
                                t.start();
                            }
                        }
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        };
        if (launchMode == LaunchMode.DEVELOPMENT) {
            devModeExecutor = executor;
            Runtime.getRuntime().addShutdownHook(new Thread(shutdownTask, "Executor shutdown thread"));
        } else {
            shutdownContext.addShutdownTask(shutdownTask);
        }
        return executor;
    }
}

