/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.configuration.AbstractDelegatingConfigSource;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.wildfly.common.Assert;

public class DeploymentProfileConfigSource
extends AbstractDelegatingConfigSource {
    private final String profilePrefix;
    private NamesSet namesSet;

    public DeploymentProfileConfigSource(ConfigSource delegate, String profileName) {
        super(delegate);
        Assert.checkNotNullParam((String)"profileName", (Object)profileName);
        this.profilePrefix = "%" + profileName + ".";
    }

    @Override
    public Set<String> getPropertyNames() {
        NamesSet namesSet = this.namesSet;
        if (namesSet == null) {
            this.namesSet = new NamesSet(this.getDelegate().getPropertyNames());
            return this.namesSet;
        }
        return namesSet;
    }

    public String getValue(String name) {
        ConfigSource delegate = this.getDelegate();
        if (name.startsWith("%")) {
            return null;
        }
        String nameWithProfile = this.profilePrefix + name;
        return delegate.getPropertyNames().contains(nameWithProfile) ? delegate.getValue(nameWithProfile) : delegate.getValue(name);
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    final class NamesSet
    extends AbstractSet<String> {
        private final Set<String> delegateSet;

        NamesSet(Set<String> delegateSet) {
            this.delegateSet = delegateSet;
        }

        @Override
        public Iterator<String> iterator() {
            return new Itr(this.delegateSet.iterator());
        }

        @Override
        public int size() {
            int cnt = 0;
            for (String ignored : this) {
                ++cnt;
            }
            return cnt;
        }

        final class Itr
        implements Iterator<String> {
            private final Iterator<String> iterator;
            private String next;

            Itr(Iterator<String> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                String profilePrefix = DeploymentProfileConfigSource.this.profilePrefix;
                Iterator<String> iterator = this.iterator;
                while (this.next == null) {
                    if (!iterator.hasNext()) {
                        return false;
                    }
                    String test = iterator.next();
                    if (test.startsWith("%")) {
                        int prefixLen = profilePrefix.length();
                        if (!test.startsWith(profilePrefix)) continue;
                        this.next = test.substring(prefixLen);
                        return true;
                    }
                    if (NamesSet.this.delegateSet.contains(profilePrefix + test)) continue;
                    this.next = test;
                    return true;
                }
                return true;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.next;
            }
        }
    }
}

