/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.configuration.ConverterFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import javax.annotation.Priority;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.Converter;
import org.jboss.logging.Logger;

public class ConverterSupport {
    private static final Logger LOG = Logger.getLogger(ConverterSupport.class);
    private static final List<ConverterItem<Object>> CONVERTERS = ConverterSupport.getConverters();
    public static final int DEFAULT_SMALLRYE_CONVERTER_PRIORITY = 100;
    public static final int DEFAULT_QUARKUS_CONVERTER_PRIORITY = 200;

    public static void populateConverters(ConfigBuilder builder) {
        CONVERTERS.forEach(ConverterSupport.addConverterTo(builder));
    }

    static int getConverterPriority(Class<? extends Converter<?>> converterClass) {
        return Optional.ofNullable(converterClass.getAnnotation(Priority.class)).map(Priority::value).orElse(100);
    }

    private static <T> ConverterItem<?> converterToItem(Converter<T> converter) {
        Class<?> converterClass = converter.getClass();
        Class<T> convertedType = ConverterFactory.getConverterType(converter);
        int priority = ConverterSupport.getConverterPriority(converterClass);
        return new ConverterItem<T>(convertedType, converter, priority);
    }

    private static List<ConverterItem<Object>> getConverters() {
        ArrayList<ConverterItem<Object>> items = new ArrayList<ConverterItem<Object>>();
        for (Converter converter : ServiceLoader.load(Converter.class)) {
            items.add(ConverterSupport.converterToItem(converter));
        }
        return items;
    }

    private static <T> Consumer<ConverterItem<T>> addConverterTo(ConfigBuilder builder) {
        return item -> {
            Class type = item.getConvertedType();
            Converter converter = item.getConverter();
            int priority = item.getPriority();
            LOG.debugf("Populate SmallRye config builder with converter for %s of priority %s", type, (Object)priority);
            builder.withConverter(type, priority, converter);
        };
    }

    private ConverterSupport() {
    }

    private static final class ConverterItem<T> {
        final Class<T> convertedType;
        final Converter<T> converter;
        final int priority;

        public ConverterItem(Class<T> convertedType, Converter<T> converter, int priority) {
            this.convertedType = convertedType;
            this.converter = converter;
            this.priority = priority;
        }

        public Class<T> getConvertedType() {
            return this.convertedType;
        }

        public Converter<T> getConverter() {
            return this.converter;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

